// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_ADD_D_TRACE_AARCH64_H_
#define VIXL_SIM_ADD_D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_add_D[] = {
  0x00000000000000fa, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x00000000000000bd, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000000fb, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x000000000000807a, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000008000007a, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x33333333333333b0, 0x0000000000000000,
  0x55555555555555d2, 0x0000000000000000,
  0x800000000000007a, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0xaaaaaaaaaaaaab27, 0x0000000000000000,
  0xcccccccccccccd49, 0x0000000000000000,
  0xffffffff8000007d, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffffffff807d, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000003d, 0x0000000000000000,
  0x000000000000007a, 0x0000000000000000,
  0x000000000000007b, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x3333333333333333, 0x0000000000000000,
  0x5555555555555555, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xcccccccccccccccc, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000041, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x3333333333333334, 0x0000000000000000,
  0x5555555555555556, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0xaaaaaaaaaaaaaaab, 0x0000000000000000,
  0xcccccccccccccccd, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000042, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000081, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x0000000000008001, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x0000000080000001, 0x0000000000000000,
  0x3333333333333335, 0x0000000000000000,
  0x5555555555555557, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0x8000000000000005, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0xccccccccccccccce, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffff80000005, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffff8005, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000003f, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000041, 0x0000000000000000,
  0x0000000000000042, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x00000000000000bd, 0x0000000000000000,
  0x00000000000000be, 0x0000000000000000,
  0x00000000000000bf, 0x0000000000000000,
  0x000000000000803d, 0x0000000000000000,
  0x000000000000803e, 0x0000000000000000,
  0x000000000000803f, 0x0000000000000000,
  0x000000008000003d, 0x0000000000000000,
  0x000000008000003e, 0x0000000000000000,
  0x000000008000003f, 0x0000000000000000,
  0x3333333333333373, 0x0000000000000000,
  0x5555555555555595, 0x0000000000000000,
  0x800000000000003d, 0x0000000000000000,
  0x800000000000003e, 0x0000000000000000,
  0x800000000000003f, 0x0000000000000000,
  0x8000000000000040, 0x0000000000000000,
  0x8000000000000041, 0x0000000000000000,
  0x8000000000000042, 0x0000000000000000,
  0x8000000000000043, 0x0000000000000000,
  0xaaaaaaaaaaaaaaea, 0x0000000000000000,
  0xcccccccccccccd0c, 0x0000000000000000,
  0xffffffff80000040, 0x0000000000000000,
  0xffffffff80000041, 0x0000000000000000,
  0xffffffff80000042, 0x0000000000000000,
  0xffffffff80000043, 0x0000000000000000,
  0xffffffffffff8040, 0x0000000000000000,
  0xffffffffffff8041, 0x0000000000000000,
  0xffffffffffff8042, 0x0000000000000000,
  0xffffffffffff8043, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffc3, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000003d, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x000000000000007c, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x00000000000000bd, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000000fb, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x000000000000807a, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000008000007a, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x33333333333333b0, 0x0000000000000000,
  0x55555555555555d2, 0x0000000000000000,
  0x800000000000007a, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0xaaaaaaaaaaaaab27, 0x0000000000000000,
  0xcccccccccccccd49, 0x0000000000000000,
  0xffffffff8000007d, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffffffff807d, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000003d, 0x0000000000000000,
  0x000000000000007a, 0x0000000000000000,
  0x000000000000007b, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x00000000000000be, 0x0000000000000000,
  0x00000000000000fb, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000000fd, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x33333333333333b1, 0x0000000000000000,
  0x55555555555555d3, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0xaaaaaaaaaaaaab28, 0x0000000000000000,
  0xcccccccccccccd4a, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x000000000000007b, 0x0000000000000000,
  0x000000000000007c, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000081, 0x0000000000000000,
  0x00000000000000bf, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000000fd, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000000000807e, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x000000008000007e, 0x0000000000000000,
  0x33333333333333b2, 0x0000000000000000,
  0x55555555555555d4, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0x8000000000000082, 0x0000000000000000,
  0xaaaaaaaaaaaaab29, 0x0000000000000000,
  0xcccccccccccccd4b, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffff80000082, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x000000000000003f, 0x0000000000000000,
  0x000000000000007c, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x0000000000007ffc, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x000000000000803d, 0x0000000000000000,
  0x000000000000807a, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000000fffb, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x0000000080007ffa, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x333333333333b330, 0x0000000000000000,
  0x555555555555d552, 0x0000000000000000,
  0x8000000000007ffa, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0xaaaaaaaaaaab2aa7, 0x0000000000000000,
  0xcccccccccccd4cc9, 0x0000000000000000,
  0xffffffff80007ffd, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f7d, 0x0000000000000000,
  0x0000000000007f7e, 0x0000000000000000,
  0x0000000000007f7f, 0x0000000000000000,
  0x0000000000007f80, 0x0000000000000000,
  0x0000000000007fbd, 0x0000000000000000,
  0x0000000000007ffa, 0x0000000000000000,
  0x0000000000007ffb, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x000000000000803e, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000000000fffb, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000000fffd, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x333333333333b331, 0x0000000000000000,
  0x555555555555d553, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0xaaaaaaaaaaab2aa8, 0x0000000000000000,
  0xcccccccccccd4cca, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000007f7e, 0x0000000000000000,
  0x0000000000007f7f, 0x0000000000000000,
  0x0000000000007f80, 0x0000000000000000,
  0x0000000000007f81, 0x0000000000000000,
  0x0000000000007fbe, 0x0000000000000000,
  0x0000000000007ffb, 0x0000000000000000,
  0x0000000000007ffc, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x0000000000008001, 0x0000000000000000,
  0x000000000000803f, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000000000807e, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000000fffd, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x0000000080007ffe, 0x0000000000000000,
  0x333333333333b332, 0x0000000000000000,
  0x555555555555d554, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0x8000000000008002, 0x0000000000000000,
  0xaaaaaaaaaaab2aa9, 0x0000000000000000,
  0xcccccccccccd4ccb, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffff80008002, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000007f7f, 0x0000000000000000,
  0x0000000000007f80, 0x0000000000000000,
  0x0000000000007f81, 0x0000000000000000,
  0x0000000000007f82, 0x0000000000000000,
  0x0000000000007fbf, 0x0000000000000000,
  0x0000000000007ffc, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x000000007ffffffc, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x000000008000003d, 0x0000000000000000,
  0x000000008000007a, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x0000000080007ffa, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0x00000000fffffffb, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x33333333b3333330, 0x0000000000000000,
  0x55555555d5555552, 0x0000000000000000,
  0x800000007ffffffa, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0xaaaaaaab2aaaaaa7, 0x0000000000000000,
  0xcccccccd4cccccc9, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000007fff7ffd, 0x0000000000000000,
  0x000000007fff7ffe, 0x0000000000000000,
  0x000000007fff7fff, 0x0000000000000000,
  0x000000007fff8000, 0x0000000000000000,
  0x000000007fffff7d, 0x0000000000000000,
  0x000000007fffff7e, 0x0000000000000000,
  0x000000007fffff7f, 0x0000000000000000,
  0x000000007fffff80, 0x0000000000000000,
  0x000000007fffffbd, 0x0000000000000000,
  0x000000007ffffffa, 0x0000000000000000,
  0x000000007ffffffb, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x000000008000003e, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x00000000fffffffb, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000000fffffffd, 0x0000000000000000,
  0x33333333b3333331, 0x0000000000000000,
  0x55555555d5555553, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0xaaaaaaab2aaaaaa8, 0x0000000000000000,
  0xcccccccd4cccccca, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x000000007fff7ffe, 0x0000000000000000,
  0x000000007fff7fff, 0x0000000000000000,
  0x000000007fff8000, 0x0000000000000000,
  0x000000007fff8001, 0x0000000000000000,
  0x000000007fffff7e, 0x0000000000000000,
  0x000000007fffff7f, 0x0000000000000000,
  0x000000007fffff80, 0x0000000000000000,
  0x000000007fffff81, 0x0000000000000000,
  0x000000007fffffbe, 0x0000000000000000,
  0x000000007ffffffb, 0x0000000000000000,
  0x000000007ffffffc, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x0000000080000001, 0x0000000000000000,
  0x000000008000003f, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x000000008000007e, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x0000000080007ffe, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000000fffffffd, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x33333333b3333332, 0x0000000000000000,
  0x55555555d5555554, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0x8000000080000002, 0x0000000000000000,
  0xaaaaaaab2aaaaaa9, 0x0000000000000000,
  0xcccccccd4ccccccb, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x000000007fff7fff, 0x0000000000000000,
  0x000000007fff8000, 0x0000000000000000,
  0x000000007fff8001, 0x0000000000000000,
  0x000000007fff8002, 0x0000000000000000,
  0x000000007fffff7f, 0x0000000000000000,
  0x000000007fffff80, 0x0000000000000000,
  0x000000007fffff81, 0x0000000000000000,
  0x000000007fffff82, 0x0000000000000000,
  0x000000007fffffbf, 0x0000000000000000,
  0x000000007ffffffc, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x3333333333333332, 0x0000000000000000,
  0x3333333333333333, 0x0000000000000000,
  0x3333333333333334, 0x0000000000000000,
  0x3333333333333335, 0x0000000000000000,
  0x3333333333333373, 0x0000000000000000,
  0x33333333333333b0, 0x0000000000000000,
  0x33333333333333b1, 0x0000000000000000,
  0x33333333333333b2, 0x0000000000000000,
  0x333333333333b330, 0x0000000000000000,
  0x333333333333b331, 0x0000000000000000,
  0x333333333333b332, 0x0000000000000000,
  0x33333333b3333330, 0x0000000000000000,
  0x33333333b3333331, 0x0000000000000000,
  0x33333333b3333332, 0x0000000000000000,
  0x6666666666666666, 0x0000000000000000,
  0x8888888888888888, 0x0000000000000000,
  0xb333333333333330, 0x0000000000000000,
  0xb333333333333331, 0x0000000000000000,
  0xb333333333333332, 0x0000000000000000,
  0xb333333333333333, 0x0000000000000000,
  0xb333333333333334, 0x0000000000000000,
  0xb333333333333335, 0x0000000000000000,
  0xb333333333333336, 0x0000000000000000,
  0xdddddddddddddddd, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x33333332b3333333, 0x0000000000000000,
  0x33333332b3333334, 0x0000000000000000,
  0x33333332b3333335, 0x0000000000000000,
  0x33333332b3333336, 0x0000000000000000,
  0x333333333332b333, 0x0000000000000000,
  0x333333333332b334, 0x0000000000000000,
  0x333333333332b335, 0x0000000000000000,
  0x333333333332b336, 0x0000000000000000,
  0x33333333333332b3, 0x0000000000000000,
  0x33333333333332b4, 0x0000000000000000,
  0x33333333333332b5, 0x0000000000000000,
  0x33333333333332b6, 0x0000000000000000,
  0x33333333333332f3, 0x0000000000000000,
  0x3333333333333330, 0x0000000000000000,
  0x3333333333333331, 0x0000000000000000,
  0x5555555555555554, 0x0000000000000000,
  0x5555555555555555, 0x0000000000000000,
  0x5555555555555556, 0x0000000000000000,
  0x5555555555555557, 0x0000000000000000,
  0x5555555555555595, 0x0000000000000000,
  0x55555555555555d2, 0x0000000000000000,
  0x55555555555555d3, 0x0000000000000000,
  0x55555555555555d4, 0x0000000000000000,
  0x555555555555d552, 0x0000000000000000,
  0x555555555555d553, 0x0000000000000000,
  0x555555555555d554, 0x0000000000000000,
  0x55555555d5555552, 0x0000000000000000,
  0x55555555d5555553, 0x0000000000000000,
  0x55555555d5555554, 0x0000000000000000,
  0x8888888888888888, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xd555555555555552, 0x0000000000000000,
  0xd555555555555553, 0x0000000000000000,
  0xd555555555555554, 0x0000000000000000,
  0xd555555555555555, 0x0000000000000000,
  0xd555555555555556, 0x0000000000000000,
  0xd555555555555557, 0x0000000000000000,
  0xd555555555555558, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x2222222222222221, 0x0000000000000000,
  0x55555554d5555555, 0x0000000000000000,
  0x55555554d5555556, 0x0000000000000000,
  0x55555554d5555557, 0x0000000000000000,
  0x55555554d5555558, 0x0000000000000000,
  0x555555555554d555, 0x0000000000000000,
  0x555555555554d556, 0x0000000000000000,
  0x555555555554d557, 0x0000000000000000,
  0x555555555554d558, 0x0000000000000000,
  0x55555555555554d5, 0x0000000000000000,
  0x55555555555554d6, 0x0000000000000000,
  0x55555555555554d7, 0x0000000000000000,
  0x55555555555554d8, 0x0000000000000000,
  0x5555555555555515, 0x0000000000000000,
  0x5555555555555552, 0x0000000000000000,
  0x5555555555555553, 0x0000000000000000,
  0x7ffffffffffffffc, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x800000000000003d, 0x0000000000000000,
  0x800000000000007a, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x8000000000007ffa, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x800000007ffffffa, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0xb333333333333330, 0x0000000000000000,
  0xd555555555555552, 0x0000000000000000,
  0xfffffffffffffffa, 0x0000000000000000,
  0xfffffffffffffffb, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x2aaaaaaaaaaaaaa7, 0x0000000000000000,
  0x4cccccccccccccc9, 0x0000000000000000,
  0x7fffffff7ffffffd, 0x0000000000000000,
  0x7fffffff7ffffffe, 0x0000000000000000,
  0x7fffffff7fffffff, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffffffff7ffd, 0x0000000000000000,
  0x7fffffffffff7ffe, 0x0000000000000000,
  0x7fffffffffff7fff, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffffff7d, 0x0000000000000000,
  0x7fffffffffffff7e, 0x0000000000000000,
  0x7fffffffffffff7f, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffffbd, 0x0000000000000000,
  0x7ffffffffffffffa, 0x0000000000000000,
  0x7ffffffffffffffb, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x800000000000003e, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0xb333333333333331, 0x0000000000000000,
  0xd555555555555553, 0x0000000000000000,
  0xfffffffffffffffb, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x2aaaaaaaaaaaaaa8, 0x0000000000000000,
  0x4cccccccccccccca, 0x0000000000000000,
  0x7fffffff7ffffffe, 0x0000000000000000,
  0x7fffffff7fffffff, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffffffff7ffe, 0x0000000000000000,
  0x7fffffffffff7fff, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffffff7e, 0x0000000000000000,
  0x7fffffffffffff7f, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffffbe, 0x0000000000000000,
  0x7ffffffffffffffb, 0x0000000000000000,
  0x7ffffffffffffffc, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x800000000000003f, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0xb333333333333332, 0x0000000000000000,
  0xd555555555555554, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x2aaaaaaaaaaaaaa9, 0x0000000000000000,
  0x4ccccccccccccccb, 0x0000000000000000,
  0x7fffffff7fffffff, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffffffff7fff, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffffff7f, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffffbf, 0x0000000000000000,
  0x7ffffffffffffffc, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000040, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0xb333333333333333, 0x0000000000000000,
  0xd555555555555555, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x2aaaaaaaaaaaaaaa, 0x0000000000000000,
  0x4ccccccccccccccc, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffffc0, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000041, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0xb333333333333334, 0x0000000000000000,
  0xd555555555555556, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x2aaaaaaaaaaaaaab, 0x0000000000000000,
  0x4ccccccccccccccd, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffff80000004, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffff8004, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffff84, 0x0000000000000000,
  0x7fffffffffffffc1, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0x8000000000000042, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0xb333333333333335, 0x0000000000000000,
  0xd555555555555557, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000005, 0x0000000000000000,
  0x2aaaaaaaaaaaaaac, 0x0000000000000000,
  0x4cccccccccccccce, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffff80000004, 0x0000000000000000,
  0x7fffffff80000005, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffff8004, 0x0000000000000000,
  0x7fffffffffff8005, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffff84, 0x0000000000000000,
  0x7fffffffffffff85, 0x0000000000000000,
  0x7fffffffffffffc2, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0x8000000000000005, 0x0000000000000000,
  0x8000000000000043, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0x8000000000000082, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0x8000000000008002, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0x8000000080000002, 0x0000000000000000,
  0xb333333333333336, 0x0000000000000000,
  0xd555555555555558, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000005, 0x0000000000000000,
  0x0000000000000006, 0x0000000000000000,
  0x2aaaaaaaaaaaaaad, 0x0000000000000000,
  0x4ccccccccccccccf, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffff80000004, 0x0000000000000000,
  0x7fffffff80000005, 0x0000000000000000,
  0x7fffffff80000006, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffff8004, 0x0000000000000000,
  0x7fffffffffff8005, 0x0000000000000000,
  0x7fffffffffff8006, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffff84, 0x0000000000000000,
  0x7fffffffffffff85, 0x0000000000000000,
  0x7fffffffffffff86, 0x0000000000000000,
  0x7fffffffffffffc3, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0xaaaaaaaaaaaaaaa9, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xaaaaaaaaaaaaaaab, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0xaaaaaaaaaaaaaaea, 0x0000000000000000,
  0xaaaaaaaaaaaaab27, 0x0000000000000000,
  0xaaaaaaaaaaaaab28, 0x0000000000000000,
  0xaaaaaaaaaaaaab29, 0x0000000000000000,
  0xaaaaaaaaaaab2aa7, 0x0000000000000000,
  0xaaaaaaaaaaab2aa8, 0x0000000000000000,
  0xaaaaaaaaaaab2aa9, 0x0000000000000000,
  0xaaaaaaab2aaaaaa7, 0x0000000000000000,
  0xaaaaaaab2aaaaaa8, 0x0000000000000000,
  0xaaaaaaab2aaaaaa9, 0x0000000000000000,
  0xdddddddddddddddd, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x2aaaaaaaaaaaaaa7, 0x0000000000000000,
  0x2aaaaaaaaaaaaaa8, 0x0000000000000000,
  0x2aaaaaaaaaaaaaa9, 0x0000000000000000,
  0x2aaaaaaaaaaaaaaa, 0x0000000000000000,
  0x2aaaaaaaaaaaaaab, 0x0000000000000000,
  0x2aaaaaaaaaaaaaac, 0x0000000000000000,
  0x2aaaaaaaaaaaaaad, 0x0000000000000000,
  0x5555555555555554, 0x0000000000000000,
  0x7777777777777776, 0x0000000000000000,
  0xaaaaaaaa2aaaaaaa, 0x0000000000000000,
  0xaaaaaaaa2aaaaaab, 0x0000000000000000,
  0xaaaaaaaa2aaaaaac, 0x0000000000000000,
  0xaaaaaaaa2aaaaaad, 0x0000000000000000,
  0xaaaaaaaaaaaa2aaa, 0x0000000000000000,
  0xaaaaaaaaaaaa2aab, 0x0000000000000000,
  0xaaaaaaaaaaaa2aac, 0x0000000000000000,
  0xaaaaaaaaaaaa2aad, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2a, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2b, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2c, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2d, 0x0000000000000000,
  0xaaaaaaaaaaaaaa6a, 0x0000000000000000,
  0xaaaaaaaaaaaaaaa7, 0x0000000000000000,
  0xaaaaaaaaaaaaaaa8, 0x0000000000000000,
  0xcccccccccccccccb, 0x0000000000000000,
  0xcccccccccccccccc, 0x0000000000000000,
  0xcccccccccccccccd, 0x0000000000000000,
  0xccccccccccccccce, 0x0000000000000000,
  0xcccccccccccccd0c, 0x0000000000000000,
  0xcccccccccccccd49, 0x0000000000000000,
  0xcccccccccccccd4a, 0x0000000000000000,
  0xcccccccccccccd4b, 0x0000000000000000,
  0xcccccccccccd4cc9, 0x0000000000000000,
  0xcccccccccccd4cca, 0x0000000000000000,
  0xcccccccccccd4ccb, 0x0000000000000000,
  0xcccccccd4cccccc9, 0x0000000000000000,
  0xcccccccd4cccccca, 0x0000000000000000,
  0xcccccccd4ccccccb, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x2222222222222221, 0x0000000000000000,
  0x4cccccccccccccc9, 0x0000000000000000,
  0x4cccccccccccccca, 0x0000000000000000,
  0x4ccccccccccccccb, 0x0000000000000000,
  0x4ccccccccccccccc, 0x0000000000000000,
  0x4ccccccccccccccd, 0x0000000000000000,
  0x4cccccccccccccce, 0x0000000000000000,
  0x4ccccccccccccccf, 0x0000000000000000,
  0x7777777777777776, 0x0000000000000000,
  0x9999999999999998, 0x0000000000000000,
  0xcccccccc4ccccccc, 0x0000000000000000,
  0xcccccccc4ccccccd, 0x0000000000000000,
  0xcccccccc4cccccce, 0x0000000000000000,
  0xcccccccc4ccccccf, 0x0000000000000000,
  0xcccccccccccc4ccc, 0x0000000000000000,
  0xcccccccccccc4ccd, 0x0000000000000000,
  0xcccccccccccc4cce, 0x0000000000000000,
  0xcccccccccccc4ccf, 0x0000000000000000,
  0xcccccccccccccc4c, 0x0000000000000000,
  0xcccccccccccccc4d, 0x0000000000000000,
  0xcccccccccccccc4e, 0x0000000000000000,
  0xcccccccccccccc4f, 0x0000000000000000,
  0xcccccccccccccc8c, 0x0000000000000000,
  0xccccccccccccccc9, 0x0000000000000000,
  0xccccccccccccccca, 0x0000000000000000,
  0xffffffff7fffffff, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000040, 0x0000000000000000,
  0xffffffff8000007d, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80007ffd, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x33333332b3333333, 0x0000000000000000,
  0x55555554d5555555, 0x0000000000000000,
  0x7fffffff7ffffffd, 0x0000000000000000,
  0x7fffffff7ffffffe, 0x0000000000000000,
  0x7fffffff7fffffff, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0xaaaaaaaa2aaaaaaa, 0x0000000000000000,
  0xcccccccc4ccccccc, 0x0000000000000000,
  0xffffffff00000000, 0x0000000000000000,
  0xffffffff00000001, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xffffffff00000003, 0x0000000000000000,
  0xffffffff7fff8000, 0x0000000000000000,
  0xffffffff7fff8001, 0x0000000000000000,
  0xffffffff7fff8002, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fffff80, 0x0000000000000000,
  0xffffffff7fffff81, 0x0000000000000000,
  0xffffffff7fffff82, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffffc0, 0x0000000000000000,
  0xffffffff7ffffffd, 0x0000000000000000,
  0xffffffff7ffffffe, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000041, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x33333332b3333334, 0x0000000000000000,
  0x55555554d5555556, 0x0000000000000000,
  0x7fffffff7ffffffe, 0x0000000000000000,
  0x7fffffff7fffffff, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffff80000004, 0x0000000000000000,
  0xaaaaaaaa2aaaaaab, 0x0000000000000000,
  0xcccccccc4ccccccd, 0x0000000000000000,
  0xffffffff00000001, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xffffffff00000003, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0xffffffff7fff8001, 0x0000000000000000,
  0xffffffff7fff8002, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fff8004, 0x0000000000000000,
  0xffffffff7fffff81, 0x0000000000000000,
  0xffffffff7fffff82, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffff84, 0x0000000000000000,
  0xffffffff7fffffc1, 0x0000000000000000,
  0xffffffff7ffffffe, 0x0000000000000000,
  0xffffffff7fffffff, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffff80000042, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x33333332b3333335, 0x0000000000000000,
  0x55555554d5555557, 0x0000000000000000,
  0x7fffffff7fffffff, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffff80000004, 0x0000000000000000,
  0x7fffffff80000005, 0x0000000000000000,
  0xaaaaaaaa2aaaaaac, 0x0000000000000000,
  0xcccccccc4cccccce, 0x0000000000000000,
  0xffffffff00000002, 0x0000000000000000,
  0xffffffff00000003, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0xffffffff00000005, 0x0000000000000000,
  0xffffffff7fff8002, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fff8004, 0x0000000000000000,
  0xffffffff7fff8005, 0x0000000000000000,
  0xffffffff7fffff82, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffff84, 0x0000000000000000,
  0xffffffff7fffff85, 0x0000000000000000,
  0xffffffff7fffffc2, 0x0000000000000000,
  0xffffffff7fffffff, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffff80000005, 0x0000000000000000,
  0xffffffff80000043, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffff80000082, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffff80008002, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x33333332b3333336, 0x0000000000000000,
  0x55555554d5555558, 0x0000000000000000,
  0x7fffffff80000000, 0x0000000000000000,
  0x7fffffff80000001, 0x0000000000000000,
  0x7fffffff80000002, 0x0000000000000000,
  0x7fffffff80000003, 0x0000000000000000,
  0x7fffffff80000004, 0x0000000000000000,
  0x7fffffff80000005, 0x0000000000000000,
  0x7fffffff80000006, 0x0000000000000000,
  0xaaaaaaaa2aaaaaad, 0x0000000000000000,
  0xcccccccc4ccccccf, 0x0000000000000000,
  0xffffffff00000003, 0x0000000000000000,
  0xffffffff00000004, 0x0000000000000000,
  0xffffffff00000005, 0x0000000000000000,
  0xffffffff00000006, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fff8004, 0x0000000000000000,
  0xffffffff7fff8005, 0x0000000000000000,
  0xffffffff7fff8006, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffff84, 0x0000000000000000,
  0xffffffff7fffff85, 0x0000000000000000,
  0xffffffff7fffff86, 0x0000000000000000,
  0xffffffff7fffffc3, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffffffff7fff, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8040, 0x0000000000000000,
  0xffffffffffff807d, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000007fff7ffd, 0x0000000000000000,
  0x000000007fff7ffe, 0x0000000000000000,
  0x000000007fff7fff, 0x0000000000000000,
  0x333333333332b333, 0x0000000000000000,
  0x555555555554d555, 0x0000000000000000,
  0x7fffffffffff7ffd, 0x0000000000000000,
  0x7fffffffffff7ffe, 0x0000000000000000,
  0x7fffffffffff7fff, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0xaaaaaaaaaaaa2aaa, 0x0000000000000000,
  0xcccccccccccc4ccc, 0x0000000000000000,
  0xffffffff7fff8000, 0x0000000000000000,
  0xffffffff7fff8001, 0x0000000000000000,
  0xffffffff7fff8002, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffffffff0000, 0x0000000000000000,
  0xffffffffffff0001, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xffffffffffff0003, 0x0000000000000000,
  0xffffffffffff7f80, 0x0000000000000000,
  0xffffffffffff7f81, 0x0000000000000000,
  0xffffffffffff7f82, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7fc0, 0x0000000000000000,
  0xffffffffffff7ffd, 0x0000000000000000,
  0xffffffffffff7ffe, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8041, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000007fff7ffe, 0x0000000000000000,
  0x000000007fff7fff, 0x0000000000000000,
  0x000000007fff8000, 0x0000000000000000,
  0x333333333332b334, 0x0000000000000000,
  0x555555555554d556, 0x0000000000000000,
  0x7fffffffffff7ffe, 0x0000000000000000,
  0x7fffffffffff7fff, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffff8004, 0x0000000000000000,
  0xaaaaaaaaaaaa2aab, 0x0000000000000000,
  0xcccccccccccc4ccd, 0x0000000000000000,
  0xffffffff7fff8001, 0x0000000000000000,
  0xffffffff7fff8002, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fff8004, 0x0000000000000000,
  0xffffffffffff0001, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xffffffffffff0003, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xffffffffffff7f81, 0x0000000000000000,
  0xffffffffffff7f82, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7f84, 0x0000000000000000,
  0xffffffffffff7fc1, 0x0000000000000000,
  0xffffffffffff7ffe, 0x0000000000000000,
  0xffffffffffff7fff, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffff8042, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x000000007fff7fff, 0x0000000000000000,
  0x000000007fff8000, 0x0000000000000000,
  0x000000007fff8001, 0x0000000000000000,
  0x333333333332b335, 0x0000000000000000,
  0x555555555554d557, 0x0000000000000000,
  0x7fffffffffff7fff, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffff8004, 0x0000000000000000,
  0x7fffffffffff8005, 0x0000000000000000,
  0xaaaaaaaaaaaa2aac, 0x0000000000000000,
  0xcccccccccccc4cce, 0x0000000000000000,
  0xffffffff7fff8002, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fff8004, 0x0000000000000000,
  0xffffffff7fff8005, 0x0000000000000000,
  0xffffffffffff0002, 0x0000000000000000,
  0xffffffffffff0003, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xffffffffffff0005, 0x0000000000000000,
  0xffffffffffff7f82, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7f84, 0x0000000000000000,
  0xffffffffffff7f85, 0x0000000000000000,
  0xffffffffffff7fc2, 0x0000000000000000,
  0xffffffffffff7fff, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffff8005, 0x0000000000000000,
  0xffffffffffff8043, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x000000007fff8000, 0x0000000000000000,
  0x000000007fff8001, 0x0000000000000000,
  0x000000007fff8002, 0x0000000000000000,
  0x333333333332b336, 0x0000000000000000,
  0x555555555554d558, 0x0000000000000000,
  0x7fffffffffff8000, 0x0000000000000000,
  0x7fffffffffff8001, 0x0000000000000000,
  0x7fffffffffff8002, 0x0000000000000000,
  0x7fffffffffff8003, 0x0000000000000000,
  0x7fffffffffff8004, 0x0000000000000000,
  0x7fffffffffff8005, 0x0000000000000000,
  0x7fffffffffff8006, 0x0000000000000000,
  0xaaaaaaaaaaaa2aad, 0x0000000000000000,
  0xcccccccccccc4ccf, 0x0000000000000000,
  0xffffffff7fff8003, 0x0000000000000000,
  0xffffffff7fff8004, 0x0000000000000000,
  0xffffffff7fff8005, 0x0000000000000000,
  0xffffffff7fff8006, 0x0000000000000000,
  0xffffffffffff0003, 0x0000000000000000,
  0xffffffffffff0004, 0x0000000000000000,
  0xffffffffffff0005, 0x0000000000000000,
  0xffffffffffff0006, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7f84, 0x0000000000000000,
  0xffffffffffff7f85, 0x0000000000000000,
  0xffffffffffff7f86, 0x0000000000000000,
  0xffffffffffff7fc3, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffffff7f, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000007f7d, 0x0000000000000000,
  0x0000000000007f7e, 0x0000000000000000,
  0x0000000000007f7f, 0x0000000000000000,
  0x000000007fffff7d, 0x0000000000000000,
  0x000000007fffff7e, 0x0000000000000000,
  0x000000007fffff7f, 0x0000000000000000,
  0x33333333333332b3, 0x0000000000000000,
  0x55555555555554d5, 0x0000000000000000,
  0x7fffffffffffff7d, 0x0000000000000000,
  0x7fffffffffffff7e, 0x0000000000000000,
  0x7fffffffffffff7f, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2a, 0x0000000000000000,
  0xcccccccccccccc4c, 0x0000000000000000,
  0xffffffff7fffff80, 0x0000000000000000,
  0xffffffff7fffff81, 0x0000000000000000,
  0xffffffff7fffff82, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffffffff7f80, 0x0000000000000000,
  0xffffffffffff7f81, 0x0000000000000000,
  0xffffffffffff7f82, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffffff00, 0x0000000000000000,
  0xffffffffffffff01, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xffffffffffffff03, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xffffffffffffff7d, 0x0000000000000000,
  0xffffffffffffff7e, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000007f7e, 0x0000000000000000,
  0x0000000000007f7f, 0x0000000000000000,
  0x0000000000007f80, 0x0000000000000000,
  0x000000007fffff7e, 0x0000000000000000,
  0x000000007fffff7f, 0x0000000000000000,
  0x000000007fffff80, 0x0000000000000000,
  0x33333333333332b4, 0x0000000000000000,
  0x55555555555554d6, 0x0000000000000000,
  0x7fffffffffffff7e, 0x0000000000000000,
  0x7fffffffffffff7f, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffff84, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2b, 0x0000000000000000,
  0xcccccccccccccc4d, 0x0000000000000000,
  0xffffffff7fffff81, 0x0000000000000000,
  0xffffffff7fffff82, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffff84, 0x0000000000000000,
  0xffffffffffff7f81, 0x0000000000000000,
  0xffffffffffff7f82, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7f84, 0x0000000000000000,
  0xffffffffffffff01, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xffffffffffffff03, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xffffffffffffff41, 0x0000000000000000,
  0xffffffffffffff7e, 0x0000000000000000,
  0xffffffffffffff7f, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000007f7f, 0x0000000000000000,
  0x0000000000007f80, 0x0000000000000000,
  0x0000000000007f81, 0x0000000000000000,
  0x000000007fffff7f, 0x0000000000000000,
  0x000000007fffff80, 0x0000000000000000,
  0x000000007fffff81, 0x0000000000000000,
  0x33333333333332b5, 0x0000000000000000,
  0x55555555555554d7, 0x0000000000000000,
  0x7fffffffffffff7f, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffff84, 0x0000000000000000,
  0x7fffffffffffff85, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2c, 0x0000000000000000,
  0xcccccccccccccc4e, 0x0000000000000000,
  0xffffffff7fffff82, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffff84, 0x0000000000000000,
  0xffffffff7fffff85, 0x0000000000000000,
  0xffffffffffff7f82, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7f84, 0x0000000000000000,
  0xffffffffffff7f85, 0x0000000000000000,
  0xffffffffffffff02, 0x0000000000000000,
  0xffffffffffffff03, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xffffffffffffff05, 0x0000000000000000,
  0xffffffffffffff42, 0x0000000000000000,
  0xffffffffffffff7f, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffc3, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000007f80, 0x0000000000000000,
  0x0000000000007f81, 0x0000000000000000,
  0x0000000000007f82, 0x0000000000000000,
  0x000000007fffff80, 0x0000000000000000,
  0x000000007fffff81, 0x0000000000000000,
  0x000000007fffff82, 0x0000000000000000,
  0x33333333333332b6, 0x0000000000000000,
  0x55555555555554d8, 0x0000000000000000,
  0x7fffffffffffff80, 0x0000000000000000,
  0x7fffffffffffff81, 0x0000000000000000,
  0x7fffffffffffff82, 0x0000000000000000,
  0x7fffffffffffff83, 0x0000000000000000,
  0x7fffffffffffff84, 0x0000000000000000,
  0x7fffffffffffff85, 0x0000000000000000,
  0x7fffffffffffff86, 0x0000000000000000,
  0xaaaaaaaaaaaaaa2d, 0x0000000000000000,
  0xcccccccccccccc4f, 0x0000000000000000,
  0xffffffff7fffff83, 0x0000000000000000,
  0xffffffff7fffff84, 0x0000000000000000,
  0xffffffff7fffff85, 0x0000000000000000,
  0xffffffff7fffff86, 0x0000000000000000,
  0xffffffffffff7f83, 0x0000000000000000,
  0xffffffffffff7f84, 0x0000000000000000,
  0xffffffffffff7f85, 0x0000000000000000,
  0xffffffffffff7f86, 0x0000000000000000,
  0xffffffffffffff03, 0x0000000000000000,
  0xffffffffffffff04, 0x0000000000000000,
  0xffffffffffffff05, 0x0000000000000000,
  0xffffffffffffff06, 0x0000000000000000,
  0xffffffffffffff43, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffffbf, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000003d, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x000000000000003f, 0x0000000000000000,
  0x0000000000007fbd, 0x0000000000000000,
  0x0000000000007fbe, 0x0000000000000000,
  0x0000000000007fbf, 0x0000000000000000,
  0x000000007fffffbd, 0x0000000000000000,
  0x000000007fffffbe, 0x0000000000000000,
  0x000000007fffffbf, 0x0000000000000000,
  0x33333333333332f3, 0x0000000000000000,
  0x5555555555555515, 0x0000000000000000,
  0x7fffffffffffffbd, 0x0000000000000000,
  0x7fffffffffffffbe, 0x0000000000000000,
  0x7fffffffffffffbf, 0x0000000000000000,
  0x7fffffffffffffc0, 0x0000000000000000,
  0x7fffffffffffffc1, 0x0000000000000000,
  0x7fffffffffffffc2, 0x0000000000000000,
  0x7fffffffffffffc3, 0x0000000000000000,
  0xaaaaaaaaaaaaaa6a, 0x0000000000000000,
  0xcccccccccccccc8c, 0x0000000000000000,
  0xffffffff7fffffc0, 0x0000000000000000,
  0xffffffff7fffffc1, 0x0000000000000000,
  0xffffffff7fffffc2, 0x0000000000000000,
  0xffffffff7fffffc3, 0x0000000000000000,
  0xffffffffffff7fc0, 0x0000000000000000,
  0xffffffffffff7fc1, 0x0000000000000000,
  0xffffffffffff7fc2, 0x0000000000000000,
  0xffffffffffff7fc3, 0x0000000000000000,
  0xffffffffffffff40, 0x0000000000000000,
  0xffffffffffffff41, 0x0000000000000000,
  0xffffffffffffff42, 0x0000000000000000,
  0xffffffffffffff43, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffffbd, 0x0000000000000000,
  0xffffffffffffffbe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000000000003d, 0x0000000000000000,
  0x000000000000007a, 0x0000000000000000,
  0x000000000000007b, 0x0000000000000000,
  0x000000000000007c, 0x0000000000000000,
  0x0000000000007ffa, 0x0000000000000000,
  0x0000000000007ffb, 0x0000000000000000,
  0x0000000000007ffc, 0x0000000000000000,
  0x000000007ffffffa, 0x0000000000000000,
  0x000000007ffffffb, 0x0000000000000000,
  0x000000007ffffffc, 0x0000000000000000,
  0x3333333333333330, 0x0000000000000000,
  0x5555555555555552, 0x0000000000000000,
  0x7ffffffffffffffa, 0x0000000000000000,
  0x7ffffffffffffffb, 0x0000000000000000,
  0x7ffffffffffffffc, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0xaaaaaaaaaaaaaaa7, 0x0000000000000000,
  0xccccccccccccccc9, 0x0000000000000000,
  0xffffffff7ffffffd, 0x0000000000000000,
  0xffffffff7ffffffe, 0x0000000000000000,
  0xffffffff7fffffff, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffffffff7ffd, 0x0000000000000000,
  0xffffffffffff7ffe, 0x0000000000000000,
  0xffffffffffff7fff, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffffff7d, 0x0000000000000000,
  0xffffffffffffff7e, 0x0000000000000000,
  0xffffffffffffff7f, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffffbd, 0x0000000000000000,
  0xfffffffffffffffa, 0x0000000000000000,
  0xfffffffffffffffb, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x000000000000003e, 0x0000000000000000,
  0x000000000000007b, 0x0000000000000000,
  0x000000000000007c, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x0000000000007ffb, 0x0000000000000000,
  0x0000000000007ffc, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x000000007ffffffb, 0x0000000000000000,
  0x000000007ffffffc, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x3333333333333331, 0x0000000000000000,
  0x5555555555555553, 0x0000000000000000,
  0x7ffffffffffffffb, 0x0000000000000000,
  0x7ffffffffffffffc, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0xaaaaaaaaaaaaaaa8, 0x0000000000000000,
  0xccccccccccccccca, 0x0000000000000000,
  0xffffffff7ffffffe, 0x0000000000000000,
  0xffffffff7fffffff, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffffffff7ffe, 0x0000000000000000,
  0xffffffffffff7fff, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffffff7e, 0x0000000000000000,
  0xffffffffffffff7f, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffffbe, 0x0000000000000000,
  0xfffffffffffffffb, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_add_D = 1600;

#endif  // VIXL_SIM_ADD_D_TRACE_AARCH64_H_
