/*!
  * Bootstrap v4.3.1 (https://getbootstrap.com/)
  * Copyright 2011-2019 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
  * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
  */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("jquery")):"function"==typeof define&&define.amd?define(["exports","jquery"],e):e(t.bootstrap={},t.jQuery)}(this,function(t,e){"use strict";
// Shoutout AngusCroll (https://goo.gl/pxwQGp)
function n(t){return{}.toString.call(t).match(/\s([a-z]+)/i)[1].toLowerCase()}function i(){return{bindType:gt,delegateType:gt,handle:function(t){if(e(t.target).is(this))return t.handleObj.handler.apply(this,arguments)}}}function o(t){var n=this,i=!1;return e(this).one(mt.TRANSITION_END,function(){i=!0}),setTimeout(function(){i||mt.triggerTransitionEnd(n)},t),this}function r(t){var e=!1;return function(){e||(e=!0,window.Promise.resolve().then(function(){e=!1,t()}))}}function s(t){var e=!1;return function(){e||(e=!0,setTimeout(function(){e=!1,t()},te))}}/**
 * Check if the given variable is a function
 * @method
 * @memberof Popper.Utils
 * @argument {Any} functionToCheck - variable to check
 * @returns {Boolean} answer to: is a function?
 */
function a(t){var e={};return t&&"[object Function]"===e.toString.call(t)}/**
 * Get CSS computed property of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Eement} element
 * @argument {String} property
 */
function l(t,e){if(1!==t.nodeType)return[];
// NOTE: 1 DOM access here
var n=t.ownerDocument.defaultView,i=n.getComputedStyle(t,null);return e?i[e]:i}/**
 * Returns the parentNode or the host of the element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} parent
 */
function c(t){return"HTML"===t.nodeName?t:t.parentNode||t.host}/**
 * Returns the scrolling parent of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} scroll parent
 */
function u(t){
// Return body, `getScroll` will take care to get the correct `scrollTop` from it
if(!t)return document.body;switch(t.nodeName){case"HTML":case"BODY":return t.ownerDocument.body;case"#document":return t.body}
// Firefox want us to check `-x` and `-y` variations as well
var e=l(t),n=e.overflow,i=e.overflowX;return/(auto|scroll|overlay)/.test(n+e.overflowY+i)?t:u(c(t))}/**
 * Determines if the browser is Internet Explorer
 * @method
 * @memberof Popper.Utils
 * @param {Number} version to check
 * @returns {Boolean} isIE
 */
function h(t){return 11===t?oe:10===t?re:oe||re}/**
 * Returns the offset parent of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} offset parent
 */
function f(t){if(!t)return document.documentElement;
// Skip hidden elements which don't have an offsetParent
for(var e=h(10)?document.body:null,n=t.offsetParent||null;n===e&&t.nextElementSibling;)n=(t=t.nextElementSibling).offsetParent;var i=n&&n.nodeName;
// .offsetParent will return the closest TH, TD or TABLE in case
// no offsetParent is present, I hate this job...
return i&&"BODY"!==i&&"HTML"!==i?-1!==["TH","TD","TABLE"].indexOf(n.nodeName)&&"static"===l(n,"position")?f(n):n:t?t.ownerDocument.documentElement:document.documentElement}function d(t){var e=t.nodeName;return"BODY"!==e&&("HTML"===e||f(t.firstElementChild)===t)}/**
 * Finds the root node (document, shadowDOM root) of the given element
 * @method
 * @memberof Popper.Utils
 * @argument {Element} node
 * @returns {Element} root node
 */
function p(t){return null!==t.parentNode?p(t.parentNode):t}/**
 * Finds the offset parent common to the two provided nodes
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element1
 * @argument {Element} element2
 * @returns {Element} common offset parent
 */
function g(t,e){
// This check is needed to avoid errors in case one of the elements isn't defined for any reason
if(!(t&&t.nodeType&&e&&e.nodeType))return document.documentElement;
// Here we make sure to give as "start" the element that comes first in the DOM
var n=t.compareDocumentPosition(e)&Node.DOCUMENT_POSITION_FOLLOWING,i=n?t:e,o=n?e:t,r=document.createRange();r.setStart(i,0),r.setEnd(o,0);var s=r.commonAncestorContainer;
// Both nodes are inside #document
if(t!==s&&e!==s||i.contains(o))return d(s)?s:f(s);
// one of the nodes is inside shadowDOM, find which one
var a=p(t);return a.host?g(a.host,e):g(t,p(e).host)}/**
 * Gets the scroll value of the given element in the given side (top and left)
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @argument {String} side `top` or `left`
 * @returns {number} amount of scrolled pixels
 */
function m(t,e){void 0===e&&(e="top");var n="top"===e?"scrollTop":"scrollLeft",i=t.nodeName;if("BODY"===i||"HTML"===i){var o=t.ownerDocument.documentElement;return(t.ownerDocument.scrollingElement||o)[n]}return t[n]}/*
 * Sum or subtract the element scroll values (left and top) from a given rect object
 * @method
 * @memberof Popper.Utils
 * @param {Object} rect - Rect object you want to change
 * @param {HTMLElement} element - The element from the function reads the scroll values
 * @param {Boolean} subtract - set to true if you want to subtract the scroll values
 * @return {Object} rect - The modifier rect object
 */
function _(t,e,n){void 0===n&&(n=!1);var i=m(e,"top"),o=m(e,"left"),r=n?-1:1;return t.top+=i*r,t.bottom+=i*r,t.left+=o*r,t.right+=o*r,t}/*
 * Helper to detect borders of a given element
 * @method
 * @memberof Popper.Utils
 * @param {CSSStyleDeclaration} styles
 * Result of `getStyleComputedProperty` on the given element
 * @param {String} axis - `x` or `y`
 * @return {number} borders - The borders size of the given axis
 */
function v(t,e){var n="x"===e?"Left":"Top",i="Left"===n?"Right":"Bottom";return parseFloat(t["border"+n+"Width"],10)+parseFloat(t["border"+i+"Width"],10)}function E(t,e,n,i){return Math.max(e["offset"+t],e["scroll"+t],n["client"+t],n["offset"+t],n["scroll"+t],h(10)?parseInt(n["offset"+t])+parseInt(i["margin"+("Height"===t?"Top":"Left")])+parseInt(i["margin"+("Height"===t?"Bottom":"Right")]):0)}function b(t){var e=t.body,n=t.documentElement,i=h(10)&&getComputedStyle(n);return{height:E("Height",e,n,i),width:E("Width",e,n,i)}}/**
 * Given element offsets, generate an output similar to getBoundingClientRect
 * @method
 * @memberof Popper.Utils
 * @argument {Object} offsets
 * @returns {Object} ClientRect like output
 */
function T(t){return Object.assign({},t,{right:t.left+t.width,bottom:t.top+t.height})}/**
 * Get bounding client rect of given element
 * @method
 * @memberof Popper.Utils
 * @param {HTMLElement} element
 * @return {Object} client rect
 */
function y(t){var e={};
// IE10 10 FIX: Please, don't ask, the element isn't
// considered in DOM in some circumstances...
// This isn't reproducible in IE10 compatibility mode of IE11
try{if(h(10)){e=t.getBoundingClientRect();var n=m(t,"top"),i=m(t,"left");e.top+=n,e.left+=i,e.bottom+=n,e.right+=i}else e=t.getBoundingClientRect()}catch(t){}var o={left:e.left,top:e.top,width:e.right-e.left,height:e.bottom-e.top},r="HTML"===t.nodeName?b(t.ownerDocument):{},s=r.width||t.clientWidth||o.right-o.left,a=r.height||t.clientHeight||o.bottom-o.top,c=t.offsetWidth-s,u=t.offsetHeight-a;
// if an hypothetical scrollbar is detected, we must be sure it's not a `border`
// we make this check conditional for performance reasons
if(c||u){var f=l(t);c-=v(f,"x"),u-=v(f,"y"),o.width-=c,o.height-=u}return T(o)}function O(t,e,n){void 0===n&&(n=!1);var i=h(10),o="HTML"===e.nodeName,r=y(t),s=y(e),a=u(t),c=l(e),f=parseFloat(c.borderTopWidth,10),d=parseFloat(c.borderLeftWidth,10);
// In cases where the parent is fixed, we must ignore negative scroll in offset calc
n&&o&&(s.top=Math.max(s.top,0),s.left=Math.max(s.left,0));var p=T({top:r.top-s.top-f,left:r.left-s.left-d,width:r.width,height:r.height});
// Subtract margins of documentElement in case it's being used as parent
// we do this only on HTML because it's the only element that behaves
// differently when margins are applied to it. The margins are included in
// the box of the documentElement, in the other cases not.
if(p.marginTop=0,p.marginLeft=0,!i&&o){var g=parseFloat(c.marginTop,10),m=parseFloat(c.marginLeft,10);p.top-=f-g,p.bottom-=f-g,p.left-=d-m,p.right-=d-m,
// Attach marginTop and marginLeft because in some circumstances we may need them
p.marginTop=g,p.marginLeft=m}return(i&&!n?e.contains(a):e===a&&"BODY"!==a.nodeName)&&(p=_(p,e)),p}function S(t,e){void 0===e&&(e=!1);var n=t.ownerDocument.documentElement,i=O(t,n),o=Math.max(n.clientWidth,window.innerWidth||0),r=Math.max(n.clientHeight,window.innerHeight||0),s=e?0:m(n),a=e?0:m(n,"left");return T({top:s-i.top+i.marginTop,left:a-i.left+i.marginLeft,width:o,height:r})}/**
 * Check if the given element is fixed or is inside a fixed parent
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @argument {Element} customContainer
 * @returns {Boolean} answer to "isFixed?"
 */
function I(t){var e=t.nodeName;return"BODY"!==e&&"HTML"!==e&&("fixed"===l(t,"position")||I(c(t)))}/**
 * Finds the first parent of an element that has a transformed property defined
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Element} first transformed parent or documentElement
 */
function A(t){
// This check is needed to avoid errors in case one of the elements isn't defined for any reason
if(!t||!t.parentElement||h())return document.documentElement;for(var e=t.parentElement;e&&"none"===l(e,"transform");)e=e.parentElement;return e||document.documentElement}/**
 * Computed the boundaries limits and return them
 * @method
 * @memberof Popper.Utils
 * @param {HTMLElement} popper
 * @param {HTMLElement} reference
 * @param {number} padding
 * @param {HTMLElement} boundariesElement - Element used to define the boundaries
 * @param {Boolean} fixedPosition - Is in fixed position mode
 * @returns {Object} Coordinates of the boundaries
 */
function C(t,e,n,i,o){void 0===o&&(o=!1);
// NOTE: 1 DOM access here
var r={top:0,left:0},s=o?A(t):g(t,e);
// Handle viewport case
if("viewport"===i)r=S(s,o);else{
// Handle other cases based on DOM element used as boundaries
var a;"scrollParent"===i?(a=u(c(e)),"BODY"===a.nodeName&&(a=t.ownerDocument.documentElement)):a="window"===i?t.ownerDocument.documentElement:i;var l=O(a,s,o);
// In case of HTML, we need a different computation
if("HTML"!==a.nodeName||I(s))
// for all the other DOM elements, this one is good
r=l;else{var h=b(t.ownerDocument),f=h.height,d=h.width;r.top+=l.top-l.marginTop,r.bottom=f+l.top,r.left+=l.left-l.marginLeft,r.right=d+l.left}}
// Add paddings
n=n||0;var p="number"==typeof n;return r.left+=p?n:n.left||0,r.top+=p?n:n.top||0,r.right-=p?n:n.right||0,r.bottom-=p?n:n.bottom||0,r}function D(t){return t.width*t.height}/**
 * Utility used to transform the `auto` placement to the placement with more
 * available space.
 * @method
 * @memberof Popper.Utils
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function w(t,e,n,i,o,r){if(void 0===r&&(r=0),-1===t.indexOf("auto"))return t;var s=C(n,i,r,o),a={top:{width:s.width,height:e.top-s.top},right:{width:s.right-e.right,height:s.height},bottom:{width:s.width,height:s.bottom-e.bottom},left:{width:e.left-s.left,height:s.height}},l=Object.keys(a).map(function(t){return Object.assign({},{key:t},a[t],{area:D(a[t])})}).sort(function(t,e){return e.area-t.area}),c=l.filter(function(t){var e=t.width,i=t.height;return e>=n.clientWidth&&i>=n.clientHeight}),u=c.length>0?c[0].key:l[0].key,h=t.split("-")[1];return u+(h?"-"+h:"")}/**
 * Get offsets to the reference element
 * @method
 * @memberof Popper.Utils
 * @param {Object} state
 * @param {Element} popper - the popper element
 * @param {Element} reference - the reference element (the popper will be relative to this)
 * @param {Element} fixedPosition - is in fixed position mode
 * @returns {Object} An object containing the offsets which will be applied to the popper
 */
function N(t,e,n,i){return void 0===i&&(i=null),O(n,i?A(e):g(e,n),i)}/**
 * Get the outer sizes of the given element (offset size + margins)
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element
 * @returns {Object} object containing width and height properties
 */
function L(t){var e=t.ownerDocument.defaultView,n=e.getComputedStyle(t),i=parseFloat(n.marginTop||0)+parseFloat(n.marginBottom||0),o=parseFloat(n.marginLeft||0)+parseFloat(n.marginRight||0);return{width:t.offsetWidth+o,height:t.offsetHeight+i}}/**
 * Get the opposite placement of the given one
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement
 * @returns {String} flipped placement
 */
function P(t){var e={left:"right",right:"left",bottom:"top",top:"bottom"};return t.replace(/left|right|bottom|top/g,function(t){return e[t]})}/**
 * Get offsets to the popper
 * @method
 * @memberof Popper.Utils
 * @param {Object} position - CSS position the Popper will get applied
 * @param {HTMLElement} popper - the popper element
 * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
 * @param {String} placement - one of the valid placement options
 * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
 */
function R(t,e,n){n=n.split("-")[0];
// Get popper node sizes
var i=L(t),o={width:i.width,height:i.height},r=-1!==["right","left"].indexOf(n),s=r?"top":"left",a=r?"left":"top",l=r?"height":"width",c=r?"width":"height";return o[s]=e[s]+e[l]/2-i[l]/2,o[a]=n===a?e[a]-i[c]:e[P(a)],o}/**
 * Mimics the `find` method of Array
 * @method
 * @memberof Popper.Utils
 * @argument {Array} arr
 * @argument prop
 * @argument value
 * @returns index or -1
 */
function H(t,e){
// use native find if supported
// use native find if supported
return Array.prototype.find?t.find(e):t.filter(e)[0]}/**
 * Return the index of the matching object
 * @method
 * @memberof Popper.Utils
 * @argument {Array} arr
 * @argument prop
 * @argument value
 * @returns index or -1
 */
function W(t,e,n){
// use native findIndex if supported
if(Array.prototype.findIndex)return t.findIndex(function(t){return t[e]===n});
// use `find` + `indexOf` if `findIndex` isn't supported
var i=H(t,function(t){return t[e]===n});return t.indexOf(i)}/**
 * Loop trough the list of modifiers and run them in order,
 * each of them will then edit the data object.
 * @method
 * @memberof Popper.Utils
 * @param {dataObject} data
 * @param {Array} modifiers
 * @param {String} ends - Optional modifier name used as stopper
 * @returns {dataObject}
 */
function F(t,e,n){return(void 0===n?t:t.slice(0,W(t,"name",n))).forEach(function(t){t.function&&// eslint-disable-line dot-notation
console.warn("`modifier.function` is deprecated, use `modifier.fn`!");var n=t.function||t.fn;// eslint-disable-line dot-notation
t.enabled&&a(n)&&(
// Add properties to offsets to make them a complete clientRect object
// we do this before each modifier to make sure the previous one doesn't
// mess with these values
e.offsets.popper=T(e.offsets.popper),e.offsets.reference=T(e.offsets.reference),e=n(e,t))}),e}/**
 * Updates the position of the popper, computing the new offsets and applying
 * the new style.<br />
 * Prefer `scheduleUpdate` over `update` because of performance reasons.
 * @method
 * @memberof Popper
 */
function M(){
// if popper is destroyed, don't perform any further update
if(!this.state.isDestroyed){var t={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:!1,offsets:{}};
// compute reference element offsets
t.offsets.reference=N(this.state,this.popper,this.reference,this.options.positionFixed),
// compute auto placement, store placement inside the data object,
// modifiers will be able to edit `placement` if needed
// and refer to originalPlacement to know the original value
t.placement=w(this.options.placement,t.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding),
// store the computed placement inside `originalPlacement`
t.originalPlacement=t.placement,t.positionFixed=this.options.positionFixed,
// compute the popper offsets
t.offsets.popper=R(this.popper,t.offsets.reference,t.placement),t.offsets.popper.position=this.options.positionFixed?"fixed":"absolute",
// run the modifiers
t=F(this.modifiers,t),
// the first `update` will call `onCreate` callback
// the other ones will call `onUpdate` callback
this.state.isCreated?this.options.onUpdate(t):(this.state.isCreated=!0,this.options.onCreate(t))}}/**
 * Helper used to know if the given modifier is enabled.
 * @method
 * @memberof Popper.Utils
 * @returns {Boolean}
 */
function j(t,e){return t.some(function(t){var n=t.name;return t.enabled&&n===e})}/**
 * Get the prefixed supported property name
 * @method
 * @memberof Popper.Utils
 * @argument {String} property (camelCase)
 * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
 */
function x(t){for(var e=[!1,"ms","Webkit","Moz","O"],n=t.charAt(0).toUpperCase()+t.slice(1),i=0;i<e.length;i++){var o=e[i],r=o?""+o+n:t;if(void 0!==document.body.style[r])return r}return null}/**
 * Destroys the popper.
 * @method
 * @memberof Popper
 */
function V(){
// touch DOM only if `applyStyle` modifier is enabled
// remove the popper if user explicity asked for the deletion on destroy
// do not use `remove` because IE11 doesn't support it
return this.state.isDestroyed=!0,j(this.modifiers,"applyStyle")&&(this.popper.removeAttribute("x-placement"),this.popper.style.position="",this.popper.style.top="",this.popper.style.left="",this.popper.style.right="",this.popper.style.bottom="",this.popper.style.willChange="",this.popper.style[x("transform")]=""),this.disableEventListeners(),this.options.removeOnDestroy&&this.popper.parentNode.removeChild(this.popper),this}/**
 * Get the window associated with the element
 * @argument {Element} element
 * @returns {Window}
 */
function U(t){var e=t.ownerDocument;return e?e.defaultView:window}function k(t,e,n,i){var o="BODY"===t.nodeName,r=o?t.ownerDocument.defaultView:t;r.addEventListener(e,n,{passive:!0}),o||k(u(r.parentNode),e,n,i),i.push(r)}/**
 * Setup needed event listeners used to update the popper position
 * @method
 * @memberof Popper.Utils
 * @private
 */
function B(t,e,n,i){
// Resize event listener on window
n.updateBound=i,U(t).addEventListener("resize",n.updateBound,{passive:!0});
// Scroll event listener on scroll parents
var o=u(t);return k(o,"scroll",n.updateBound,n.scrollParents),n.scrollElement=o,n.eventsEnabled=!0,n}/**
 * It will add resize/scroll events and start recalculating
 * position of the popper element when they are triggered.
 * @method
 * @memberof Popper
 */
function G(){this.state.eventsEnabled||(this.state=B(this.reference,this.options,this.state,this.scheduleUpdate))}/**
 * Remove event listeners used to update the popper position
 * @method
 * @memberof Popper.Utils
 * @private
 */
function K(t,e){
// Remove resize event listener on window
// Remove scroll event listener on scroll parents
// Reset state
return U(t).removeEventListener("resize",e.updateBound),e.scrollParents.forEach(function(t){t.removeEventListener("scroll",e.updateBound)}),e.updateBound=null,e.scrollParents=[],e.scrollElement=null,e.eventsEnabled=!1,e}/**
 * It will remove resize/scroll events and won't recalculate popper position
 * when they are triggered. It also won't trigger `onUpdate` callback anymore,
 * unless you call `update` method manually.
 * @method
 * @memberof Popper
 */
function q(){this.state.eventsEnabled&&(cancelAnimationFrame(this.scheduleUpdate),this.state=K(this.reference,this.state))}/**
 * Tells if a given input is a number
 * @method
 * @memberof Popper.Utils
 * @param {*} input to check
 * @return {Boolean}
 */
function Q(t){return""!==t&&!isNaN(parseFloat(t))&&isFinite(t)}/**
 * Set the style to the given popper
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element - Element to apply the style to
 * @argument {Object} styles
 * Object with a list of properties and values which will be applied to the element
 */
function Y(t,e){Object.keys(e).forEach(function(n){var i="";
// add unit if the value is numeric and is one of the following
-1!==["width","height","top","right","bottom","left"].indexOf(n)&&Q(e[n])&&(i="px"),t.style[n]=e[n]+i})}/**
 * Set the attributes to the given popper
 * @method
 * @memberof Popper.Utils
 * @argument {Element} element - Element to apply the attributes to
 * @argument {Object} styles
 * Object with a list of properties and values which will be applied to the element
 */
function X(t,e){Object.keys(e).forEach(function(n){!1!==e[n]?t.setAttribute(n,e[n]):t.removeAttribute(n)})}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} data.styles - List of style properties - values to apply to popper element
 * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The same data object
 */
function z(t){
// any property present in `data.styles` will be applied to the popper,
// in this way we can make the 3rd party modifiers add custom styles to it
// Be aware, modifiers could override the properties defined in the previous
// lines of this modifier!
// any property present in `data.attributes` will be applied to the popper,
// they will be set as HTML attributes of the element
// if arrowElement is defined and arrowStyles has some properties
return Y(t.instance.popper,t.styles),X(t.instance.popper,t.attributes),t.arrowElement&&Object.keys(t.arrowStyles).length&&Y(t.arrowElement,t.arrowStyles),t}/**
 * Set the x-placement attribute before everything else because it could be used
 * to add margins to the popper margins needs to be calculated to get the
 * correct popper offsets.
 * @method
 * @memberof Popper.modifiers
 * @param {HTMLElement} reference - The reference element used to position the popper
 * @param {HTMLElement} popper - The HTML element used as popper
 * @param {Object} options - Popper.js options
 */
function $(t,e,n,i,o){
// compute reference element offsets
var r=N(o,e,t,n.positionFixed),s=w(n.placement,r,e,t,n.modifiers.flip.boundariesElement,n.modifiers.flip.padding);
// Apply `position` to popper before anything else because
// without the position applied we can't guarantee correct computations
return e.setAttribute("x-placement",s),Y(e,{position:n.positionFixed?"fixed":"absolute"}),n}/**
 * @function
 * @memberof Popper.Utils
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Boolean} shouldRound - If the offsets should be rounded at all
 * @returns {Object} The popper's position offsets rounded
 *
 * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
 * good as it can be within reason.
 * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
 *
 * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
 * as well on High DPI screens).
 *
 * Firefox prefers no rounding for positioning and does not have blurriness on
 * high DPI screens.
 *
 * Only horizontal placement and left/right values need to be considered.
 */
function J(t,e){var n=t.offsets,i=n.popper,o=n.reference,r=-1!==["left","right"].indexOf(t.placement),s=-1!==t.placement.indexOf("-"),a=o.width%2==i.width%2,l=o.width%2==1&&i.width%2==1,c=function(t){return t},u=e?r||s||a?Math.round:Math.floor:c,h=e?Math.round:c;return{left:u(l&&!s&&e?i.left-1:i.left),top:h(i.top),bottom:h(i.bottom),right:u(i.right)}}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function Z(t,e){var n=e.x,i=e.y,o=t.offsets,r=o.popper,s=H(t.instance.modifiers,function(t){return"applyStyle"===t.name}).gpuAcceleration;void 0!==s&&console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!");var a,l,c=void 0!==s?s:e.gpuAcceleration,u=f(t.instance.popper),h=y(u),d={position:r.position},p=J(t,window.devicePixelRatio<2||!se),g="bottom"===n?"top":"bottom",m="right"===i?"left":"right",_=x("transform");if(l="bottom"===g?
// when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
// and not the bottom of the html element
"HTML"===u.nodeName?-u.clientHeight+p.bottom:-h.height+p.bottom:p.top,a="right"===m?"HTML"===u.nodeName?-u.clientWidth+p.right:-h.width+p.right:p.left,c&&_)d[_]="translate3d("+a+"px, "+l+"px, 0)",d[g]=0,d[m]=0,d.willChange="transform";else{
// othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
var v="bottom"===g?-1:1,E="right"===m?-1:1;d[g]=l*v,d[m]=a*E,d.willChange=g+", "+m}
// Attributes
var b={"x-placement":t.placement};
// Update `data` attributes, styles and arrowStyles
return t.attributes=Object.assign({},b,t.attributes),t.styles=Object.assign({},d,t.styles),t.arrowStyles=Object.assign({},t.offsets.arrow,t.arrowStyles),t}/**
 * Helper used to know if the given modifier depends from another one.<br />
 * It checks if the needed modifier is listed and enabled.
 * @method
 * @memberof Popper.Utils
 * @param {Array} modifiers - list of modifiers
 * @param {String} requestingName - name of requesting modifier
 * @param {String} requestedName - name of requested modifier
 * @returns {Boolean}
 */
function tt(t,e,n){var i=H(t,function(t){return t.name===e}),o=!!i&&t.some(function(t){return t.name===n&&t.enabled&&t.order<i.order});if(!o){var r="`"+e+"`",s="`"+n+"`";console.warn(s+" modifier is required by "+r+" modifier in order to work, be sure to include it before "+r+"!")}return o}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function et(t,e){var n;
// arrow depends on keepTogether in order to work
if(!tt(t.instance.modifiers,"arrow","keepTogether"))return t;var i=e.element;
// if arrowElement is a string, suppose it's a CSS selector
if("string"==typeof i){
// if arrowElement is not found, don't run the modifier
if(!(i=t.instance.popper.querySelector(i)))return t}else
// if the arrowElement isn't a query selector we must check that the
// provided DOM node is child of its popper node
if(!t.instance.popper.contains(i))return console.warn("WARNING: `arrow.element` must be child of its popper element!"),t;var o=t.placement.split("-")[0],r=t.offsets,s=r.popper,a=r.reference,c=-1!==["left","right"].indexOf(o),u=c?"height":"width",h=c?"Top":"Left",f=h.toLowerCase(),d=c?"left":"top",p=c?"bottom":"right",g=L(i)[u];
//
// extends keepTogether behavior making sure the popper and its
// reference have enough pixels in conjunction
//
// top/left side
a[p]-g<s[f]&&(t.offsets.popper[f]-=s[f]-(a[p]-g)),
// bottom/right side
a[f]+g>s[p]&&(t.offsets.popper[f]+=a[f]+g-s[p]),t.offsets.popper=T(t.offsets.popper);
// compute center of the popper
var m=a[f]+a[u]/2-g/2,_=l(t.instance.popper),v=parseFloat(_["margin"+h],10),E=parseFloat(_["border"+h+"Width"],10),b=m-t.offsets.popper[f]-v-E;
// prevent arrowElement from being placed not contiguously to its popper
return b=Math.max(Math.min(s[u]-g,b),0),t.arrowElement=i,t.offsets.arrow=(n={},n[f]=Math.round(b),n[d]="",n),t}/**
 * Get the opposite placement variation of the given one
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement variation
 * @returns {String} flipped placement variation
 */
function nt(t){return"end"===t?"start":"start"===t?"end":t}/**
 * Given an initial placement, returns all the subsequent placements
 * clockwise (or counter-clockwise).
 *
 * @method
 * @memberof Popper.Utils
 * @argument {String} placement - A valid placement (it accepts variations)
 * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
 * @returns {Array} placements including their variations
 */
function it(t,e){void 0===e&&(e=!1);var n=le.indexOf(t),i=le.slice(n+1).concat(le.slice(0,n));return e?i.reverse():i}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function ot(t,e){
// if `inner` modifier is enabled, we can't use the `flip` modifier
if(j(t.instance.modifiers,"inner"))return t;if(t.flipped&&t.placement===t.originalPlacement)
// seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
return t;var n=C(t.instance.popper,t.instance.reference,e.padding,e.boundariesElement,t.positionFixed),i=t.placement.split("-")[0],o=P(i),r=t.placement.split("-")[1]||"",s=[];switch(e.behavior){case ce.FLIP:s=[i,o];break;case ce.CLOCKWISE:s=it(i);break;case ce.COUNTERCLOCKWISE:s=it(i,!0);break;default:s=e.behavior}return s.forEach(function(a,l){if(i!==a||s.length===l+1)return t;i=t.placement.split("-")[0],o=P(i);var c=t.offsets.popper,u=t.offsets.reference,h=Math.floor,f="left"===i&&h(c.right)>h(u.left)||"right"===i&&h(c.left)<h(u.right)||"top"===i&&h(c.bottom)>h(u.top)||"bottom"===i&&h(c.top)<h(u.bottom),d=h(c.left)<h(n.left),p=h(c.right)>h(n.right),g=h(c.top)<h(n.top),m=h(c.bottom)>h(n.bottom),_="left"===i&&d||"right"===i&&p||"top"===i&&g||"bottom"===i&&m,v=-1!==["top","bottom"].indexOf(i),E=!!e.flipVariations&&(v&&"start"===r&&d||v&&"end"===r&&p||!v&&"start"===r&&g||!v&&"end"===r&&m);(f||_||E)&&(
// this boolean to detect any flip loop
t.flipped=!0,(f||_)&&(i=s[l+1]),E&&(r=nt(r)),t.placement=i+(r?"-"+r:""),
// this object contains `position`, we want to preserve it along with
// any additional property we may add in the future
t.offsets.popper=Object.assign({},t.offsets.popper,R(t.instance.popper,t.offsets.reference,t.placement)),t=F(t.instance.modifiers,t,"flip"))}),t}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function rt(t){var e=t.offsets,n=e.popper,i=e.reference,o=t.placement.split("-")[0],r=Math.floor,s=-1!==["top","bottom"].indexOf(o),a=s?"right":"bottom",l=s?"left":"top",c=s?"width":"height";return n[a]<r(i[l])&&(t.offsets.popper[l]=r(i[l])-n[c]),n[l]>r(i[a])&&(t.offsets.popper[l]=r(i[a])),t}/**
 * Converts a string containing value + unit into a px value number
 * @function
 * @memberof {modifiers~offset}
 * @private
 * @argument {String} str - Value + unit string
 * @argument {String} measurement - `height` or `width`
 * @argument {Object} popperOffsets
 * @argument {Object} referenceOffsets
 * @returns {Number|String}
 * Value in pixels, or original string if no values were extracted
 */
function st(t,e,n,i){
// separate value from unit
var o=t.match(/((?:\-|\+)?\d*\.?\d*)(.*)/),r=+o[1],s=o[2];
// If it's not a number it's an operator, I guess
if(!r)return t;if(0===s.indexOf("%")){var a;switch(s){case"%p":a=n;break;case"%":case"%r":default:a=i}return T(a)[e]/100*r}if("vh"===s||"vw"===s){return("vh"===s?Math.max(document.documentElement.clientHeight,window.innerHeight||0):Math.max(document.documentElement.clientWidth,window.innerWidth||0))/100*r}
// if is an explicit pixel unit, we get rid of the unit and keep the value
// if is an implicit unit, it's px, and we return just the value
return r}/**
 * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
 * @function
 * @memberof {modifiers~offset}
 * @private
 * @argument {String} offset
 * @argument {Object} popperOffsets
 * @argument {Object} referenceOffsets
 * @argument {String} basePlacement
 * @returns {Array} a two cells array with x and y offsets in numbers
 */
function at(t,e,n,i){var o=[0,0],r=-1!==["right","left"].indexOf(i),s=t.split(/(\+|\-)/).map(function(t){return t.trim()}),a=s.indexOf(H(s,function(t){return-1!==t.search(/,|\s/)}));s[a]&&-1===s[a].indexOf(",")&&console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.");
// If divider is found, we divide the list of values and operands to divide
// them by ofset X and Y.
var l=/\s*,\s*|\s+/,c=-1!==a?[s.slice(0,a).concat([s[a].split(l)[0]]),[s[a].split(l)[1]].concat(s.slice(a+1))]:[s];
// Convert the values with units to absolute pixels to allow our computations
// Loop trough the offsets arrays and execute the operations
return c=c.map(function(t,i){
// Most of the units rely on the orientation of the popper
var o=(1===i?!r:r)?"height":"width",s=!1;return t.reduce(function(t,e){return""===t[t.length-1]&&-1!==["+","-"].indexOf(e)?(t[t.length-1]=e,s=!0,t):s?(t[t.length-1]+=e,s=!1,t):t.concat(e)},[]).map(function(t){return st(t,o,e,n)})}),c.forEach(function(t,e){t.forEach(function(n,i){Q(n)&&(o[e]+=n*("-"===t[i-1]?-1:1))})}),o}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @argument {Number|String} options.offset=0
 * The offset value as described in the modifier description
 * @returns {Object} The data object, properly modified
 */
function lt(t,e){var n,i=e.offset,o=t.placement,r=t.offsets,s=r.popper,a=r.reference,l=o.split("-")[0];return n=Q(+i)?[+i,0]:at(i,s,a,l),"left"===l?(s.top+=n[0],s.left-=n[1]):"right"===l?(s.top+=n[0],s.left+=n[1]):"top"===l?(s.left+=n[0],s.top-=n[1]):"bottom"===l&&(s.left+=n[0],s.top+=n[1]),t.popper=s,t}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function ct(t,e){var n=e.boundariesElement||f(t.instance.popper);
// If offsetParent is the reference element, we really want to
// go one step up and use the next offsetParent as reference to
// avoid to make this modifier completely useless and look like broken
t.instance.reference===n&&(n=f(n));
// NOTE: DOM access here
// resets the popper's position so that the document size can be calculated excluding
// the size of the popper element itself
var i=x("transform"),o=t.instance.popper.style,r=o.top,s=o.left,a=o[i];o.top="",o.left="",o[i]="";var l=C(t.instance.popper,t.instance.reference,e.padding,n,t.positionFixed);
// NOTE: DOM access here
// restores the original style properties after the offsets have been computed
o.top=r,o.left=s,o[i]=a,e.boundaries=l;var c=e.priority,u=t.offsets.popper,h={primary:function(t){var n,i=u[t];return u[t]<l[t]&&!e.escapeWithReference&&(i=Math.max(u[t],l[t])),n={},n[t]=i,n},secondary:function(t){var n,i="right"===t?"left":"top",o=u[i];return u[t]>l[t]&&!e.escapeWithReference&&(o=Math.min(u[i],l[t]-("right"===t?u.width:u.height))),n={},n[i]=o,n}};return c.forEach(function(t){var e=-1!==["left","top"].indexOf(t)?"primary":"secondary";u=Object.assign({},u,h[e](t))}),t.offsets.popper=u,t}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function ut(t){var e,n,i=t.placement,o=i.split("-")[0],r=i.split("-")[1];
// if shift shiftvariation is specified, run the modifier
if(r){var s=t.offsets,a=s.reference,l=s.popper,c=-1!==["bottom","top"].indexOf(o),u=c?"left":"top",h=c?"width":"height",f={start:(e={},e[u]=a[u],e),end:(n={},n[u]=a[u]+a[h]-l[h],n)};t.offsets.popper=Object.assign({},l,f[r])}return t}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by update method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function ht(t){if(!tt(t.instance.modifiers,"hide","preventOverflow"))return t;var e=t.offsets.reference,n=H(t.instance.modifiers,function(t){return"preventOverflow"===t.name}).boundaries;if(e.bottom<n.top||e.left>n.right||e.top>n.bottom||e.right<n.left){
// Avoid unnecessary DOM access if visibility hasn't changed
if(!0===t.hide)return t;t.hide=!0,t.attributes["x-out-of-boundaries"]=""}else{
// Avoid unnecessary DOM access if visibility hasn't changed
if(!1===t.hide)return t;t.hide=!1,t.attributes["x-out-of-boundaries"]=!1}return t}/**
 * @function
 * @memberof Modifiers
 * @argument {Object} data - The data object generated by `update` method
 * @argument {Object} options - Modifiers configuration and options
 * @returns {Object} The data object, properly modified
 */
function ft(t){var e=t.placement,n=e.split("-")[0],i=t.offsets,o=i.popper,r=i.reference,s=-1!==["left","right"].indexOf(n),a=-1===["top","left"].indexOf(n);return o[s?"left":"top"]=r[n]-(a?o[s?"width":"height"]:0),t.placement=P(e),t.offsets.popper=T(o),t}function dt(t,e){var n=t.nodeName.toLowerCase();if(-1!==e.indexOf(n))return-1===Pe.indexOf(n)||Boolean(t.nodeValue.match(We)||t.nodeValue.match(Fe));
// Check if a regular expression validates the attribute.
for(var i=e.filter(function(t){return t instanceof RegExp}),o=0,r=i.length;o<r;o++)if(n.match(i[o]))return!0;return!1}function pt(t,e,n){if(0===t.length)return t;if(n&&"function"==typeof n)return n(t);for(var i=new window.DOMParser,o=i.parseFromString(t,"text/html"),r=Object.keys(e),s=[].slice.call(o.body.querySelectorAll("*")),a=0,l=s.length;a<l;a++)!function(t,n){var i=s[t],o=i.nodeName.toLowerCase();if(-1===r.indexOf(i.nodeName.toLowerCase()))return void i.parentNode.removeChild(i);var a=[].slice.call(i.attributes),l=[].concat(e["*"]||[],e[o]||[]);a.forEach(function(t){dt(t,l)||i.removeAttribute(t.nodeName)})}(a);return o.body.innerHTML}e=e&&e.hasOwnProperty("default")?e.default:e;/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): util.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Private TransitionEnd Helpers
 * ------------------------------------------------------------------------
 */
var gt="transitionend",mt={TRANSITION_END:"bsTransitionEnd",getUID:function(t){do{
// eslint-disable-next-line no-bitwise
t+=~~(1e6*Math.random())}while(document.getElementById(t));return t},getSelectorFromElement:function(t){var e=t.getAttribute("data-target");if(!e||"#"===e){var n=t.getAttribute("href");e=n&&"#"!==n?n.trim():""}try{return document.querySelector(e)?e:null}catch(t){return null}},getTransitionDurationFromElement:function(t){if(!t)return 0;
// Get transition-duration of the element
var n=e(t).css("transition-duration"),i=e(t).css("transition-delay"),o=parseFloat(n),r=parseFloat(i);
// Return 0 if element or transition duration is not found
// Return 0 if element or transition duration is not found
// If multiple durations are defined, take the first
return o||r?(n=n.split(",")[0],i=i.split(",")[0],1e3*(parseFloat(n)+parseFloat(i))):0},reflow:function(t){return t.offsetHeight},triggerTransitionEnd:function(t){e(t).trigger(gt)},
// TODO: Remove in v5
supportsTransitionEnd:function(){return Boolean(gt)},isElement:function(t){return(t[0]||t).nodeType},typeCheckConfig:function(t,e,i){for(var o in i)if(Object.prototype.hasOwnProperty.call(i,o)){var r=i[o],s=e[o],a=s&&mt.isElement(s)?"element":n(s);if(!new RegExp(r).test(a))throw new Error(t.toUpperCase()+': Option "'+o+'" provided type "'+a+'" but expected type "'+r+'".')}},findShadowRoot:function(t){if(!document.documentElement.attachShadow)return null;
// Can find the shadow root otherwise it'll return the document
if("function"==typeof t.getRootNode){var e=t.getRootNode();return e instanceof ShadowRoot?e:null}
// when we don't find a shadow root
return t instanceof ShadowRoot?t:t.parentNode?mt.findShadowRoot(t.parentNode):null}};!function(){e.fn.emulateTransitionEnd=o,e.event.special[mt.TRANSITION_END]=i()}();/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): alert.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var _t="alert",vt=e.fn[_t],Et={DISMISS:'[data-dismiss="alert"]'},bt={CLOSE:"close.bs.alert",CLOSED:"closed.bs.alert",CLICK_DATA_API:"click.bs.alert.data-api"},Tt={ALERT:"alert",FADE:"fade",SHOW:"show"},yt=function(t){this._element=t},Ot={VERSION:{configurable:!0}};
// Getters
Ot.VERSION.get=function(){return"4.3.1"},
// Public
yt.prototype.close=function(t){var e=this._element;t&&(e=this._getRootElement(t)),this._triggerCloseEvent(e).isDefaultPrevented()||this._removeElement(e)},yt.prototype.dispose=function(){e.removeData(this._element,"bs.alert"),this._element=null},
// Private
yt.prototype._getRootElement=function(t){var n=mt.getSelectorFromElement(t),i=!1;return n&&(i=document.querySelector(n)),i||(i=e(t).closest("."+Tt.ALERT)[0]),i},yt.prototype._triggerCloseEvent=function(t){var n=e.Event(bt.CLOSE);return e(t).trigger(n),n},yt.prototype._removeElement=function(t){var n=this;if(e(t).removeClass(Tt.SHOW),!e(t).hasClass(Tt.FADE))return void this._destroyElement(t);var i=mt.getTransitionDurationFromElement(t);e(t).one(mt.TRANSITION_END,function(e){return n._destroyElement(t,e)}).emulateTransitionEnd(i)},yt.prototype._destroyElement=function(t){e(t).detach().trigger(bt.CLOSED).remove()},
// Static
yt._jQueryInterface=function(t){return this.each(function(){var n=e(this),i=n.data("bs.alert");i||(i=new yt(this),n.data("bs.alert",i)),"close"===t&&i[t](this)})},yt._handleDismiss=function(t){return function(e){e&&e.preventDefault(),t.close(this)}},Object.defineProperties(yt,Ot),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(bt.CLICK_DATA_API,Et.DISMISS,yt._handleDismiss(new yt)),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[_t]=yt._jQueryInterface,e.fn[_t].Constructor=yt,e.fn[_t].noConflict=function(){return e.fn[_t]=vt,yt._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): button.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var St=e.fn.button,It={ACTIVE:"active",BUTTON:"btn",FOCUS:"focus"},At={DATA_TOGGLE_CARROT:'[data-toggle^="button"]',DATA_TOGGLE:'[data-toggle="buttons"]',INPUT:'input:not([type="hidden"])',ACTIVE:".active",BUTTON:".btn"},Ct={CLICK_DATA_API:"click.bs.button.data-api",FOCUS_BLUR_DATA_API:"focus.bs.button.data-api blur.bs.button.data-api"},Dt=function(t){this._element=t},wt={VERSION:{configurable:!0}};
// Getters
wt.VERSION.get=function(){return"4.3.1"},
// Public
Dt.prototype.toggle=function(){var t=!0,n=!0,i=e(this._element).closest(At.DATA_TOGGLE)[0];if(i){var o=this._element.querySelector(At.INPUT);if(o){if("radio"===o.type)if(o.checked&&this._element.classList.contains(It.ACTIVE))t=!1;else{var r=i.querySelector(At.ACTIVE);r&&e(r).removeClass(It.ACTIVE)}if(t){if(o.hasAttribute("disabled")||i.hasAttribute("disabled")||o.classList.contains("disabled")||i.classList.contains("disabled"))return;o.checked=!this._element.classList.contains(It.ACTIVE),e(o).trigger("change")}o.focus(),n=!1}}n&&this._element.setAttribute("aria-pressed",!this._element.classList.contains(It.ACTIVE)),t&&e(this._element).toggleClass(It.ACTIVE)},Dt.prototype.dispose=function(){e.removeData(this._element,"bs.button"),this._element=null},
// Static
Dt._jQueryInterface=function(t){return this.each(function(){var n=e(this).data("bs.button");n||(n=new Dt(this),e(this).data("bs.button",n)),"toggle"===t&&n[t]()})},Object.defineProperties(Dt,wt),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(Ct.CLICK_DATA_API,At.DATA_TOGGLE_CARROT,function(t){t.preventDefault();var n=t.target;e(n).hasClass(It.BUTTON)||(n=e(n).closest(At.BUTTON)),Dt._jQueryInterface.call(e(n),"toggle")}).on(Ct.FOCUS_BLUR_DATA_API,At.DATA_TOGGLE_CARROT,function(t){var n=e(t.target).closest(At.BUTTON)[0];e(n).toggleClass(It.FOCUS,/^focus(in)?$/.test(t.type))}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn.button=Dt._jQueryInterface,e.fn.button.Constructor=Dt,e.fn.button.noConflict=function(){return e.fn.button=St,Dt._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): carousel.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var Nt="carousel",Lt=".bs.carousel",Pt=e.fn[Nt],Rt={interval:5e3,keyboard:!0,slide:!1,pause:"hover",wrap:!0,touch:!0},Ht={interval:"(number|boolean)",keyboard:"boolean",slide:"(boolean|string)",pause:"(string|boolean)",wrap:"boolean",touch:"boolean"},Wt={NEXT:"next",PREV:"prev",LEFT:"left",RIGHT:"right"},Ft={SLIDE:"slide.bs.carousel",SLID:"slid.bs.carousel",KEYDOWN:"keydown.bs.carousel",MOUSEENTER:"mouseenter.bs.carousel",MOUSELEAVE:"mouseleave.bs.carousel",TOUCHSTART:"touchstart.bs.carousel",TOUCHMOVE:"touchmove.bs.carousel",TOUCHEND:"touchend.bs.carousel",POINTERDOWN:"pointerdown.bs.carousel",POINTERUP:"pointerup.bs.carousel",DRAG_START:"dragstart.bs.carousel",LOAD_DATA_API:"load.bs.carousel.data-api",CLICK_DATA_API:"click.bs.carousel.data-api"},Mt={CAROUSEL:"carousel",ACTIVE:"active",SLIDE:"slide",RIGHT:"carousel-item-right",LEFT:"carousel-item-left",NEXT:"carousel-item-next",PREV:"carousel-item-prev",ITEM:"carousel-item",POINTER_EVENT:"pointer-event"},jt={ACTIVE:".active",ACTIVE_ITEM:".active.carousel-item",ITEM:".carousel-item",ITEM_IMG:".carousel-item img",NEXT_PREV:".carousel-item-next, .carousel-item-prev",INDICATORS:".carousel-indicators",DATA_SLIDE:"[data-slide], [data-slide-to]",DATA_RIDE:'[data-ride="carousel"]'},xt={TOUCH:"touch",PEN:"pen"},Vt=function(t,e){this._items=null,this._interval=null,this._activeElement=null,this._isPaused=!1,this._isSliding=!1,this.touchTimeout=null,this.touchStartX=0,this.touchDeltaX=0,this._config=this._getConfig(e),this._element=t,this._indicatorsElement=this._element.querySelector(jt.INDICATORS),this._touchSupported="ontouchstart"in document.documentElement||navigator.maxTouchPoints>0,this._pointerEvent=Boolean(window.PointerEvent||window.MSPointerEvent),this._addEventListeners()},Ut={VERSION:{configurable:!0},Default:{configurable:!0}};
// Getters
Ut.VERSION.get=function(){return"4.3.1"},Ut.Default.get=function(){return Rt},
// Public
Vt.prototype.next=function(){this._isSliding||this._slide(Wt.NEXT)},Vt.prototype.nextWhenVisible=function(){
// Don't call next when the page isn't visible
// or the carousel or its parent isn't visible
!document.hidden&&e(this._element).is(":visible")&&"hidden"!==e(this._element).css("visibility")&&this.next()},Vt.prototype.prev=function(){this._isSliding||this._slide(Wt.PREV)},Vt.prototype.pause=function(t){t||(this._isPaused=!0),this._element.querySelector(jt.NEXT_PREV)&&(mt.triggerTransitionEnd(this._element),this.cycle(!0)),clearInterval(this._interval),this._interval=null},Vt.prototype.cycle=function(t){t||(this._isPaused=!1),this._interval&&(clearInterval(this._interval),this._interval=null),this._config.interval&&!this._isPaused&&(this._interval=setInterval((document.visibilityState?this.nextWhenVisible:this.next).bind(this),this._config.interval))},Vt.prototype.to=function(t){var n=this;this._activeElement=this._element.querySelector(jt.ACTIVE_ITEM);var i=this._getItemIndex(this._activeElement);if(!(t>this._items.length-1||t<0)){if(this._isSliding)return void e(this._element).one(Ft.SLID,function(){return n.to(t)});if(i===t)return this.pause(),void this.cycle();var o=t>i?Wt.NEXT:Wt.PREV;this._slide(o,this._items[t])}},Vt.prototype.dispose=function(){e(this._element).off(Lt),e.removeData(this._element,"bs.carousel"),this._items=null,this._config=null,this._element=null,this._interval=null,this._isPaused=null,this._isSliding=null,this._activeElement=null,this._indicatorsElement=null},
// Private
Vt.prototype._getConfig=function(t){return t=Object.assign({},Rt,t),mt.typeCheckConfig(Nt,t,Ht),t},Vt.prototype._handleSwipe=function(){var t=Math.abs(this.touchDeltaX);if(!(t<=40)){var e=t/this.touchDeltaX;
// swipe left
e>0&&this.prev(),
// swipe right
e<0&&this.next()}},Vt.prototype._addEventListeners=function(){var t=this;this._config.keyboard&&e(this._element).on(Ft.KEYDOWN,function(e){return t._keydown(e)}),"hover"===this._config.pause&&e(this._element).on(Ft.MOUSEENTER,function(e){return t.pause(e)}).on(Ft.MOUSELEAVE,function(e){return t.cycle(e)}),this._config.touch&&this._addTouchEventListeners()},Vt.prototype._addTouchEventListeners=function(){var t=this;if(this._touchSupported){var n=function(e){t._pointerEvent&&xt[e.originalEvent.pointerType.toUpperCase()]?t.touchStartX=e.originalEvent.clientX:t._pointerEvent||(t.touchStartX=e.originalEvent.touches[0].clientX)},i=function(e){
// ensure swiping with one touch and not pinching
e.originalEvent.touches&&e.originalEvent.touches.length>1?t.touchDeltaX=0:t.touchDeltaX=e.originalEvent.touches[0].clientX-t.touchStartX},o=function(e){t._pointerEvent&&xt[e.originalEvent.pointerType.toUpperCase()]&&(t.touchDeltaX=e.originalEvent.clientX-t.touchStartX),t._handleSwipe(),"hover"===t._config.pause&&(
// If it's a touch-enabled device, mouseenter/leave are fired as
// part of the mouse compatibility events on first tap - the carousel
// would stop cycling until user tapped out of it;
// here, we listen for touchend, explicitly pause the carousel
// (as if it's the second time we tap on it, mouseenter compat event
// is NOT fired) and after a timeout (to allow for mouse compatibility
// events to fire) we explicitly restart cycling
t.pause(),t.touchTimeout&&clearTimeout(t.touchTimeout),t.touchTimeout=setTimeout(function(e){return t.cycle(e)},500+t._config.interval))};e(this._element.querySelectorAll(jt.ITEM_IMG)).on(Ft.DRAG_START,function(t){return t.preventDefault()}),this._pointerEvent?(e(this._element).on(Ft.POINTERDOWN,function(t){return n(t)}),e(this._element).on(Ft.POINTERUP,function(t){return o(t)}),this._element.classList.add(Mt.POINTER_EVENT)):(e(this._element).on(Ft.TOUCHSTART,function(t){return n(t)}),e(this._element).on(Ft.TOUCHMOVE,function(t){return i(t)}),e(this._element).on(Ft.TOUCHEND,function(t){return o(t)}))}},Vt.prototype._keydown=function(t){if(!/input|textarea/i.test(t.target.tagName))switch(t.which){case 37:t.preventDefault(),this.prev();break;case 39:t.preventDefault(),this.next()}},Vt.prototype._getItemIndex=function(t){return this._items=t&&t.parentNode?[].slice.call(t.parentNode.querySelectorAll(jt.ITEM)):[],this._items.indexOf(t)},Vt.prototype._getItemByDirection=function(t,e){var n=t===Wt.NEXT,i=t===Wt.PREV,o=this._getItemIndex(e),r=this._items.length-1;if((i&&0===o||n&&o===r)&&!this._config.wrap)return e;var s=t===Wt.PREV?-1:1,a=(o+s)%this._items.length;return-1===a?this._items[this._items.length-1]:this._items[a]},Vt.prototype._triggerSlideEvent=function(t,n){var i=this._getItemIndex(t),o=this._getItemIndex(this._element.querySelector(jt.ACTIVE_ITEM)),r=e.Event(Ft.SLIDE,{relatedTarget:t,direction:n,from:o,to:i});return e(this._element).trigger(r),r},Vt.prototype._setActiveIndicatorElement=function(t){if(this._indicatorsElement){var n=[].slice.call(this._indicatorsElement.querySelectorAll(jt.ACTIVE));e(n).removeClass(Mt.ACTIVE);var i=this._indicatorsElement.children[this._getItemIndex(t)];i&&e(i).addClass(Mt.ACTIVE)}},Vt.prototype._slide=function(t,n){var i,o,r,s=this,a=this._element.querySelector(jt.ACTIVE_ITEM),l=this._getItemIndex(a),c=n||a&&this._getItemByDirection(t,a),u=this._getItemIndex(c),h=Boolean(this._interval);if(t===Wt.NEXT?(i=Mt.LEFT,o=Mt.NEXT,r=Wt.LEFT):(i=Mt.RIGHT,o=Mt.PREV,r=Wt.RIGHT),c&&e(c).hasClass(Mt.ACTIVE))return void(this._isSliding=!1);if(!this._triggerSlideEvent(c,r).isDefaultPrevented()&&a&&c){this._isSliding=!0,h&&this.pause(),this._setActiveIndicatorElement(c);var f=e.Event(Ft.SLID,{relatedTarget:c,direction:r,from:l,to:u});if(e(this._element).hasClass(Mt.SLIDE)){e(c).addClass(o),mt.reflow(c),e(a).addClass(i),e(c).addClass(i);var d=parseInt(c.getAttribute("data-interval"),10);d?(this._config.defaultInterval=this._config.defaultInterval||this._config.interval,this._config.interval=d):this._config.interval=this._config.defaultInterval||this._config.interval;var p=mt.getTransitionDurationFromElement(a);e(a).one(mt.TRANSITION_END,function(){e(c).removeClass(i+" "+o).addClass(Mt.ACTIVE),e(a).removeClass(Mt.ACTIVE+" "+o+" "+i),s._isSliding=!1,setTimeout(function(){return e(s._element).trigger(f)},0)}).emulateTransitionEnd(p)}else e(a).removeClass(Mt.ACTIVE),e(c).addClass(Mt.ACTIVE),this._isSliding=!1,e(this._element).trigger(f);h&&this.cycle()}},
// Static
Vt._jQueryInterface=function(t){return this.each(function(){var n=e(this).data("bs.carousel"),i=Object.assign({},Rt,e(this).data());"object"==typeof t&&(i=Object.assign({},i,t));var o="string"==typeof t?t:i.slide;if(n||(n=new Vt(this,i),e(this).data("bs.carousel",n)),"number"==typeof t)n.to(t);else if("string"==typeof o){if(void 0===n[o])throw new TypeError('No method named "'+o+'"');n[o]()}else i.interval&&i.ride&&(n.pause(),n.cycle())})},Vt._dataApiClickHandler=function(t){var n=mt.getSelectorFromElement(this);if(n){var i=e(n)[0];if(i&&e(i).hasClass(Mt.CAROUSEL)){var o=Object.assign({},e(i).data(),e(this).data()),r=this.getAttribute("data-slide-to");r&&(o.interval=!1),Vt._jQueryInterface.call(e(i),o),r&&e(i).data("bs.carousel").to(r),t.preventDefault()}}},Object.defineProperties(Vt,Ut),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(Ft.CLICK_DATA_API,jt.DATA_SLIDE,Vt._dataApiClickHandler),e(window).on(Ft.LOAD_DATA_API,function(){for(var t=[].slice.call(document.querySelectorAll(jt.DATA_RIDE)),n=0,i=t.length;n<i;n++){var o=e(t[n]);Vt._jQueryInterface.call(o,o.data())}}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[Nt]=Vt._jQueryInterface,e.fn[Nt].Constructor=Vt,e.fn[Nt].noConflict=function(){return e.fn[Nt]=Pt,Vt._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): collapse.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var kt="collapse",Bt=e.fn[kt],Gt={toggle:!0,parent:""},Kt={toggle:"boolean",parent:"(string|element)"},qt={SHOW:"show.bs.collapse",SHOWN:"shown.bs.collapse",HIDE:"hide.bs.collapse",HIDDEN:"hidden.bs.collapse",CLICK_DATA_API:"click.bs.collapse.data-api"},Qt={SHOW:"show",COLLAPSE:"collapse",COLLAPSING:"collapsing",COLLAPSED:"collapsed"},Yt={WIDTH:"width",HEIGHT:"height"},Xt={ACTIVES:".show, .collapsing",DATA_TOGGLE:'[data-toggle="collapse"]'},zt=function(t,e){var n=this;this._isTransitioning=!1,this._element=t,this._config=this._getConfig(e),this._triggerArray=[].slice.call(document.querySelectorAll('[data-toggle="collapse"][href="#'+t.id+'"],[data-toggle="collapse"][data-target="#'+t.id+'"]'));for(var i=[].slice.call(document.querySelectorAll(Xt.DATA_TOGGLE)),o=0,r=i.length;o<r;o++){var s=i[o],a=mt.getSelectorFromElement(s),l=[].slice.call(document.querySelectorAll(a)).filter(function(e){return e===t});null!==a&&l.length>0&&(n._selector=a,n._triggerArray.push(s))}this._parent=this._config.parent?this._getParent():null,this._config.parent||this._addAriaAndCollapsedClass(this._element,this._triggerArray),this._config.toggle&&this.toggle()},$t={VERSION:{configurable:!0},Default:{configurable:!0}};
// Getters
$t.VERSION.get=function(){return"4.3.1"},$t.Default.get=function(){return Gt},
// Public
zt.prototype.toggle=function(){e(this._element).hasClass(Qt.SHOW)?this.hide():this.show()},zt.prototype.show=function(){var t=this;if(!this._isTransitioning&&!e(this._element).hasClass(Qt.SHOW)){var n,i;if(this._parent&&(n=[].slice.call(this._parent.querySelectorAll(Xt.ACTIVES)).filter(function(e){return"string"==typeof t._config.parent?e.getAttribute("data-parent")===t._config.parent:e.classList.contains(Qt.COLLAPSE)}),0===n.length&&(n=null)),!(n&&(i=e(n).not(this._selector).data("bs.collapse"))&&i._isTransitioning)){var o=e.Event(qt.SHOW);if(e(this._element).trigger(o),!o.isDefaultPrevented()){n&&(zt._jQueryInterface.call(e(n).not(this._selector),"hide"),i||e(n).data("bs.collapse",null));var r=this._getDimension();e(this._element).removeClass(Qt.COLLAPSE).addClass(Qt.COLLAPSING),this._element.style[r]=0,this._triggerArray.length&&e(this._triggerArray).removeClass(Qt.COLLAPSED).attr("aria-expanded",!0),this.setTransitioning(!0);var s=function(){e(t._element).removeClass(Qt.COLLAPSING).addClass(Qt.COLLAPSE).addClass(Qt.SHOW),t._element.style[r]="",t.setTransitioning(!1),e(t._element).trigger(qt.SHOWN)},a=r[0].toUpperCase()+r.slice(1),l="scroll"+a,c=mt.getTransitionDurationFromElement(this._element);e(this._element).one(mt.TRANSITION_END,s).emulateTransitionEnd(c),this._element.style[r]=this._element[l]+"px"}}}},zt.prototype.hide=function(){var t=this;if(!this._isTransitioning&&e(this._element).hasClass(Qt.SHOW)){var n=e.Event(qt.HIDE);if(e(this._element).trigger(n),!n.isDefaultPrevented()){var i=this._getDimension();this._element.style[i]=this._element.getBoundingClientRect()[i]+"px",mt.reflow(this._element),e(this._element).addClass(Qt.COLLAPSING).removeClass(Qt.COLLAPSE).removeClass(Qt.SHOW);var o=this._triggerArray.length;if(o>0)for(var r=0;r<o;r++){var s=t._triggerArray[r],a=mt.getSelectorFromElement(s);if(null!==a){var l=e([].slice.call(document.querySelectorAll(a)));l.hasClass(Qt.SHOW)||e(s).addClass(Qt.COLLAPSED).attr("aria-expanded",!1)}}this.setTransitioning(!0);var c=function(){t.setTransitioning(!1),e(t._element).removeClass(Qt.COLLAPSING).addClass(Qt.COLLAPSE).trigger(qt.HIDDEN)};this._element.style[i]="";var u=mt.getTransitionDurationFromElement(this._element);e(this._element).one(mt.TRANSITION_END,c).emulateTransitionEnd(u)}}},zt.prototype.setTransitioning=function(t){this._isTransitioning=t},zt.prototype.dispose=function(){e.removeData(this._element,"bs.collapse"),this._config=null,this._parent=null,this._element=null,this._triggerArray=null,this._isTransitioning=null},
// Private
zt.prototype._getConfig=function(t){// Coerce string values
return t=Object.assign({},Gt,t),t.toggle=Boolean(t.toggle),mt.typeCheckConfig(kt,t,Kt),t},zt.prototype._getDimension=function(){return e(this._element).hasClass(Yt.WIDTH)?Yt.WIDTH:Yt.HEIGHT},zt.prototype._getParent=function(){var t,n=this;mt.isElement(this._config.parent)?(t=this._config.parent,
// It's a jQuery object
void 0!==this._config.parent.jquery&&(t=this._config.parent[0])):t=document.querySelector(this._config.parent);var i='[data-toggle="collapse"][data-parent="'+this._config.parent+'"]',o=[].slice.call(t.querySelectorAll(i));return e(o).each(function(t,e){n._addAriaAndCollapsedClass(zt._getTargetFromElement(e),[e])}),t},zt.prototype._addAriaAndCollapsedClass=function(t,n){var i=e(t).hasClass(Qt.SHOW);n.length&&e(n).toggleClass(Qt.COLLAPSED,!i).attr("aria-expanded",i)},
// Static
zt._getTargetFromElement=function(t){var e=mt.getSelectorFromElement(t);return e?document.querySelector(e):null},zt._jQueryInterface=function(t){return this.each(function(){var n=e(this),i=n.data("bs.collapse"),o=Object.assign({},Gt,n.data(),"object"==typeof t&&t?t:{});if(!i&&o.toggle&&/show|hide/.test(t)&&(o.toggle=!1),i||(i=new zt(this,o),n.data("bs.collapse",i)),"string"==typeof t){if(void 0===i[t])throw new TypeError('No method named "'+t+'"');i[t]()}})},Object.defineProperties(zt,$t),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(qt.CLICK_DATA_API,Xt.DATA_TOGGLE,function(t){
// preventDefault only for <a> elements (which change the URL) not inside the collapsible element
"A"===t.currentTarget.tagName&&t.preventDefault();var n=e(this),i=mt.getSelectorFromElement(this),o=[].slice.call(document.querySelectorAll(i));e(o).each(function(){var t=e(this),i=t.data("bs.collapse"),o=i?"toggle":n.data();zt._jQueryInterface.call(t,o)})}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[kt]=zt._jQueryInterface,e.fn[kt].Constructor=zt,e.fn[kt].noConflict=function(){return e.fn[kt]=Bt,zt._jQueryInterface};for(var Jt="undefined"!=typeof window&&"undefined"!=typeof document,Zt=["Edge","Trident","Firefox"],te=0,ee=0;ee<Zt.length;ee+=1)if(Jt&&navigator.userAgent.indexOf(Zt[ee])>=0){te=1;break}var ne=Jt&&window.Promise,ie=ne?r:s,oe=Jt&&!(!window.MSInputMethodContext||!document.documentMode),re=Jt&&/MSIE 10/.test(navigator.userAgent),se=Jt&&/Firefox/i.test(navigator.userAgent),ae=["auto-start","auto","auto-end","top-start","top","top-end","right-start","right","right-end","bottom-end","bottom","bottom-start","left-end","left","left-start"],le=ae.slice(3),ce={FLIP:"flip",CLOCKWISE:"clockwise",COUNTERCLOCKWISE:"counterclockwise"},ue={/**
   * Modifier used to shift the popper on the start or end of its reference
   * element.<br />
   * It will read the variation of the `placement` property.<br />
   * It can be one either `-end` or `-start`.
   * @memberof modifiers
   * @inner
   */
shift:{/** @prop {number} order=100 - Index used to define the order of execution */
order:100,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:ut},/**
   * The `offset` modifier can shift your popper on both its axis.
   *
   * It accepts the following units:
   * - `px` or unit-less, interpreted as pixels
   * - `%` or `%r`, percentage relative to the length of the reference element
   * - `%p`, percentage relative to the length of the popper element
   * - `vw`, CSS viewport width unit
   * - `vh`, CSS viewport height unit
   *
   * For length is intended the main axis relative to the placement of the popper.<br />
   * This means that if the placement is `top` or `bottom`, the length will be the
   * `width`. In case of `left` or `right`, it will be the `height`.
   *
   * You can provide a single value (as `Number` or `String`), or a pair of values
   * as `String` divided by a comma or one (or more) white spaces.<br />
   * The latter is a deprecated method because it leads to confusion and will be
   * removed in v2.<br />
   * Additionally, it accepts additions and subtractions between different units.
   * Note that multiplications and divisions aren't supported.
   *
   * Valid examples are:
   * ```
   * 10
   * '10%'
   * '10, 10'
   * '10%, 10'
   * '10 + 10%'
   * '10 - 5vh + 3%'
   * '-10px + 5vh, 5px - 6%'
   * ```
   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
   *
   * @memberof modifiers
   * @inner
   */
offset:{/** @prop {number} order=200 - Index used to define the order of execution */
order:200,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:lt,/** @prop {Number|String} offset=0
     * The offset value as described in the modifier description
     */
offset:0},/**
   * Modifier used to prevent the popper from being positioned outside the boundary.
   *
   * A scenario exists where the reference itself is not within the boundaries.<br />
   * We can say it has "escaped the boundaries" — or just "escaped".<br />
   * In this case we need to decide whether the popper should either:
   *
   * - detach from the reference and remain "trapped" in the boundaries, or
   * - if it should ignore the boundary and "escape with its reference"
   *
   * When `escapeWithReference` is set to`true` and reference is completely
   * outside its boundaries, the popper will overflow (or completely leave)
   * the boundaries in order to remain attached to the edge of the reference.
   *
   * @memberof modifiers
   * @inner
   */
preventOverflow:{/** @prop {number} order=300 - Index used to define the order of execution */
order:300,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:ct,/**
     * @prop {Array} [priority=['left','right','top','bottom']]
     * Popper will try to prevent overflow following these priorities by default,
     * then, it could overflow on the left and on top of the `boundariesElement`
     */
priority:["left","right","top","bottom"],/**
     * @prop {number} padding=5
     * Amount of pixel used to define a minimum distance between the boundaries
     * and the popper. This makes sure the popper always has a little padding
     * between the edges of its container
     */
padding:5,/**
     * @prop {String|HTMLElement} boundariesElement='scrollParent'
     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
     * `viewport` or any DOM element.
     */
boundariesElement:"scrollParent"},/**
   * Modifier used to make sure the reference and its popper stay near each other
   * without leaving any gap between the two. Especially useful when the arrow is
   * enabled and you want to ensure that it points to its reference element.
   * It cares only about the first axis. You can still have poppers with margin
   * between the popper and its reference element.
   * @memberof modifiers
   * @inner
   */
keepTogether:{/** @prop {number} order=400 - Index used to define the order of execution */
order:400,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:rt},/**
   * This modifier is used to move the `arrowElement` of the popper to make
   * sure it is positioned between the reference element and its popper element.
   * It will read the outer size of the `arrowElement` node to detect how many
   * pixels of conjunction are needed.
   *
   * It has no effect if no `arrowElement` is provided.
   * @memberof modifiers
   * @inner
   */
arrow:{/** @prop {number} order=500 - Index used to define the order of execution */
order:500,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:et,/** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
element:"[x-arrow]"},/**
   * Modifier used to flip the popper's placement when it starts to overlap its
   * reference element.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   *
   * **NOTE:** this modifier will interrupt the current update cycle and will
   * restart it if it detects the need to flip the placement.
   * @memberof modifiers
   * @inner
   */
flip:{/** @prop {number} order=600 - Index used to define the order of execution */
order:600,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:ot,/**
     * @prop {String|Array} behavior='flip'
     * The behavior used to change the popper's placement. It can be one of
     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
     * placements (with optional variations)
     */
behavior:"flip",/**
     * @prop {number} padding=5
     * The popper will flip if it hits the edges of the `boundariesElement`
     */
padding:5,/**
     * @prop {String|HTMLElement} boundariesElement='viewport'
     * The element which will define the boundaries of the popper position.
     * The popper will never be placed outside of the defined boundaries
     * (except if `keepTogether` is enabled)
     */
boundariesElement:"viewport"},/**
   * Modifier used to make the popper flow toward the inner of the reference element.
   * By default, when this modifier is disabled, the popper will be placed outside
   * the reference element.
   * @memberof modifiers
   * @inner
   */
inner:{/** @prop {number} order=700 - Index used to define the order of execution */
order:700,/** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
enabled:!1,/** @prop {ModifierFn} */
fn:ft},/**
   * Modifier used to hide the popper when its reference element is outside of the
   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
   * be used to hide with a CSS selector the popper when its reference is
   * out of boundaries.
   *
   * Requires the `preventOverflow` modifier before it in order to work.
   * @memberof modifiers
   * @inner
   */
hide:{/** @prop {number} order=800 - Index used to define the order of execution */
order:800,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:ht},/**
   * Computes the style that will be applied to the popper element to gets
   * properly positioned.
   *
   * Note that this modifier will not touch the DOM, it just prepares the styles
   * so that `applyStyle` modifier can apply it. This separation is useful
   * in case you need to replace `applyStyle` with a custom implementation.
   *
   * This modifier has `850` as `order` value to maintain backward compatibility
   * with previous versions of Popper.js. Expect the modifiers ordering method
   * to change in future major versions of the library.
   *
   * @memberof modifiers
   * @inner
   */
computeStyle:{/** @prop {number} order=850 - Index used to define the order of execution */
order:850,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:Z,/**
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
gpuAcceleration:!0,/**
     * @prop {string} [x='bottom']
     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
     * Change this if your popper should grow in a direction different from `bottom`
     */
x:"bottom",/**
     * @prop {string} [x='left']
     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
     * Change this if your popper should grow in a direction different from `right`
     */
y:"right"},/**
   * Applies the computed styles to the popper element.
   *
   * All the DOM manipulations are limited to this modifier. This is useful in case
   * you want to integrate Popper.js inside a framework or view library and you
   * want to delegate all the DOM manipulations to it.
   *
   * Note that if you disable this modifier, you must make sure the popper element
   * has its position set to `absolute` before Popper.js can do its work!
   *
   * Just disable this modifier and define your own to achieve the desired effect.
   *
   * @memberof modifiers
   * @inner
   */
applyStyle:{/** @prop {number} order=900 - Index used to define the order of execution */
order:900,/** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
enabled:!0,/** @prop {ModifierFn} */
fn:z,/** @prop {Function} */
onLoad:$,/**
     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
     * @prop {Boolean} gpuAcceleration=true
     * If true, it uses the CSS 3D transformation to position the popper.
     * Otherwise, it will use the `top` and `left` properties
     */
gpuAcceleration:void 0}},he={/**
   * Popper's placement.
   * @prop {Popper.placements} placement='bottom'
   */
placement:"bottom",/**
   * Set this to true if you want popper to position it self in 'fixed' mode
   * @prop {Boolean} positionFixed=false
   */
positionFixed:!1,/**
   * Whether events (resize, scroll) are initially enabled.
   * @prop {Boolean} eventsEnabled=true
   */
eventsEnabled:!0,/**
   * Set to true if you want to automatically remove the popper when
   * you call the `destroy` method.
   * @prop {Boolean} removeOnDestroy=false
   */
removeOnDestroy:!1,/**
   * Callback called when the popper is created.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onCreate}
   */
onCreate:function(){},/**
   * Callback called when the popper is updated. This callback is not called
   * on the initialization/creation of the popper, but only on subsequent
   * updates.<br />
   * By default, it is set to no-op.<br />
   * Access Popper.js instance with `data.instance`.
   * @prop {onUpdate}
   */
onUpdate:function(){},/**
   * List of modifiers used to modify the offsets before they are applied to the popper.
   * They provide most of the functionalities of Popper.js.
   * @prop {modifiers}
   */
modifiers:ue},fe=function t(e,n,i){var o=this;void 0===i&&(i={}),
// make update() debounced, so that it only runs at most once-per-tick
this.update=ie(this.update.bind(this)),this.scheduleUpdate=this.scheduleUpdate.bind(this),
// with {} we create a new object with the options inside it
this.options=Object.assign({},t.Defaults,i),
// init state
this.state={isDestroyed:!1,isCreated:!1,scrollParents:[]},
// get reference and popper elements (allow jQuery wrappers)
this.reference=e&&e.jquery?e[0]:e,this.popper=n&&n.jquery?n[0]:n,
// Deep merge modifiers options
this.options.modifiers={},Object.keys(Object.assign({},t.Defaults.modifiers,i.modifiers)).forEach(function(e){o.options.modifiers[e]=Object.assign({},t.Defaults.modifiers[e]||{},
// If there are custom options, override and merge with default ones
i.modifiers?i.modifiers[e]:{})}),
// Refactoring modifiers' list (Object => Array)
this.modifiers=Object.keys(this.options.modifiers).map(function(t){return Object.assign({},{name:t},o.options.modifiers[t])}).sort(function(t,e){return t.order-e.order}),
// modifiers have the ability to execute arbitrary code when Popper.js get inited
// such code is executed in the same order of its modifier
// they could add new properties to their options configuration
// BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!
this.modifiers.forEach(function(t){t.enabled&&a(t.onLoad)&&t.onLoad(o.reference,o.popper,o.options,t,o.state)}),
// fire the first update to position the popper in the right place
this.update();var r=this.options.eventsEnabled;r&&
// setup event listeners, they will take care of update the position in specific situations
this.enableEventListeners(),this.state.eventsEnabled=r};
// We can't use class properties because they don't get listed in the
// class prototype and break stuff like Sinon stubs
fe.prototype.update=function(){return M.call(this)},fe.prototype.destroy=function(){return V.call(this)},fe.prototype.enableEventListeners=function(){return G.call(this)},fe.prototype.disableEventListeners=function(){return q.call(this)},/**
 * Schedules an update. It will run on the next UI update available.
 * @method scheduleUpdate
 * @memberof Popper
 */
fe.prototype.scheduleUpdate=function(){return requestAnimationFrame(this.update)},/**
 * Collection of utilities useful when writing custom modifiers.
 * Starting from version 1.7, this method is available only if you
 * include `popper-utils.js` before `popper.js`.
 *
 * **DEPRECATION**: This way to access PopperUtils is deprecated
 * and will be removed in v2! Use the PopperUtils module directly instead.
 * Due to the high instability of the methods contained in Utils, we can't
 * guarantee them to follow semver. Use them at your own risk!
 * @static
 * @private
 * @type {Object}
 * @deprecated since version 1.8
 * @member Utils
 * @memberof Popper
 */
fe.Utils=("undefined"!=typeof window?window:global).PopperUtils,fe.placements=ae,fe.Defaults=he;/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): dropdown.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var de="dropdown",pe=e.fn[de],ge=new RegExp("38|40|27"),me={HIDE:"hide.bs.dropdown",HIDDEN:"hidden.bs.dropdown",SHOW:"show.bs.dropdown",SHOWN:"shown.bs.dropdown",CLICK:"click.bs.dropdown",CLICK_DATA_API:"click.bs.dropdown.data-api",KEYDOWN_DATA_API:"keydown.bs.dropdown.data-api",KEYUP_DATA_API:"keyup.bs.dropdown.data-api"},_e={DISABLED:"disabled",SHOW:"show",DROPUP:"dropup",DROPRIGHT:"dropright",DROPLEFT:"dropleft",MENURIGHT:"dropdown-menu-right",MENULEFT:"dropdown-menu-left",POSITION_STATIC:"position-static"},ve={DATA_TOGGLE:'[data-toggle="dropdown"]',FORM_CHILD:".dropdown form",MENU:".dropdown-menu",NAVBAR_NAV:".navbar-nav",VISIBLE_ITEMS:".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)"},Ee={TOP:"top-start",TOPEND:"top-end",BOTTOM:"bottom-start",BOTTOMEND:"bottom-end",RIGHT:"right-start",RIGHTEND:"right-end",LEFT:"left-start",LEFTEND:"left-end"},be={offset:0,flip:!0,boundary:"scrollParent",reference:"toggle",display:"dynamic"},Te={offset:"(number|string|function)",flip:"boolean",boundary:"(string|element)",reference:"(string|element)",display:"string"},ye=function(t,e){this._element=t,this._popper=null,this._config=this._getConfig(e),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar(),this._addEventListeners()},Oe={VERSION:{configurable:!0},Default:{configurable:!0},DefaultType:{configurable:!0}};
// Getters
Oe.VERSION.get=function(){return"4.3.1"},Oe.Default.get=function(){return be},Oe.DefaultType.get=function(){return Te},
// Public
ye.prototype.toggle=function(){if(!this._element.disabled&&!e(this._element).hasClass(_e.DISABLED)){var t=ye._getParentFromElement(this._element),n=e(this._menu).hasClass(_e.SHOW);if(ye._clearMenus(),!n){var i={relatedTarget:this._element},o=e.Event(me.SHOW,i);if(e(t).trigger(o),!o.isDefaultPrevented()){
// Disable totally Popper.js for Dropdown in Navbar
if(!this._inNavbar){/**
     * Check for Popper dependency
     * Popper - https://popper.js.org
     */
if(void 0===fe)throw new TypeError("Bootstrap's dropdowns require Popper.js (https://popper.js.org/)");var r=this._element;"parent"===this._config.reference?r=t:mt.isElement(this._config.reference)&&(r=this._config.reference,
// Check if it's jQuery element
void 0!==this._config.reference.jquery&&(r=this._config.reference[0])),
// If boundary is not `scrollParent`, then set position to `static`
// to allow the menu to "escape" the scroll parent's boundaries
// https://github.com/twbs/bootstrap/issues/24251
"scrollParent"!==this._config.boundary&&e(t).addClass(_e.POSITION_STATIC),this._popper=new fe(r,this._menu,this._getPopperConfig())}
// If this is a touch-enabled device we add extra
// empty mouseover listeners to the body's immediate children;
// only needed because of broken event delegation on iOS
// https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html
"ontouchstart"in document.documentElement&&0===e(t).closest(ve.NAVBAR_NAV).length&&e(document.body).children().on("mouseover",null,e.noop),this._element.focus(),this._element.setAttribute("aria-expanded",!0),e(this._menu).toggleClass(_e.SHOW),e(t).toggleClass(_e.SHOW).trigger(e.Event(me.SHOWN,i))}}}},ye.prototype.show=function(){if(!(this._element.disabled||e(this._element).hasClass(_e.DISABLED)||e(this._menu).hasClass(_e.SHOW))){var t={relatedTarget:this._element},n=e.Event(me.SHOW,t),i=ye._getParentFromElement(this._element);e(i).trigger(n),n.isDefaultPrevented()||(e(this._menu).toggleClass(_e.SHOW),e(i).toggleClass(_e.SHOW).trigger(e.Event(me.SHOWN,t)))}},ye.prototype.hide=function(){if(!this._element.disabled&&!e(this._element).hasClass(_e.DISABLED)&&e(this._menu).hasClass(_e.SHOW)){var t={relatedTarget:this._element},n=e.Event(me.HIDE,t),i=ye._getParentFromElement(this._element);e(i).trigger(n),n.isDefaultPrevented()||(e(this._menu).toggleClass(_e.SHOW),e(i).toggleClass(_e.SHOW).trigger(e.Event(me.HIDDEN,t)))}},ye.prototype.dispose=function(){e.removeData(this._element,"bs.dropdown"),e(this._element).off(".bs.dropdown"),this._element=null,this._menu=null,null!==this._popper&&(this._popper.destroy(),this._popper=null)},ye.prototype.update=function(){this._inNavbar=this._detectNavbar(),null!==this._popper&&this._popper.scheduleUpdate()},
// Private
ye.prototype._addEventListeners=function(){var t=this;e(this._element).on(me.CLICK,function(e){e.preventDefault(),e.stopPropagation(),t.toggle()})},ye.prototype._getConfig=function(t){return t=Object.assign({},this.constructor.Default,e(this._element).data(),t),mt.typeCheckConfig(de,t,this.constructor.DefaultType),t},ye.prototype._getMenuElement=function(){if(!this._menu){var t=ye._getParentFromElement(this._element);t&&(this._menu=t.querySelector(ve.MENU))}return this._menu},ye.prototype._getPlacement=function(){var t=e(this._element.parentNode),n=Ee.BOTTOM;
// Handle dropup
return t.hasClass(_e.DROPUP)?(n=Ee.TOP,e(this._menu).hasClass(_e.MENURIGHT)&&(n=Ee.TOPEND)):t.hasClass(_e.DROPRIGHT)?n=Ee.RIGHT:t.hasClass(_e.DROPLEFT)?n=Ee.LEFT:e(this._menu).hasClass(_e.MENURIGHT)&&(n=Ee.BOTTOMEND),n},ye.prototype._detectNavbar=function(){return e(this._element).closest(".navbar").length>0},ye.prototype._getOffset=function(){var t=this,e={};return"function"==typeof this._config.offset?e.fn=function(e){return e.offsets=Object.assign({},e.offsets,t._config.offset(e.offsets,t._element)||{}),e}:e.offset=this._config.offset,e},ye.prototype._getPopperConfig=function(){var t={placement:this._getPlacement(),modifiers:{offset:this._getOffset(),flip:{enabled:this._config.flip},preventOverflow:{boundariesElement:this._config.boundary}}};
// Disable Popper.js if we have a static display
return"static"===this._config.display&&(t.modifiers.applyStyle={enabled:!1}),t},
// Static
ye._jQueryInterface=function(t){return this.each(function(){var n=e(this).data("bs.dropdown"),i="object"==typeof t?t:null;if(n||(n=new ye(this,i),e(this).data("bs.dropdown",n)),"string"==typeof t){if(void 0===n[t])throw new TypeError('No method named "'+t+'"');n[t]()}})},ye._clearMenus=function(t){if(!t||3!==t.which&&("keyup"!==t.type||9===t.which))for(var n=[].slice.call(document.querySelectorAll(ve.DATA_TOGGLE)),i=0,o=n.length;i<o;i++){var r=ye._getParentFromElement(n[i]),s=e(n[i]).data("bs.dropdown"),a={relatedTarget:n[i]};if(t&&"click"===t.type&&(a.clickEvent=t),s){var l=s._menu;if(e(r).hasClass(_e.SHOW)&&!(t&&("click"===t.type&&/input|textarea/i.test(t.target.tagName)||"keyup"===t.type&&9===t.which)&&e.contains(r,t.target))){var c=e.Event(me.HIDE,a);e(r).trigger(c),c.isDefaultPrevented()||(
// If this is a touch-enabled device we remove the extra
// empty mouseover listeners we added for iOS support
"ontouchstart"in document.documentElement&&e(document.body).children().off("mouseover",null,e.noop),n[i].setAttribute("aria-expanded","false"),e(l).removeClass(_e.SHOW),e(r).removeClass(_e.SHOW).trigger(e.Event(me.HIDDEN,a)))}}}},ye._getParentFromElement=function(t){var e,n=mt.getSelectorFromElement(t);return n&&(e=document.querySelector(n)),e||t.parentNode},
// eslint-disable-next-line complexity
ye._dataApiKeydownHandler=function(t){
// If not input/textarea:
//- And not a key in REGEXP_KEYDOWN => not a dropdown command
// If input/textarea:
//- If space key => not a dropdown command
//- If key is other than escape
//  - If key is not up or down => not a dropdown command
//  - If trigger inside the menu => not a dropdown command
if((/input|textarea/i.test(t.target.tagName)?!(32===t.which||27!==t.which&&(40!==t.which&&38!==t.which||e(t.target).closest(ve.MENU).length)):ge.test(t.which))&&(t.preventDefault(),t.stopPropagation(),!this.disabled&&!e(this).hasClass(_e.DISABLED))){var n=ye._getParentFromElement(this),i=e(n).hasClass(_e.SHOW);if(!i||i&&(27===t.which||32===t.which)){if(27===t.which){var o=n.querySelector(ve.DATA_TOGGLE);e(o).trigger("focus")}return void e(this).trigger("click")}var r=[].slice.call(n.querySelectorAll(ve.VISIBLE_ITEMS));if(0!==r.length){var s=r.indexOf(t.target);38===t.which&&s>0&&// Up
s--,40===t.which&&s<r.length-1&&// Down
s++,s<0&&(s=0),r[s].focus()}}},Object.defineProperties(ye,Oe),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(me.KEYDOWN_DATA_API,ve.DATA_TOGGLE,ye._dataApiKeydownHandler).on(me.KEYDOWN_DATA_API,ve.MENU,ye._dataApiKeydownHandler).on(me.CLICK_DATA_API+" "+me.KEYUP_DATA_API,ye._clearMenus).on(me.CLICK_DATA_API,ve.DATA_TOGGLE,function(t){t.preventDefault(),t.stopPropagation(),ye._jQueryInterface.call(e(this),"toggle")}).on(me.CLICK_DATA_API,ve.FORM_CHILD,function(t){t.stopPropagation()}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[de]=ye._jQueryInterface,e.fn[de].Constructor=ye,e.fn[de].noConflict=function(){return e.fn[de]=pe,ye._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): modal.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var Se=e.fn.modal,Ie={backdrop:!0,keyboard:!0,focus:!0,show:!0},Ae={backdrop:"(boolean|string)",keyboard:"boolean",focus:"boolean",show:"boolean"},Ce={HIDE:"hide.bs.modal",HIDDEN:"hidden.bs.modal",SHOW:"show.bs.modal",SHOWN:"shown.bs.modal",FOCUSIN:"focusin.bs.modal",RESIZE:"resize.bs.modal",CLICK_DISMISS:"click.dismiss.bs.modal",KEYDOWN_DISMISS:"keydown.dismiss.bs.modal",MOUSEUP_DISMISS:"mouseup.dismiss.bs.modal",MOUSEDOWN_DISMISS:"mousedown.dismiss.bs.modal",CLICK_DATA_API:"click.bs.modal.data-api"},De={SCROLLABLE:"modal-dialog-scrollable",SCROLLBAR_MEASURER:"modal-scrollbar-measure",BACKDROP:"modal-backdrop",OPEN:"modal-open",FADE:"fade",SHOW:"show"},we={DIALOG:".modal-dialog",MODAL_BODY:".modal-body",DATA_TOGGLE:'[data-toggle="modal"]',DATA_DISMISS:'[data-dismiss="modal"]',FIXED_CONTENT:".fixed-top, .fixed-bottom, .is-fixed, .sticky-top",STICKY_CONTENT:".sticky-top"},Ne=function(t,e){this._config=this._getConfig(e),this._element=t,this._dialog=t.querySelector(we.DIALOG),this._backdrop=null,this._isShown=!1,this._isBodyOverflowing=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1,this._scrollbarWidth=0},Le={VERSION:{configurable:!0},Default:{configurable:!0}};
// Getters
Le.VERSION.get=function(){return"4.3.1"},Le.Default.get=function(){return Ie},
// Public
Ne.prototype.toggle=function(t){return this._isShown?this.hide():this.show(t)},Ne.prototype.show=function(t){var n=this;if(!this._isShown&&!this._isTransitioning){e(this._element).hasClass(De.FADE)&&(this._isTransitioning=!0);var i=e.Event(Ce.SHOW,{relatedTarget:t});e(this._element).trigger(i),this._isShown||i.isDefaultPrevented()||(this._isShown=!0,this._checkScrollbar(),this._setScrollbar(),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),e(this._element).on(Ce.CLICK_DISMISS,we.DATA_DISMISS,function(t){return n.hide(t)}),e(this._dialog).on(Ce.MOUSEDOWN_DISMISS,function(){e(n._element).one(Ce.MOUSEUP_DISMISS,function(t){e(t.target).is(n._element)&&(n._ignoreBackdropClick=!0)})}),this._showBackdrop(function(){return n._showElement(t)}))}},Ne.prototype.hide=function(t){var n=this;if(t&&t.preventDefault(),this._isShown&&!this._isTransitioning){var i=e.Event(Ce.HIDE);if(e(this._element).trigger(i),this._isShown&&!i.isDefaultPrevented()){this._isShown=!1;var o=e(this._element).hasClass(De.FADE);if(o&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),e(document).off(Ce.FOCUSIN),e(this._element).removeClass(De.SHOW),e(this._element).off(Ce.CLICK_DISMISS),e(this._dialog).off(Ce.MOUSEDOWN_DISMISS),o){var r=mt.getTransitionDurationFromElement(this._element);e(this._element).one(mt.TRANSITION_END,function(t){return n._hideModal(t)}).emulateTransitionEnd(r)}else this._hideModal()}}},Ne.prototype.dispose=function(){[window,this._element,this._dialog].forEach(function(t){return e(t).off(".bs.modal")}),/**
   * `document` has 2 events `Event.FOCUSIN` and `Event.CLICK_DATA_API`
   * Do not move `document` in `htmlElements` array
   * It will remove `Event.CLICK_DATA_API` event that should remain
   */
e(document).off(Ce.FOCUSIN),e.removeData(this._element,"bs.modal"),this._config=null,this._element=null,this._dialog=null,this._backdrop=null,this._isShown=null,this._isBodyOverflowing=null,this._ignoreBackdropClick=null,this._isTransitioning=null,this._scrollbarWidth=null},Ne.prototype.handleUpdate=function(){this._adjustDialog()},
// Private
Ne.prototype._getConfig=function(t){return t=Object.assign({},Ie,t),mt.typeCheckConfig("modal",t,Ae),t},Ne.prototype._showElement=function(t){var n=this,i=e(this._element).hasClass(De.FADE);this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||
// Don't move modal's DOM position
document.body.appendChild(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),e(this._dialog).hasClass(De.SCROLLABLE)?this._dialog.querySelector(we.MODAL_BODY).scrollTop=0:this._element.scrollTop=0,i&&mt.reflow(this._element),e(this._element).addClass(De.SHOW),this._config.focus&&this._enforceFocus();var o=e.Event(Ce.SHOWN,{relatedTarget:t}),r=function(){n._config.focus&&n._element.focus(),n._isTransitioning=!1,e(n._element).trigger(o)};if(i){var s=mt.getTransitionDurationFromElement(this._dialog);e(this._dialog).one(mt.TRANSITION_END,r).emulateTransitionEnd(s)}else r()},Ne.prototype._enforceFocus=function(){var t=this;e(document).off(Ce.FOCUSIN).on(Ce.FOCUSIN,function(n){document!==n.target&&t._element!==n.target&&0===e(t._element).has(n.target).length&&t._element.focus()})},Ne.prototype._setEscapeEvent=function(){var t=this;this._isShown&&this._config.keyboard?e(this._element).on(Ce.KEYDOWN_DISMISS,function(e){27===e.which&&(e.preventDefault(),t.hide())}):this._isShown||e(this._element).off(Ce.KEYDOWN_DISMISS)},Ne.prototype._setResizeEvent=function(){var t=this;this._isShown?e(window).on(Ce.RESIZE,function(e){return t.handleUpdate(e)}):e(window).off(Ce.RESIZE)},Ne.prototype._hideModal=function(){var t=this;this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._isTransitioning=!1,this._showBackdrop(function(){e(document.body).removeClass(De.OPEN),t._resetAdjustments(),t._resetScrollbar(),e(t._element).trigger(Ce.HIDDEN)})},Ne.prototype._removeBackdrop=function(){this._backdrop&&(e(this._backdrop).remove(),this._backdrop=null)},Ne.prototype._showBackdrop=function(t){var n=this,i=e(this._element).hasClass(De.FADE)?De.FADE:"";if(this._isShown&&this._config.backdrop){if(this._backdrop=document.createElement("div"),this._backdrop.className=De.BACKDROP,i&&this._backdrop.classList.add(i),e(this._backdrop).appendTo(document.body),e(this._element).on(Ce.CLICK_DISMISS,function(t){if(n._ignoreBackdropClick)return void(n._ignoreBackdropClick=!1);t.target===t.currentTarget&&("static"===n._config.backdrop?n._element.focus():n.hide())}),i&&mt.reflow(this._backdrop),e(this._backdrop).addClass(De.SHOW),!t)return;if(!i)return void t();var o=mt.getTransitionDurationFromElement(this._backdrop);e(this._backdrop).one(mt.TRANSITION_END,t).emulateTransitionEnd(o)}else if(!this._isShown&&this._backdrop){e(this._backdrop).removeClass(De.SHOW);var r=function(){n._removeBackdrop(),t&&t()};if(e(this._element).hasClass(De.FADE)){var s=mt.getTransitionDurationFromElement(this._backdrop);e(this._backdrop).one(mt.TRANSITION_END,r).emulateTransitionEnd(s)}else r()}else t&&t()},
// ----------------------------------------------------------------------
// the following methods are used to handle overflowing modals
// todo (fat): these should probably be refactored out of modal.js
// ----------------------------------------------------------------------
Ne.prototype._adjustDialog=function(){var t=this._element.scrollHeight>document.documentElement.clientHeight;!this._isBodyOverflowing&&t&&(this._element.style.paddingLeft=this._scrollbarWidth+"px"),this._isBodyOverflowing&&!t&&(this._element.style.paddingRight=this._scrollbarWidth+"px")},Ne.prototype._resetAdjustments=function(){this._element.style.paddingLeft="",this._element.style.paddingRight=""},Ne.prototype._checkScrollbar=function(){var t=document.body.getBoundingClientRect();this._isBodyOverflowing=t.left+t.right<window.innerWidth,this._scrollbarWidth=this._getScrollbarWidth()},Ne.prototype._setScrollbar=function(){var t=this;if(this._isBodyOverflowing){
// Note: DOMNode.style.paddingRight returns the actual value or '' if not set
// while $(DOMNode).css('padding-right') returns the calculated value or 0 if not set
var n=[].slice.call(document.querySelectorAll(we.FIXED_CONTENT)),i=[].slice.call(document.querySelectorAll(we.STICKY_CONTENT));
// Adjust fixed content padding
e(n).each(function(n,i){var o=i.style.paddingRight,r=e(i).css("padding-right");e(i).data("padding-right",o).css("padding-right",parseFloat(r)+t._scrollbarWidth+"px")}),
// Adjust sticky content margin
e(i).each(function(n,i){var o=i.style.marginRight,r=e(i).css("margin-right");e(i).data("margin-right",o).css("margin-right",parseFloat(r)-t._scrollbarWidth+"px")});
// Adjust body padding
var o=document.body.style.paddingRight,r=e(document.body).css("padding-right");e(document.body).data("padding-right",o).css("padding-right",parseFloat(r)+this._scrollbarWidth+"px")}e(document.body).addClass(De.OPEN)},Ne.prototype._resetScrollbar=function(){
// Restore fixed content padding
var t=[].slice.call(document.querySelectorAll(we.FIXED_CONTENT));e(t).each(function(t,n){var i=e(n).data("padding-right");e(n).removeData("padding-right"),n.style.paddingRight=i||""});
// Restore sticky content
var n=[].slice.call(document.querySelectorAll(""+we.STICKY_CONTENT));e(n).each(function(t,n){var i=e(n).data("margin-right");void 0!==i&&e(n).css("margin-right",i).removeData("margin-right")});
// Restore body padding
var i=e(document.body).data("padding-right");e(document.body).removeData("padding-right"),document.body.style.paddingRight=i||""},Ne.prototype._getScrollbarWidth=function(){// thx d.walsh
var t=document.createElement("div");t.className=De.SCROLLBAR_MEASURER,document.body.appendChild(t);var e=t.getBoundingClientRect().width-t.clientWidth;return document.body.removeChild(t),e},
// Static
Ne._jQueryInterface=function(t,n){return this.each(function(){var i=e(this).data("bs.modal"),o=Object.assign({},Ie,e(this).data(),"object"==typeof t&&t?t:{});if(i||(i=new Ne(this,o),e(this).data("bs.modal",i)),"string"==typeof t){if(void 0===i[t])throw new TypeError('No method named "'+t+'"');i[t](n)}else o.show&&i.show(n)})},Object.defineProperties(Ne,Le),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(Ce.CLICK_DATA_API,we.DATA_TOGGLE,function(t){var n,i=this,o=mt.getSelectorFromElement(this);o&&(n=document.querySelector(o));var r=e(n).data("bs.modal")?"toggle":Object.assign({},e(n).data(),e(this).data());"A"!==this.tagName&&"AREA"!==this.tagName||t.preventDefault();var s=e(n).one(Ce.SHOW,function(t){t.isDefaultPrevented()||s.one(Ce.HIDDEN,function(){e(i).is(":visible")&&i.focus()})});Ne._jQueryInterface.call(e(n),r,this)}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn.modal=Ne._jQueryInterface,e.fn.modal.Constructor=Ne,e.fn.modal.noConflict=function(){return e.fn.modal=Se,Ne._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): tools/sanitizer.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
var Pe=["background","cite","href","itemtype","longdesc","poster","src","xlink:href"],Re=/^aria-[\w-]*$/i,He={
// Global attributes allowed on any supplied element below.
"*":["class","dir","id","lang","role",Re],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]},We=/^(?:(?:https?|mailto|ftp|tel|file):|[^&:\/?#]*(?:[\/?#]|$))/gi,Fe=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+\/]+=*$/i,Me="tooltip",je=e.fn[Me],xe=new RegExp("(^|\\s)bs-tooltip\\S+","g"),Ve=["sanitize","whiteList","sanitizeFn"],Ue={animation:"boolean",template:"string",title:"(string|element|function)",trigger:"string",delay:"(number|object)",html:"boolean",selector:"(string|boolean)",placement:"(string|function)",offset:"(number|string|function)",container:"(string|element|boolean)",fallbackPlacement:"(string|array)",boundary:"(string|element)",sanitize:"boolean",sanitizeFn:"(null|function)",whiteList:"object"},ke={AUTO:"auto",TOP:"top",RIGHT:"right",BOTTOM:"bottom",LEFT:"left"},Be={animation:!0,template:'<div class="tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,selector:!1,placement:"top",offset:0,container:!1,fallbackPlacement:"flip",boundary:"scrollParent",sanitize:!0,sanitizeFn:null,whiteList:He},Ge={SHOW:"show",OUT:"out"},Ke={HIDE:"hide.bs.tooltip",HIDDEN:"hidden.bs.tooltip",SHOW:"show.bs.tooltip",SHOWN:"shown.bs.tooltip",INSERTED:"inserted.bs.tooltip",CLICK:"click.bs.tooltip",FOCUSIN:"focusin.bs.tooltip",FOCUSOUT:"focusout.bs.tooltip",MOUSEENTER:"mouseenter.bs.tooltip",MOUSELEAVE:"mouseleave.bs.tooltip"},qe={FADE:"fade",SHOW:"show"},Qe={TOOLTIP:".tooltip",TOOLTIP_INNER:".tooltip-inner",ARROW:".arrow"},Ye={HOVER:"hover",FOCUS:"focus",CLICK:"click",MANUAL:"manual"},Xe=function(t,e){/**
   * Check for Popper dependency
   * Popper - https://popper.js.org
   */
if(void 0===fe)throw new TypeError("Bootstrap's tooltips require Popper.js (https://popper.js.org/)");
// private
this._isEnabled=!0,this._timeout=0,this._hoverState="",this._activeTrigger={},this._popper=null,
// Protected
this.element=t,this.config=this._getConfig(e),this.tip=null,this._setListeners()},ze={VERSION:{configurable:!0},Default:{configurable:!0},NAME:{configurable:!0},DATA_KEY:{configurable:!0},Event:{configurable:!0},EVENT_KEY:{configurable:!0},DefaultType:{configurable:!0}};
// Getters
ze.VERSION.get=function(){return"4.3.1"},ze.Default.get=function(){return Be},ze.NAME.get=function(){return Me},ze.DATA_KEY.get=function(){return"bs.tooltip"},ze.Event.get=function(){return Ke},ze.EVENT_KEY.get=function(){return".bs.tooltip"},ze.DefaultType.get=function(){return Ue},
// Public
Xe.prototype.enable=function(){this._isEnabled=!0},Xe.prototype.disable=function(){this._isEnabled=!1},Xe.prototype.toggleEnabled=function(){this._isEnabled=!this._isEnabled},Xe.prototype.toggle=function(t){if(this._isEnabled)if(t){var n=this.constructor.DATA_KEY,i=e(t.currentTarget).data(n);i||(i=new this.constructor(t.currentTarget,this._getDelegateConfig()),e(t.currentTarget).data(n,i)),i._activeTrigger.click=!i._activeTrigger.click,i._isWithActiveTrigger()?i._enter(null,i):i._leave(null,i)}else{if(e(this.getTipElement()).hasClass(qe.SHOW))return void this._leave(null,this);this._enter(null,this)}},Xe.prototype.dispose=function(){clearTimeout(this._timeout),e.removeData(this.element,this.constructor.DATA_KEY),e(this.element).off(this.constructor.EVENT_KEY),e(this.element).closest(".modal").off("hide.bs.modal"),this.tip&&e(this.tip).remove(),this._isEnabled=null,this._timeout=null,this._hoverState=null,this._activeTrigger=null,null!==this._popper&&this._popper.destroy(),this._popper=null,this.element=null,this.config=null,this.tip=null},Xe.prototype.show=function(){var t=this;if("none"===e(this.element).css("display"))throw new Error("Please use show on visible elements");var n=e.Event(this.constructor.Event.SHOW);if(this.isWithContent()&&this._isEnabled){e(this.element).trigger(n);var i=mt.findShadowRoot(this.element),o=e.contains(null!==i?i:this.element.ownerDocument.documentElement,this.element);if(n.isDefaultPrevented()||!o)return;var r=this.getTipElement(),s=mt.getUID(this.constructor.NAME);r.setAttribute("id",s),this.element.setAttribute("aria-describedby",s),this.setContent(),this.config.animation&&e(r).addClass(qe.FADE);var a="function"==typeof this.config.placement?this.config.placement.call(this,r,this.element):this.config.placement,l=this._getAttachment(a);this.addAttachmentClass(l);var c=this._getContainer();e(r).data(this.constructor.DATA_KEY,this),e.contains(this.element.ownerDocument.documentElement,this.tip)||e(r).appendTo(c),e(this.element).trigger(this.constructor.Event.INSERTED),this._popper=new fe(this.element,r,{placement:l,modifiers:{offset:this._getOffset(),flip:{behavior:this.config.fallbackPlacement},arrow:{element:Qe.ARROW},preventOverflow:{boundariesElement:this.config.boundary}},onCreate:function(e){e.originalPlacement!==e.placement&&t._handlePopperPlacementChange(e)},onUpdate:function(e){return t._handlePopperPlacementChange(e)}}),e(r).addClass(qe.SHOW),
// If this is a touch-enabled device we add extra
// empty mouseover listeners to the body's immediate children;
// only needed because of broken event delegation on iOS
// https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html
"ontouchstart"in document.documentElement&&e(document.body).children().on("mouseover",null,e.noop);var u=function(){t.config.animation&&t._fixTransition();var n=t._hoverState;t._hoverState=null,e(t.element).trigger(t.constructor.Event.SHOWN),n===Ge.OUT&&t._leave(null,t)};if(e(this.tip).hasClass(qe.FADE)){var h=mt.getTransitionDurationFromElement(this.tip);e(this.tip).one(mt.TRANSITION_END,u).emulateTransitionEnd(h)}else u()}},Xe.prototype.hide=function(t){var n=this,i=this.getTipElement(),o=e.Event(this.constructor.Event.HIDE),r=function(){n._hoverState!==Ge.SHOW&&i.parentNode&&i.parentNode.removeChild(i),n._cleanTipClass(),n.element.removeAttribute("aria-describedby"),e(n.element).trigger(n.constructor.Event.HIDDEN),null!==n._popper&&n._popper.destroy(),t&&t()};if(e(this.element).trigger(o),!o.isDefaultPrevented()){if(e(i).removeClass(qe.SHOW),
// If this is a touch-enabled device we remove the extra
// empty mouseover listeners we added for iOS support
"ontouchstart"in document.documentElement&&e(document.body).children().off("mouseover",null,e.noop),this._activeTrigger[Ye.CLICK]=!1,this._activeTrigger[Ye.FOCUS]=!1,this._activeTrigger[Ye.HOVER]=!1,e(this.tip).hasClass(qe.FADE)){var s=mt.getTransitionDurationFromElement(i);e(i).one(mt.TRANSITION_END,r).emulateTransitionEnd(s)}else r();this._hoverState=""}},Xe.prototype.update=function(){null!==this._popper&&this._popper.scheduleUpdate()},
// Protected
Xe.prototype.isWithContent=function(){return Boolean(this.getTitle())},Xe.prototype.addAttachmentClass=function(t){e(this.getTipElement()).addClass("bs-tooltip-"+t)},Xe.prototype.getTipElement=function(){return this.tip=this.tip||e(this.config.template)[0],this.tip},Xe.prototype.setContent=function(){var t=this.getTipElement();this.setElementContent(e(t.querySelectorAll(Qe.TOOLTIP_INNER)),this.getTitle()),e(t).removeClass(qe.FADE+" "+qe.SHOW)},Xe.prototype.setElementContent=function(t,n){if("object"==typeof n&&(n.nodeType||n.jquery))
// Content is a DOM node or a jQuery
return void(this.config.html?e(n).parent().is(t)||t.empty().append(n):t.text(e(n).text()));this.config.html?(this.config.sanitize&&(n=pt(n,this.config.whiteList,this.config.sanitizeFn)),t.html(n)):t.text(n)},Xe.prototype.getTitle=function(){var t=this.element.getAttribute("data-original-title");return t||(t="function"==typeof this.config.title?this.config.title.call(this.element):this.config.title),t},
// Private
Xe.prototype._getOffset=function(){var t=this,e={};return"function"==typeof this.config.offset?e.fn=function(e){return e.offsets=Object.assign({},e.offsets,t.config.offset(e.offsets,t.element)||{}),e}:e.offset=this.config.offset,e},Xe.prototype._getContainer=function(){return!1===this.config.container?document.body:mt.isElement(this.config.container)?e(this.config.container):e(document).find(this.config.container)},Xe.prototype._getAttachment=function(t){return ke[t.toUpperCase()]},Xe.prototype._setListeners=function(){var t=this;this.config.trigger.split(" ").forEach(function(n){if("click"===n)e(t.element).on(t.constructor.Event.CLICK,t.config.selector,function(e){return t.toggle(e)});else if(n!==Ye.MANUAL){var i=n===Ye.HOVER?t.constructor.Event.MOUSEENTER:t.constructor.Event.FOCUSIN,o=n===Ye.HOVER?t.constructor.Event.MOUSELEAVE:t.constructor.Event.FOCUSOUT;e(t.element).on(i,t.config.selector,function(e){return t._enter(e)}).on(o,t.config.selector,function(e){return t._leave(e)})}}),e(this.element).closest(".modal").on("hide.bs.modal",function(){t.element&&t.hide()}),this.config.selector?this.config=Object.assign({},this.config,{trigger:"manual",selector:""}):this._fixTitle()},Xe.prototype._fixTitle=function(){var t=typeof this.element.getAttribute("data-original-title");(this.element.getAttribute("title")||"string"!==t)&&(this.element.setAttribute("data-original-title",this.element.getAttribute("title")||""),this.element.setAttribute("title",""))},Xe.prototype._enter=function(t,n){var i=this.constructor.DATA_KEY;return n=n||e(t.currentTarget).data(i),n||(n=new this.constructor(t.currentTarget,this._getDelegateConfig()),e(t.currentTarget).data(i,n)),t&&(n._activeTrigger["focusin"===t.type?Ye.FOCUS:Ye.HOVER]=!0),e(n.getTipElement()).hasClass(qe.SHOW)||n._hoverState===Ge.SHOW?void(n._hoverState=Ge.SHOW):(clearTimeout(n._timeout),n._hoverState=Ge.SHOW,n.config.delay&&n.config.delay.show?void(n._timeout=setTimeout(function(){n._hoverState===Ge.SHOW&&n.show()},n.config.delay.show)):void n.show())},Xe.prototype._leave=function(t,n){var i=this.constructor.DATA_KEY;if(n=n||e(t.currentTarget).data(i),n||(n=new this.constructor(t.currentTarget,this._getDelegateConfig()),e(t.currentTarget).data(i,n)),t&&(n._activeTrigger["focusout"===t.type?Ye.FOCUS:Ye.HOVER]=!1),!n._isWithActiveTrigger()){if(clearTimeout(n._timeout),n._hoverState=Ge.OUT,!n.config.delay||!n.config.delay.hide)return void n.hide();n._timeout=setTimeout(function(){n._hoverState===Ge.OUT&&n.hide()},n.config.delay.hide)}},Xe.prototype._isWithActiveTrigger=function(){var t=this;for(var e in t._activeTrigger)if(t._activeTrigger[e])return!0;return!1},Xe.prototype._getConfig=function(t){var n=e(this.element).data();return Object.keys(n).forEach(function(t){-1!==Ve.indexOf(t)&&delete n[t]}),t=Object.assign({},this.constructor.Default,n,"object"==typeof t&&t?t:{}),"number"==typeof t.delay&&(t.delay={show:t.delay,hide:t.delay}),"number"==typeof t.title&&(t.title=t.title.toString()),"number"==typeof t.content&&(t.content=t.content.toString()),mt.typeCheckConfig(Me,t,this.constructor.DefaultType),t.sanitize&&(t.template=pt(t.template,t.whiteList,t.sanitizeFn)),t},Xe.prototype._getDelegateConfig=function(){var t=this,e={};if(this.config)for(var n in t.config)t.constructor.Default[n]!==t.config[n]&&(e[n]=t.config[n]);return e},Xe.prototype._cleanTipClass=function(){var t=e(this.getTipElement()),n=t.attr("class").match(xe);null!==n&&n.length&&t.removeClass(n.join(""))},Xe.prototype._handlePopperPlacementChange=function(t){var e=t.instance;this.tip=e.popper,this._cleanTipClass(),this.addAttachmentClass(this._getAttachment(t.placement))},Xe.prototype._fixTransition=function(){var t=this.getTipElement(),n=this.config.animation;null===t.getAttribute("x-placement")&&(e(t).removeClass(qe.FADE),this.config.animation=!1,this.hide(),this.show(),this.config.animation=n)},
// Static
Xe._jQueryInterface=function(t){return this.each(function(){var n=e(this).data("bs.tooltip"),i="object"==typeof t&&t;if((n||!/dispose|hide/.test(t))&&(n||(n=new Xe(this,i),e(this).data("bs.tooltip",n)),"string"==typeof t)){if(void 0===n[t])throw new TypeError('No method named "'+t+'"');n[t]()}})},Object.defineProperties(Xe,ze),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[Me]=Xe._jQueryInterface,e.fn[Me].Constructor=Xe,e.fn[Me].noConflict=function(){return e.fn[Me]=je,Xe._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): popover.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var $e="popover",Je=e.fn[$e],Ze=new RegExp("(^|\\s)bs-popover\\S+","g"),tn=Object.assign({},Xe.Default,{placement:"right",trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>'}),en=Object.assign({},Xe.DefaultType,{content:"(string|element|function)"}),nn={FADE:"fade",SHOW:"show"},on={TITLE:".popover-header",CONTENT:".popover-body"},rn={HIDE:"hide.bs.popover",HIDDEN:"hidden.bs.popover",SHOW:"show.bs.popover",SHOWN:"shown.bs.popover",INSERTED:"inserted.bs.popover",CLICK:"click.bs.popover",FOCUSIN:"focusin.bs.popover",FOCUSOUT:"focusout.bs.popover",MOUSEENTER:"mouseenter.bs.popover",MOUSELEAVE:"mouseleave.bs.popover"},sn=function(t){function n(){t.apply(this,arguments)}t&&(n.__proto__=t),n.prototype=Object.create(t&&t.prototype),n.prototype.constructor=n;var i={VERSION:{configurable:!0},Default:{configurable:!0},NAME:{configurable:!0},DATA_KEY:{configurable:!0},Event:{configurable:!0},EVENT_KEY:{configurable:!0},DefaultType:{configurable:!0}};
// Overrides
// Private
// Static
return i.VERSION.get=function(){return"4.3.1"},i.Default.get=function(){return tn},i.NAME.get=function(){return $e},i.DATA_KEY.get=function(){return"bs.popover"},i.Event.get=function(){return rn},i.EVENT_KEY.get=function(){return".bs.popover"},i.DefaultType.get=function(){return en},n.prototype.isWithContent=function(){return this.getTitle()||this._getContent()},n.prototype.addAttachmentClass=function(t){e(this.getTipElement()).addClass("bs-popover-"+t)},n.prototype.getTipElement=function(){return this.tip=this.tip||e(this.config.template)[0],this.tip},n.prototype.setContent=function(){var t=e(this.getTipElement());
// We use append for html objects to maintain js events
this.setElementContent(t.find(on.TITLE),this.getTitle());var n=this._getContent();"function"==typeof n&&(n=n.call(this.element)),this.setElementContent(t.find(on.CONTENT),n),t.removeClass(nn.FADE+" "+nn.SHOW)},n.prototype._getContent=function(){return this.element.getAttribute("data-content")||this.config.content},n.prototype._cleanTipClass=function(){var t=e(this.getTipElement()),n=t.attr("class").match(Ze);null!==n&&n.length>0&&t.removeClass(n.join(""))},n._jQueryInterface=function(t){return this.each(function(){var i=e(this).data("bs.popover"),o="object"==typeof t?t:null;if((i||!/dispose|hide/.test(t))&&(i||(i=new n(this,o),e(this).data("bs.popover",i)),"string"==typeof t)){if(void 0===i[t])throw new TypeError('No method named "'+t+'"');i[t]()}})},Object.defineProperties(n,i),n}(Xe);/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[$e]=sn._jQueryInterface,e.fn[$e].Constructor=sn,e.fn[$e].noConflict=function(){return e.fn[$e]=Je,sn._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): scrollspy.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var an="scrollspy",ln=e.fn[an],cn={offset:10,method:"auto",target:""},un={offset:"number",method:"string",target:"(string|element)"},hn={ACTIVATE:"activate.bs.scrollspy",SCROLL:"scroll.bs.scrollspy",LOAD_DATA_API:"load.bs.scrollspy.data-api"},fn={DROPDOWN_ITEM:"dropdown-item",DROPDOWN_MENU:"dropdown-menu",ACTIVE:"active"},dn={DATA_SPY:'[data-spy="scroll"]',ACTIVE:".active",NAV_LIST_GROUP:".nav, .list-group",NAV_LINKS:".nav-link",NAV_ITEMS:".nav-item",LIST_ITEMS:".list-group-item",DROPDOWN:".dropdown",DROPDOWN_ITEMS:".dropdown-item",DROPDOWN_TOGGLE:".dropdown-toggle"},pn={OFFSET:"offset",POSITION:"position"},gn=function(t,n){var i=this;this._element=t,this._scrollElement="BODY"===t.tagName?window:t,this._config=this._getConfig(n),this._selector=this._config.target+" "+dn.NAV_LINKS+","+this._config.target+" "+dn.LIST_ITEMS+","+this._config.target+" "+dn.DROPDOWN_ITEMS,this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,e(this._scrollElement).on(hn.SCROLL,function(t){return i._process(t)}),this.refresh(),this._process()},mn={VERSION:{configurable:!0},Default:{configurable:!0}};
// Getters
mn.VERSION.get=function(){return"4.3.1"},mn.Default.get=function(){return cn},
// Public
gn.prototype.refresh=function(){var t=this,n=this._scrollElement===this._scrollElement.window?pn.OFFSET:pn.POSITION,i="auto"===this._config.method?n:this._config.method,o=i===pn.POSITION?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight(),[].slice.call(document.querySelectorAll(this._selector)).map(function(t){var n,r=mt.getSelectorFromElement(t);if(r&&(n=document.querySelector(r)),n){var s=n.getBoundingClientRect();if(s.width||s.height)
// TODO (fat): remove sketch reliance on jQuery position/offset
return[e(n)[i]().top+o,r]}return null}).filter(function(t){return t}).sort(function(t,e){return t[0]-e[0]}).forEach(function(e){t._offsets.push(e[0]),t._targets.push(e[1])})},gn.prototype.dispose=function(){e.removeData(this._element,"bs.scrollspy"),e(this._scrollElement).off(".bs.scrollspy"),this._element=null,this._scrollElement=null,this._config=null,this._selector=null,this._offsets=null,this._targets=null,this._activeTarget=null,this._scrollHeight=null},
// Private
gn.prototype._getConfig=function(t){if(t=Object.assign({},cn,"object"==typeof t&&t?t:{}),"string"!=typeof t.target){var n=e(t.target).attr("id");n||(n=mt.getUID(an),e(t.target).attr("id",n)),t.target="#"+n}return mt.typeCheckConfig(an,t,un),t},gn.prototype._getScrollTop=function(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop},gn.prototype._getScrollHeight=function(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)},gn.prototype._getOffsetHeight=function(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height},gn.prototype._process=function(){var t=this,e=this._getScrollTop()+this._config.offset,n=this._getScrollHeight(),i=this._config.offset+n-this._getOffsetHeight();if(this._scrollHeight!==n&&this.refresh(),e>=i){var o=this._targets[this._targets.length-1];return void(this._activeTarget!==o&&this._activate(o))}if(this._activeTarget&&e<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(var r=this._offsets.length,s=r;s--;){t._activeTarget!==t._targets[s]&&e>=t._offsets[s]&&(void 0===t._offsets[s+1]||e<t._offsets[s+1])&&t._activate(t._targets[s])}},gn.prototype._activate=function(t){this._activeTarget=t,this._clear();var n=this._selector.split(",").map(function(e){return e+'[data-target="'+t+'"],'+e+'[href="'+t+'"]'}),i=e([].slice.call(document.querySelectorAll(n.join(","))));i.hasClass(fn.DROPDOWN_ITEM)?(i.closest(dn.DROPDOWN).find(dn.DROPDOWN_TOGGLE).addClass(fn.ACTIVE),i.addClass(fn.ACTIVE)):(
// Set triggered link as active
i.addClass(fn.ACTIVE),
// Set triggered links parents as active
// With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor
i.parents(dn.NAV_LIST_GROUP).prev(dn.NAV_LINKS+", "+dn.LIST_ITEMS).addClass(fn.ACTIVE),
// Handle special case when .nav-link is inside .nav-item
i.parents(dn.NAV_LIST_GROUP).prev(dn.NAV_ITEMS).children(dn.NAV_LINKS).addClass(fn.ACTIVE)),e(this._scrollElement).trigger(hn.ACTIVATE,{relatedTarget:t})},gn.prototype._clear=function(){[].slice.call(document.querySelectorAll(this._selector)).filter(function(t){return t.classList.contains(fn.ACTIVE)}).forEach(function(t){return t.classList.remove(fn.ACTIVE)})},
// Static
gn._jQueryInterface=function(t){return this.each(function(){var n=e(this).data("bs.scrollspy"),i="object"==typeof t&&t;if(n||(n=new gn(this,i),e(this).data("bs.scrollspy",n)),"string"==typeof t){if(void 0===n[t])throw new TypeError('No method named "'+t+'"');n[t]()}})},Object.defineProperties(gn,mn),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(window).on(hn.LOAD_DATA_API,function(){for(var t=[].slice.call(document.querySelectorAll(dn.DATA_SPY)),n=t.length,i=n;i--;){var o=e(t[i]);gn._jQueryInterface.call(o,o.data())}}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn[an]=gn._jQueryInterface,e.fn[an].Constructor=gn,e.fn[an].noConflict=function(){return e.fn[an]=ln,gn._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): tab.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var _n=e.fn.tab,vn={HIDE:"hide.bs.tab",HIDDEN:"hidden.bs.tab",SHOW:"show.bs.tab",SHOWN:"shown.bs.tab",CLICK_DATA_API:"click.bs.tab.data-api"},En={DROPDOWN_MENU:"dropdown-menu",ACTIVE:"active",DISABLED:"disabled",FADE:"fade",SHOW:"show"},bn={DROPDOWN:".dropdown",NAV_LIST_GROUP:".nav, .list-group",ACTIVE:".active",ACTIVE_UL:"> li > .active",DATA_TOGGLE:'[data-toggle="tab"], [data-toggle="pill"], [data-toggle="list"]',DROPDOWN_TOGGLE:".dropdown-toggle",DROPDOWN_ACTIVE_CHILD:"> .dropdown-menu .active"},Tn=function(t){this._element=t},yn={VERSION:{configurable:!0}};
// Getters
yn.VERSION.get=function(){return"4.3.1"},
// Public
Tn.prototype.show=function(){var t=this;if(!(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&e(this._element).hasClass(En.ACTIVE)||e(this._element).hasClass(En.DISABLED))){var n,i,o=e(this._element).closest(bn.NAV_LIST_GROUP)[0],r=mt.getSelectorFromElement(this._element);if(o){var s="UL"===o.nodeName||"OL"===o.nodeName?bn.ACTIVE_UL:bn.ACTIVE;i=e.makeArray(e(o).find(s)),i=i[i.length-1]}var a=e.Event(vn.HIDE,{relatedTarget:this._element}),l=e.Event(vn.SHOW,{relatedTarget:i});if(i&&e(i).trigger(a),e(this._element).trigger(l),!l.isDefaultPrevented()&&!a.isDefaultPrevented()){r&&(n=document.querySelector(r)),this._activate(this._element,o);var c=function(){var n=e.Event(vn.HIDDEN,{relatedTarget:t._element}),o=e.Event(vn.SHOWN,{relatedTarget:i});e(i).trigger(n),e(t._element).trigger(o)};n?this._activate(n,n.parentNode,c):c()}}},Tn.prototype.dispose=function(){e.removeData(this._element,"bs.tab"),this._element=null},
// Private
Tn.prototype._activate=function(t,n,i){var o=this,r=!n||"UL"!==n.nodeName&&"OL"!==n.nodeName?e(n).children(bn.ACTIVE):e(n).find(bn.ACTIVE_UL),s=r[0],a=i&&s&&e(s).hasClass(En.FADE),l=function(){return o._transitionComplete(t,s,i)};if(s&&a){var c=mt.getTransitionDurationFromElement(s);e(s).removeClass(En.SHOW).one(mt.TRANSITION_END,l).emulateTransitionEnd(c)}else l()},Tn.prototype._transitionComplete=function(t,n,i){if(n){e(n).removeClass(En.ACTIVE);var o=e(n.parentNode).find(bn.DROPDOWN_ACTIVE_CHILD)[0];o&&e(o).removeClass(En.ACTIVE),"tab"===n.getAttribute("role")&&n.setAttribute("aria-selected",!1)}if(e(t).addClass(En.ACTIVE),"tab"===t.getAttribute("role")&&t.setAttribute("aria-selected",!0),mt.reflow(t),t.classList.contains(En.FADE)&&t.classList.add(En.SHOW),t.parentNode&&e(t.parentNode).hasClass(En.DROPDOWN_MENU)){var r=e(t).closest(bn.DROPDOWN)[0];if(r){var s=[].slice.call(r.querySelectorAll(bn.DROPDOWN_TOGGLE));e(s).addClass(En.ACTIVE)}t.setAttribute("aria-expanded",!0)}i&&i()},
// Static
Tn._jQueryInterface=function(t){return this.each(function(){var n=e(this),i=n.data("bs.tab");if(i||(i=new Tn(this),n.data("bs.tab",i)),"string"==typeof t){if(void 0===i[t])throw new TypeError('No method named "'+t+'"');i[t]()}})},Object.defineProperties(Tn,yn),/**
 * ------------------------------------------------------------------------
 * Data Api implementation
 * ------------------------------------------------------------------------
 */
e(document).on(vn.CLICK_DATA_API,bn.DATA_TOGGLE,function(t){t.preventDefault(),Tn._jQueryInterface.call(e(this),"show")}),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn.tab=Tn._jQueryInterface,e.fn.tab.Constructor=Tn,e.fn.tab.noConflict=function(){return e.fn.tab=_n,Tn._jQueryInterface};/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): toast.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
/**
 * ------------------------------------------------------------------------
 * Constants
 * ------------------------------------------------------------------------
 */
var On=e.fn.toast,Sn={CLICK_DISMISS:"click.dismiss.bs.toast",HIDE:"hide.bs.toast",HIDDEN:"hidden.bs.toast",SHOW:"show.bs.toast",SHOWN:"shown.bs.toast"},In={FADE:"fade",HIDE:"hide",SHOW:"show",SHOWING:"showing"},An={animation:"boolean",autohide:"boolean",delay:"number"},Cn={animation:!0,autohide:!0,delay:500},Dn={DATA_DISMISS:'[data-dismiss="toast"]'},wn=function(t,e){this._element=t,this._config=this._getConfig(e),this._timeout=null,this._setListeners()},Nn={VERSION:{configurable:!0},DefaultType:{configurable:!0},Default:{configurable:!0}};
// Getters
Nn.VERSION.get=function(){return"4.3.1"},Nn.DefaultType.get=function(){return An},Nn.Default.get=function(){return Cn},
// Public
wn.prototype.show=function(){var t=this;e(this._element).trigger(Sn.SHOW),this._config.animation&&this._element.classList.add(In.FADE);var n=function(){t._element.classList.remove(In.SHOWING),t._element.classList.add(In.SHOW),e(t._element).trigger(Sn.SHOWN),t._config.autohide&&t.hide()};if(this._element.classList.remove(In.HIDE),this._element.classList.add(In.SHOWING),this._config.animation){var i=mt.getTransitionDurationFromElement(this._element);e(this._element).one(mt.TRANSITION_END,n).emulateTransitionEnd(i)}else n()},wn.prototype.hide=function(t){var n=this;this._element.classList.contains(In.SHOW)&&(e(this._element).trigger(Sn.HIDE),t?this._close():this._timeout=setTimeout(function(){n._close()},this._config.delay))},wn.prototype.dispose=function(){clearTimeout(this._timeout),this._timeout=null,this._element.classList.contains(In.SHOW)&&this._element.classList.remove(In.SHOW),e(this._element).off(Sn.CLICK_DISMISS),e.removeData(this._element,"bs.toast"),this._element=null,this._config=null},
// Private
wn.prototype._getConfig=function(t){return t=Object.assign({},Cn,e(this._element).data(),"object"==typeof t&&t?t:{}),mt.typeCheckConfig("toast",t,this.constructor.DefaultType),t},wn.prototype._setListeners=function(){var t=this;e(this._element).on(Sn.CLICK_DISMISS,Dn.DATA_DISMISS,function(){return t.hide(!0)})},wn.prototype._close=function(){var t=this,n=function(){t._element.classList.add(In.HIDE),e(t._element).trigger(Sn.HIDDEN)};if(this._element.classList.remove(In.SHOW),this._config.animation){var i=mt.getTransitionDurationFromElement(this._element);e(this._element).one(mt.TRANSITION_END,n).emulateTransitionEnd(i)}else n()},
// Static
wn._jQueryInterface=function(t){return this.each(function(){var n=e(this),i=n.data("bs.toast"),o="object"==typeof t&&t;if(i||(i=new wn(this,o),n.data("bs.toast",i)),"string"==typeof t){if(void 0===i[t])throw new TypeError('No method named "'+t+'"');i[t](this)}})},Object.defineProperties(wn,Nn),/**
 * ------------------------------------------------------------------------
 * jQuery
 * ------------------------------------------------------------------------
 */
e.fn.toast=wn._jQueryInterface,e.fn.toast.Constructor=wn,e.fn.toast.noConflict=function(){return e.fn.toast=On,wn._jQueryInterface},/**
 * --------------------------------------------------------------------------
 * Bootstrap (v4.3.1): index.js
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 * --------------------------------------------------------------------------
 */
function(){if(void 0===e)throw new TypeError("Bootstrap's JavaScript requires jQuery. jQuery must be included before Bootstrap's JavaScript.");var t=e.fn.jquery.split(" ")[0].split(".");if(t[0]<2&&t[1]<9||1===t[0]&&9===t[1]&&t[2]<1||t[0]>=4)throw new Error("Bootstrap's JavaScript requires at least jQuery v1.9.1 but less than v4.0.0")}(),t.Util=mt,t.Alert=yt,t.Button=Dt,t.Carousel=Vt,t.Collapse=zt,t.Dropdown=ye,t.Modal=Ne,t.Popover=sn,t.Scrollspy=gn,t.Tab=Tn,t.Toast=wn,t.Tooltip=Xe,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=dist/js/bootstrap.min.js.map