/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * ShapeTools/shape program - shapeopt.c
 *
 * Author: Axel Mahler (Axel.Mahler@cs.tu-berlin.de)
 *
 * $Header: shapeopt.c[8.0] Wed Jul  7 18:33:14 1993 axel@cs.tu-berlin.de frozen $
 */
#ifndef lint
static char *AtFSid = "$Header: shapeopt.c[8.0] Wed Jul  7 18:33:14 1993 axel@cs.tu-berlin.de frozen $";
#endif

#include "shape.h"

EXPORT char cfname[MYMAXNAMLEN];
EXPORT char echomac[32];
EXPORT char *forcelist[10];
EXPORT FILE *cid;

EXPORT Bool debugflg;
EXPORT Bool D_flag;
EXPORT Bool Var_flag;
EXPORT Bool envflg;
EXPORT Bool fileflg;
EXPORT Bool nostdfile;
EXPORT Bool ignoreflg;
EXPORT Bool goflg;
EXPORT Bool noexflg;
EXPORT Bool printflg;
EXPORT Bool ruleflg;
EXPORT Bool silentflg;
EXPORT Bool stdinflg;
EXPORT Bool confid;
EXPORT Bool rebuildflg;
EXPORT Bool expflg;
EXPORT Bool noexpflg;
EXPORT Bool echoflg;
EXPORT Bool nomsgflg;
EXPORT Bool novclassflg;
EXPORT Bool bpoolflg;
EXPORT Bool nobpoolflg;
EXPORT Bool forceflg;

LOCAL int h_d_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  debugflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_D_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  D_flag = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}


LOCAL int h_e_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  envflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_f_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{

struct linked_list *shfiles;
if (!strcmp(arg,""))
  return(1);
fileflg = TRUE;
if (strcmp(arg,"-") == 0)
  stdinflg = TRUE;
else
  {
    if (shapefiles == (struct linked_list *) NIL)
      {
	if ((shapefiles = (struct linked_list *) malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	  errexit(10,"malloc");
	if ((shapefiles->string = malloc((unsigned) strlen(arg) + sizeof(char))) == NIL)
	  errexit(10,"malloc");
	strcpy(shapefiles->string,arg);
	shapefiles->nextstring = (struct linked_list *) NIL;
      }
    else
      {
	shfiles = shapefiles;
	while( shfiles->nextstring != (struct linked_list *) NIL)
	  shfiles = shfiles->nextstring;
	
	if((shfiles->nextstring  = (struct linked_list *) malloc(sizeof(struct linked_list))) == (struct linked_list *) NIL)
	  errexit(10,"malloc");
	shfiles = shfiles->nextstring;
	if ((shfiles->string = malloc((unsigned) strlen(arg) + sizeof(char))) == NIL)
	  errexit(10,"malloc");
	strcpy(shfiles->string, arg);
	shfiles->nextstring = (struct linked_list *) NIL;
      }
  }
  return(0);
}


LOCAL int h_force_option(opt,arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  int i = 0;
  forceflg = TRUE;
  while(forcelist[i] != NIL)
    {
      if (i == 10)
	errexit(36, NIL);
      i++;
    }
  if ((forcelist[i] = malloc((unsigned) (strlen(arg) + sizeof(char)))) == NIL)
    errexit(10,"malloc");
  strcpy(forcelist[i],arg);
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  strcat (shapeflags, arg);
  strcat (shapeflags, " ");
  return (0);
}

LOCAL int h_h_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  return(1);
}

LOCAL int h_i_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  ignoreflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_k_option(opt, arg)
     /*ARGSUSED*/
     char *opt; 
     char *arg;
{
  goflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_n_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  noexflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_nomsg_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  nomsgflg = TRUE;
  atBindNoMsg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_novclass_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  novclassflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_p_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  printflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_r_option(opt,arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  implicit_suffs[0] = -1;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}


LOCAL int h_R_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  ruleflg = TRUE;
  strcpy(ruleset,arg);
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  strcat (shapeflags, arg);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_s_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  silentflg = TRUE;
  stQuietFlag = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_version_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  printf("shape - Version %s\n", version());
  printf("AtFS version %s\n", af_version());
  printf("AtFS toolkit lib %s\n", atVersion());
  exit(0);
}

LOCAL int h_expandall_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  if (noexpflg)
    errexit(34,NIL);
  expflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_expandnothing_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  if(expflg)
    errexit(34,NIL);
  noexpflg = TRUE;
  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  return(0);
}

LOCAL int h_echo_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  echoflg = TRUE;
  strcpy(echomac,arg);
  return(0);
}

LOCAL int h_V_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  static int nvars = 0;
  Bool addplus = FALSE;
  char *vnp;

  /* activate a variant from the command line */
  if (nvars == MAXCMDLINEVARS) {
    warning (99, "Too many variant activations from command line");
    return 1;
  }

  if (!(arg && *arg)) {
    warning (99, "Usage: shape -V <variantname>");
    return 1;
  }

  if (*arg != '+') addplus = TRUE;

  if ((vnp = (char *)malloc (strlen (arg) + (addplus ? 2 : 1))) == NULL)
    errexit (10, "malloc");
  if (addplus)
    strcpy (vnp, "+");
  else
    *vnp = '\0';

  strcat (vnp, arg);
  cmd_line_vars[nvars++] = vnp;

  strcat (shapeflags, "-");
  strcat (shapeflags, opt);
  strcat (shapeflags, " ");
  strcat (shapeflags, arg);
  strcat (shapeflags, " ");

  Var_flag = TRUE;
  return 0;
}

LOCAL int h_confid_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{

  confid = TRUE;
  return 0;
}

LOCAL int h_rebuild_option(opt, arg)
     /*ARGSUSED*/
     char *opt;
     char *arg;
{
  strcpy (rbrule, "bound_configuration_thread");

  if ((strrchr (arg, '[') == NIL)) {
    strcpy (rbtarg, arg);
    strcpy (rbfile, arg);
    strcat (rbfile, ".bct");
  }
  else {
    char *p;
    strcpy (rbfile, arg);
    strcpy (rbtarg, arg);
    if ((p = strchr (rbtarg, '.')) != NIL)
      *p = '\0';
  }

  rebuildflg = TRUE;
  
  return 0;

}

EXPORT StOptDesc odesc[] = {
  { "d", PSWITCH, h_d_option, NULL, NULL },
  { "D", PSWITCH, h_D_option, NULL, NULL },
  { "e", PSWITCH, h_e_option, NULL, NULL },
  { "f", PARG, h_f_option, NULL, NULL },
  { "force", PARG, h_force_option, NULL, NULL },
  { "h", PSWITCH, h_h_option, NULL, NULL },
  { "i", PSWITCH, h_i_option, NULL, NULL },
  { "k", PSWITCH, h_k_option, NULL, NULL },
  { "n", PSWITCH, h_n_option, NULL, NULL },
  { "nomsg", PSWITCH, h_nomsg_option, NULL, NULL },
  { "novclass", PSWITCH, h_novclass_option, NULL, NULL },
  { "p", PSWITCH, h_p_option, NULL, NULL },
  { "r", PSWITCH, h_r_option, NULL, NULL },
  { "R", PARG, h_R_option, NULL, NULL },
  { "s", PSWITCH, h_s_option, NULL, NULL },
  { "V", PARG, h_V_option, NULL, NULL },
  { "version", PSWITCH, h_version_option, NULL, NULL },
  { "confid", PSWITCH, h_confid_option, NULL, NULL },
  { "bct", PSWITCH, h_confid_option, NULL, NULL },
  { "rebuild", PARG, h_rebuild_option, NULL, NULL },
  { "xpon", PSWITCH, h_expandall_option, NULL, NULL },
  { "xpoff", PSWITCH, h_expandnothing_option, NULL, NULL },
  { "echo", PARG, h_echo_option, NULL, NULL },
  { (char *) NULL, 0, NULL, NULL, NULL }
};
