#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the following features of the sanitizer:

   - Converting TNEF to MIME

tac

if [ ! -e /usr/local/bin/f-prot ]; then
    # F-Prot not installed, fake a successful run.
    echo -n "SKIPPED: F-Prot not installed.  " >&2
    cat $TEST_RESULTS/sanitizer.tnef.ok >test.out
    exit 0
fi
if [ ! -e $ANOMY/bin/Anomy/TNEFStream.pm ]; then
    # ANOMY::TNEFStream not installed, fake a successful run.
    echo -n "SKIPPED: ANOMY::TNEFStream not installed.  " >&2
    cat $TEST_RESULTS/sanitizer.tnef.ok >test.out
    exit 0
fi

# Obfuscation so our distributed package does not trigger AV products...
SKIPPED1="eJ8+IgYEAQaQCAAEAAAAAAABAAEAAQeQBgAIAAAA5AQAAAAAAADoAAEIgAcAGAAAAElQTS5N"
SKIPPED2="aWNyb3NvZnQgTWFpbC5Ob3RlADEIAQ2ABAACAAAAAgACAAEGgAMADgAAANIHBAAZAAUADwAA"
SKIPPED3="AAQADgEBA5AGAHAEAAAjAAAACwACAAEAAAALACMAAAAAAAMAJgAAAAAACwApAAAAAAALACsA"
SKIPPED4="AAAAAAMALgAAAAAAAwA2AAAAAAAeAHAAAQAAADgAAABjb21wYW5pZXMgbWVyZ2UgdG8gZm9y"

$ANOMY/bin/sanitizer.pl -fprot $SAN_CONF \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_kill_tnef = 1' \
    'file_list_2_policy  = unknown:drop:drop:defang' \
    'file_name_tpl = ./.tmp.$$$' \
    'feat_log_inline = 1' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
From bre  Fri May 17 19:33:45 2002
Return-Path: <bre@monique.frisk-software.com>
Received: (from bre@localhost)
	by monique.frisk-software.com (8.11.2/8.11.2) id g4HJXjK19121
	for bre@monique.frisk-software.com; Fri, 17 May 2002 19:33:45 GMT
Date: Fri, 17 May 2002 19:33:45 +0000
From: =?iso-8859-1?Q?Bjarni_R=FAnar_Einarsson?= <bre@monique.frisk-software.com>
To: =?iso-8859-1?Q?Bjarni_R=FAnar_Einarsson?= <bre@monique.frisk-software.com>
Subject: Foo!!!
Message-ID: <20020517193345.A14401@monique.frisk-software.com>
Mime-Version: 1.0
Content-Type: multipart/mixed; boundary="oyUTqETQ0mS9luUI"
Content-Disposition: inline
User-Agent: Mutt/1.2.5i
Status: RO
Content-Length: 7496
Lines: 113


--oyUTqETQ0mS9luUI
Content-Type: text/plain; charset=us-ascii
Content-Disposition: inline

ldkj

--oyUTqETQ0mS9luUI
Content-Type: application/ms-tnef
Content-Disposition: attachment; filename="winmail.dat"
Content-Transfer-Encoding: base64

$SKIPPED1
$SKIPPED2
$SKIPPED3
$SKIPPED4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--oyUTqETQ0mS9luUI--

EOF
