# Google API Client Library for Ruby Docs

The Google API Client Library for Ruby is designed for Ruby
client-application developers. It offers simple, flexible
access to many Google APIs.

## Features

- Call Google APIs simply
- Handle Auth with fewer lines of code
- Use standard tooling for installation

## Documentation

Learn how to use the Google API Client Library for Ruby with these guides:

### Usage Guides

- {file:docs/getting-started.md Getting Started}
- {file:docs/installation.md Installation}
- {file:docs/auth.md Auth}
  - {file:docs/api-keys.md API Keys}
  - {file:docs/oauth.md OAuth 2.0}
  - {file:docs/oauth-web.md OAuth 2.0 for Web Server Applications}
  - {file:docs/oauth-installed.md OAuth 2.0 for Installed Applications}
  - {file:docs/oauth-server.md OAuth 2.0 for Server to Server Applications}
  - {file:docs/client-secrets.md Client Secrets}
- How to...
  - {file:docs/logging.md Use Logging}
  - {file:docs/media-upload.md Upload Media}
  - {file:docs/pagination.md Use Pagination}
  - {file:docs/performance.md Improve Performance}

### Reference Documentation

- Reference documentation for [google-api-client](https://googleapis.dev/ruby/google-api-client/latest/index.html).
