<?php
class DownDetectorBridge extends BridgeAbstract {

	const MAINTAINER = 'teromene';
	const NAME = 'DownDetector Bridge';
	const URI = 'https://downdetector.com/';
	const DESCRIPTION = 'Returns most recent downtimes from DownDetector';
	const CACHE_TIMEOUT = 300; // 5 min

	const PARAMETERS = array(
		'All Websites' => array(
			'country' => array(
				'type' => 'list',
				'name' => 'Country',
				'values' => array(
					'Argentina' => 'https://downdetector.com.ar',
					'Australia' => 'https://downdetector.com.au',
					'België' => 'https://allestoringen.be',
					'Brasil' => 'https://downdetector.com.br',
					'Canada' => 'https://downdetector.ca',
					'Chile' => 'https://downdetector.cl',
					'Colombia' => 'https://downdetector.com.co',
					'Danmark' => 'https://downdetector.dk',
					'Deutschland' => 'https://allestörungen.de',
					'Ecuador' => 'https://downdetector.ec',
					'España' => 'https://downdetector.es',
					'France' => 'https://downdetector.fr',
					'Hong Kong' => 'https://downdetector.hk',
					'Hrvatska' => 'https://downdetector.hr',
					'India' => 'https://downdetector.in',
					'Indonesia' => 'https://downdetector.id',
					'Ireland' => 'https://downdetector.ie',
					'Italia' => 'https://downdetector.it',
					'Magyarország' => 'https://downdetector.hu',
					'Malaysia' => 'https://downdetector.my',
					'México' => 'https://downdetector.mx',
					'Nederland' => 'https://allestoringen.nl',
					'New Zealand' => 'https://downdetector.co.nz',
					'Norge' => 'https://downdetector.no',
					'Pakistan' => 'https://downdetector.pk',
					'Perú' => 'https://downdetector.pe',
					'Pilipinas' => 'https://downdetector.ph',
					'Polska' => 'https://downdetector.pl',
					'Portugal' => 'https://downdetector.pt',
					'România' => 'https://downdetector.ro',
					'Schweiz' => 'https://allestörungen.ch',
					'Singapore' => 'https://downdetector.sg',
					'Slovensko' => 'https://downdetector.sk',
					'South Africa' => 'https://downdetector.co.za',
					'Suomi' => 'https://downdetector.fi',
					'Sverige' => 'https://downdetector.se',
					'Türkiye' => 'https://downdetector.web.tr',
					'UAE' => 'https://downdetector.ae',
					'UK' => 'https://downdetector.co.uk',
					'United States' => 'https://downdetector.com',
					'Österreich' => 'https://allestörungen.at',
					'Česko' => 'https://downdetector.cz',
					'Ελλάς' => 'https://downdetector.gr',
					'Россия' => 'https://downdetector.ru',
					'日本' => 'https://downdetector.jp'
				)
			)
		),
		'Specific Website' => array(
			'website' => array(
				'type' => 'list',
				'name' => 'Website',
				'values' => array(
					'Österreich' => array(
						'1&1' => 35086,
						'3 (Drei)' => 33546,
						'A1' => 33543,
						'Alexa' => 36919,
						'Amazon' => 33506,
						'Amazon Prime Video' => 35085,
						'Amino Apps' => 39034,
						'Anthem' => 38200,
						'Apex Legends' => 38117,
						'App Store' => 35584,
						'Bank Austria' => 34715,
						'Battlefield' => 38051,
						'BAWAG' => 34716,
						'Binance' => 36938,
						'Blizzard Battle.net' => 35087,
						'Bob' => 34953,
						'Boom Beach' => 34781,
						'Bwin' => 35071,
						'Call of Duty' => 34156,
						'Car2Go' => 34554,
						'Clash of Clans' => 35088,
						'Clash Royale' => 38357,
						'Coinbase' => 36804,
						'Counter-strike' => 35055,
						'Crunchyroll' => 38092,
						'Dazn' => 36508,
						'Dead By Daylight' => 37414,
						'Deezer' => 33832,
						'Destiny' => 34954,
						'DHL' => 36747,
						'Discord' => 36768,
						'Dota 2' => 35398,
						'Dropbox' => 33509,
						'EA' => 34502,
						'Easybank' => 36992,
						'eBay' => 33510,
						'Emerion' => 34613,
						'Epic Games Store' => 39021,
						'Erste Bank und Sparkasse' => 36724,
						'Facebook' => 33511,
						'Facebook Messenger' => 33512,
						'Fifa' => 37605,
						'Flickr' => 33513,
						'For Honor' => 35996,
						'Fortnite' => 36689,
						'Ghost Recon' => 36009,
						'Gmail' => 33514,
						'GMX' => 33515,
						'Google' => 33516,
						'Google Hangouts' => 33517,
						'Google Play' => 33518,
						'GTA 5' => 35082,
						'Guild Wars 2' => 36473,
						'Handy Parken' => 34316,
						'Hay Day' => 34854,
						'Hello Bank' => 37010,
						'HoT' => 38751,
						'iCloud' => 35501,
						'ICQ' => 33520,
						'ING DiBa' => 35129,
						'Instagram' => 33522,
						'iTunes' => 33523,
						'Kabelplus' => 34473,
						'Kik' => 33524,
						'Kraken' => 36770,
						'League of Legends' => 34350,
						'LinkedIn' => 33525,
						'Liwest' => 34471,
						'Lovoo' => 35079,
						'Magenta' => 38440,
						'Maxdome' => 35084,
						'Minecraft' => 36432,
						'Mittwald' => 36987,
						'N26' => 38834,
						'Netatmo' => 37956,
						'Netflix' => 34631,
						'Nintendo Network' => 35523,
						'Nitrado' => 35548,
						'NordVPN' => 38587,
						'Office 365' => 35120,
						'OneDrive' => 35412,
						'ORF' => 35600,
						'Origin' => 36889,
						'Outlook' => 35083,
						'Overwatch' => 36153,
						'Path of Exile' => 37730,
						'Paypal' => 35399,
						'Playerunknown\'s Battlegrounds' => 36488,
						'Playstation Network' => 33526,
						'Pokémon Go' => 35745,
						'Quizduell' => 34528,
						'Raiffeisen Bank' => 38750,
						'Rainbow Six' => 35563,
						'Red Dead Redemption' => 37739,
						'Reddit' => 36827,
						'Rocket League' => 35485,
						'roNET' => 37041,
						'Salzburg AG Cablelink' => 35601,
						'Shpock' => 38681,
						'Sky' => 35081,
						'Sky Ticket' => 35142,
						'Skype' => 33527,
						'Smart Hub' => 35400,
						'Snapchat' => 33528,
						'Spotify' => 33529,
						'Spusu' => 35598,
						'Steam' => 34117,
						'Teamviewer' => 35686,
						'Tele2' => 34339,
						'Telegram' => 34903,
						'Telering' => 34952,
						'The Division' => 35599,
						'The elder scrolls online' => 37160,
						'The Simpsons Tapped Out' => 37283,
						'Threema' => 34255,
						'Tinder' => 34243,
						'Tipico' => 36515,
						'Tumblr' => 33530,
						'Twitch' => 35024,
						'Twitter' => 33531,
						'Uplay PC' => 34689,
						'Viber' => 33532,
						'Viewster' => 34326,
						'Vimeo' => 33533,
						'Volksbank' => 34717,
						'Warface' => 37524,
						'Warframe' => 37136,
						'Waze' => 33534,
						'Whatsapp' => 33535,
						'Wikipedia' => 33536,
						'Willhaben.at' => 35859,
						'World of Tanks' => 36674,
						'World of Warcraft' => 36998,
						'World of Warships' => 38009,
						'Xbox Live' => 33538,
						'Yahoo Mail' => 33539,
						'Yahoo Messenger' => 33540,
						'Yesss' => 35346,
						'Youtube' => 33541,
						'Z1 Battle Royale' => 35489,
					),
					'Deutschland' => array(
						'1&1' => 32554,
						'1blu' => 37319,
						'2k' => 37731,
						'3CX' => 36439,
						'3sat' => 35797,
						'Afterbuy' => 37015,
						'Airbnb' => 35422,
						'Albion Online' => 38799,
						'Aldi Talk' => 32579,
						'Alexa' => 35912,
						'All-inkl' => 35162,
						'Amazon' => 32572,
						'Amazon Prime Music' => 37584,
						'Amazon Prime Video' => 34495,
						'Amazon Web Services' => 36326,
						'Amino Apps' => 39033,
						'Amplus' => 35446,
						'Anthem' => 38055,
						'Anydesk' => 37487,
						'AOL' => 34377,
						'Apex Legends' => 38112,
						'App Store' => 35579,
						'Apple Music' => 35246,
						'Apple Store' => 34448,
						'Arche NetVision' => 35593,
						'ArcheAge' => 35062,
						'Arcor' => 34374,
						'ARK: Survival Evolved' => 39065,
						'Arma 3' => 35063,
						'Asana' => 38024,
						'Assassin\'s Creed' => 35010,
						'Badoo' => 35011,
						'Base' => 32568,
						'Battlefield' => 36092,
						'Baur' => 35043,
						'Bet3000' => 35035,
						'Bet365' => 35034,
						'Bethesda' => 38317,
						'BILDmobil' => 32609,
						'Binance' => 36942,
						'Bing' => 34708,
						'Bitfinex' => 36833,
						'Bitstamp' => 36808,
						'Blackberry' => 3,
						'Blade &Soul' => 35512,
						'Blau' => 37655,
						'Blau' => 34108,
						'Blizzard Battle.net' => 34483,
						'Blogger' => 32606,
						'BMW ConnectedDrive' => 38034,
						'Boom Beach' => 34365,
						'Bornet' => 34944,
						'Bwin' => 34491,
						'Call of Duty' => 34155,
						'Candy Crush' => 35148,
						'Candy Crush Soda Saga' => 35174,
						'Car-Net' => 37031,
						'Car2Go' => 34555,
						'Centurylink' => 35624,
						'Checkdomain' => 36096,
						'Clash of Clans' => 34289,
						'Clash Royale' => 35588,
						'Cloudflare' => 34881,
						'Coinbase' => 36798,
						'Colt' => 37653,
						'Comdirect' => 34774,
						'Comedy Central' => 34122,
						'Commerzbank' => 32607,
						'Comunio' => 34719,
						'Congstar' => 32590,
						'Consors Bank' => 35545,
						'CosmosDirect' => 35042,
						'Counter-strike' => 34887,
						'Crunchyroll' => 36718,
						'DABbank' => 35921,
						'Das Erste' => 34386,
						'Dazn' => 35956,
						'Dead By Daylight' => 35951,
						'Deezer' => 33831,
						'DeGiro' => 38203,
						'Deliveroo' => 37546,
						'Destiny' => 34895,
						'Deutsche Bahn' => 32569,
						'Deutsche Bank' => 32611,
						'Deutsche Glasfaser' => 36087,
						'Deutsche Telefon' => 35851,
						'DeutschlandSIM' => 34635,
						'DFP' => 35004,
						'DHL' => 34896,
						'Discord' => 35796,
						'DKB' => 32767,
						'DNSNET' => 35670,
						'DomainFactory' => 37381,
						'Dota 2' => 34900,
						'dpd' => 36120,
						'Dragon Ball' => 36380,
						'Drillisch' => 36019,
						'Driveclub' => 34928,
						'Dropbox' => 32585,
						'E-Plus' => 10121,
						'EA' => 34497,
						'Easybell' => 34370,
						'eBay' => 32567,
						'Ecotel' => 36794,
						'Elite: Dangerous' => 37077,
						'Emailn' => 34687,
						'Emerion' => 34614,
						'Entega' => 37039,
						'Epic Games Store' => 38827,
						'Escape from Tarkov' => 37977,
						'Etoro' => 36965,
						'Eurosport Player' => 36559,
						'Eventim' => 37621,
						'Evernote ' => 36506,
						'Ewe TEL' => 33559,
						'Facebook' => 32552,
						'Facebook Messenger' => 32560,
						'Faceit' => 37147,
						'Facetime' => 34603,
						'Fallout' => 35433,
						'Farm Heroes Saga' => 35175,
						'Fidor Bank' => 35894,
						'Fifa' => 35469,
						'Finya' => 37060,
						'Fitbit' => 37972,
						'Fl!nk' => 35170,
						'Flickr' => 32604,
						'Fonic' => 32594,
						'For Honor' => 35985,
						'Fortnite' => 36626,
						'Forza' => 37568,
						'Freenet' => 34354,
						'Friday the 13th The Game' => 37561,
						'Fyve' => 34378,
						'G-Portal' => 37155,
						'Game of war' => 35230,
						'Gameduell' => 37566,
						'Gardena Smart' => 37350,
						'Garmin' => 37049,
						'Gears of War' => 35940,
						'Gems of war' => 38802,
						'Geocaching' => 37178,
						'Ghost Recon' => 36001,
						'Giropay' => 38204,
						'GitHub' => 35348,
						'GLS' => 36119,
						'Gmail' => 32584,
						'GMX' => 32563,
						'Go Daddy' => 34874,
						'Goneo' => 37576,
						'Google' => 32553,
						'Google Drive' => 36603,
						'Google Hangouts' => 32600,
						'Google Kalender' => 38603,
						'Google Play' => 32593,
						'Gran Turismo' => 36917,
						'Grindr' => 35532,
						'GTA 5' => 34754,
						'Guild Wars 2' => 35061,
						'Halo' => 35419,
						'Halo Wars' => 36034,
						'Harry Potter: Wizards Unite' => 38686,
						'Hay Day' => 34366,
						'Helinet' => 34959,
						'Hermes' => 35196,
						'Hetzner ' => 35943,
						'Hipchat' => 34869,
						'Hitbox.TV' => 35932,
						'Hitman' => 35586,
						'Homematic' => 36795,
						'Hosteurope' => 37958,
						'Htp' => 34400,
						'Hue' => 37810,
						'Hunt: Showdown' => 38787,
						'HypoVereinsbank' => 34965,
						'iCloud' => 32549,
						'ICQ' => 33123,
						'Idealo' => 37156,
						'iMessage' => 32671,
						'Inexio' => 36371,
						'ING DiBa' => 35156,
						'Ingress' => 35765,
						'Innogy Highspeed' => 37459,
						'Instagram' => 32599,
						'Intercity Express (ICE)' => 32581,
						'iTunes' => 32672,
						'Jappy' => 32596,
						'Jira' => 36066,
						'Jobst DSL' => 36727,
						'Jodel' => 36793,
						'Joyn' => 38604,
						'Jurassic World Alive' => 37310,
						'K-Classic Mobil' => 33986,
						'Kabel eins‎' => 34392,
						'Kickbase' => 37451,
						'Kicker' => 37450,
						'Kicktipp' => 35824,
						'Kik' => 33353,
						'Klarmobil' => 32605,
						'KMS' => 34399,
						'Knuddels' => 35865,
						'Kraken' => 36749,
						'Ladbrokes' => 35161,
						'LastPass' => 34780,
						'League of Legends' => 34112,
						'Lebara' => 35791,
						'Line' => 34300,
						'LinkedIn' => 32557,
						'Lotto24' => 35040,
						'Lottohelden' => 36882,
						'Lovoo' => 34814,
						'Lufthansa' => 32574,
						'Lycamobile' => 34939,
						'M-net' => 32571,
						'Madden' => 38906,
						'Mail.de' => 34909,
						'Mailbox' => 34832,
						'Markt.de' => 37465,
						'Maxdome' => 34749,
						'MDCC' => 34760,
						'MDDSL' => 37056,
						'Mercedes Me' => 37153,
						'MiCoach' => 34936,
						'Microsoft Azure' => 36093,
						'Microsoft Teams' => 38185,
						'Minecraft' => 32556,
						'Mittwald' => 33412,
						'Mixer' => 38770,
						'Mobilcom Debitel' => 32610,
						'MTV' => 34120,
						'My Fitness Pal' => 37637,
						'Mybet' => 35036,
						'N26' => 35719,
						'NBA 2k' => 38595,
						'Need for Speed' => 35429,
						'Netatmo' => 37452,
						'Netbeat' => 35906,
						'NetCologne' => 32587,
						'netcombw' => 35638,
						'netcup' => 35632,
						'Netflix' => 34630,
						'Netkom' => 37201,
						'Neverwinter' => 35768,
						'Nfon' => 35792,
						'Nintendo Network' => 35519,
						'Nintendo Switch Online' => 37244,
						'Nitrado' => 34941,
						'No Man\'s Sky' => 35794,
						'NordVPN' => 38584,
						'Norisbank' => 34964,
						'Nvidia' => 37462,
						'Nvidia' => 39069,
						'O2' => 10122,
						'Office 365' => 34730,
						'OkCupid' => 37330,
						'OLB' => 37057,
						'OneDrive' => 35408,
						'Onleihe' => 35635,
						'Origin' => 34371,
						'Osnatel' => 33873,
						'Otelo' => 35480,
						'Otto' => 32598,
						'Outlook' => 32546,
						'Overwatch' => 35684,
						'Paladins' => 35925,
						'Path of Exile' => 36479,
						'Payback' => 37654,
						'Paypal' => 34375,
						'pcvisit' => 37643,
						'PES' => 37952,
						'Pet Rescue Saga' => 35176,
						'Pinterest' => 37585,
						'Placetel' => 35128,
						'Playerunknown\'s Battlegrounds' => 36332,
						'Playstation Network' => 32551,
						'Pokémon Duel' => 35976,
						'Pokémon Go' => 35724,
						'Pokerstars' => 37439,
						'Postbank' => 32589,
						'Posteo' => 34309,
						'Primacom' => 33502,
						'ProSieben' => 34390,
						'PŸUR' => 32592,
						'QSC' => 33560,
						'Quizduell' => 34292,
						'Rainbow Six' => 35479,
						'Razer' => 38699,
						'Realm Royale' => 37288,
						'Red Dead Redemption' => 37601,
						'Reddit' => 35882,
						'RFT Kabel' => 35831,
						'Roblox' => 35815,
						'Rocket League' => 35252,
						'Royal Games' => 38217,
						'RTL II' => 34393,
						'RTL Television' => 34387,
						'Runescape' => 35108,
						'RWE' => 36116,
						'RWW' => 37955,
						'Ryanair' => 37518,
						'Salesforce' => 34733,
						'Santander Consumer Bank' => 32603,
						'Sat.1' => 34389,
						'Save.TV' => 37193,
						'Sea of Thieves' => 37112,
						'Shpock' => 37311,
						'Signal' => 37072,
						'Simply' => 36376,
						'Simquadrat' => 34945,
						'Simsme' => 34795,
						'Simyo' => 32591,
						'Sipgate' => 34127,
						'SKL' => 35041,
						'Sky' => 32562,
						'Sky Ticket' => 35141,
						'Skype' => 32561,
						'Skype for Business' => 35351,
						'Slack' => 35936,
						'Smart Hub' => 35181,
						'Smite' => 34803,
						'Snapchat' => 33377,
						'Soundcloud' => 34353,
						'Sparda' => 35370,
						'Sparkasse' => 32757,
						'Speedtest' => 38780,
						'Spiegel' => 36050,
						'Spotify' => 32564,
						'Star Citizen' => 39035,
						'Star Wars Battlefront' => 35460,
						'Steam' => 32559,
						'Strato' => 33413,
						'Strava' => 38731,
						'Streetspotr' => 34920,
						'Summoners War' => 37420,
						'SWB' => 34515,
						'Tado' => 36634,
						'Tango' => 33731,
						'Targobank' => 34966,
						'Teamspeak' => 33346,
						'Teamviewer' => 34344,
						'Tele2' => 33503,
						'Tele5' => 35727,
						'Telegram' => 34229,
						'Telekom' => 10117,
						'Tellonym' => 37248,
						'The Crew 2' => 37252,
						'The Division' => 35570,
						'The elder scrolls online' => 34480,
						'The Simpsons Tapped Out' => 34701,
						'Threema' => 34253,
						'Tiktok' => 39044,
						'Tinder' => 34242,
						'Tipico' => 34714,
						'TNG' => 38772,
						'Todoist' => 36462,
						'TomTom' => 35813,
						'Tumblr' => 32588,
						'TuneIn' => 38763,
						'TV Now' => 35143,
						'Tweakbox' => 38349,
						'Twitch' => 34376,
						'Twitter' => 32583,
						'Udemy' => 38388,
						'Unitymedia' => 32548,
						'Uplay PC' => 34380,
						'Usenext' => 36117,
						'Vero' => 37064,
						'Versatel' => 33561,
						'Viber' => 33372,
						'Viewster' => 34324,
						'Vimeo' => 32582,
						'Visa' => 37238,
						'VIVA' => 34121,
						'Vodafone' => 10120,
						'Volksbanken und Raiffeisenbanken' => 32758,
						'VOX' => 34391,
						'Warface' => 35944,
						'Warframe' => 36366,
						'Watchbox' => 36537,
						'Wattpad' => 34700,
						'Waze' => 33411,
						'Web.de' => 32586,
						'WeChat' => 34301,
						'Weebly' => 34914,
						'Weight Watchers' => 35662,
						'WeTransfer' => 36433,
						'Wetter.com' => 36051,
						'WetterOnline' => 34810,
						'Whatsapp' => 32555,
						'Wikipedia' => 32565,
						'Wilhelm.tel' => 34398,
						'Wish' => 38153,
						'WiSoTEL' => 37543,
						'Wobcom' => 35991,
						'Wordpress' => 32570,
						'World of Tanks' => 35524,
						'World of Warcraft' => 34373,
						'World of Warships' => 36638,
						'Wüstenrot' => 36977,
						'Xbox Live' => 32573,
						'Xing' => 34822,
						'Yahoo Mail' => 32597,
						'Yahoo Messenger' => 32580,
						'Yourfone' => 33415,
						'Youtube' => 32578,
						'Youtube Music' => 37586,
						'Z1 Battle Royale' => 35147,
						'Zattoo' => 35367,
						'ZDF' => 34388,
						'Zynga' => 32608,
					),
					'Nederland' => array(
						'112' => 10011,
						'3FM' => 10174,
						'9292.nl' => 33376,
						'ABN-Amro' => 29,
						'ABP pensioenfonds' => 35862,
						'Adobe Creative Cloud' => 34916,
						'ADP' => 32669,
						'Adyen' => 37610,
						'Aegon Bank' => 10132,
						'Afas' => 10093,
						'Afterpay' => 34769,
						'Airbnb' => 35423,
						'Airmiles' => 37516,
						'Albert Heijn' => 34010,
						'Alex' => 10056,
						'Algemeen Dagblad' => 1,
						'AliExpress' => 37384,
						'Amazon' => 37379,
						'Amazon Prime Video' => 36976,
						'AMSIX' => 10008,
						'Antagonist' => 35160,
						'Anthem' => 38054,
						'Apex Legends' => 38118,
						'App Store' => 35580,
						'Apple Music' => 35245,
						'Apple Store' => 34446,
						'Argenta' => 10158,
						'Argeweb' => 35073,
						'Arriva' => 2,
						'ASN Bank' => 10048,
						'Assassin\'s Creed' => 35009,
						'Badoo' => 37650,
						'Battlefield' => 37094,
						'Belastingdienst' => 10002,
						'Ben' => 10053,
						'Bibliotheek' => 34132,
						'Binance' => 36879,
						'Binck' => 10055,
						'Bing' => 34707,
						'BlaBlaCar' => 36088,
						'Bliep' => 33998,
						'Blizzard Battle.net' => 34485,
						'Bol.com' => 10112,
						'Booking.com' => 37574,
						'Boom Beach' => 34363,
						'Brabant Water' => 10071,
						'Brawl Stars' => 38818,
						'Budgetphone' => 35132,
						'Buienalarm' => 37245,
						'Buienradar' => 33565,
						'Bunq' => 35820,
						'Byte' => 32764,
						'Caiway' => 4,
						'CAK' => 37289,
						'Call of Duty' => 34154,
						'CanalDigitaal' => 31,
						'Candy Crush' => 34025,
						'Cbizz' => 37659,
						'Centraal Beheer Achmea' => 10157,
						'Centraal Bureau voor de Statistiek' => 10168,
						'CheapConnect' => 36122,
						'Chelloo' => 35546,
						'Choozze' => 35096,
						'Clash of Clans' => 34290,
						'Clash Royale' => 37522,
						'Cloudflare' => 38623,
						'Cloudhosting.nl' => 33486,
						'Coinbase' => 36236,
						'Comedy Central' => 34033,
						'Concepts' => 10043,
						'Connexxion' => 5,
						'Coolblue' => 35543,
						'Counter-strike' => 36644,
						'Credit Europe Bank' => 10194,
						'Crunchyroll' => 36722,
						'Dead By Daylight' => 37412,
						'Deezer' => 33769,
						'DeGiro' => 34019,
						'Delight Mobile' => 33987,
						'Delta' => 10123,
						'Destiny' => 34891,
						'Deutsche Bank' => 10119,
						'DFP' => 35003,
						'DHL' => 35223,
						'DigiD' => 10001,
						'Digipoort' => 34520,
						'Discord' => 36043,
						'Disney+' => 38319,
						'Dota 2' => 36397,
						'Dpd' => 35619,
						'Dropbox' => 10192,
						'Dumpert' => 33375,
						'Dunea' => 10074,
						'EA' => 34501,
						'Easynet' => 33997,
						'eBay' => 33857,
						'Elite: Dangerous' => 37777,
						'Enduris' => 35999,
						'Eneco' => 10124,
						'Energielabel voor Woningen' => 35117,
						'Enexis' => 10014,
						'Ennatuurlijk' => 35159,
						'Epic Games Store' => 39020,
						'Escape from Tarkov' => 39059,
						'Esprit Telecom' => 10150,
						'Essent' => 10114,
						'Etoro' => 36958,
						'Eurosport Player' => 35821,
						'Eventim' => 37622,
						'Evides' => 10072,
						'Eweka' => 10039,
						'Exact Online' => 34815,
						'Exchange Online' => 34728,
						'Facebook' => 6,
						'Facebook Messenger' => 10185,
						'Facetime' => 34607,
						'Fallout' => 35434,
						'FBTO' => 34015,
						'Feedly' => 34712,
						'Fiber' => 10103,
						'Fifa' => 35474,
						'Flickr' => 37948,
						'Flitsmeister' => 34369,
						'For Honor' => 35987,
						'Fortnite' => 36625,
						'Fox Sports' => 10096,
						'Friday the 13th The Game' => 37560,
						'Funda' => 32576,
						'Game of war' => 35231,
						'Garmin' => 38165,
						'Garmin Connect' => 38171,
						'Gatehub' => 36957,
						'Ghost Recon' => 36010,
						'GitHub' => 35347,
						'Glashart Media' => 10105,
						'GLS' => 36118,
						'Gmail' => 10041,
						'Google' => 10010,
						'Google Agenda' => 38602,
						'Google Drive' => 34276,
						'Google Hangouts' => 10062,
						'Google Play' => 10038,
						'Gran Turismo' => 36873,
						'Greenchoice' => 37959,
						'Greenwheels' => 34007,
						'Grindr' => 35531,
						'GTA 5' => 34753,
						'Guild Wars 2' => 36464,
						'GVB' => 7,
						'Halo' => 35420,
						'Happn' => 37014,
						'Harry Potter: Wizards Unite' => 38689,
						'Hay Day' => 34368,
						'Hearthstone' => 38564,
						'Hollandsnieuwe' => 10040,
						'Hosted.nl' => 33483,
						'Hostnet' => 32761,
						'HTM' => 8,
						'Hue' => 37812,
						'iCloud' => 30,
						'iDeal' => 10025,
						'IEX' => 35782,
						'IG' => 34307,
						'iMessage' => 10130,
						'Indeed' => 35941,
						'Infopact' => 37565,
						'ING' => 9,
						'Instagram' => 32558,
						'International Card Services (ICS)' => 10169,
						'InterNLnet' => 34252,
						'Interpolis' => 34017,
						'ITDev Solutions' => 35533,
						'iTunes' => 10151,
						'Jira' => 36067,
						'Jonaz' => 37348,
						'Jumbo' => 36184,
						'Jurassic World Alive' => 37334,
						'JustEat' => 10164,
						'Kabel Noord' => 10113,
						'Kabeltex' => 10138,
						'Kadaster' => 37652,
						'Kamer van Koophandel' => 10167,
						'KickXL' => 10098,
						'Kik' => 10191,
						'Kliksafe' => 10109,
						'KLM' => 10028,
						'Knab' => 10131,
						'KNMI' => 34013,
						'KPN' => 11,
						'Kraken' => 36748,
						'Kruidvat' => 37312,
						'LastPass' => 34779,
						'League of Legends' => 35169,
						'LeasePlan Bank' => 10160,
						'Leaseweb' => 32762,
						'Lebara' => 10128,
						'Lexa.nl' => 35838,
						'Liander' => 10013,
						'Lijbrandt' => 10045,
						'LinkedIn' => 10201,
						'Litebit' => 36836,
						'Lloyds Bank' => 10154,
						'LOI' => 34947,
						'Lotto' => 34923,
						'Lycamobile' => 10129,
						'Lynx' => 10085,
						'Magister' => 35274,
						'Marktplaats' => 10170,
						'Microsoft Azure' => 36114,
						'Microsoft Teams' => 38186,
						'Mijnbroker' => 10088,
						'Mijndomein' => 34348,
						'MijnOverheid' => 10015,
						'Minecraft' => 36173,
						'Mobicross' => 34898,
						'Moneyou' => 10155,
						'Motto' => 35482,
						'MTV' => 34031,
						'Multisafepay' => 34877,
						'My Fitness Pal' => 37636,
						'MyOrder' => 34291,
						'Nationale Nederlanden' => 10166,
						'Nest' => 35189,
						'Net 5' => 10181,
						'Netatmo' => 37453,
						'Netflix' => 33849,
						'Neverwinter' => 36676,
						'NIBC Direct' => 10159,
						'Nintendo eShop' => 34105,
						'Nintendo Network' => 35520,
						'Nintendo Switch Online' => 37242,
						'Nitrado' => 35549,
						'NLE' => 37651,
						'NLziet' => 34219,
						'NordVPN' => 38585,
						'NOS.nl' => 10063,
						'NPO 1' => 10179,
						'NPO 2' => 10180,
						'NPO 3' => 10182,
						'NPO Start' => 10064,
						'NS' => 21,
						'Nu.nl' => 12,
						'Nuon' => 10084,
						'Oasen' => 10078,
						'Office 365' => 35119,
						'OHRA' => 34819,
						'ON' => 10097,
						'OneDrive' => 32779,
						'Online.nl' => 10193,
						'OnlineWerkplekken.nl' => 33485,
						'Onsbrabantnet' => 10044,
						'Origin' => 34372,
						'Outlook' => 10042,
						'OV-chipkaart' => 10145,
						'Overwatch' => 35723,
						'Paladins' => 37407,
						'Park Mobile' => 10139,
						'Park-line' => 10137,
						'Path of Exile' => 37729,
						'Pathé Thuis' => 33848,
						'Paypal' => 10021,
						'Paysafecard' => 10152,
						'PCextreme' => 32763,
						'Picnic' => 37503,
						'PIN' => 10009,
						'Player Unknown\'s Battlegrounds' => 36336,
						'Playstation Network' => 10006,
						'Plinq' => 10108,
						'Pokémon Go' => 35731,
						'Pokerstars' => 37438,
						'PostNL' => 32766,
						'PWN Waterleidingbedrijf Noord-Holland' => 10073,
						'Q-Park' => 10111,
						'Quizduel' => 34293,
						'Qurrent' => 35729,
						'Rabobank' => 13,
						'Radio 1' => 10175,
						'Radio 2' => 10176,
						'Raet' => 32670,
						'Rainbow Six' => 35564,
						'Realm Royale' => 37315,
						'Red Dead Redemption' => 38286,
						'Reddit' => 36822,
						'Redworks' => 34773,
						'Reggefiber' => 10104,
						'RegioBank' => 10050,
						'Rekam' => 10195,
						'Rendo Netwerken' => 10126,
						'RET' => 14,
						'Reviced' => 36061,
						'Robeco' => 10153,
						'Robin Mobile' => 35695,
						'Roblox' => 35814,
						'Rocket League' => 35254,
						'RoutIT' => 34349,
						'RTL 5' => 10183,
						'RTL 8' => 10184,
						'RTL XL' => 10066,
						'RTL4' => 10178,
						'Runescape' => 35701,
						'Ruzzle' => 33968,
						'Ryanair' => 37517,
						'Salesforce' => 10016,
						'SBS6' => 10177,
						'Schiphol' => 10027,
						'Scorito' => 34726,
						'Sea of Thieves' => 37113,
						'SEOshop' => 35592,
						'Sharepoint Online' => 34732,
						'Signal' => 37073,
						'Signet' => 34407,
						'Simpel' => 10037,
						'Simyo' => 10054,
						'Skype' => 10024,
						'Skype for Business' => 34729,
						'Slack' => 37336,
						'Smart Hub' => 35180,
						'Snapchat' => 10187,
						'Snappet' => 37613,
						'SNS' => 10019,
						'Sociale Verzekeringsbank (SVB)' => 10186,
						'Sofort Banking' => 10149,
						'Solcon' => 10099,
						'Soundcloud' => 34352,
						'Sparql' => 34519,
						'Speurders' => 34805,
						'Spotify' => 10003,
						'Staatsloterij' => 10094,
						'Star Wars Battlefront' => 36918,
						'Steam' => 34106,
						'Stedin' => 10012,
						'Steep' => 37823,
						'Stemwijzer' => 35980,
						'Stichting Kabeltelevisie Pijnacker' => 34143,
						'Stipte' => 10102,
						'Strato' => 35045,
						'Strava' => 36046,
						'Studiemeter' => 37075,
						'Studystore' => 36600,
						'Surfnet' => 34396,
						'T-Mobile' => 19,
						'Tado' => 36633,
						'Tango' => 33740,
						'Teamviewer' => 34342,
						'Tele2' => 16,
						'Telegraaf' => 17,
						'Telegram' => 34221,
						'Telfort' => 18,
						'The Division' => 35569,
						'The elder scrolls online' => 37329,
						'Threema' => 34254,
						'Thuisbezorgd.nl' => 10163,
						'Ticketmaster' => 10133,
						'Tickney ' => 35923,
						'Tikkie' => 36737,
						'Tiktok' => 39074,
						'Tinder' => 34238,
						'Today\'s' => 10087,
						'TomTom Live' => 34917,
						'Toto' => 35590,
						'TradersOnly' => 10090,
						'Transavia' => 35168,
						'TransIP' => 32771,
						'Trined' => 10107,
						'Triodos Bank' => 10051,
						'True' => 36576,
						'Tumblr' => 36714,
						'TuneIn' => 38762,
						'Tweak' => 10100,
						'Tweakbox' => 38348,
						'Tweakers' => 37376,
						'Twinfield' => 36725,
						'Twitch' => 35025,
						'Twitter' => 22,
						'Unet' => 34408,
						'Uplay PC' => 34379,
						'UWV en Werk.nl' => 10017,
						'Van Lanschot Bankiers' => 10052,
						'VDX' => 35780,
						'Vectone' => 35237,
						'Veolia' => 32612,
						'Veronica' => 34493,
						'Versio' => 32765,
						'VGZ' => 34946,
						'Viber' => 10172,
						'Videoland' => 33850,
						'Vimeo' => 38534,
						'Vimexx' => 35924,
						'VirtualComputing.nl' => 35698,
						'Vitens' => 10070,
						'Vodafone' => 24,
						'VoIPmobiel' => 34692,
						'Volgjezorg' => 37645,
						'VPSHosting.nl' => 33487,
						'VPSServer.nl' => 33484,
						'VVV Cadeaubon' => 35134,
						'Warface' => 38764,
						'Warframe' => 36490,
						'Waterbedrijf Groningen' => 10077,
						'Waterleiding Maatschappij Limburg' => 10076,
						'Waterleidingmaatschappij Drenthe' => 10079,
						'Waternet' => 10075,
						'Waze' => 33409,
						'Webex' => 34164,
						'Webreus' => 32778,
						'Weebly' => 34913,
						'Weeronline.nl' => 34014,
						'Weerplaza' => 35115,
						'Wehkamp' => 33980,
						'Westland Infra' => 10125,
						'WeTransfer' => 10190,
						'Whatsapp' => 10000,
						'Wikipedia' => 10092,
						'Wish' => 38152,
						'Wisper' => 10101,
						'Woningnet' => 36758,
						'Wordfeud' => 25,
						'WordOn' => 34036,
						'World of Tanks' => 35526,
						'World of Warcraft' => 34382,
						'World of Warships' => 38010,
						'Wrts' => 34215,
						'Xbox Live' => 10148,
						'XS4ALL' => 26,
						'XSyou' => 10106,
						'Yahoo Mail' => 34020,
						'Yellowbrick' => 10140,
						'Youfone' => 10144,
						'Yourhosting' => 34360,
						'YouTube' => 10005,
						'Z1 Battle Royale' => 35495,
						'Zalando' => 33981,
						'Ziggo' => 28,
						'Zilveren Kruis' => 34727,
						'Zwitserleven' => 34262,
					),
					'UK' => array(
						'123 Reg' => 35870,
						'1and1' => 34818,
						'2k' => 36427,
						'3 (Three)' => 32674,
						'4chan' => 38596,
						'Abebooks' => 36536,
						'Adobe Creative Cloud' => 34552,
						'Airbnb' => 35424,
						'Alexa' => 35911,
						'AliExpress' => 39062,
						'Amazon' => 32613,
						'Amazon Prime Music' => 36426,
						'Amazon Prime Video' => 34494,
						'Amazon Web Services' => 36327,
						'American Express' => 37398,
						'Amino Apps' => 38196,
						'Ancestry' => 38680,
						'Anthem' => 38053,
						'Anydesk' => 37489,
						'Apex Legends' => 38114,
						'App Store' => 35578,
						'Apple Music' => 35242,
						'Apple Store' => 34454,
						'Argos' => 34018,
						'ARK: Survival Evolved' => 36551,
						'Arlo' => 37076,
						'Asana' => 38023,
						'Asda' => 37979,
						'Ask4' => 34411,
						'Assassin\'s Creed' => 35006,
						'Autotrader' => 34793,
						'Badoo' => 37501,
						'Bank of Ireland UK' => 38228,
						'Bank of Scotland' => 32692,
						'Barclaycard' => 37762,
						'Barclays' => 32685,
						'Battlefield' => 36585,
						'Bet365' => 35030,
						'Betfair' => 35031,
						'Binance' => 36877,
						'Bing' => 33615,
						'Bitbucket' => 36683,
						'Black Desert Online' => 38492,
						'Blizzard Battle.net' => 34487,
						'Blogger' => 32617,
						'Booking.com' => 38703,
						'Boom Beach' => 34783,
						'Brawl Stars' => 38819,
						'British Airways' => 37644,
						'British Gas' => 35653,
						'BT' => 32673,
						'Bumble' => 36401,
						'Bwin' => 34490,
						'Cablecom' => 34413,
						'Cahoot' => 34826,
						'Call of Duty' => 34151,
						'Candy Crush' => 35094,
						'Capital One' => 37223,
						'Car-Net' => 37030,
						'Cdkeys' => 37575,
						'Centurylink' => 35625,
						'CEX' => 34897,
						'Channel 4' => 34948,
						'Chelsea Building Society' => 38223,
						'Clash of Clans' => 34444,
						'Clash Royale' => 36856,
						'Cloudflare' => 34880,
						'CMC Markets' => 37629,
						'Coinbase' => 36797,
						'Colt Group ' => 35961,
						'Conan Exiles' => 38392,
						'ConnectWise' => 38469,
						'Conventry Building Society' => 38225,
						'Counter-strike' => 35057,
						'Craigslist' => 32619,
						'Crunchyroll' => 36715,
						'Daisy' => 34410,
						'Danske Bank' => 38227,
						'Dark Souls' => 36953,
						'Dauntless' => 38541,
						'DayZ' => 38781,
						'Dazn' => 39010,
						'Dead By Daylight' => 36425,
						'Deezer' => 33829,
						'DeGiro' => 38202,
						'Deliveroo' => 37548,
						'Demon' => 34412,
						'Destiny' => 34893,
						'DeviantArt' => 38491,
						'DFP' => 34999,
						'Discord' => 36020,
						'Dota 2' => 35403,
						'Driveclub' => 34927,
						'Dropbox' => 32620,
						'EA' => 34506,
						'EA Sports UFC' => 38468,
						'Easynet' => 33881,
						'eBay' => 32621,
						'Eclipse' => 32680,
						'EE' => 32661,
						'Elite: Dangerous' => 36684,
						'Epic Games Store' => 38828,
						'Escape from Tarkov' => 38108,
						'Etoro' => 36959,
						'Etsy' => 36422,
						'Eurosport Player' => 35819,
						'Evernote' => 34705,
						'Exchange Online' => 34536,
						'Expedia' => 36421,
						'Experian' => 38156,
						'Exponential-E' => 34409,
						'Facebook' => 32622,
						'Facebook Messenger' => 32623,
						'Faceit' => 37145,
						'Facetime' => 34604,
						'Fallout' => 35431,
						'Fandom' => 38690,
						'Far Cry' => 37176,
						'Fasthosts' => 35705,
						'Fifa' => 35471,
						'Find my iPhone' => 36123,
						'First Direct' => 33978,
						'First Trust Bank' => 38226,
						'Fitbit' => 36630,
						'Flickr' => 32624,
						'Fling' => 35165,
						'For Honor' => 35988,
						'Fortnite' => 36624,
						'Forza' => 37569,
						'Freedompop' => 35639,
						'Freesat' => 37594,
						'Freeview' => 35771,
						'Friday the 13th The Game' => 37563,
						'Funimation' => 37745,
						'Game of war' => 35229,
						'Gamma' => 34899,
						'Garmin' => 36990,
						'Garmin Connect' => 37192,
						'Gears of War' => 35939,
						'Ghost Recon' => 36007,
						'Giffgaff' => 33985,
						'Gigler' => 35790,
						'GitHub' => 32625,
						'Glide' => 38901,
						'Gmail' => 32626,
						'Go Daddy' => 34873,
						'Google' => 32627,
						'Google Calendar' => 38598,
						'Google Cloud' => 38536,
						'Google Drive' => 34273,
						'Google Hangouts' => 32629,
						'Google Home' => 36138,
						'Google Play' => 32628,
						'GoToMeeting' => 36505,
						'Gran Turismo' => 36680,
						'Great Western Railway' => 37808,
						'Grindr' => 35530,
						'GTA 5' => 34752,
						'Guild Wars 2' => 36407,
						'Gumtree' => 32756,
						'Halifax' => 32689,
						'Halo' => 35451,
						'Harry Potter: Wizards Unite' => 38688,
						'Hay Day' => 34788,
						'Hayu' => 38052,
						'Heart Internet' => 37623,
						'Hearthstone' => 38563,
						'Hermes' => 34949,
						'Hipchat' => 34866,
						'Hitman' => 36880,
						'Hive' => 39072,
						'HMRC' => 36961,
						'Home telecom' => 35959,
						'Hootsuite' => 32630,
						'HQ Trivia' => 37161,
						'HSBC' => 32686,
						'Hue' => 37811,
						'Hunt: showdown' => 38823,
						'Hyperoptic' => 36520,
						'iCloud' => 32663,
						'IG' => 37630,
						'iMessage' => 32664,
						'Imgur' => 32632,
						'IMVU' => 37177,
						'Indeed' => 38589,
						'Instagram' => 32633,
						'Internet Movie Database (IMDb)' => 36752,
						'Iomart' => 37180,
						'iPlayer' => 32755,
						'iTunes' => 32665,
						'ITV' => 34302,
						'Janet' => 35452,
						'Jira' => 34871,
						'John Lewis' => 36782,
						'Jurassic World Alive' => 37332,
						'Just Eat' => 36031,
						'KC' => 34130,
						'Kik' => 33352,
						'Kraken' => 36751,
						'Ladbrokes' => 35033,
						'LastPass' => 34778,
						'League of Legends' => 35048,
						'LinkedIn' => 32634,
						'Litebit' => 36837,
						'Lloyds Bank' => 32691,
						'M&S Bank' => 35457,
						'M24Seven' => 37150,
						'Madden' => 38458,
						'Mail.com' => 34800,
						'Mailbox' => 34836,
						'Mailchimp' => 38728,
						'Manx Telecom' => 35534,
						'Mastercard' => 37250,
						'McDonalds app' => 37374,
						'Meetup' => 34246,
						'Metro Bank' => 34970,
						'Microsoft Azure' => 32651,
						'Microsoft Teams' => 38184,
						'Minecraft' => 32635,
						'Mixer' => 38768,
						'Monzo' => 37591,
						'Moonfruit' => 35456,
						'MTV' => 34124,
						'Musical.ly' => 37140,
						'My Fitness Pal' => 36956,
						'My Vue' => 36329,
						'Namesco Ltd' => 35900,
						'National Lottery' => 34950,
						'Nationwide' => 32690,
						'NatWest' => 32684,
						'NBA 2k' => 37721,
						'Nest' => 35192,
						'Netflix' => 32636,
						'Neverwinter' => 35767,
						'NikePlus' => 38783,
						'Nintendo eShop' => 34100,
						'Nintendo Network' => 35516,
						'Nintendo Switch Online' => 37241,
						'No Man\'s Sky' => 37405,
						'NordVPN' => 38248,
						'Now TV' => 34406,
						'Nvidia' => 39068,
						'O2' => 32660,
						'Office 365' => 34538,
						'OkCupid' => 37331,
						'Omegle' => 39043,
						'OneDrive' => 32781,
						'Online.net' => 36174,
						'ooVoo' => 36586,
						'Orange' => 32676,
						'Origin' => 36419,
						'Origin Broadband' => 36052,
						'Outlook' => 32631,
						'Overwatch' => 35681,
						'OVH' => 36160,
						'Paddy Power' => 35032,
						'Paladins' => 36377,
						'Path of Exile' => 36487,
						'Paypal' => 35557,
						'PES' => 38590,
						'Photobucket' => 32638,
						'Pinterest' => 32639,
						'Player Unknown\'s Battlegrounds' => 36335,
						'Playstation Network' => 32668,
						'PlentyOfFish' => 36023,
						'Plusnet' => 32683,
						'Pokémon Go' => 35730,
						'Pokerstars' => 37440,
						'Post Office' => 32682,
						'Project Online' => 34539,
						'ProtonMail' => 38963,
						'Quickbooks Online' => 36583,
						'Quizup' => 34298,
						'Rackspace' => 34610,
						'Rainbow Six' => 35476,
						'Rakuten TV' => 37597,
						'RBS (Royal Bank of Scotland)' => 32688,
						'Realm Royale' => 37309,
						'Red Dead Redemption' => 37743,
						'Redbox' => 38791,
						'Reddit' => 34844,
						'Relish' => 34797,
						'Revolut' => 37365,
						'Roblox' => 35786,
						'Rocket League' => 35355,
						'Royal Mail' => 35776,
						'Runescape' => 35107,
						'Ruzzle' => 34479,
						'Ryanair' => 36003,
						'Sagepay' => 36781,
						'Sainsbury\'s Bank' => 35116,
						'Salesforce' => 38495,
						'Santander' => 32687,
						'Sarahah' => 36373,
						'Scottish Power' => 36041,
						'Sea of Thieves' => 37110,
						'Sharepoint Online' => 34540,
						'Shopify' => 38538,
						'Shutterstock' => 37448,
						'Signal' => 37070,
						'Sky' => 32782,
						'Sky Bet' => 35076,
						'Skype' => 32640,
						'Skype for Business' => 34537,
						'Slack' => 35934,
						'Slideshare' => 32641,
						'Smart Hub' => 35179,
						'Smartsheet' => 38723,
						'Smile' => 36661,
						'Smite' => 35407,
						'Snapchat' => 32642,
						'Soundcloud' => 36954,
						'Sourceforge' => 32643,
						'South Western Railway' => 37809,
						'Spotify' => 32644,
						'Squarespace' => 38784,
						'SSE' => 37058,
						'Star Citizen' => 39036,
						'Star Wars Battlefront' => 35551,
						'Starling Bank' => 38719,
						'Steam' => 32667,
						'Steep' => 37822,
						'Strava' => 37046,
						'Streamcenter' => 37016,
						'Summoners War' => 37419,
						'T-Mobile' => 32679,
						'Tado' => 36632,
						'Talkmobile' => 33988,
						'TalkTalk' => 32677,
						'Tango' => 33739,
						'Teamviewer' => 34615,
						'Telegram' => 34222,
						'Tesco Bank' => 34969,
						'Tesco Broadband' => 34086,
						'Tesco Mobile' => 35149,
						'The Co-operative Bank' => 34971,
						'The Crew 2' => 36555,
						'The Division' => 35561,
						'The elder scrolls online' => 36400,
						'The People\'s Operator' => 35150,
						'The Simpsons Tapped out' => 35077,
						'Thinkmoney' => 36331,
						'Ticketmaster' => 36786,
						'Tiktok' => 38726,
						'Tinder' => 34240,
						'TomTom Live' => 34918,
						'Transferwise' => 38565,
						'Trove' => 38826,
						'TSB Bank' => 33970,
						'Tumblr' => 32645,
						'TuneIn' => 37973,
						'Tweakbox' => 38342,
						'Twitch' => 35022,
						'Twitter' => 32646,
						'Uber' => 37498,
						'Uber Eats' => 38271,
						'Udemy' => 37717,
						'UKfast' => 36838,
						'Ulster Bank' => 36071,
						'Unibet' => 36055,
						'Uplay PC' => 34691,
						'UPS' => 38744,
						'Viber' => 33349,
						'Vimeo' => 32647,
						'Virgin Media' => 32675,
						'Visa' => 37237,
						'Vistaprint' => 35130,
						'Vodafone' => 32659,
						'Waitrose' => 36964,
						'Warface' => 38766,
						'Warframe' => 36367,
						'Wattpad' => 34696,
						'Waze' => 33407,
						'Webex' => 34161,
						'Weebly' => 38547,
						'Weight Watchers' => 35663,
						'WeTransfer' => 32648,
						'Whatsapp' => 32649,
						'Whisper' => 37028,
						'Wikipedia' => 32650,
						'William Hill' => 35029,
						'Wish' => 39040,
						'Wix' => 37233,
						'Wordpress.com' => 32652,
						'World of Tanks' => 35525,
						'World of Warcraft' => 35052,
						'World of Warships' => 36639,
						'WWE Network' => 38085,
						'Xbox Live' => 32666,
						'Xero' => 37500,
						'XLN Telecom' => 33989,
						'Yahoo' => 32653,
						'Yahoo Mail' => 32654,
						'Yahoo Messenger' => 32655,
						'Yammer' => 36955,
						'Yelp' => 32656,
						'Yorkshire Bank' => 34968,
						'Yorkshire Building Society' => 38224,
						'Youtube' => 32657,
						'Youtube Music' => 37587,
						'Yubo' => 37246,
						'Z1 Battle Royale' => 35490,
						'Zen Internet' => 33874,
						'ZoHo' => 36039,
						'Zone Broadband' => 36994,
						'Zoom' => 37946,
						'Zynga' => 32658,
					),
					'United States' => array(
						'1and1' => 34817,
						'1Password' => 36441,
						'2600hertz' => 37692,
						'2k' => 34768,
						'4chan' => 37567,
						'7 Days to Die' => 35947,
						'8x8' => 34314,
						'ABC' => 38902,
						'Abebooks' => 36535,
						'Absolver' => 37366,
						'Access One' => 36063,
						'Acorns' => 37647,
						'Adams Networks' => 33556,
						'Adobe Connect' => 34134,
						'Adobe Creative Cloud' => 34551,
						'ADP' => 37657,
						'ADT' => 38502,
						'Adyen' => 37611,
						'Agar.io' => 38216,
						'Aio Wireless' => 34098,
						'Air Canada' => 20003,
						'Airbnb' => 34335,
						'AireSpring' => 35893,
						'Airnow.gov' => 37658,
						'Akamai' => 35447,
						'Alaska Airlines' => 20004,
						'Alaska Communications' => 36040,
						'Albion Online' => 38795,
						'Alexa' => 35910,
						'AliExpress' => 37395,
						'Allegiant Air' => 20005,
						'Ally' => 34791,
						'Amazon' => 20006,
						'Amazon Prime Music' => 34710,
						'Amazon Prime Video' => 33370,
						'Amazon Web Services' => 10147,
						'American Airlines' => 20007,
						'American Express' => 35958,
						'American Messaging' => 34128,
						'Amino Apps' => 37290,
						'Ammyy' => 36575,
						'Amtrak' => 20008,
						'Ancestry' => 38296,
						'Anno 1800' => 38413,
						'Anthem' => 37746,
						'Antietam' => 37051,
						'Anydesk' => 37406,
						'AOL' => 33419,
						'Apex Legends' => 38111,
						'App Store' => 35575,
						'Apple Maps' => 36125,
						'Apple Music' => 35241,
						'Apple News' => 36126,
						'Apple Store' => 34447,
						'Apple TV' => 36058,
						'Apple TV+' => 38318,
						'Appriver' => 37074,
						'AppValley' => 37749,
						'Arbuckle' => 34489,
						'ArcheAge' => 34876,
						'ARK: Survival Evolved' => 36350,
						'Arlo' => 36779,
						'Armstrong' => 34027,
						'Arvest Bank' => 37148,
						'Arvig' => 34919,
						'Asana' => 35828,
						'Assassin\'s Creed' => 35005,
						'AT&T' => 20010,
						'Atlantic Broadband' => 33437,
						'Authorize.net' => 34821,
						'Autotask' => 37579,
						'BabyTEL' => 35631,
						'Backblaze' => 35483,
						'Badoo' => 35993,
						'Bandwidth' => 35667,
						'Bank of America' => 20011,
						'Barclays' => 37639,
						'BART' => 20012,
						'Batman The Telltale Series' => 35896,
						'Battalion 1944' => 37002,
						'Battleborn' => 35718,
						'Battlefield' => 36091,
						'Battlerite' => 36820,
						'BB&T' => 35658,
						'Beats Music' => 34294,
						'beIN' => 37355,
						'Bejeweled' => 35904,
						'Bendbroad' => 34884,
						'Best Buy' => 34329,
						'BET' => 34125,
						'Bethesda' => 38316,
						'Binance' => 36818,
						'Bing' => 20014,
						'Birch Communications' => 33549,
						'Bitbucket' => 35414,
						'Bitfinex' => 36787,
						'Bitflyer' => 36789,
						'Bitstamp' => 34023,
						'Bittrex' => 36788,
						'Black Desert Online' => 37108,
						'BlackBerry' => 20015,
						'Blade and Soul' => 35511,
						'Blizzard Battle.net' => 34486,
						'Blogger' => 20016,
						'Blue Jay Wireless' => 35464,
						'Bluebird' => 37362,
						'Bluehost' => 33418,
						'BlueJeans' => 37509,
						'BMW ConnectedDrive' => 38471,
						'BNY Mellon' => 35674,
						'Boingo' => 37377,
						'Booking.com' => 34330,
						'Boom Beach' => 34364,
						'Box' => 32775,
						'Brawl Stars' => 38312,
						'BT' => 38338,
						'Buckeye Cablesystem' => 34029,
						'Buffer' => 36013,
						'Bullet Force' => 37109,
						'Bumble' => 35823,
						'C Spire' => 38219,
						'Cable One' => 20019,
						'Call of Duty' => 34148,
						'CallTower' => 35365,
						'Caltrain' => 20021,
						'Candy Crush' => 34024,
						'Candy Crush Soda Saga' => 35171,
						'Canva' => 36778,
						'Capital One' => 20022,
						'Cash App' => 38685,
						'CBSSports' => 35826,
						'Century National Bank' => 37690,
						'CenturyLink' => 20023,
						'Change.org' => 35616,
						'Charles Schwab' => 20078,
						'Chase' => 20025,
						'Chegg' => 36054,
						'Chicago Transit Authority' => 20026,
						'Chime' => 39050,
						'Chrome Web Store' => 34116,
						'Cincinnati Bell' => 33422,
						'Cirra Networks' => 36357,
						'Citi' => 20027,
						'Citizens Bank' => 37748,
						'Civilization' => 35869,
						'Clash of Clans' => 33550,
						'Clash Royale' => 35587,
						'Classlink' => 36821,
						'Clear' => 33423,
						'Cloudflare' => 32542,
						'Cloudsmith' => 35946,
						'Cloudtrax' => 37528,
						'CNET' => 33341,
						'CNN' => 34141,
						'Cogent' => 34026,
						'Coinbase' => 36175,
						'Comcast' => 20029,
						'Comedy Central' => 34126,
						'Common App' => 36726,
						'Comporium' => 36032,
						'Conan Exiles' => 37195,
						'Concur' => 36730,
						'Confluence' => 37540,
						'ConnectWise' => 37493,
						'Consolidated' => 34030,
						'Consolidated Edison' => 35679,
						'Consumer Cellular' => 37761,
						'Copy.com' => 34231,
						'Coredial' => 35454,
						'Costco' => 37061,
						'Counter-strike' => 34886,
						'Cox' => 20030,
						'Crackle' => 35349,
						'Craigslist' => 20031,
						'Credit One Bank' => 37760,
						'Cricket Wireless' => 20032,
						'Crown Castle' => 35812,
						'Crunchyroll' => 35114,
						'Cryptopia' => 36973,
						'Dailymotion' => 37598,
						'Dark Souls.' => 35710,
						'Dauntless' => 37204,
						'DayZ' => 37751,
						'Dazn' => 37497,
						'DC Universe Online' => 37059,
						'Dead By Daylight' => 35760,
						'Deezer' => 36424,
						'Defiance 2050' => 37364,
						'Delta Air Lines' => 20033,
						'Destiny' => 34761,
						'DeviantArt' => 34888,
						'Di.fm' => 35645,
						'Diablo' => 34385,
						'DirecTV' => 20034,
						'Directv Now' => 35933,
						'Discord' => 35795,
						'Dish Network' => 20035,
						'Disney World' => 35837,
						'Disney+' => 38800,
						'Disqus' => 34145,
						'Diversity Lottery' => 38472,
						'Dlive' => 38470,
						'Docker' => 37817,
						'Doom' => 35717,
						'Doordash' => 37581,
						'Dota 2' => 34304,
						'Doublelist' => 37580,
						'Downforeveryoneorjustme' => 34758,
						'Draftkings' => 37036,
						'Dragon Ball' => 35858,
						'Dramafever' => 36064,
						'DreamHost' => 35926,
						'Driveclub' => 35891,
						'Dropbox' => 20036,
						'Duckduckgo' => 35650,
						'Duke Energy' => 35871,
						'Duolingo' => 35942,
						'Dyl' => 37383,
						'Dyn' => 35707,
						'E-Trade' => 20037,
						'EA' => 34499,
						'EA Sports UFC' => 35715,
						'Eagle Communications ' => 36027,
						'Earthlink' => 32776,
						'Eatel' => 35448,
						'eBay' => 20038,
						'Ecobee' => 37163,
						'eFax' => 38664,
						'Electric Power Board' => 35778,
						'Elite: Dangerous' => 36478,
						'Ello' => 34906,
						'Endicia' => 36839,
						'Engine Yard' => 33966,
						'eNom' => 35901,
						'EPB Chattanooga' => 35513,
						'Epic Games Store' => 37756,
						'Escape from Tarkov' => 37424,
						'ESPN' => 33335,
						'ESPN Plus' => 38320,
						'Etherdelta' => 36858,
						'Etsy' => 33366,
						'Eve Online' => 35721,
						'Eve Valkyrie' => 35884,
						'Evernote' => 34706,
						'Everquest' => 38337,
						'Exchange Online' => 34534,
						'Exede' => 33557,
						'Expedia' => 34332,
						'Experian' => 38155,
						'ExpressVPN' => 37544,
						'Faceapp' => 38695,
						'Facebook' => 10198,
						'Facebook Messenger' => 20039,
						'Faceit' => 38543,
						'Facetime' => 34606,
						'FAFSA' => 37691,
						'FairPoint' => 33994,
						'Fallout' => 35430,
						'Family Search' => 33439,
						'Fandango' => 34481,
						'Fandom' => 34317,
						'Fanduel' => 37035,
						'Fanfiction' => 37101,
						'Far Cry' => 35713,
						'FastMail' => 35779,
						'Fatcow' => 34882,
						'Fax2mail' => 38665,
						'FedEx' => 35843,
						'Feedly' => 34704,
						'Fidelity' => 36738,
						'Fifa' => 35470,
						'Final Fantasy' => 35860,
						'Find my iPhone' => 38662,
						'First Communications ' => 36062,
						'FirstEnergy' => 35994,
						'FirstLight' => 34879,
						'Fitbit' => 35800,
						'Fite' => 38794,
						'Fiverr' => 37054,
						'Flickr' => 20040,
						'Fling' => 37353,
						'Flipboard' => 33491,
						'Florida Power & Light' => 35699,
						'Fonality' => 34312,
						'For Honor' => 35984,
						'Forge Of Empires' => 35886,
						'Fortnite' => 36375,
						'Forza' => 36817,
						'Fox News' => 35880,
						'Fox Sports Go' => 37164,
						'Frankfort PlantBoard' => 35466,
						'Freedompop' => 35657,
						'Freepik' => 36739,
						'Friday the 13th The Game' => 36348,
						'Frii' => 35668,
						'Frontier' => 20041,
						'Frontier Airlines' => 20042,
						'FuboTV' => 36658,
						'Funimation' => 36665,
						'Fuze' => 35847,
						'FXNOW' => 37504,
						'G-Portal' => 37154,
						'G2A.com' => 35898,
						'Game of Thrones Conquest' => 37669,
						'Game of war' => 35228,
						'Gamebattles' => 37753,
						'Gameloft' => 35964,
						'Gamestop' => 36780,
						'Gang Beasts' => 36926,
						'Garmin' => 35554,
						'Garmin Connect' => 35801,
						'Gatehub' => 36841,
						'GCI' => 35633,
						'GDAX' => 36791,
						'Gears of War' => 35848,
						'Geeking' => 37251,
						'Gemini' => 36811,
						'Gems of war' => 38801,
						'Geocaching' => 35770,
						'Gfycat' => 38504,
						'Ghost' => 38720,
						'Ghost Recon' => 36000,
						'Ghosttunes' => 34883,
						'GitHub' => 10004,
						'Gitlab' => 37146,
						'Glassdoor' => 35740,
						'Glide' => 34016,
						'Glitch' => 38721,
						'Gmail' => 20043,
						'Go Daddy' => 33416,
						'GOG.com' => 34287,
						'Google' => 10200,
						'Google Calendar' => 38597,
						'Google Cloud' => 37380,
						'Google Drive' => 34271,
						'Google Fiber' => 33421,
						'Google Hangouts' => 20046,
						'Google Home' => 36137,
						'Google Play' => 20045,
						'GoToMeeting' => 33489,
						'Gran Turismo' => 36347,
						'Grande' => 34404,
						'Greenlight' => 37628,
						'Grindr' => 35529,
						'Groove Music' => 33972,
						'Groupme' => 35739,
						'Groupon' => 35709,
						'Growtopia' => 36835,
						'Grubhub' => 37693,
						'GTA 5' => 33995,
						'Guild Wars 2' => 35060,
						'H&R Block' => 34328,
						'Halo' => 35418,
						'Halo Wars' => 36035,
						'Happn' => 37013,
						'Hargray' => 34142,
						'Harry Potter: Wizards Unite' => 38593,
						'Hashflare' => 37038,
						'Hawaiian Airlines' => 20047,
						'Hawaiian Telcom' => 33436,
						'Hay Day' => 34367,
						'Hayu' => 37198,
						'HBO Go' => 34340,
						'HBO Now' => 38697,
						'Healthcare.gov' => 34011,
						'Hearthstone' => 36834,
						'Heartland' => 38803,
						'Heroku' => 33965,
						'HiDive' => 37527,
						'HInge' => 37625,
						'Hipchat' => 34865,
						'HitBTC' => 36925,
						'Hitman' => 35585,
						'Hive' => 37571,
						'Honeywell' => 38110,
						'Hootsuite' => 20048,
						'Hostgator' => 33417,
						'Hostmonster' => 35931,
						'Hotels.com' => 34334,
						'Hotwire' => 34331,
						'HouseParty' => 37356,
						'HQ Trivia' => 36815,
						'HSBC' => 35673,
						'Hue' => 37514,
						'HughesNet' => 32787,
						'Hulu' => 33331,
						'Humanity' => 36735,
						'Hunt: showdown' => 37006,
						'Hurricane Electric' => 35811,
						'I3 Broadband' => 36286,
						'IBM Cloud' => 37649,
						'iCloud' => 20049,
						'ICQ' => 34766,
						'iFunny' => 38294,
						'IGTV' => 37317,
						'iHeartRadio‎' => 33369,
						'Illinois Century Network' => 36086,
						'IMDb Freedrive' => 37960,
						'iMessage' => 20050,
						'Imgur' => 20051,
						'IMVU' => 36523,
						'Inbox' => 34318,
						'inContact' => 35836,
						'Indeed' => 35864,
						'Ingress' => 35764,
						'Injustice 2' => 36526,
						'Inmotion' => 34759,
						'Instagram' => 20052,
						'Integra' => 33554,
						'Interactive Brokers' => 34115,
						'Intermedia' => 33973,
						'Internet Movie Database (IMDb)' => 33337,
						'Intralinks' => 38667,
						'Ipage' => 35659,
						'iRacing' => 35957,
						'Iridium' => 35652,
						'Ironsight' => 37142,
						'IRS' => 35542,
						'iTunes' => 20053,
						'iTunes Connect' => 36489,
						'iTunes Match' => 36059,
						'iWork' => 36124,
						'Jabber' => 36524,
						'Jackbox' => 38790,
						'JetBlue Airways' => 20054,
						'Jira' => 34870,
						'Jive' => 35453,
						'JP Morgan' => 37034,
						'Juno' => 32786,
						'Jurassic World Alive' => 37256,
						'Kayak' => 34338,
						'Keek' => 33770,
						'Kik' => 32770,
						'Kraken' => 36660,
						'Kucoin' => 36962,
						'last.fm' => 35634,
						'LastPass' => 35541,
						'LawBreakers' => 36527,
						'Layer3 TV' => 37378,
						'Leaco' => 35665,
						'League of Legends' => 34111,
						'Lifesize' => 37003,
						'Lightpath' => 35685,
						'Limebike' => 37205,
						'Limelight Networks' => 35462,
						'Line' => 33738,
						'LinkedIn' => 20055,
						'Linode' => 35907,
						'Liquid Web' => 34825,
						'LiveLeak' => 38273,
						'Liveperson' => 35417,
						'Logix' => 38295,
						'Logmein' => 33488,
						'Lola Wireless' => 35905,
						'Lowe\'s' => 38297,
						'LS Networks' => 35703,
						'Lumos Networks' => 34217,
						'Lyft' => 36571,
						'Lynda' => 35781,
						'Madden' => 37747,
						'Maguss' => 37047,
						'Mail.com' => 34798,
						'Mailbox' => 34831,
						'Mailchimp' => 36017,
						'MARTA' => 20056,
						'Marvel' => 38792,
						'Marvel Contest of Champions' => 37005,
						'Maryland Transit Administration (MTA)' => 20017,
						'Mass Effect ' => 36057,
						'Mastercard' => 37249,
						'MaxxSouth ' => 36095,
						'MBTA' => 20057,
						'McDonalds app' => 36369,
						'Media Temple' => 35950,
						'Mediacom' => 20058,
						'Meetme' => 37042,
						'Meetup' => 34245,
						'Megapath' => 33420,
						'Merrill Lynch' => 37032,
						'Metra' => 20059,
						'Metro PCS' => 20060,
						'MetroCast' => 34405,
						'Metrolink' => 20061,
						'Metronetinc' => 35890,
						'MHz Choice' => 37297,
						'Miami Dade Transit' => 20062,
						'Microsoft Azure' => 32547,
						'Microsoft Teams' => 38018,
						'Microsoft VLSC' => 38187,
						'Midcontinent Media' => 33552,
						'Mimecast' => 35783,
						'Minecraft' => 20063,
						'Mint' => 36589,
						'MintSim' => 36438,
						'Mitel' => 36005,
						'Mixer' => 36525,
						'MLB The Show' => 35711,
						'MLB TV' => 35712,
						'Mobile legends' => 37394,
						'Mobile Strike' => 36476,
						'Momentum Telecom' => 36733,
						'Moneylion' => 38303,
						'Monster Hunter' => 37007,
						'Mordhau' => 38497,
						'Moviepass' => 37004,
						'Movies Anywhere' => 38771,
						'MovieTickets' => 36178,
						'MSL Live' => 37107,
						'MTV' => 34133,
						'MU Legend' => 36792,
						'Music Unlimited' => 35909,
						'Musical.ly' => 36659,
						'My Fitness Pal' => 35803,
						'My Social Security' => 37627,
						'Naruto-Storm' => 35845,
						'National Grid NY' => 36024,
						'NBA 2k' => 35714,
						'NBC Sports Live Extra' => 34295,
						'NBCNews.com' => 33340,
						'NCTC' => 36344,
						'Need for Speed' => 35428,
						'NEMR' => 35514,
						'Nest' => 35190,
						'Net10 Wireless' => 34090,
						'netBlazr' => 35656,
						'Neteller' => 38321,
						'Netflix' => 20065,
						'Netsuite' => 35743,
						'Nettalk' => 36732,
						'Network Solutions' => 33548,
						'NetZero' => 32785,
						'Neverwinter' => 35603,
						'New Jersey Transit' => 20066,
						'New York MTA' => 20067,
						'New York Times' => 33339,
						'Newegg' => 35438,
						'NewWave Communications' => 36026,
						'Nextiva' => 34850,
						'NFL Network' => 36572,
						'NHL.tv' => 36816,
						'Nicehash' => 37037,
						'NikePlus' => 35805,
						'Nintendo eShop' => 34099,
						'Nintendo Network' => 35515,
						'Nintendo Switch Online' => 37240,
						'No Man\'s Sky' => 35793,
						'NordVPN' => 37545,
						'North State' => 36840,
						'Northland Communications' => 38035,
						'Norwood Light' => 35738,
						'NTT Communications' => 35856,
						'NuGet' => 36740,
						'Oculus' => 38253,
						'Office 365' => 34532,
						'OkCupid' => 35902,
						'Okta' => 35742,
						'Omegle' => 36522,
						'OneDrive' => 32780,
						'Onelogin' => 38439,
						'Ooma' => 35628,
						'ooVoo' => 34085,
						'Opera' => 38406,
						'Optimum / Cablevision' => 20020,
						'OptionsHouse' => 20068,
						'optionsXpress' => 20069,
						'Oracle Cloud' => 38033,
						'Orbitz' => 34337,
						'Origin' => 34113,
						'OS X Update' => 36127,
						'Outlook' => 10205,
						'Overdrive' => 35855,
						'Overwatch' => 35680,
						'Pacific Northern Gas ' => 35807,
						'Page Plus' => 34012,
						'Pagely' => 33974,
						'Paladins' => 35857,
						'Pandora' => 20070,
						'Paperspace' => 37200,
						'Paragon' => 36359,
						'PATCO' => 20071,
						'PATH' => 20072,
						'Path of Exile' => 34823,
						'Patreon' => 38503,
						'Paypal' => 20073,
						'pCloud' => 36588,
						'PenTeleData' => 34401,
						'Periscope' => 35595,
						'Personal Capital' => 36969,
						'PES' => 37951,
						'PG&E' => 35677,
						'PGA Tour Live' => 37235,
						'Phonepower' => 35361,
						'Photobucket' => 20074,
						'Pinterest' => 20075,
						'Planetside2' => 35787,
						'Player Unknown\'s Battlegrounds' => 36135,
						'Playstation Network' => 20076,
						'Playstation Vue' => 35188,
						'PlentyOfFish' => 35799,
						'Plex' => 35573,
						'PNC' => 33333,
						'Pokémon Duel' => 35966,
						'Pokémon Go' => 35725,
						'Pokerstars' => 38749,
						'Poloniex' => 36349,
						'Postmates' => 36774,
						'Powerschool' => 35867,
						'Prey' => 37295,
						'Priceline' => 34333,
						'Project Online' => 34535,
						'Proofpoint' => 38666,
						'ProtonMail' => 36136,
						'Quake Champions' => 36773,
						'Quickbooks Online' => 35761,
						'Quicken' => 36614,
						'Quizlet' => 34322,
						'Quizup' => 34296,
						'Quora' => 34341,
						'Rabb.it' => 36819,
						'Rackspace' => 34609,
						'Rain World Game' => 36042,
						'Rainbow Six' => 35463,
						'Razer' => 38698,
						'RCN' => 32784,
						'Realm Royale' => 37287,
						'Red Dead Redemption' => 37600,
						'Redbox' => 37213,
						'Reddit' => 33342,
						'Reflexion' => 38733,
						'RingCentral' => 34311,
						'Rise Broadband' => 35458,
						'Robinhood' => 35706,
						'Roblox' => 34820,
						'Rocket League' => 35251,
						'RocketRez' => 35784,
						'Roku' => 37194,
						'Royal Games' => 38218,
						'Runescape' => 34804,
						'Runkeeper' => 35802,
						'Runtastic' => 35804,
						'Rust' => 37755,
						'Ruzzle' => 33969,
						'Safelink Wireless' => 35467,
						'Safenet' => 37538,
						'Salesforce' => 32773,
						'Santander Bank' => 38656,
						'Sarahah' => 36365,
						'Schooldesk' => 35468,
						'Scottrade' => 20079,
						'ScreenConnect' => 35661,
						'Scum' => 37464,
						'Sea of Thieves' => 36995,
						'SEC Network' => 37757,
						'Secom' => 36972,
						'Second Life' => 37612,
						'SEPTA' => 20080,
						'Service Electric' => 33553,
						'Sharebuilder' => 20081,
						'Sharefile' => 37513,
						'Sharepoint Online' => 34533,
						'Shentel' => 35666,
						'Shopify' => 37555,
						'Shoretel' => 35846,
						'Showtime Anytime' => 35591,
						'Shutterstock' => 35704,
						'Signal' => 37071,
						'SignupGenius' => 35636,
						'Simple' => 34790,
						'Simple Mobile' => 33979,
						'Siri' => 38339,
						'SiriusXM' => 37048,
						'Skillshare' => 35775,
						'Skrill' => 37257,
						'Skype' => 20082,
						'Skype for Business' => 35350,
						'Skyscanner' => 38645,
						'SkySwitch' => 36664,
						'SkyWest' => 20084,
						'Slack' => 35437,
						'Slashdot' => 36615,
						'Sleeper' => 37455,
						'Slideshare' => 20085,
						'Sling' => 35155,
						'Smart Hub' => 35178,
						'Smartsheet' => 38310,
						'SmartThings' => 37102,
						'Smite' => 34802,
						'SNAP EBT' => 34006,
						'Snapchat' => 20086,
						'Socket' => 37411,
						'Sonic.net' => 34403,
						'Soundcloud' => 34351,
						'Sourceforge' => 20087,
						'South Central Communications' => 35759,
						'Southern California Edison' => 35700,
						'Southwest Airlines' => 20088,
						'Spectrum' => 20024,
						'Speedtest' => 37354,
						'Spirit Communications' => 35808,
						'SplashID' => 35594,
						'Spotify' => 20090,
						'Sprint' => 20091,
						'Square' => 37053,
						'Squarespace' => 36573,
						'Stack Exchange' => 34319,
						'Stackoverflow' => 34258,
						'Stadia' => 38302,
						'Staminus' => 34608,
						'Stamps.com' => 36662,
						'Star Citizen' => 36477,
						'Star Wars Battlefront' => 35459,
						'Starbucks' => 37210,
						'Starz' => 38291,
						'Steam' => 20092,
						'Steep' => 36011,
						'Straight Talk' => 34097,
						'Strava' => 36047,
						'Streamlabs' => 37206,
						'Strife' => 35853,
						'Stripe' => 38668,
						'Suddenlink' => 20093,
						'Suitebox' => 37211,
						'Summit Broadband' => 35617,
						'Summoners War' => 37409,
						'SunTrust Bank' => 37346,
						'Surfline' => 36341,
						'SurveyMonkey' => 35963,
						'T-Mobile' => 20097,
						'T. Rowe Price' => 37033,
						'Talkray' => 34750,
						'Tango' => 33728,
						'Target' => 34320,
						'Taxslayer' => 36018,
						'TD Ameritrade' => 20094,
						'TD Bank' => 35672,
						'TDS Telecom' => 33558,
						'Teamviewer' => 34343,
						'Tekken' => 37196,
						'Telecharge' => 37220,
						'Telegram' => 34227,
						'Tennis TV' => 37040,
						'TERA' => 37105,
						'Tesla' => 37152,
						'The Crew 2' => 35809,
						'The Culling' => 37752,
						'The Division' => 35558,
						'The elder scrolls online' => 35535,
						'The Huffington Post' => 33334,
						'The Simpsons Tapped out' => 34702,
						'The Weather Channel' => 33336,
						'Thingiverse' => 38732,
						'Threads' => 38983,
						'Threema' => 35892,
						'TIAA ' => 35597,
						'Ticketmaster' => 36534,
						'Tidal' => 37512,
						'Tiktok' => 38367,
						'Tinder' => 34237,
						'Titanfall' => 35897,
						'Tivo' => 37001,
						'Todoist' => 36461,
						'Toggl' => 36993,
						'TPx Communications' => 34402,
						'TracFone Wireless' => 20099,
						'Tradeking' => 33768,
						'TradeSatoshi' => 37106,
						'TradeStation' => 20100,
						'Transferwise' => 37199,
						'Travelocity' => 34336,
						'Trello' => 34796,
						'Trove' => 35363,
						'Trusted Id' => 36636,
						'TSYS' => 36517,
						'Tumblr' => 20101,
						'TuneIn' => 35221,
						'TurboTax' => 34327,
						'TV Time' => 37197,
						'TW Telecom' => 32783,
						'Tweakbox' => 37750,
						'Tweetdeck' => 39009,
						'Twitch' => 34308,
						'Twitter' => 10204,
						'Uber' => 36570,
						'Uber Eats' => 37648,
						'Udacity' => 35842,
						'Udemy' => 35644,
						'UFC' => 36736,
						'UMG Gaming' => 36528,
						'Uncharted' => 35716,
						'United Airlines' => 20104,
						'Untappd' => 37363,
						'Uplay PC' => 34381,
						'UPS' => 34321,
						'Upwork' => 35436,
						'US Bank' => 20106,
						'US Cellular' => 20103,
						'USA Mobility' => 34129,
						'USPS' => 34259,
						'Utah Broadband' => 36342,
						'Vainglory' => 37203,
						'Vanguard' => 37011,
						'Vectren' => 35872,
						'Venmo' => 37209,
						'Verizon' => 20107,
						'Vero' => 37062,
						'Viaero' => 37508,
						'Viasat' => 38298,
						'Viber' => 32769,
						'Viewster' => 34323,
						'Viki' => 36065,
						'Vimeo' => 20110,
						'Vine' => 33368,
						'Virgin Mobile' => 34724,
						'Visa' => 37239,
						'Visible' => 38605,
						'Visual Studio Team Services' => 37463,
						'Vlive' => 36574,
						'Vonage' => 34315,
						'Voxer' => 33492,
						'VRChat' => 36991,
						'VRV' => 36640,
						'Vudu' => 34109,
						'Vyve Broadband' => 36012,
						'W3Schools' => 35887,
						'Waiter.com' => 36776,
						'Walmart Family' => 35465,
						'Walmart.com' => 33338,
						'War Thunder' => 37318,
						'Warface' => 37510,
						'Warframe' => 35825,
						'Washington Metropolitan Area Transit Authority' => 20111,
						'Wattpad' => 34693,
						'Wave Broadband' => 34028,
						'Waze' => 33382,
						'Webassign' => 35873,
						'Webex' => 33490,
						'Webhosting.net' => 35435,
						'Webs' => 35895,
						'Weebly' => 34910,
						'Weight Watchers' => 35646,
						'Wells Fargo' => 20112,
						'Wemo' => 37593,
						'Westman' => 35359,
						'WeTransfer' => 20113,
						'Whatsapp' => 10136,
						'Whisper' => 36881,
						'Wikipedia' => 20115,
						'Wilcoinc' => 35696,
						'Wildstar' => 36475,
						'William Hill' => 38900,
						'Windstream' => 20117,
						'Wish' => 38154,
						'Wix' => 35596,
						'Wordpress.com' => 20118,
						'Workday' => 37314,
						'World of Tanks' => 35357,
						'World of Warcraft' => 34263,
						'World of Warships' => 36637,
						'World War 3' => 37599,
						'World War Z' => 38405,
						'WOW' => 20114,
						'WP Engine' => 33975,
						'Wunderground' => 35948,
						'Wunderlist' => 35839,
						'WWE Network' => 36056,
						'Xbox Live' => 20119,
						'Xfinity Flex' => 38412,
						'XO' => 32777,
						'Yahoo' => 10203,
						'Yahoo Mail' => 20120,
						'Yahoo Messenger' => 20121,
						'Yammer' => 35559,
						'Yelp' => 20122,
						'Youtube' => 34651,
						'Youtube Music' => 37461,
						'Youtube TV' => 37296,
						'Yubo' => 37720,
						'Z1 Battle Royale' => 35146,
						'Zayo' => 35866,
						'Zelle' => 38683,
						'Zendesk' => 35854,
						'Zillow' => 33367,
						'ZoHo' => 34144,
						'Zoom' => 37349,
						'Zwift' => 38167,
						'Zynga' => 20123,
					),
					'New Zealand' => array(
						'2degrees' => 33886,
						'4chan' => 38270,
						'Alexa' => 36920,
						'Amurit.net' => 37710,
						'Anthem' => 38210,
						'ANZ' => 33888,
						'Apex Legends' => 38134,
						'Apple Store' => 34457,
						'ASB' => 33905,
						'beIN' => 38493,
						'Bigpipe' => 37704,
						'Bing' => 33889,
						'Blizzard Battle.net' => 38465,
						'BNZ' => 33907,
						'Call of Duty' => 34150,
						'CallPlus' => 33885,
						'CCL' => 37705,
						'Counter-strike' => 36854,
						'Crunchyroll' => 38146,
						'Cryptopia' => 36963,
						'Dead By Daylight' => 37434,
						'Destiny' => 38942,
						'Discord' => 38609,
						'Dota 2' => 36415,
						'EA' => 34505,
						'eBay' => 33891,
						'Evernote' => 35914,
						'Facebook' => 33892,
						'Facebook Messenger' => 33893,
						'Facetime' => 34587,
						'Fifa' => 38400,
						'Flip' => 37706,
						'Fortnite' => 36655,
						'Gmail' => 33894,
						'Google' => 33895,
						'Google Drive' => 36759,
						'Google Hangouts' => 33896,
						'Google Play' => 38525,
						'Gran Turismo' => 36948,
						'Grindr' => 38402,
						'GTA 5' => 37277,
						'iCloud' => 33921,
						'iMessage' => 33922,
						'Inspire Net' => 35445,
						'Instagram' => 33915,
						'iTunes' => 33923,
						'Kik' => 33914,
						'Kiwibank' => 33906,
						'League of Legends' => 38692,
						'Lightbox' => 35504,
						'LinkedIn' => 33897,
						'Minecraft' => 38617,
						'My Fitness Pal' => 37635,
						'myob' => 38926,
						'MyRepublic' => 34931,
						'NBA 2k' => 38785,
						'Neon' => 37707,
						'Netflix' => 34857,
						'Nzdating' => 37708,
						'Office 365' => 37171,
						'OneDrive' => 36863,
						'Orcon' => 33883,
						'Origin' => 36887,
						'Outlook' => 33918,
						'Overwatch' => 36416,
						'Pandora' => 33919,
						'Pinterest' => 33898,
						'Player Unknown\'s Battlegrounds' => 36362,
						'Playstation Network' => 34858,
						'Pokémon Go' => 35733,
						'Rabodirect' => 34980,
						'Rainbow Six' => 36610,
						'Reddit' => 34860,
						'Roblox' => 37662,
						'Skinny' => 37709,
						'Sky TV' => 33887,
						'Skype' => 33912,
						'Slingshot' => 34737,
						'Snapchat' => 33908,
						'Spark' => 33884,
						'Spotify' => 33910,
						'Steam' => 34225,
						'Tinder' => 34859,
						'Trade Me' => 33916,
						'Trustpower' => 37703,
						'Twitch' => 36540,
						'Twitter' => 33899,
						'Viber' => 33909,
						'Vodafone' => 33882,
						'Voxer' => 33913,
						'Wattpad' => 34697,
						'WeChat' => 33920,
						'Westpac' => 33900,
						'Whatsapp' => 33917,
						'Wikipedia' => 33901,
						'World of Warcraft' => 38814,
						'Xbox Live' => 34284,
						'Xero' => 35929,
						'Yahoo' => 33902,
						'Yahoo Mail' => 33903,
						'Youtube' => 33904,
						'Z1 Battle Royale' => 37266,
					),
					'België' => array(
						'2dehands.be' => 34257,
						'Apex Legends' => 38141,
						'App Store' => 38555,
						'Apple Store' => 38925,
						'Argenta' => 32491,
						'Bancontact Mister Cash' => 33976,
						'Base' => 10207,
						'Battlefield' => 38444,
						'Belfius' => 32545,
						'Binance' => 36934,
						'Binck' => 32388,
						'Blizzard Battle.net' => 38810,
						'BNP Paribas Fortis' => 32543,
						'Bolero' => 37619,
						'Bpost' => 37157,
						'Bwin' => 34872,
						'Call of Duty' => 35536,
						'Clash Royale' => 38948,
						'Counter-strike' => 38245,
						'Crelan' => 37614,
						'Dead By Daylight' => 37445,
						'Deezer' => 33828,
						'Destiny' => 38559,
						'Deutsche Bank' => 34140,
						'Discord' => 37391,
						'Dommel' => 33977,
						'Dota 2' => 38478,
						'Dropbox' => 32525,
						'EA' => 34841,
						'eBay' => 33858,
						'EDPnet' => 32855,
						'Engie Electrabel' => 37616,
						'Epic Games Store' => 39027,
						'Facebook' => 22339,
						'Facebook Messenger' => 34851,
						'Facetime' => 34605,
						'Fifa' => 36906,
						'Fintro' => 37617,
						'Fluvius' => 37615,
						'Fortnite' => 36696,
						'Ghost Recon' => 39001,
						'Gmail' => 32374,
						'Google' => 32343,
						'Google Hangouts' => 32395,
						'Google Play' => 32371,
						'Gran Turismo' => 36913,
						'Grindr' => 38743,
						'GTA 5' => 35500,
						'Guild Wars 2' => 36474,
						'iCloud' => 22363,
						'iMessage' => 32463,
						'ING' => 22342,
						'Instagram' => 34286,
						'Isabel' => 34004,
						'Itsme' => 37454,
						'iTunes' => 32484,
						'Jim Mobile' => 37618,
						'KBC' => 32544,
						'Kik' => 32524,
						'Kraken' => 36828,
						'League of Legends' => 38631,
						'Lebara' => 32461,
						'LinkedIn' => 32534,
						'Lycamobile' => 32462,
						'Mobile Vikings' => 32854,
						'Moneyou' => 32488,
						'Multisafepay' => 34878,
						'Nest' => 38517,
						'Netflix' => 34629,
						'Numéricable' => 32856,
						'Office 365' => 36409,
						'OneDrive' => 35410,
						'Orange' => 10208,
						'Origin' => 36888,
						'Outlook' => 32375,
						'Overwatch' => 36383,
						'OVH' => 36746,
						'Paypal' => 32354,
						'Paysafecard' => 32485,
						'Play Sports' => 37582,
						'Player Unknown\'s Battlegrounds' => 36568,
						'Playstation Network' => 32339,
						'Pokémon Go' => 35736,
						'Proximus' => 10206,
						'Rainbow Six' => 36180,
						'Reddit' => 37474,
						'Roblox' => 38757,
						'Rocket League' => 35978,
						'Runescape' => 38654,
						'Salesforce' => 32349,
						'Scarlet' => 32435,
						'Simyo' => 32387,
						'Skype' => 32357,
						'Smartschool' => 37620,
						'Snapchat' => 32520,
						'Sofort Banking' => 32482,
						'Spotify' => 32336,
						'Steam' => 34278,
						'Strava' => 38161,
						'Teamviewer' => 34907,
						'Telegram' => 35971,
						'Telenet' => 10196,
						'Tinder' => 35499,
						'TuneIn' => 38759,
						'TV Vlaanderen' => 22364,
						'Tweakbox' => 38786,
						'Twitch' => 36542,
						'Twitter' => 22355,
						'Unibet' => 38830,
						'Uplay PC' => 35614,
						'Viber' => 32505,
						'Voo' => 32853,
						'VTM' => 38394,
						'Waze' => 36657,
						'WeTransfer' => 32523,
						'Whatsapp' => 32333,
						'Wikipedia' => 32425,
						'Wordfeud' => 22358,
						'Xbox Live' => 32481,
						'Yahoo Mail' => 34840,
						'Yellowbrick' => 37609,
						'Yeloplay' => 37359,
						'YouTube' => 32338,
						'Z1 Battle Royale' => 37258,
					),
					'Australia' => array(
						'2k' => 36402,
						'4chan' => 38290,
						'AAPT telecommunications' => 35849,
						'ABC' => 37712,
						'Activ8me' => 36814,
						'Adam Internet' => 33877,
						'Adelaide Bank' => 36729,
						'Adobe Creative Cloud' => 34553,
						'Airbnb' => 36403,
						'Alexa' => 36922,
						'Amaysim' => 35654,
						'Amazon' => 36404,
						'Amazon Prime Video' => 36968,
						'Amazon Web Services' => 34093,
						'American Express' => 38173,
						'Amino Apps' => 39045,
						'Amnet' => 33878,
						'Anthem' => 38176,
						'ANZ' => 33364,
						'Apex Legends' => 38125,
						'App Store' => 35577,
						'Apple Music' => 35243,
						'Apple Store' => 34455,
						'ARK: Survival Evolved' => 38746,
						'Assassin\'s Creed' => 35008,
						'AusBBS' => 36812,
						'Aussie Broadband' => 37219,
						'Australia Post' => 37052,
						'Bank Australia' => 38682,
						'Bank of Melbourne' => 35356,
						'Bank of Queensland' => 37458,
						'Bank SA' => 35354,
						'Bankwest' => 34972,
						'Battlefield' => 37468,
						'Belong' => 37179,
						'Bendigo Bank' => 37715,
						'BigPond' => 33993,
						'Binance' => 36878,
						'Bing' => 32874,
						'Blizzard Battle.net' => 35053,
						'Blogger' => 32875,
						'Boom Beach' => 36871,
						'Box' => 32876,
						'Brawl Stars' => 38816,
						'Bumble' => 36809,
						'Call of Duty' => 36405,
						'Candy Crush' => 35092,
						'Centrelink' => 37549,
						'Centurylink' => 34131,
						'Citibank' => 36507,
						'Clash of Clans' => 37302,
						'Clash Royale' => 38953,
						'Cloudflare' => 32877,
						'ClubTelco' => 34792,
						'Coinbase' => 36802,
						'Coinspot' => 36927,
						'Commander' => 37714,
						'Commonwealth Bank' => 33362,
						'Counter-strike' => 35059,
						'Crackle' => 35112,
						'Craigslist' => 32878,
						'Crunchyroll' => 36717,
						'Dead By Daylight' => 37415,
						'Deezer' => 33833,
						'Deliveroo' => 38197,
						'Destiny' => 34894,
						'DFP' => 35002,
						'Discord' => 36022,
						'Dodo' => 34003,
						'Doordash' => 39006,
						'Dota 2' => 35405,
						'Dropbox' => 32879,
						'EA' => 34509,
						'eBay' => 32880,
						'Eftel' => 35553,
						'Elite: Dangerous' => 37104,
						'Escape from Tarkov' => 38626,
						'ESPN' => 38387,
						'Etsy' => 37481,
						'Exchange Online' => 34545,
						'Exetel' => 34478,
						'Facebook' => 32881,
						'Facebook Messenger' => 32882,
						'Facetime' => 34601,
						'Fallout' => 35432,
						'Far Cry' => 37190,
						'Fifa' => 35473,
						'Fitbit' => 38358,
						'Flickr' => 32883,
						'Fonality' => 34313,
						'For Honor' => 35989,
						'Fortnite' => 36622,
						'Foxtel' => 33355,
						'Funimation' => 38583,
						'Game of war' => 35416,
						'Gears of War' => 38894,
						'Ghost Recon' => 36008,
						'GitHub' => 36529,
						'Gmail' => 32885,
						'Go Daddy' => 36619,
						'Google' => 32886,
						'Google Drive' => 34274,
						'Google Hangouts' => 32887,
						'Google Home' => 37343,
						'Google Play' => 32888,
						'Gran Turismo' => 36875,
						'Grindr' => 35834,
						'GTA 5' => 34755,
						'Guild Wars 2' => 36408,
						'Gumtree' => 33360,
						'Halo' => 35449,
						'Hay Day' => 34786,
						'Hayu' => 38366,
						'Hearthstone' => 38660,
						'Heronet' => 35949,
						'Hipchat' => 34867,
						'Hootsuite' => 32889,
						'iCloud' => 32890,
						'iiNet' => 33555,
						'iMessage' => 32891,
						'Imgur' => 32892,
						'Instagram' => 32893,
						'Internode' => 34477,
						'iPrimus' => 33876,
						'iTunes' => 32894,
						'Kik' => 32895,
						'Kraken' => 36849,
						'Ladbrokes' => 37640,
						'LastPass' => 34776,
						'League of Legends' => 35049,
						'LinkedIn' => 32896,
						'Mail.com' => 34799,
						'Mailbox' => 34834,
						'Mate Communicate' => 36813,
						'McDonalds app' => 37525,
						'ME Bank' => 34973,
						'Microsoft Azure' => 32917,
						'Microsoft Teams' => 38694,
						'Minecraft' => 32897,
						'My Fitness Pal' => 37633,
						'My Republic' => 35982,
						'MyGov' => 37550,
						'MyNetFone' => 35481,
						'myob' => 36343,
						'NAB' => 33365,
						'National Broadband Network, NBN' => 35992,
						'NBA 2k' => 37736,
						'Netflix' => 35177,
						'Netregistry' => 36060,
						'Netspeed' => 34492,
						'Nine' => 37000,
						'Nintendo eShop' => 34102,
						'Nintendo Network' => 35517,
						'Nintendo Switch Online' => 37243,
						'No Man\'s Sky' => 37404,
						'Office 365' => 34543,
						'OkCupid' => 38489,
						'OneDrive' => 32904,
						'Optus' => 33356,
						'Origin' => 35091,
						'Outlook' => 32899,
						'Overwatch' => 35683,
						'Paladins' => 37656,
						'Pandora' => 33343,
						'Panthur' => 36346,
						'Path of Exile' => 36498,
						'Paypal' => 35607,
						'Photobucket' => 32901,
						'Pinterest' => 32902,
						'Player Unknown\'s Battlegrounds' => 36356,
						'Playstation Network' => 34842,
						'PlentyOfFish' => 37416,
						'Pokémon Go' => 35732,
						'Project Online' => 34542,
						'Quickbooks Online' => 38220,
						'Rabobank' => 34974,
						'Rabodirect' => 34975,
						'Rainbow Six' => 35478,
						'Red Dead Redemption' => 37740,
						'Reddit' => 34843,
						'Roblox' => 36832,
						'Rocket League' => 35497,
						'Runescape' => 35106,
						'Salesforce' => 32903,
						'Sarahah' => 36374,
						'SBS' => 34703,
						'Sea of Thieves' => 37115,
						'Sharepoint Online' => 34541,
						'Skype' => 32905,
						'Skype for Business' => 34544,
						'Slack' => 35937,
						'Slideshare' => 32906,
						'Smite' => 35406,
						'Snapchat' => 32907,
						'Soundcloud' => 37230,
						'Spintel' => 35962,
						'Sportsbet' => 37713,
						'Spotify' => 33225,
						'St. George Bank' => 35353,
						'Stan' => 35503,
						'Star Wars Battlefront' => 35552,
						'Steam' => 34114,
						'Steep' => 37922,
						'Summoners War' => 37418,
						'Suncorp Bank' => 34432,
						'Sure Telecom' => 34394,
						'Tango' => 33742,
						'Teamviewer' => 34617,
						'Telegram' => 34220,
						'Telstra' => 33354,
						'The Division' => 35572,
						'The elder scrolls online' => 36554,
						'The Simpsons Tapped out' => 38166,
						'Think Mobile' => 34527,
						'Tiktok' => 39061,
						'Tinder' => 34241,
						'TPG Telecom' => 33359,
						'Tumblr' => 32910,
						'TuneIn' => 38761,
						'Tweakbox' => 38346,
						'Twitch' => 35026,
						'Twitter' => 32911,
						'Uber' => 37766,
						'Uber Eats' => 38272,
						'Uberglobal' => 35669,
						'Udemy' => 37719,
						'Uplay PC' => 36211,
						'V4 Telecom' => 37357,
						'Vaya' => 34518,
						'Viber' => 32912,
						'Vimeo' => 32913,
						'Virgin Mobile' => 34516,
						'Vocus' => 37711,
						'Vodafone' => 33357,
						'War Thunder' => 38361,
						'Warframe' => 36495,
						'Wattpad' => 34694,
						'Waze' => 33405,
						'Webex' => 34162,
						'Weebly' => 34911,
						'Westnet' => 35163,
						'Westpac' => 33363,
						'WeTransfer' => 32914,
						'Whatsapp' => 32915,
						'Wikipedia' => 32916,
						'Wish' => 39042,
						'Wix' => 37255,
						'Wordpress.com' => 32918,
						'World of Tanks' => 37191,
						'World of Warcraft' => 35054,
						'WWE Network' => 38722,
						'Xbox Live' => 34283,
						'Xero' => 36177,
						'Yahoo' => 32919,
						'Yahoo Mail' => 32920,
						'Yahoo Messenger' => 32921,
						'Yelp' => 32922,
						'Youtube' => 32923,
						'Youtube Music' => 37590,
						'Z1 Battle Royale' => 35494,
						'Zettanet' => 35655,
						'ZoHo' => 37551,
					),
					'Canada' => array(
						'2k' => 36723,
						'Acanac' => 34107,
						'Access' => 33069,
						'Aeroplan' => 35789,
						'Air Canada' => 37029,
						'Air Miles' => 35788,
						'Airbnb' => 37423,
						'Alaska Airlines' => 32926,
						'Alexa' => 37067,
						'Allegiant Air' => 32927,
						'Allstream' => 34001,
						'Altima Telecom' => 37247,
						'Amazon' => 32928,
						'Amazon Prime Music' => 38907,
						'Amazon Prime Video' => 37393,
						'Amazon Web Services' => 32929,
						'American Airlines' => 32930,
						'American Express' => 38172,
						'Amino Apps' => 38716,
						'Anthem' => 38056,
						'Anydesk' => 37488,
						'Apex Legends' => 38113,
						'App Store' => 35576,
						'Apple Music' => 35244,
						'Apple Store' => 34456,
						'ARK: Survival Evolved' => 38747,
						'Assassin\'s Creed' => 35007,
						'BabyTEL' => 35360,
						'Battlefield' => 36923,
						'BC Hydro' => 35806,
						'Beanfield' => 36663,
						'beIN' => 38788,
						'Bell' => 32936,
						'Bell Aliant' => 32937,
						'Bet365' => 39064,
						'Binance' => 36876,
						'Bing' => 32938,
						'Black Desert Online' => 38829,
						'Blizzard Battle.net' => 34488,
						'Blogger' => 32940,
						'BMO' => 34525,
						'Boom Beach' => 36558,
						'Box' => 32941,
						'Brama Telecom' => 34146,
						'Brawl Stars' => 38833,
						'Bumble' => 36330,
						'Call of Duty' => 34149,
						'Candy Crush' => 35093,
						'Capital One' => 36410,
						'Carry Telecom' => 37695,
						'CBC' => 34267,
						'Centurylink' => 35627,
						'Chatr' => 34005,
						'CIBC' => 34526,
						'CIK Telecom‎' => 34428,
						'Clash of Clans' => 34445,
						'Clash Royale' => 37523,
						'Cloudflare' => 32952,
						'CNN' => 37372,
						'Cogeco' => 32953,
						'Cogent' => 35556,
						'Coinbase' => 36800,
						'Colbanet' => 37542,
						'CommStream' => 36028,
						'Comwave' => 36641,
						'Counter-strike' => 35056,
						'Crackle' => 35111,
						'Craigslist' => 32956,
						'Crave TV' => 35621,
						'Crunchyroll' => 36716,
						'Dark Souls' => 36557,
						'DayZ' => 39007,
						'Dazn' => 36510,
						'Dead By Daylight' => 36595,
						'Delta Air Lines' => 32958,
						'Destiny' => 34892,
						'DFP' => 35001,
						'Diablo' => 39071,
						'Discord' => 36411,
						'Distributel' => 33870,
						'Doordash' => 38385,
						'Dota 2' => 35404,
						'Dropbox' => 32961,
						'EA' => 34504,
						'EA Sports UFC' => 36552,
						'Eastlink' => 33414,
						'eBay' => 32964,
						'Ebox' => 35555,
						'Ecobee' => 38021,
						'Elite: Dangerous' => 37103,
						'Epic Games Store' => 38767,
						'Equitable Bank' => 36731,
						'Escape from Tarkov' => 37975,
						'Etsy' => 38265,
						'Exchange Online' => 34546,
						'Execulink' => 34942,
						'Expedia' => 37401,
						'Facebook' => 32965,
						'Facebook Messenger' => 32966,
						'Facetime' => 34595,
						'Fallout' => 37663,
						'FedEx' => 36500,
						'Fido' => 34000,
						'Fifa' => 35472,
						'Fitbit' => 38359,
						'Flickr' => 32967,
						'For Honor' => 35986,
						'Fortnite' => 36623,
						'Forza' => 38836,
						'Fox News' => 37665,
						'Freedom Mobile' => 33869,
						'Friday the 13th The Game' => 37562,
						'Funimation' => 37744,
						'Game of war' => 35415,
						'Garmin Connect' => 38540,
						'Gears of War' => 35938,
						'Ghost Recon' => 37772,
						'GitHub' => 32970,
						'Gmail' => 32971,
						'Go Daddy' => 34943,
						'GO Transit' => 32972,
						'Google' => 32973,
						'Google Calendar' => 38599,
						'Google Cloud' => 38537,
						'Google Drive' => 34272,
						'Google Hangouts' => 32974,
						'Google Home' => 36141,
						'Google Play' => 32975,
						'GoToMeeting' => 36504,
						'Gran Turismo' => 36679,
						'Grindr' => 35835,
						'GTA 5' => 34756,
						'Guild Wars 2' => 36406,
						'Halo' => 35450,
						'Harry Potter: Wizards Unite' => 38687,
						'Hay Day' => 34789,
						'Hayu' => 38789,
						'Hearthstone' => 38289,
						'Hipchat' => 34868,
						'Hootsuite' => 32977,
						'HQ Trivia' => 37027,
						'HSBC' => 39048,
						'Hue' => 37814,
						'HughesNet' => 32978,
						'iCloud' => 32979,
						'iMessage' => 33249,
						'Imgur' => 32981,
						'IMVU' => 37472,
						'Indeed' => 38782,
						'Instagram' => 32982,
						'Interac' => 39049,
						'iTunes' => 32983,
						'JetBlue Airways' => 32984,
						'Jira' => 38545,
						'Juno' => 32985,
						'Kijiji' => 34303,
						'Kik' => 32986,
						'Koodo' => 34002,
						'Kraken' => 36750,
						'LastPass' => 36785,
						'League of Legends' => 35047,
						'Lightspeed' => 37066,
						'LinkedIn' => 32987,
						'Madden' => 38459,
						'Mail.com' => 34801,
						'Mailbox' => 34837,
						'McDonalds app' => 37642,
						'MCSNet' => 35889,
						'Metro Loop' => 37646,
						'Microsoft Azure' => 33057,
						'Minecraft' => 32996,
						'Mixer' => 38769,
						'MLB The Show' => 36989,
						'MLB TV' => 37189,
						'Montréal Metro' => 32997,
						'Mordhau' => 38734,
						'MTS' => 33868,
						'My Fitness Pal' => 37632,
						'NBA 2k' => 37722,
						'Nest' => 35191,
						'Netflix' => 32998,
						'NetZero' => 32999,
						'Neverwinter' => 35766,
						'Nintendo eShop' => 34101,
						'Nintendo Network' => 35518,
						'No Man\'s Sky' => 38779,
						'NorthernTel' => 34636,
						'Northwestel' => 35104,
						'Office 365' => 34548,
						'OkCupid' => 36678,
						'OneDrive' => 33020,
						'Oricom Internet' => 35829,
						'Origin' => 36584,
						'Outlook' => 33005,
						'Overwatch' => 35682,
						'Paladins' => 37664,
						'Path of Exile' => 36481,
						'Paypal' => 33010,
						'PC Optimum' => 37216,
						'Peer 1' => 34824,
						'Photobucket' => 33011,
						'Pinterest' => 33012,
						'Piper' => 38323,
						'Player Unknown\'s Battlegrounds' => 36337,
						'Playstation Network' => 33013,
						'PlentyOfFish' => 35798,
						'Pokémon Go' => 35734,
						'Pokerstars' => 38174,
						'Primus' => 33872,
						'Qtrade Financial Group' => 36025,
						'Quickbooks Online' => 37607,
						'Quizup' => 34297,
						'Rabb.it' => 37974,
						'Rainbow Six' => 35477,
						'RBC' => 34521,
						'Red Dead Redemption' => 37742,
						'Reddit' => 34845,
						'Roblox' => 35785,
						'Rocket League' => 35498,
						'Rogers' => 33015,
						'Runescape' => 35105,
						'Salesforce' => 33016,
						'Sarahah' => 36514,
						'Sasktel' => 33871,
						'Scotiabank' => 34523,
						'Sea of Thieves' => 37111,
						'Sharepoint Online' => 34550,
						'Shaw' => 33551,
						'Shopify' => 35863,
						'Signal' => 36328,
						'Simplii' => 37541,
						'SiriusXM' => 38561,
						'SkipTheDishes' => 38322,
						'Skype' => 33021,
						'Skype for Business' => 34547,
						'Slack' => 35935,
						'Slideshare' => 33023,
						'Smartsheet' => 38724,
						'Smite' => 37026,
						'Snapchat' => 33024,
						'Soundcloud' => 37229,
						'Sourceforge' => 33025,
						'Spotify' => 33028,
						'Star Wars Battlefront' => 35550,
						'Start Communications' => 34426,
						'Steam' => 33030,
						'Steep' => 37923,
						'Strava' => 38745,
						'Summoners War' => 37422,
						'Tangerine' => 37694,
						'Tango' => 33741,
						'Tbaytel' => 34612,
						'TD Canada Trust' => 34522,
						'Teamviewer' => 34618,
						'TekSavvy' => 33867,
						'Télébec' => 34110,
						'Telegram' => 34228,
						'Telnet' => 34158,
						'Telus' => 33034,
						'TeraGo' => 34427,
						'Tesla' => 38835,
						'The Division' => 35571,
						'The elder scrolls online' => 36399,
						'The Simpsons Tapped out' => 35109,
						'The Weather Channel' => 38837,
						'Ticketmaster' => 39008,
						'Tiktok' => 38727,
						'Tinder' => 34239,
						'Toronto Transit Commission' => 33036,
						'Translink' => 33039,
						'Trello' => 39066,
						'Trove' => 38825,
						'Tumblr' => 33040,
						'TuneIn' => 36037,
						'TurboTax' => 38213,
						'Tweakbox' => 38343,
						'Twitch' => 35023,
						'Twitter' => 33042,
						'Uber' => 37765,
						'Uber Eats' => 38022,
						'Udemy' => 37718,
						'United Airlines' => 33044,
						'Uplay PC' => 34688,
						'UPS' => 36831,
						'Vancity' => 37570,
						'Velcom' => 36978,
						'Viber' => 33348,
						'Vidéotron' => 33050,
						'Vimeo' => 33051,
						'Virgin Mobile' => 34096,
						'Visa' => 38693,
						'VMedia' => 34265,
						'Warface' => 38777,
						'Warframe' => 36370,
						'Wattpad' => 34695,
						'Waveapps' => 35960,
						'Waze' => 33406,
						'Webex' => 34160,
						'Weight Watchers' => 35664,
						'WestJet' => 35648,
						'WeTransfer' => 33054,
						'Whatsapp' => 33055,
						'Whisper' => 34625,
						'Wiband' => 34771,
						'Wikipedia' => 33056,
						'Wish' => 39041,
						'Wisp' => 37218,
						'Wordpress.com' => 33059,
						'World of Tanks' => 35527,
						'World of Warcraft' => 34264,
						'WWE Network' => 38717,
						'Xbox Live' => 33061,
						'Xplornet' => 34270,
						'Yahoo' => 33063,
						'Yahoo Mail' => 33064,
						'Yahoo Messenger' => 33065,
						'Yak' => 34269,
						'Yelp' => 33066,
						'Youtube' => 33067,
						'Youtube Music' => 37588,
						'Yubo' => 38961,
						'Z1 Battle Royale' => 35491,
						'ZoHo' => 36038,
						'Zoom' => 37947,
						'Zynga' => 33068,
					),
					'Hong Kong' => array(
						'3 (Three)' => 36202,
						'Apex Legends' => 38178,
						'App Store' => 37734,
						'Binance' => 37023,
						'Blizzard Battle.net' => 36186,
						'China Mobile' => 36199,
						'Cloudflare' => 38641,
						'Counter-strike' => 38725,
						'CSL' => 36200,
						'Discord' => 38608,
						'EA' => 36700,
						'eBay' => 36207,
						'Facebook' => 36185,
						'Fifa' => 37604,
						'For Honor' => 36187,
						'Ghost Recon' => 38990,
						'Gmail' => 36188,
						'Google' => 36210,
						'Google Drive' => 38264,
						'Google Play' => 38526,
						'GTA 5' => 37279,
						'Hong Kong Broadband Network' => 36204,
						'iCloud' => 38842,
						'Instagram' => 36392,
						'Kraken' => 36984,
						'Netflix' => 36213,
						'Netvigator' => 36203,
						'Office 365' => 37172,
						'Origin' => 38396,
						'Outlook' => 36189,
						'Overwatch' => 36190,
						'PCCW' => 36205,
						'Player Unknown\'s Battlegrounds' => 36617,
						'Playstation Network' => 36191,
						'Pokémon Go' => 36192,
						'Rainbow Six' => 36193,
						'Reddit' => 37479,
						'Skype' => 36194,
						'Smartone' => 36198,
						'Snapchat' => 36208,
						'Steam' => 38650,
						'Telegram' => 36195,
						'Three Home Broadband' => 36206,
						'Tinder' => 36196,
						'TuneIn' => 36036,
						'Twitter' => 38671,
						'Uplay PC' => 36212,
						'Whatsapp' => 36197,
						'Yahoo Mail' => 36769,
						'Youtube' => 36209,
					),
					'Ireland' => array(
						'3 (Three)' => 34214,
						'AIB (Allied Irish Banks)' => 34209,
						'Amazon' => 34165,
						'Apex Legends' => 38133,
						'App Store' => 38557,
						'Apple Store' => 34460,
						'Bank of Ireland' => 37754,
						'Battlefield' => 38451,
						'Binance' => 36931,
						'Bing' => 34166,
						'Boom Beach' => 35153,
						'Call of Duty' => 36709,
						'Counter-strike' => 38233,
						'Craigslist' => 34167,
						'Crunchyroll' => 38094,
						'Dead By Daylight' => 37444,
						'Deezer' => 34168,
						'Destiny' => 38615,
						'Digiweb' => 34875,
						'Discord' => 37390,
						'DoneDeal' => 34208,
						'EA' => 36413,
						'eBay' => 34169,
						'Eir' => 34210,
						'eMobile' => 34211,
						'Facebook' => 34170,
						'Facebook Messenger' => 34171,
						'Facetime' => 34584,
						'Fifa' => 36907,
						'Fortnite' => 36692,
						'Ghost Recon' => 38992,
						'Gmail' => 34172,
						'Google' => 34173,
						'Google Hangouts' => 34174,
						'Google Play' => 34175,
						'Gran Turismo' => 36949,
						'Grindr' => 36755,
						'GTA 5' => 37275,
						'Hootsuite' => 34176,
						'iCloud' => 34177,
						'Imagine' => 34425,
						'iMessage' => 34178,
						'Imgur' => 34179,
						'Instagram' => 34180,
						'iTunes' => 34181,
						'Kik' => 34182,
						'Kraken' => 36850,
						'Ladbrokes' => 37469,
						'LinkedIn' => 34183,
						'Magnet' => 34424,
						'Meteor' => 34213,
						'My Fitness Pal' => 37634,
						'Nest' => 35193,
						'Netflix' => 34184,
						'Now TV' => 38403,
						'O2' => 34206,
						'Office 365' => 35441,
						'Origin' => 36890,
						'Outlook' => 34185,
						'Overwatch' => 36484,
						'Paddy Power' => 38360,
						'Pinterest' => 34186,
						'Playstation Network' => 34187,
						'PlentyOfFish' => 37417,
						'Pokémon Go' => 35758,
						'Rabodirect' => 34979,
						'Rainbow Six' => 36414,
						'Red Dead Redemption' => 38288,
						'Reddit' => 36826,
						'Roblox' => 38756,
						'Rocket League' => 36670,
						'Ryanair' => 37253,
						'Sky' => 34212,
						'Skype' => 37018,
						'Sleepless' => 38314,
						'Snapchat' => 34188,
						'Spotify' => 34189,
						'Steam' => 34190,
						'Strava' => 38643,
						'Teamviewer' => 37631,
						'Telegram' => 37226,
						'Tinder' => 34864,
						'Tumblr' => 34191,
						'TuneIn' => 38760,
						'Twitch' => 36538,
						'Twitter' => 34192,
						'Ulster Bank' => 36070,
						'Viber' => 34193,
						'Vimeo' => 34194,
						'Virgin Media' => 34207,
						'Vodafone' => 34196,
						'Wattpad' => 34699,
						'Waze' => 34197,
						'Webex' => 34198,
						'Whatsapp' => 34199,
						'Wikipedia' => 34200,
						'Xbox Live' => 34201,
						'Yahoo' => 34202,
						'Yahoo Mail' => 34203,
						'Yahoo Messenger' => 34204,
						'Youtube' => 34205,
						'Youtube Music' => 37589,
						'Z1 Battle Royale' => 37261,
					),
					'Danmark' => array(
						'3 (Tre)' => 33694,
						'Amazon' => 33651,
						'Anthem' => 38212,
						'Apex Legends' => 38128,
						'App Store' => 38554,
						'Apple Store' => 34452,
						'Battlefield' => 37097,
						'Bet365' => 38813,
						'Bibob' => 33841,
						'Binance' => 36930,
						'Blizzard Battle.net' => 36162,
						'Call of Duty' => 36707,
						'CBB Mobil' => 33840,
						'Counter-strike' => 36171,
						'Crunchyroll' => 36721,
						'Danske Bank' => 33687,
						'DBA' => 33700,
						'Dead By Daylight' => 37427,
						'Deezer' => 33835,
						'Destiny' => 36593,
						'Discord' => 36682,
						'DMI' => 36121,
						'Dota 2' => 36398,
						'EA' => 35496,
						'eBay' => 34862,
						'EnergiMidt' => 34435,
						'Epic Games Store' => 39025,
						'Ewii' => 34436,
						'Facebook' => 33652,
						'Facebook Messenger' => 33653,
						'Faceit' => 38542,
						'Facetime' => 34590,
						'Fifa' => 36621,
						'For Honor' => 36163,
						'Fortnite' => 36690,
						'Fullrate' => 34433,
						'Ghost Recon' => 39002,
						'Gmail' => 33654,
						'Google' => 33655,
						'Google Drive' => 36606,
						'Google Hangouts' => 33656,
						'Google Play' => 33657,
						'Gran Turismo' => 36915,
						'GTA 5' => 36170,
						'Guild Wars 2' => 36469,
						'HBO Nordic' => 35605,
						'iCloud' => 33658,
						'iMessage' => 33659,
						'Instagram' => 33660,
						'iTunes' => 33661,
						'Kik' => 33705,
						'Kraken' => 36851,
						'Kviknet' => 38016,
						'League of Legends' => 36166,
						'LinkedIn' => 33701,
						'Minecraft' => 37282,
						'Net 1' => 33725,
						'Netflix' => 33689,
						'Nordea' => 33688,
						'Office 365' => 35440,
						'OneDrive' => 36867,
						'Origin' => 36894,
						'Outlook' => 33662,
						'Overwatch' => 36165,
						'Path of Exile' => 36482,
						'Playerunknown\'s Battlegrounds' => 36334,
						'Playstation Network' => 33663,
						'Pokémon Go' => 35753,
						'Rainbow Six' => 36161,
						'Realm Royale' => 37306,
						'Red Dead Redemption' => 38306,
						'Reddit' => 36824,
						'Roblox' => 36612,
						'Rocket League' => 35977,
						'Sea of Thieves' => 37122,
						'Skype' => 33686,
						'Snapchat' => 33696,
						'Spotify' => 33697,
						'Steam' => 34277,
						'Stofa' => 34434,
						'TDC' => 33691,
						'Teamviewer' => 35693,
						'Telegram' => 37181,
						'Telenor' => 33692,
						'Telia' => 33693,
						'Tinder' => 34861,
						'Twitch' => 35508,
						'Twitter' => 33664,
						'Uplay PC' => 35610,
						'Viaplay' => 37292,
						'Viber' => 33698,
						'Warframe' => 36703,
						'Whatsapp' => 33703,
						'Wikipedia' => 33665,
						'Wordfeud' => 33702,
						'World of Warcraft' => 36168,
						'World of Warships' => 38013,
						'Xbox Live' => 33666,
						'Yahoo Mail' => 37043,
						'Youmusic' => 33699,
						'Yousee' => 33695,
						'Youtube' => 33667,
						'Z1 Battle Royale' => 37265,
					),
					'Sverige' => array(
						'3 (Tre)' => 33722,
						'A3' => 38249,
						'Amazon' => 33668,
						'Anthem' => 38190,
						'Apex Legends' => 38115,
						'App Store' => 38101,
						'Apple Store' => 34450,
						'Bahnhof' => 34417,
						'BankID' => 33845,
						'Battlefield' => 37093,
						'Bet365' => 38812,
						'Binance' => 36933,
						'Blizzard Battle.net' => 34484,
						'Blocket' => 33716,
						'Boxer' => 37572,
						'Bredband2' => 34418,
						'Bredbandsbolaget' => 33843,
						'Bredbandsson' => 36049,
						'Call of Duty' => 35539,
						'Com Hem' => 34416,
						'Counter-strike' => 36172,
						'Crunchyroll' => 36719,
						'Dead By Daylight' => 36598,
						'Destiny' => 35510,
						'Discord' => 36764,
						'Dota 2' => 35876,
						'EA' => 35509,
						'eBay' => 34863,
						'Epic Games Store' => 39023,
						'Escape from Tarkov' => 38107,
						'Eurosport Player' => 36613,
						'Facebook' => 33669,
						'Facebook Messenger' => 33670,
						'Faceit' => 39039,
						'Facetime' => 34589,
						'Fifa' => 36909,
						'For Honor' => 35998,
						'Fortnite' => 36685,
						'Ghost Recon' => 39003,
						'Glocalnet' => 33842,
						'Gmail' => 33671,
						'Google' => 33672,
						'Google Drive' => 36604,
						'Google Hangouts' => 33673,
						'Google Play' => 33674,
						'Gran Turismo' => 36914,
						'Grindr' => 38739,
						'GTA 5' => 35528,
						'Guild Wars 2' => 36466,
						'Halebop' => 33726,
						'Handelsbanken' => 33718,
						'Hay Day' => 38214,
						'HBO Nordic' => 35606,
						'Hearthstone' => 38659,
						'Hue' => 37816,
						'iCloud' => 33675,
						'Ikano Bank' => 36578,
						'iMessage' => 33676,
						'Instagram' => 33677,
						'iTunes' => 33678,
						'Kik' => 33704,
						'Kraken' => 36829,
						'League of Legends' => 36167,
						'LinkedIn' => 33714,
						'Minecraft' => 37281,
						'Net 1' => 33724,
						'Netflix' => 33706,
						'Nordea' => 33717,
						'Office 365' => 35439,
						'OneDrive' => 36869,
						'Origin' => 36898,
						'Outlook' => 33679,
						'Overwatch' => 36150,
						'Path of Exile' => 36480,
						'Playerunknown\'s Battlegrounds' => 36333,
						'Playstation Network' => 33707,
						'Pokémon Go' => 35749,
						'Rainbow Six' => 36148,
						'Realm Royale' => 37307,
						'Red Dead Redemption' => 38285,
						'Reddit' => 35883,
						'Riksnet' => 37486,
						'Roblox' => 36611,
						'Rocket League' => 35487,
						'Sea of Thieves' => 37114,
						'SEB' => 33719,
						'SF Anytime' => 37573,
						'SkandiaBanken' => 34021,
						'Skype' => 33708,
						'Slack' => 37495,
						'Snapchat' => 33709,
						'Soundcloud' => 37228,
						'Sparbanken Öresund' => 34310,
						'Spotify' => 33838,
						'Steam' => 34135,
						'Swedbank' => 33713,
						'Swish' => 35777,
						'Teamviewer' => 35692,
						'Tele2' => 33721,
						'Telegram' => 35969,
						'Telenor' => 33723,
						'Telia' => 33720,
						'Telldus' => 36653,
						'The Elder Scrolls Online' => 36033,
						'Tinder' => 36458,
						'Tradera' => 33715,
						'Tumblr' => 36713,
						'Tweakbox' => 38905,
						'Twitch' => 35507,
						'Twitter' => 33710,
						'Uplay PC' => 35609,
						'Viaplay' => 37291,
						'Viber' => 37502,
						'Warframe' => 36701,
						'Whatsapp' => 33711,
						'Wikipedia' => 33682,
						'Wordfeud' => 33712,
						'World of Tanks' => 35488,
						'World of Warcraft' => 36169,
						'World of Warships' => 38011,
						'Xbox Live' => 33683,
						'Yahoo Mail' => 37044,
						'Youtube' => 33684,
						'Z1 Battle Royale' => 35493,
					),
					'Italia' => array(
						'3 Italia' => 33154,
						'Airbnb' => 37345,
						'Aircomm' => 36015,
						'Alexa' => 38031,
						'AlternatYva' => 37556,
						'Amazon' => 33174,
						'Amazon Prime Video' => 36975,
						'Anthem' => 38189,
						'Anydesk' => 37491,
						'Apex Legends' => 38119,
						'App Store' => 37733,
						'Apple Store' => 34468,
						'Aruba' => 37217,
						'Banco di Napoli' => 33181,
						'Battlefield' => 37095,
						'Betclic' => 39047,
						'Binance' => 36937,
						'Blizzard Battle.net' => 37092,
						'BNL' => 33180,
						'Brawl Stars' => 38821,
						'Bwin' => 35072,
						'Call of Duty' => 35537,
						'Clash of Clans' => 34361,
						'Clash Royale' => 38956,
						'Cloudflare' => 38620,
						'Coinbase' => 36801,
						'Coopvoce' => 34921,
						'Counter-strike' => 36650,
						'Credito Emiliano - Credem' => 33182,
						'Crunchyroll' => 38095,
						'Dazn' => 37442,
						'Dead By Daylight' => 36627,
						'Deezer' => 33839,
						'Destiny' => 36590,
						'Discord' => 36767,
						'Dota 2' => 35878,
						'Dropbox' => 33175,
						'EA' => 34498,
						'EA Sports UFC' => 36553,
						'eBay' => 32816,
						'Elite: Dangerous' => 37774,
						'Eolo' => 37763,
						'Epic Games Store' => 39024,
						'Escape from Tarkov' => 39056,
						'Facebook' => 32812,
						'Facebook Messenger' => 32813,
						'Facetime' => 34598,
						'Fallout' => 37668,
						'Fastweb' => 33160,
						'Fifa' => 36910,
						'Fineco' => 33167,
						'Flickr' => 37949,
						'For Honor' => 35990,
						'Fortnite' => 36686,
						'Friday the 13th The Game' => 37564,
						'Ghost Recon' => 38999,
						'Gmail' => 32815,
						'Google' => 32805,
						'Google Drive' => 36607,
						'Google Hangouts' => 32806,
						'Google Play' => 32807,
						'Gran Turismo' => 36874,
						'Grindr' => 36757,
						'GTA5 ' => 35918,
						'Guild Wars 2' => 36472,
						'Ho' => 37408,
						'Hue' => 37813,
						'iCloud' => 33169,
						'Iliad' => 37214,
						'iMessage' => 33164,
						'Infinity' => 35972,
						'Infostrada' => 34711,
						'ING Direct' => 33168,
						'Instagram' => 33170,
						'Intesa Sanpaolo' => 33179,
						'iTunes' => 33159,
						'Kena Mobile' => 36364,
						'Kraken' => 36771,
						'League of Legends' => 37759,
						'Libero' => 33178,
						'LinkedIn' => 33177,
						'Linkem' => 34475,
						'Lottomatica' => 35068,
						'Lycamobile' => 38691,
						'Mc-link' => 34476,
						'Mediaset Premium' => 33162,
						'Mediaset TV Free' => 35973,
						'My Fitness Pal' => 37638,
						'Netflix' => 35568,
						'Neverwinter' => 36675,
						'NGI' => 34474,
						'Office 365' => 35443,
						'Onedrive' => 35411,
						'Origin' => 36897,
						'Outlook' => 33163,
						'Overwatch' => 36384,
						'Paddy Power' => 35069,
						'Paladins' => 36379,
						'Path of Exile' => 37726,
						'Paypal' => 33166,
						'Player Unknown\'s Battlegrounds' => 36567,
						'Playstation Network' => 32818,
						'Pokémon Go' => 35737,
						'Poste Italiane' => 37361,
						'PosteMobile' => 37360,
						'Quizduello' => 34299,
						'Rainbow Six' => 36045,
						'Red Dead Redemption' => 38284,
						'Reddit' => 37367,
						'Roblox' => 38916,
						'Rocket League' => 35979,
						'Ruzzle' => 33967,
						'Ryanair' => 37519,
						'Sea of Thieves' => 37121,
						'Sisal' => 35066,
						'Sky' => 33155,
						'Skype' => 32821,
						'Slack' => 37341,
						'SNAI' => 35067,
						'Snapchat' => 36446,
						'Spotify' => 33176,
						'Steam' => 34136,
						'Tango' => 33743,
						'Teamviewer' => 35455,
						'Telegram' => 34904,
						'The elder scrolls online' => 37327,
						'TIM' => 33158,
						'TimMusic' => 35913,
						'TimVision' => 35908,
						'Tinder' => 36549,
						'Tiscali' => 33161,
						'Tumblr' => 36712,
						'Tweakbox' => 38344,
						'Twitch' => 35604,
						'Twitter' => 32814,
						'UniCredit' => 33171,
						'Uplay PC' => 35613,
						'Viber' => 33403,
						'Virgilio' => 36459,
						'Vodafone' => 33156,
						'Warface' => 38765,
						'Warframe' => 36492,
						'WeBank' => 33173,
						'WeTransfer' => 36445,
						'Whatsapp' => 32820,
						'Wifi Trenitalia' => 35974,
						'Wikipedia' => 33172,
						'William Hill' => 35070,
						'Wind' => 33157,
						'World of Warships' => 38012,
						'Xbox Live' => 32819,
						'Yahoo' => 32809,
						'Yahoo Mail' => 32810,
						'Yahoo Messenger' => 32811,
						'Youtube' => 32808,
						'Z1 Battle Royale' => 37254,
						'ZoHo' => 37554,
					),
					'South Africa' => array(
						'ABSA' => 33599,
						'Afrihost' => 35660,
						'Amazon' => 33578,
						'Apex Legends' => 38157,
						'Apple Store' => 34458,
						'Axxess' => 35618,
						'Bidorbuy' => 33596,
						'Binance' => 36941,
						'Bing' => 33579,
						'Blizzard Battle.net' => 37661,
						'Call of Duty' => 34152,
						'Capitec' => 36966,
						'Cell C' => 33602,
						'Clash Royale' => 38946,
						'Cool Ideas' => 38326,
						'Counter-strike' => 36512,
						'Cybersmart' => 34619,
						'Dead By Daylight' => 37435,
						'Deezer' => 33834,
						'Destiny' => 38981,
						'DirecTV Now' => 35915,
						'Discord' => 38611,
						'Discovery' => 38334,
						'Dota 2' => 36428,
						'DSTv' => 33607,
						'EA' => 34507,
						'eBay' => 33581,
						'Eskom' => 38333,
						'Facebook' => 33582,
						'Facebook Messenger' => 37737,
						'Fifa' => 38436,
						'First National Bank (FNB)' => 33597,
						'Fortnite' => 36710,
						'Ghost Recon' => 38994,
						'Gmail' => 33583,
						'Google' => 33584,
						'Google Hangouts' => 33585,
						'Google Play' => 33586,
						'Gov.za' => 38328,
						'GTA 5' => 37273,
						'Guild Wars 2' => 36501,
						'Gumtree' => 33592,
						'iBurst' => 34620,
						'iCloud' => 33587,
						'Imaginet' => 38325,
						'Instagram' => 33588,
						'Internet Solutions' => 38332,
						'iTunes' => 33589,
						'Kik' => 33590,
						'Kraken' => 36985,
						'League of Legends' => 38633,
						'LinkedIn' => 33591,
						'Luno' => 37012,
						'Metrofibre' => 38335,
						'MTN' => 33601,
						'MWEB' => 33606,
						'Nedbank' => 35461,
						'Neotel' => 35426,
						'Netflix' => 36390,
						'Octotel' => 38327,
						'Office 365' => 35444,
						'OLX' => 33255,
						'Openserve' => 38331,
						'Origin' => 36886,
						'Outlook' => 33566,
						'Overwatch' => 36149,
						'Paypal' => 33567,
						'Pinterest' => 33568,
						'Player Unknown\'s Battlegrounds' => 36642,
						'Playstation Network' => 33569,
						'Pokémon Go' => 35756,
						'Rain' => 37397,
						'Rainbow Six' => 37738,
						'Reddit' => 38362,
						'Safricom' => 35139,
						'SARS' => 38336,
						'Seacom' => 38329,
						'Showmax' => 37149,
						'Skype' => 33570,
						'Snapchat' => 33571,
						'Standard Bank' => 33598,
						'Steam' => 34223,
						'Takealot' => 36777,
						'Teamviewer' => 37480,
						'Telegram' => 37184,
						'Telkom' => 33603,
						'The elder scrolls online' => 37325,
						'The Simpsons Tapped out' => 35903,
						'Tinder' => 37166,
						'Twitch' => 38702,
						'Twitter' => 33572,
						'Viber' => 33595,
						'Virgin Mobile' => 38324,
						'Vodacom' => 33600,
						'Vox' => 35368,
						'Vumatel' => 37660,
						'Warframe' => 37125,
						'Webafrica' => 38330,
						'WeChat' => 33594,
						'Whatsapp' => 33573,
						'Wikipedia' => 33574,
						'Xbox Live' => 34285,
						'Yahoo' => 33575,
						'Yahoo Mail' => 33576,
						'Youtube' => 33577,
					),
					'India' => array(
						'ACT' => 34764,
						'Aircel' => 33257,
						'Airtel' => 33233,
						'Alexa' => 36921,
						'AliExpress' => 37824,
						'Amazon' => 35118,
						'Amazon Prime Music' => 37583,
						'Amazon Prime Video' => 36974,
						'Amazon Web Services' => 38411,
						'Apex Legends' => 38180,
						'App Store' => 38556,
						'Apple Store' => 34459,
						'Bank of Baroda' => 37676,
						'Bank of India' => 33250,
						'Bharat Sanchar Nigam Limited (BSNL)' => 33232,
						'Binance' => 36932,
						'Bitbucket' => 36988,
						'Boom Beach' => 34782,
						'Brawl Stars' => 38822,
						'Call of Duty' => 34153,
						'Cherrinet' => 37677,
						'Clash of Clans' => 36872,
						'Clash Royale' => 38955,
						'Cloudflare' => 38652,
						'Counter-strike' => 38240,
						'Destiny' => 38989,
						'Discord' => 38106,
						'Dota 2' => 36393,
						'Dropbox' => 33237,
						'EA' => 34508,
						'eBay' => 32863,
						'Facebook' => 32860,
						'Facebook Messenger' => 33238,
						'Facetime' => 34596,
						'Fifa' => 38399,
						'Flipkart' => 33252,
						'Fortnite' => 36843,
						'GitHub' => 37606,
						'Gmail' => 32862,
						'Go Daddy' => 37499,
						'Google' => 32857,
						'Google Drive' => 38261,
						'Google Hangouts' => 32869,
						'Google Home' => 37344,
						'Google Play' => 33239,
						'GTA 5' => 37272,
						'Haptik' => 34762,
						'Hathway' => 37673,
						'Hay Day' => 34787,
						'HDFC Bank' => 33231,
						'ICICI Bank' => 37674,
						'iCloud' => 33240,
						'IDBI Bank' => 37678,
						'Idea Cellular' => 33234,
						'Idian Bank' => 37670,
						'iMessage' => 33248,
						'Instagram' => 33241,
						'IRCTC' => 37671,
						'iTunes' => 33230,
						'Jio' => 37460,
						'Kik' => 33351,
						'Line' => 33400,
						'LinkedIn' => 33242,
						'Mahanagar Telephone Nigam Limited (MTNL)' => 33258,
						'Microsoft Azure' => 36112,
						'MTS' => 33260,
						'Naukri' => 33253,
						'Netflix' => 37299,
						'Office 365' => 37174,
						'OLX' => 33593,
						'ooVoo' => 34084,
						'Origin' => 38378,
						'Outlook' => 33243,
						'Paypal' => 33244,
						'Paytm' => 33401,
						'Pinterest' => 37231,
						'Player Unknown\'s Battlegrounds' => 36643,
						'Playstation Network' => 32865,
						'Pokémon Go' => 35755,
						'Quora' => 37473,
						'Rainbow Six' => 36412,
						'Reddit' => 38061,
						'Reliance' => 33236,
						'Roblox' => 38921,
						'Salesforce' => 34734,
						'Sarahah' => 36513,
						'Skype' => 32868,
						'Snapchat' => 36741,
						'Spotify' => 37079,
						'Standard Chartered' => 33235,
						'State Bank of India (SBI)' => 33251,
						'Steam' => 35930,
						'Swiggy' => 37675,
						'Tango' => 33744,
						'Tata Docomo' => 33256,
						'Teamviewer' => 34346,
						'Telegram' => 36582,
						'Tiktok' => 38661,
						'Tinder' => 37167,
						'Tumblr' => 37641,
						'Twitch' => 38355,
						'Twitter' => 32861,
						'Uber Eats' => 38898,
						'Udemy' => 38389,
						'Uninor' => 33259,
						'Uplay PC' => 36628,
						'Viber' => 33049,
						'Videocon' => 33261,
						'Vimeo' => 37232,
						'Vodafone' => 33254,
						'Warframe' => 37124,
						'Wattpad' => 34698,
						'Waze' => 33408,
						'Webex' => 34163,
						'WeChat' => 33396,
						'Whatsapp' => 32867,
						'Wikipedia' => 33245,
						'Xbox Live' => 32866,
						'Yahoo' => 32859,
						'Yahoo Mail' => 33246,
						'Yahoo Messenger' => 33247,
						'You Broadband' => 34763,
						'Youtube' => 32858,
						'Zee5' => 38647,
						'Zerodha' => 37207,
						'ZoHo' => 37552,
						'Zomato' => 37672,
					),
					'Portugal' => array(
						'ActivoBank' => 33959,
						'Apex Legends' => 38127,
						'Apple Store' => 34464,
						'Banco Espírito Santo' => 33961,
						'Banco Santander Totta' => 33960,
						'Binance' => 36945,
						'Bing' => 33925,
						'Blizzard Battle.net' => 37225,
						'Cabovisão' => 33956,
						'Caixa Geral de Depósitos' => 33957,
						'Call of Duty' => 38982,
						'Clash Royale' => 38957,
						'Counter-Strike' => 36651,
						'Dead By Daylight' => 37429,
						'Deezer' => 33927,
						'Destiny' => 38964,
						'Discord' => 37388,
						'Dota 2' => 38479,
						'EA' => 36452,
						'eBay' => 33928,
						'Facebook' => 33929,
						'Facebook Messenger' => 34847,
						'Facetime' => 34586,
						'Fifa' => 36905,
						'Fortnite' => 36695,
						'Gmail' => 33930,
						'Go Daddy' => 34849,
						'Google' => 33931,
						'Google Play' => 33932,
						'GTA 5' => 36857,
						'HBO' => 38379,
						'iCloud' => 33933,
						'iMessage' => 33934,
						'Instagram' => 33963,
						'iTunes' => 33935,
						'Kik' => 33943,
						'Kraken' => 36980,
						'League of Legends' => 38635,
						'LinkedIn' => 33936,
						'MEO' => 33950,
						'Millennium Bcp' => 33958,
						'Montepio' => 33962,
						'Netflix' => 37301,
						'NOS' => 33952,
						'Office 365' => 37175,
						'OLX' => 33949,
						'OneDrive' => 36870,
						'Optimus' => 33951,
						'Origin' => 36892,
						'Outlook' => 33937,
						'Overwatch' => 37082,
						'Paypal' => 33938,
						'Pinterest' => 37373,
						'Player Unknown\'s Battlegrounds' => 36566,
						'Playstation Network' => 33939,
						'Pokémon Go' => 35754,
						'Rainbow Six' => 36454,
						'Reddit' => 38068,
						'Roblox' => 38920,
						'Rocket League' => 36668,
						'Skype' => 33940,
						'Snapchat' => 36742,
						'Spotify' => 33964,
						'Steam' => 34138,
						'Teamviewer' => 35691,
						'Telegram' => 37186,
						'Tinder' => 37921,
						'Twitch' => 36453,
						'Twitter' => 33941,
						'Uplay PC' => 38651,
						'Uzo' => 33954,
						'Viber' => 33942,
						'Vodafone' => 33953,
						'Warframe' => 37135,
						'Whatsapp' => 34855,
						'Wikipedia' => 33944,
						'Xbox Live' => 33945,
						'Yahoo' => 33946,
						'Yahoo Mail' => 33947,
						'Youtube' => 33948,
						'Z1 Battle Royale' => 37264,
					),
					'Schweiz' => array(
						'Airbnb' => 37666,
						'Anthem' => 38205,
						'Apex Legends' => 38130,
						'App Store' => 35583,
						'Apple Store' => 34462,
						'Battlefield' => 38050,
						'Bet365' => 38831,
						'Binance' => 36935,
						'Blizzard Battle.net' => 36569,
						'Call of Duty' => 34157,
						'Clash Royale' => 38958,
						'Coinbase' => 36805,
						'Counter-strike' => 36646,
						'Crunchyroll' => 38144,
						'Dazn' => 36509,
						'Dead By Daylight' => 37413,
						'Deezer' => 34038,
						'Destiny' => 36591,
						'Discord' => 37389,
						'Dota 2' => 35402,
						'Dropbox' => 34039,
						'EA' => 34503,
						'eBay' => 34040,
						'Epic Games Store' => 39026,
						'Evard' => 35642,
						'Facebook' => 34041,
						'Facebook Messenger' => 34885,
						'Facetime' => 34585,
						'Fifa' => 37089,
						'flashcable' => 37202,
						'Flickr' => 34042,
						'For Honor' => 35997,
						'Fortnite' => 36688,
						'Ghost Recon' => 36006,
						'Gmail' => 34043,
						'GMX' => 34044,
						'Google' => 34045,
						'Google Hangouts' => 34046,
						'Google Play' => 34047,
						'Green' => 36971,
						'Grindr' => 38742,
						'GTA 5' => 35502,
						'Guild Wars 2' => 36465,
						'Hay Day' => 34853,
						'iCloud' => 34048,
						'ICQ' => 34049,
						'iMessage' => 34050,
						'Instagram' => 34051,
						'iTunes' => 34052,
						'Kik' => 34054,
						'Kraken' => 36807,
						'League of Legends' => 35574,
						'LinkedIn' => 34055,
						'Lovoo' => 35401,
						'Mail.de' => 38629,
						'Netatmo' => 38467,
						'Netflix' => 34632,
						'Nitrado' => 35547,
						'Office 365' => 36581,
						'OneDrive' => 35413,
						'Origin' => 36891,
						'Outlook' => 34057,
						'Overwatch' => 36152,
						'Peoplefone' => 36602,
						'Playerunknown\'s Battlegrounds' => 36560,
						'Playstation Network' => 34087,
						'Pokémon Go' => 35744,
						'PostFinance' => 36048,
						'Protonmail' => 35643,
						'Quickline' => 36970,
						'Quizduell' => 34529,
						'Rainbow Six' => 36147,
						'Red Dead Redemption' => 37741,
						'Reddit' => 38067,
						'Ricardo' => 34079,
						'Rocket League' => 35486,
						'Salt' => 35602,
						'Search.ch' => 34080,
						'Sky Sport' => 37069,
						'Skype' => 34059,
						'Snapchat' => 34060,
						'Spotify' => 34061,
						'SRF' => 34081,
						'Steam' => 34226,
						'Sunrise' => 34078,
						'Swisscom' => 34077,
						'Tango' => 34062,
						'Teamviewer' => 34616,
						'Telegram' => 35968,
						'The elder scrolls online' => 35763,
						'Threema' => 34256,
						'Tinder' => 34244,
						'Tumblr' => 34063,
						'TuneIn' => 38775,
						'Tutti' => 36014,
						'Tweakbox' => 38904,
						'Twint' => 38183,
						'Twitch' => 35505,
						'Twitter' => 34064,
						'UBS' => 34082,
						'UPC' => 34075,
						'Uplay PC' => 34690,
						'Viber' => 34065,
						'Viewster' => 34325,
						'Vimeo' => 34066,
						'Waze' => 34067,
						'Web.de' => 34068,
						'Whatsapp' => 34069,
						'Wikipedia' => 34070,
						'World of Warships' => 38015,
						'Xbox Live' => 34088,
						'Yahoo Mail' => 34072,
						'Yahoo Messenger' => 34073,
						'Yallo' => 37298,
						'Youtube' => 34074,
						'Z1 Battle Royale' => 35492,
						'Zattoo' => 35366,
					),
					'Singapore' => array(
						'Airbnb' => 37608,
						'Apex Legends' => 38182,
						'App Store' => 37735,
						'Apple Store' => 34682,
						'Binance' => 36944,
						'Bing' => 34652,
						'Blizzard Battle.net' => 36431,
						'Brawl Stars' => 38820,
						'Call of Duty' => 39051,
						'Clash of Clans' => 34667,
						'Clash Royale' => 38952,
						'Counter-strike' => 36556,
						'DBS' => 34658,
						'Destiny' => 38986,
						'Discord' => 37100,
						'Dota 2' => 35875,
						'Dropbox' => 34671,
						'EA' => 36429,
						'Facebook' => 34645,
						'Facebook Messenger' => 34646,
						'Facetime' => 34681,
						'Fifa' => 38398,
						'Fortnite' => 37321,
						'Ghost Recon' => 38995,
						'Gmail' => 34647,
						'Google' => 34648,
						'Google Drive' => 34649,
						'Google Hangouts' => 38364,
						'Google Play' => 38519,
						'Grindr' => 36754,
						'GTA 5' => 37278,
						'HSBC' => 34672,
						'iCloud' => 34685,
						'iMessage' => 34684,
						'Instagram' => 34665,
						'iTunes' => 34683,
						'League of Legends' => 38748,
						'Line' => 34740,
						'LinkedIn' => 34656,
						'M1' => 34662,
						'Microsoft Azure' => 36113,
						'Minecraft' => 38738,
						'My Republic' => 36463,
						'Netflix' => 36391,
						'Office 365' => 37173,
						'OkCupid' => 38490,
						'Origin' => 38377,
						'Outlook' => 34673,
						'Overwatch' => 36389,
						'Path of Exile' => 37723,
						'Player Unknown\'s Battlegrounds' => 36361,
						'Playstation Network' => 34668,
						'Pokémon Go' => 35757,
						'POSB' => 34738,
						'Rainbow Six' => 36382,
						'Reddit' => 37475,
						'Roblox' => 37286,
						'SingTel' => 34661,
						'Skype' => 36418,
						'Snapchat' => 34666,
						'Spotify' => 34739,
						'Standard Chartered' => 34743,
						'Starhub' => 34663,
						'Steam' => 36430,
						'Summoners War' => 37421,
						'Taobao' => 34660,
						'Telegram' => 36381,
						'Tinder' => 37137,
						'Tumblr' => 36711,
						'Tweakbox' => 38345,
						'Twitch' => 36539,
						'Twitter' => 34659,
						'Uplay PC' => 37521,
						'Viber' => 34670,
						'Viewqwest' => 37506,
						'Warframe' => 36494,
						'WeChat' => 34674,
						'Whatsapp' => 34664,
						'Whisper' => 34624,
						'Wikipedia' => 34655,
						'Xbox Live' => 34669,
						'Yahoo' => 34654,
						'Yahoo Mail' => 34653,
						'Youtube' => 34650,
					),
					'Türkiye' => array(
						'Akbank' => 33783,
						'Anthem' => 38195,
						'Apex Legends' => 38121,
						'Apple Store' => 34451,
						'Battlefield' => 38449,
						'Binance' => 36952,
						'Blizzard Battle.net' => 37224,
						'Call of Duty' => 38940,
						'Counter-strike' => 36652,
						'D-Smart' => 34422,
						'Dead By Daylight' => 37433,
						'Denizbank' => 33788,
						'Destiny' => 38984,
						'Discord' => 36766,
						'Dota 2' => 36396,
						'EA' => 36157,
						'Facebook' => 33748,
						'Facebook Messenger' => 33749,
						'Facetime' => 34588,
						'Fifa' => 37087,
						'Finansbank' => 33786,
						'For Honor' => 37369,
						'Fortnite' => 36698,
						'Garanti' => 33780,
						'GittiGidiyor' => 33779,
						'Gmail' => 33750,
						'Google' => 33751,
						'Google Hangouts' => 33752,
						'Google Play' => 33753,
						'Gran Turismo' => 36947,
						'GTA 5' => 37276,
						'HalkBank' => 33784,
						'HSBC' => 33790,
						'iCloud' => 33754,
						'iMessage' => 33755,
						'ING Bank' => 33789,
						'Instagram' => 33732,
						'iTunes' => 33756,
						'Kik' => 33757,
						'Kraken' => 36986,
						'LinkedIn' => 33758,
						'Messageme' => 33727,
						'Netflix' => 37300,
						'Office 365' => 38058,
						'Origin' => 36901,
						'Outlook' => 33759,
						'Overwatch' => 36386,
						'Player Unknown\'s Battlegrounds' => 36456,
						'Playstation Network' => 33760,
						'Rainbow Six' => 36154,
						'Reddit' => 38064,
						'Roblox' => 38915,
						'Rocket League' => 36669,
						'Sahibinden' => 33778,
						'Skype' => 33761,
						'Snapchat' => 33762,
						'Steam' => 37322,
						'Tango' => 33730,
						'Telegram' => 37090,
						'Tinder' => 37911,
						'Ttnet' => 33776,
						'Türk Ekonomi Bankası (TEB)' => 33791,
						'Türk Telekom' => 33771,
						'Turkcell' => 33774,
						'Türkiye İş Bankası' => 33781,
						'Türksat  Kablo' => 33772,
						'Twitch' => 35506,
						'Twitter' => 33613,
						'Uplay PC' => 36156,
						'VakıfBank' => 33785,
						'Viber' => 33733,
						'Vodafone' => 33775,
						'Warframe' => 37128,
						'Whatsapp' => 33764,
						'Xbox Live' => 33766,
						'Yahoo Mail' => 38885,
						'Yandex' => 33777,
						'Yapı Kredi' => 33782,
						'Youtube' => 33767,
						'Ziraat Bankası' => 33787,
					),
					'Suomi' => array(
						'Aktia' => 36308,
						'Apex Legends' => 38123,
						'Battlefield' => 37096,
						'Binance' => 36929,
						'Blizzard Battle.net' => 36299,
						'Call of Duty' => 36706,
						'Clash Royale' => 38947,
						'Counter-strike' => 36645,
						'Crunchyroll' => 38097,
						'Dankse Bank' => 36307,
						'Dead By Daylight' => 37428,
						'Destiny' => 38531,
						'Discord' => 36681,
						'DNA' => 36304,
						'Dota 2' => 36434,
						'EA' => 36295,
						'Elisa' => 36303,
						'Epic Games Store' => 39030,
						'Escape from Tarkov' => 39057,
						'Facebook' => 36237,
						'Facebook Messenger' => 36240,
						'Faceit' => 39038,
						'Fifa' => 37603,
						'Fortnite' => 36691,
						'Ghost Recon' => 38998,
						'Gmail' => 36254,
						'Google' => 36253,
						'Google Play' => 38522,
						'Gran Turismo' => 36912,
						'GTA 5' => 36844,
						'Guild Wars 2' => 36471,
						'HBO Nordic' => 36302,
						'iCloud' => 38841,
						'Instagram' => 36435,
						'Kraken' => 36852,
						'League of Legends' => 38632,
						'Minecraft' => 38616,
						'Netflix' => 36252,
						'Nordea' => 36306,
						'Office 365' => 36297,
						'OP' => 36305,
						'Origin' => 36904,
						'Outlook' => 36251,
						'Overwatch' => 36250,
						'Path of Exile' => 36530,
						'Paypal' => 37347,
						'Playerunknown\'s Battlegrounds' => 36339,
						'Playstation Network' => 36249,
						'Pokémon Go' => 36248,
						'Rainbow Six' => 36247,
						'Reddit' => 36823,
						'Roblox' => 38913,
						'Rocket League' => 36300,
						'Runescape' => 38655,
						'Sea of Thieves' => 37118,
						'Skype' => 36246,
						'Slack' => 37496,
						'Snapchat' => 36245,
						'Spotify' => 37078,
						'Steam' => 36296,
						'Telegram' => 37091,
						'Telia' => 36287,
						'Tinder' => 36298,
						'Twitch' => 36436,
						'Twitter' => 36677,
						'Uplay PC' => 36244,
						'Viaplay' => 37294,
						'Viber' => 37494,
						'Warframe' => 36704,
						'Whatsapp' => 36243,
						'Wikipedia' => 38871,
						'World of Tanks' => 36673,
						'Xbox Live' => 36301,
						'Yahoo Mail' => 38883,
						'Youtube' => 36242,
						'Z1 Battle Royale' => 37259,
					),
					'France' => array(
						'Albion Online' => 38796,
						'Alexa' => 38030,
						'Alice' => 34009,
						'Amazon' => 32693,
						'Amazon Web Services' => 38109,
						'Ameli' => 38705,
						'Amen' => 35888,
						'Anthem' => 38207,
						'Apex Legends' => 38116,
						'App Store' => 35582,
						'Apple Store' => 34469,
						'AXA Banque' => 33427,
						'Bankin\'' => 37592,
						'Banque Populaire' => 33432,
						'Battlefield' => 38057,
						'Betclic' => 39046,
						'Binance' => 36939,
						'Bing' => 32696,
						'BlaBlaCar' => 36089,
						'Blizzard Battle.net' => 36437,
						'Blogger' => 32697,
						'BNP Paribas' => 32749,
						'Boom Beach' => 35154,
						'Bouygues Télécom' => 32747,
						'Brawl Stars' => 38815,
						'Caisse d\'allocations familiales' => 38708,
						'Caisse d\'Epargne' => 33428,
						'Call of Duty' => 35037,
						'CanalSat' => 34034,
						'Candy Crush' => 35881,
						'Cdiscount' => 35038,
						'CIC' => 33431,
						'Clash Royale' => 38151,
						'Cloudflare' => 38622,
						'Coinbase' => 36830,
						'Completel' => 33982,
						'Compte Nickel' => 35983,
						'Counter-Strike' => 36649,
						'Crédit Agricole' => 32753,
						'Crédit Mutuel' => 33429,
						'Crunchyroll' => 38096,
						'Dartybox' => 32848,
						'Dead By Daylight' => 37425,
						'Deezer' => 32843,
						'Destiny' => 34951,
						'Discord' => 36763,
						'Dofus Touch' => 38711,
						'Dota 2' => 35877,
						'Dropbox' => 32700,
						'Duel Quiz' => 34530,
						'EA' => 32844,
						'eBay' => 32701,
						'Elite: Dangerous' => 37776,
						'Epic Games Store' => 39029,
						'Escape from Tarkov' => 39058,
						'Facebook' => 32702,
						'Facebook Messenger' => 32703,
						'Facetime' => 34602,
						'Fallout' => 37667,
						'Fifa' => 35475,
						'Flickr' => 32704,
						'Fnac' => 35065,
						'For Honor' => 35995,
						'Fortnite' => 36656,
						'Free' => 32744,
						'Gandi' => 38712,
						'Ghost Recon' => 38959,
						'GitHub' => 32705,
						'Gmail' => 32706,
						'Google' => 32707,
						'Google Agenda' => 38601,
						'Google Drive' => 36608,
						'Google Hangouts' => 32709,
						'Google Play' => 32708,
						'Gran Turismo' => 36911,
						'Grindr' => 36756,
						'GTA 5' => 35039,
						'Guild Wars 2' => 36468,
						'Hearthstone' => 38562,
						'Hootsuite' => 32710,
						'Hue' => 37815,
						'Hunt: showdown' => 38824,
						'iCloud' => 32712,
						'Idealo' => 34890,
						'iMessage' => 32713,
						'ING Direct' => 33426,
						'Instagram' => 32715,
						'iTunes' => 32716,
						'JeuxVidéo' => 32847,
						'K-net' => 37790,
						'Kraken' => 36753,
						'La Banque Postale' => 32754,
						'La Poste' => 37215,
						'La Poste Mobile' => 32752,
						'LCL (Crédit Lyonnais)' => 33424,
						'Le Bon Coin' => 32840,
						'League of Legends' => 35369,
						'LinkedIn' => 32717,
						'LycaMobile' => 32849,
						'M6 Mobile' => 32845,
						'Magic' => 37456,
						'Météo France' => 38706,
						'Microsoft Azure' => 36115,
						'Minecraft' => 32718,
						'Molotov.TV' => 35965,
						'myCanal' => 38710,
						'Netatmo' => 37957,
						'Netflix' => 34633,
						'Nintendo eShop' => 34103,
						'Nordnet' => 38709,
						'NRJ Mobile' => 32846,
						'Numéricable' => 32748,
						'OCS' => 38707,
						'Office 365' => 35126,
						'Onedrive' => 35409,
						'Online.net' => 36159,
						'Orange' => 32745,
						'Orange Bank' => 37511,
						'Origin' => 36896,
						'Outlook' => 32711,
						'Overwatch' => 36151,
						'OVH' => 34744,
						'Paladins' => 36378,
						'Path of Exile' => 36855,
						'Paypal' => 32842,
						'Photobucket' => 32721,
						'Pinterest' => 32722,
						'Player Unknown\'s Battlegrounds' => 36363,
						'Playstation Network' => 32741,
						'Pokémon Go' => 35735,
						'Prime Video' => 38457,
						'Rainbow Six' => 35562,
						'Rakuten TV' => 37596,
						'Realm Royale' => 37308,
						'Red Dead Redemption' => 38287,
						'Reddit' => 37368,
						'Roblox' => 38755,
						'Rocket League' => 35253,
						'Salesforce' => 38501,
						'Sea of Thieves' => 37117,
						'SFR' => 32746,
						'Shadow' => 37212,
						'Skype' => 32723,
						'Skyrock.com' => 33430,
						'Slack' => 37337,
						'Slideshare' => 32724,
						'Snapchat' => 33378,
						'Société Générale' => 33425,
						'Sosh' => 34830,
						'Spotify' => 32727,
						'Star Citizen' => 39037,
						'Steam' => 32742,
						'Streamlabs' => 38927,
						'Syma' => 37449,
						'Tango' => 34482,
						'Teamviewer' => 34908,
						'Telegram' => 34230,
						'The elder scrolls online' => 37326,
						'Tinder' => 34808,
						'Tumblr' => 32728,
						'TuneIn' => 38758,
						'Tweakbox' => 38347,
						'Twitch' => 35027,
						'Twitter' => 32729,
						'Uber Eats' => 38897,
						'Unibet' => 38274,
						'Uplay PC' => 35544,
						'Viber' => 33373,
						'Vimeo' => 32730,
						'Warface' => 38776,
						'Warframe' => 36368,
						'Waze' => 33410,
						'WeTransfer' => 32731,
						'Whatsapp' => 32575,
						'Wibox' => 37055,
						'Wikipedia' => 32732,
						'Wordpress.com' => 32734,
						'World of Tanks' => 36030,
						'Xbox Live' => 32743,
						'Yahoo' => 32735,
						'Yahoo Mail' => 32736,
						'Yahoo Messenger' => 32737,
						'Youtube' => 32739,
						'Z1 Battle Royale' => 37260,
						'Zynga' => 32740,
					),
					'Brasil' => array(
						'Albion Online' => 38797,
						'Alelo' => 37410,
						'Algar' => 37507,
						'Alog' => 34746,
						'Amazon' => 33206,
						'Amazon Prime Video' => 38754,
						'Amazon Web Services' => 34091,
						'America Net' => 35127,
						'Anthem' => 38211,
						'Anydesk' => 37492,
						'Apex Legends' => 38126,
						'App Store' => 39054,
						'Apple Store' => 34449,
						'Avianca' => 36519,
						'Azul' => 36358,
						'Banco Central do Brasil' => 36002,
						'Banco do Brasil' => 34037,
						'Banco Inter' => 37559,
						'Banco Itaú' => 33205,
						'Banco Safra' => 37151,
						'Banco Santander' => 33381,
						'Banestes' => 37065,
						'Banrisul' => 35425,
						'Battlefield' => 38447,
						'Betfair' => 38188,
						'Binance' => 36940,
						'Bing' => 33215,
						'Blizzard Battle.net' => 36671,
						'Bradesco' => 33197,
						'Brisanet' => 36967,
						'Buscapé' => 35167,
						'C6 Bank' => 38773,
						'Cabo Telecom' => 33991,
						'Cabonnet' => 35919,
						'Caixa Econômica Federal' => 33191,
						'Call of Duty' => 38163,
						'Claro' => 33199,
						'Clash of Clans' => 37303,
						'Clash Royale' => 36053,
						'Clear' => 37557,
						'Cloudflare' => 38621,
						'Clusterweb' => 35967,
						'Copel Telecom' => 35671,
						'Correios' => 34611,
						'Counter-Strike' => 38162,
						'Credit Suisse' => 37978,
						'Crunchyroll' => 37138,
						'Dataprev' => 35137,
						'Dead By Daylight' => 36596,
						'Deezer' => 33385,
						'Destiny' => 38943,
						'Discord' => 37392,
						'Dota 2' => 35879,
						'Dropbox' => 33214,
						'EA' => 34500,
						'eBay' => 33207,
						'eCAC' => 34961,
						'Embratel' => 33999,
						'Enem' => 35136,
						'Epic Games Store' => 39031,
						'eSocial' => 35427,
						'Faceapp' => 38696,
						'Facebook' => 33184,
						'Facebook Messenger' => 34846,
						'Facetime' => 34597,
						'Feedly' => 34723,
						'Fifa' => 37769,
						'For Honor' => 37371,
						'Fortnite' => 36699,
						'Free Fire' => 38804,
						'Garena' => 38301,
						'Getnet' => 36745,
						'GitHub' => 38591,
						'Globo' => 34721,
						'Gmail' => 33194,
						'Go Daddy' => 34848,
						'Gol' => 38600,
						'Google' => 33186,
						'Google Cloud' => 38535,
						'Google Play' => 33211,
						'GTA 5' => 34757,
						'GVT' => 33562,
						'HBO' => 36354,
						'Hostgator' => 34745,
						'Hostnet' => 35850,
						'HSBC' => 34644,
						'iCloud' => 33219,
						'ICQ' => 34765,
						'iFood ' => 36960,
						'iMessage' => 33165,
						'Instagram' => 33204,
						'ITMNetworks' => 36094,
						'iTunes' => 33208,
						'Jurassic World Alive' => 37335,
						'Kik' => 34856,
						'KingHost' => 34957,
						'Kraken' => 36979,
						'League of Legends' => 39018,
						'Ligue Telecom' => 37526,
						'Line' => 33736,
						'LinkedIn' => 33210,
						'Locaweb' => 34722,
						'Mandic' => 36090,
						'Mercado Bitcoin' => 36790,
						'Mercado Livre' => 34234,
						'Microsoft Azure' => 36111,
						'Multiplay' => 37221,
						'NET' => 33190,
						'Netflix' => 33222,
						'Neverwinter' => 36158,
						'Nextel' => 33202,
						'Nota fiscal eletrônica' => 34718,
						'Nubank' => 37063,
						'Office 365' => 37170,
						'Oi' => 33196,
						'OLX' => 34235,
						'OneDrive' => 36866,
						'Origin' => 36903,
						'Outlook' => 33221,
						'Overwatch' => 36502,
						'PagSeguro' => 37313,
						'Path of Exile' => 37725,
						'Paypal' => 33213,
						'Pinterest' => 38164,
						'Player Unknown\'s Battlegrounds' => 36565,
						'Playstation Network' => 33217,
						'Pokémon Go' => 35751,
						'Polícia Federal' => 35135,
						'Porto Seguro Conecta' => 35981,
						'QConcursos' => 36601,
						'Rainbow Six' => 36451,
						'Receita Federal' => 34960,
						'Red Dead Redemption' => 38909,
						'Reddit' => 37477,
						'Roblox' => 37399,
						'Rocket League' => 38558,
						'Salesforce' => 38494,
						'Sefaz' => 37626,
						'Sercomtel' => 33990,
						'Sicoob' => 37624,
						'Sicredi' => 37505,
						'SiSU' => 38029,
						'SKY' => 33875,
						'Skype' => 33203,
						'Slack' => 37339,
						'Snapchat' => 33379,
						'Spotify' => 36594,
						'Steam' => 34137,
						'Submarino' => 35074,
						'SuperDigital' => 36744,
						'Teamviewer' => 35690,
						'Telegram' => 34937,
						'Terra' => 33193,
						'TIM' => 34686,
						'Tinder' => 36550,
						'Tribunal Superior Eleitoral' => 37578,
						'Twitch' => 36372,
						'Twitter' => 33195,
						'Uber' => 37767,
						'Udemy' => 38313,
						'Umbler' => 37577,
						'UOL' => 33189,
						'UOLHost' => 34748,
						'Uplay PC' => 38636,
						'Viber' => 33386,
						'Vimeo' => 38533,
						'Vivo' => 33192,
						'Vono' => 35138,
						'Warframe' => 36702,
						'Waze' => 33383,
						'WeChat' => 33735,
						'Whatsapp' => 32837,
						'Wikipedia' => 33198,
						'World of Warcraft' => 38879,
						'Xbox Live' => 33216,
						'Yahoo' => 33187,
						'Yahoo Mail' => 33201,
						'Youtube' => 33185,
						'Zello' => 33387,
					),
					'Россия' => array(
						'Albion Online' => 38798,
						'Anthem' => 38191,
						'Apex Legends' => 38138,
						'Apple Music' => 39012,
						'Apple Store' => 34470,
						'avito' => 37696,
						'Battlefield' => 38448,
						'Binance' => 37021,
						'Blizzard Battle.net' => 36784,
						'Call of Duty' => 39052,
						'Citilink' => 37700,
						'Cloudflare' => 38619,
						'Counter-strike' => 38234,
						'Dead By Daylight' => 37430,
						'Destiny' => 38941,
						'DNS Shop' => 37701,
						'Dota 2' => 36395,
						'EA' => 36924,
						'eBay' => 32799,
						'Elite: Dangerous' => 37775,
						'Facetime' => 34599,
						'Fifa' => 38428,
						'For Honor' => 37370,
						'Fortnite' => 37143,
						'GitHub' => 38713,
						'Gmail' => 32798,
						'GTA 5' => 36845,
						'iCloud' => 38840,
						'ICQ' => 33122,
						'iMessage' => 33115,
						'Interzet' => 33563,
						'iTunes' => 33114,
						'Ivi' => 34807,
						'Kraken' => 36982,
						'Last FM' => 36533,
						'Mail.Ru' => 33113,
						'Megogo' => 38198,
						'NetByNet' => 35927,
						'Okko' => 38793,
						'Origin' => 36900,
						'Outlook' => 33116,
						'Overwatch' => 36385,
						'Ozon' => 37702,
						'Path of Exile' => 37724,
						'Paypal' => 33118,
						'Player Unknown\'s Battlegrounds' => 36455,
						'Playstation Network' => 32801,
						'Qip' => 37697,
						'Qiwi' => 33504,
						'Rainbow Six' => 36457,
						'Reddit' => 38066,
						'Roblox' => 38922,
						'SkyNet' => 35103,
						'Slack' => 37340,
						'Snapchat' => 37144,
						'Teamviewer' => 34347,
						'Telegram' => 36734,
						'The elder scrolls online' => 37323,
						'Tumblr' => 37284,
						'Twitter' => 32797,
						'Uplay PC' => 35611,
						'Viber ' => 33402,
						'Warframe' => 37126,
						'WebMoney' => 33119,
						'Wildberries' => 37699,
						'World of Tanks' => 35051,
						'Xbox Live' => 32802,
						'Yahoo' => 32792,
						'Yahoo Mail' => 32793,
						'Yahoo Messenger' => 32794,
						'Yota' => 34356,
						'Акадо' => 34429,
						'Альфа-Банк' => 33110,
						'Банк ДОМ.РФ' => 38704,
						'Билайн' => 32850,
						'Ватсап' => 32803,
						'Википедия' => 33120,
						'ВКонтакте' => 32851,
						'ВТБ 24' => 33109,
						'ГИС ЖКХ' => 35822,
						'Гугл' => 32788,
						'Гугл Hangouts' => 32789,
						'Гугл Плей' => 32790,
						'Дискорд ' => 37386,
						'Дом.ru' => 34395,
						'Инстаграм' => 36069,
						'Кинопаб' => 38199,
						'Летай' => 34430,
						'МГТС' => 33108,
						'МегаФон' => 33104,
						'Мотив' => 33864,
						'МТС' => 33121,
						'НСПК ' => 35608,
						'Одноклассники' => 33112,
						'Почта России' => 36587,
						'Рамблер' => 37441,
						'Релком' => 34357,
						'Росреестр' => 38311,
						'Ростелеком' => 33105,
						'Сбербанк' => 33106,
						'СДЭК' => 38729,
						'Скай Линк' => 34358,
						'Скайп' => 32804,
						'Стим' => 34266,
						'Твич' => 36543,
						'Теле2' => 33818,
						'Тиндер' => 37919,
						'Тинькофф Банк ' => 37698,
						'ТТК' => 34359,
						'Уфанет' => 34431,
						'Фейсбук' => 32795,
						'Фейсбук Мессенджер' => 32796,
						'ФНС' => 38648,
						'Хоум Кредит' => 38627,
						'ЭлЖур ' => 37515,
						'Ютуб' => 32791,
						'Яндекс' => 33111,
						'Яндекс.Музыка' => 39013,
						'Яндекс.Навигатор' => 39014,
					),
					'España' => array(
						'Alexa' => 38032,
						'Amazon' => 33140,
						'Amazon Prime Video' => 38753,
						'Anthem' => 38201,
						'Anydesk' => 37490,
						'Apex Legends' => 38122,
						'App Store' => 38553,
						'Apple Store' => 34465,
						'Banco Popular' => 33135,
						'Banco Sabadell' => 33151,
						'Banco Santander' => 33132,
						'Bankia' => 33134,
						'Bankinter' => 33143,
						'Battlefield' => 39017,
						'BBVA' => 33133,
						'Binance' => 36936,
						'Blizzard Battle.net' => 36105,
						'Brawl Stars' => 38832,
						'Cableworld' => 37457,
						'Call of Duty' => 35538,
						'Clash of Clans' => 34362,
						'Clash Royale' => 38951,
						'Coinbase' => 36803,
						'Counter Strike' => 38239,
						'Crunchyroll' => 38147,
						'Dazn' => 39005,
						'Dead By Daylight' => 36597,
						'Deezer' => 33830,
						'Destiny' => 38944,
						'Discord' => 37387,
						'Dota 2' => 37188,
						'Dropbox' => 33142,
						'EA' => 36449,
						'eBay' => 33267,
						'Epic Games Store' => 39032,
						'Euskaltel' => 34442,
						'Facebook' => 32829,
						'Facebook Messenger' => 32830,
						'Facetime' => 34600,
						'Fifa' => 37088,
						'For Honor' => 36182,
						'Fortnite' => 36694,
						'Ghost Recon' => 38996,
						'Github' => 36521,
						'Gmail' => 32832,
						'Google' => 32822,
						'Google Drive' => 36605,
						'Google Hangouts' => 32823,
						'Google Play' => 33226,
						'Gran Turismo' => 36950,
						'Grindr' => 38401,
						'GTA 5' => 37274,
						'Guild Wars 2' => 36485,
						'HBO' => 36497,
						'Ibercaja' => 33153,
						'iCloud' => 33227,
						'iMessage' => 32980,
						'ING Direct' => 33148,
						'Instagram' => 33147,
						'iTunes' => 33144,
						'Jazztel' => 33129,
						'Kraken' => 36806,
						'League of Legends' => 38634,
						'Line' => 33394,
						'LinkedIn' => 33150,
						'Llamaya' => 38315,
						'Lowi' => 35832,
						'MásMóvil' => 36068,
						'Mil Anuncios' => 33141,
						'Movistar' => 33124,
						'Nest' => 38551,
						'Netflix' => 35565,
						'Office 365' => 35442,
						'OneDrive' => 36864,
						'ONO' => 33128,
						'Orange' => 33126,
						'Origin' => 36895,
						'Outlook' => 33220,
						'Overwatch' => 36387,
						'Pasion.com' => 37141,
						'Path of Exile' => 37770,
						'Paypal' => 33145,
						'Pepephone' => 33130,
						'Player Unknown\'s Battlegrounds' => 36561,
						'Playstation Network' => 32835,
						'Pokémon Go' => 35750,
						'Quantis' => 37050,
						'R' => 34441,
						'Rainbow Six' => 36145,
						'Rakuten TV' => 37595,
						'Reddit' => 37476,
						'Roblox' => 38928,
						'Rocket League' => 36181,
						'Sea of Thieves' => 37119,
						'Segunda Mano' => 33138,
						'Simyo' => 33131,
						'Sky' => 37520,
						'Skype' => 32838,
						'Slack' => 37342,
						'Snapchat' => 33380,
						'Spotify' => 33146,
						'Steam' => 34280,
						'Tango' => 33746,
						'Teamviewer' => 35688,
						'Telecable' => 34443,
						'Telegram' => 35352,
						'Tinder' => 36548,
						'Tuenti' => 33137,
						'Tweakbox' => 38350,
						'Twitch' => 36545,
						'Twitter' => 32831,
						'Unicaja' => 33149,
						'Uplay PC' => 35615,
						'Vibbo' => 36183,
						'Viber' => 33374,
						'Vodafone' => 33125,
						'Warframe' => 36705,
						'Whatsapp' => 33263,
						'Wikipedia' => 33139,
						'Xbox Live' => 32836,
						'Yahoo' => 32826,
						'Yahoo Mail' => 32827,
						'Yahoo Messenger' => 32828,
						'Yoigo' => 33127,
						'Youtube' => 32825,
						'Z1 Battle Royale' => 37263,
					),
					'Polska' => array(
						'Allegro' => 33799,
						'Amazon' => 33633,
						'Apex Legends' => 38124,
						'Apple Store' => 34453,
						'Bank Millennium' => 37535,
						'Bank Pekao' => 37534,
						'Battlefield' => 37471,
						'BGŻ BNP Paribas' => 37530,
						'Binance' => 36946,
						'Blizzard Battle.net' => 36783,
						'Call of Duty' => 38923,
						'Chomikuj' => 33803,
						'Clash Royale' => 38950,
						'Cloudflare' => 38624,
						'Counter-Strike' => 36648,
						'Cyfrowy Polsat' => 33866,
						'Dead By Daylight' => 36599,
						'Deezer' => 33837,
						'Destiny' => 38945,
						'Deutsche bank Polska' => 36176,
						'Discord' => 36761,
						'Dota 2' => 36447,
						'Dropbox' => 33796,
						'EA' => 36448,
						'East&West' => 35641,
						'eBay' => 38579,
						'Elite: Dangerous' => 37778,
						'Epic Games Store' => 39022,
						'Escape from Tarkov' => 39060,
						'Eurobank' => 37008,
						'Facebook' => 33634,
						'Facebook Messenger' => 33635,
						'Facetime' => 34591,
						'Fifa' => 37086,
						'For Honor' => 37305,
						'Fortnite' => 36693,
						'Get in Bank' => 37532,
						'GG (Gadu Gadu)' => 33809,
						'Ghost Recon' => 38997,
						'GitHub' => 38466,
						'Gmail' => 33636,
						'Google' => 33637,
						'Google Hangouts' => 33638,
						'Google Play' => 33639,
						'Gran Turismo' => 36916,
						'Grindr' => 38741,
						'GTA 5' => 36848,
						'Guild Wars 2' => 36467,
						'Gumtree' => 33805,
						'HBO' => 36355,
						'Heyah' => 33812,
						'Home.pl' => 37537,
						'iCloud' => 33640,
						'Idea Bank' => 37533,
						'iMessage' => 33641,
						'Inea' => 34415,
						'ING Bank' => 33807,
						'Instagram' => 33642,
						'iTunes' => 33643,
						'Kraken' => 36983,
						'League of Legends' => 36629,
						'LinkedIn' => 33806,
						'Mbank' => 33800,
						'Multimedia Polska' => 33879,
						'Nazwa' => 37320,
						'Nest Bank' => 37529,
						'Netflix' => 35728,
						'Netia' => 33815,
						'NK.pl (Nasza-klasa)' => 33808,
						'O2' => 33801,
						'Office 365' => 35125,
						'OLX' => 33802,
						'OneDrive' => 36868,
						'Orange' => 33810,
						'Origin' => 36899,
						'Outlook' => 33644,
						'Overwatch' => 36388,
						'Path of Exile' => 37728,
						'PKO Bank Polski' => 36044,
						'Play' => 33813,
						'Player Unknown\'s Battlegrounds' => 36580,
						'Playstation Network' => 33645,
						'Plus' => 33814,
						'Pokémon Go' => 35752,
						'Rainbow Six' => 36394,
						'Reddit' => 37485,
						'Roblox' => 37400,
						'Rocket League' => 36667,
						'Santander' => 37531,
						'Sea of Thieves' => 37120,
						'Skype' => 33793,
						'Slack' => 37338,
						'Snapchat' => 33797,
						'Spotify' => 33836,
						'Steam' => 34279,
						'T-Mobile' => 33811,
						'Teamviewer' => 35694,
						'Telegram' => 35970,
						'The elder scrolls online' => 37328,
						'Tinder' => 36547,
						'Tumblr' => 37285,
						'Twitch' => 36450,
						'Twitter' => 33646,
						'UPC' => 33816,
						'Uplay PC' => 35612,
						'Vectra' => 33817,
						'Viber' => 33794,
						'Warframe' => 36493,
						'Whatsapp' => 33792,
						'Wikipedia' => 33647,
						'World of Tanks' => 36029,
						'World of Warcraft' => 37446,
						'World of Warships' => 38008,
						'Xbox Live' => 33648,
						'Yahoo Mail' => 38887,
						'Youtube' => 33649,
						'Z1 Battle Royale' => 37267,
					),
					'Norge' => array(
						'Altibox' => 36318,
						'Anthem' => 38206,
						'Apex Legends' => 38120,
						'App Store' => 38100,
						'Battlefield' => 37098,
						'Binance' => 36928,
						'Blizzard Battle.net' => 36309,
						'Call of Duty' => 36708,
						'Coinbase' => 36799,
						'Counter-strike' => 36647,
						'Crunchyroll' => 36720,
						'Danske Bank' => 36321,
						'Dead By Daylight' => 37426,
						'Destiny' => 36592,
						'Discord' => 36762,
						'Dota 2' => 36442,
						'EA' => 36310,
						'Epic Games Store' => 39028,
						'Facebook' => 36238,
						'Facebook Messenger' => 36269,
						'Fifa' => 36908,
						'Fortnite' => 36687,
						'Get' => 36319,
						'Ghost Recon' => 39000,
						'Gmail' => 36255,
						'Google' => 36256,
						'Google Drive' => 36760,
						'Google Play' => 38528,
						'GTA 5' => 36847,
						'Guild Wars 2' => 36470,
						'HBO Nordic' => 36316,
						'iCloud' => 38844,
						'Ikano Bank' => 36577,
						'Instagram' => 36443,
						'Kraken' => 36853,
						'League of Legends' => 38630,
						'Minecraft' => 37280,
						'Netflix' => 36257,
						'NexGenTel' => 36320,
						'Nordea' => 36325,
						'Norges Bank' => 36324,
						'Office 365' => 36311,
						'OneDrive' => 36865,
						'Origin' => 36893,
						'Outlook' => 36258,
						'Overwatch' => 36259,
						'Path of Exile' => 37727,
						'Playerunknown\'s Battlegrounds' => 36338,
						'Playstation Network' => 36260,
						'Pokémon Go' => 36261,
						'Rainbow Six' => 36262,
						'Realm Royale' => 37316,
						'Red Dead Redemption' => 38283,
						'Reddit' => 36825,
						'Roblox' => 38919,
						'Rocket League' => 36312,
						'Sea of Thieves' => 37116,
						'Skype' => 36263,
						'Snapchat' => 36264,
						'Sparebanken 1' => 36323,
						'Spotify' => 36796,
						'Steam' => 36313,
						'Strava' => 38730,
						'Tele2' => 36317,
						'Telegram' => 37183,
						'Telenor' => 36288,
						'The elder scrolls online' => 37324,
						'Tinder' => 36314,
						'Twitch' => 36444,
						'Twitter' => 37268,
						'Uplay PC' => 36265,
						'Viaplay' => 37293,
						'Warframe' => 37129,
						'Whatsapp' => 36266,
						'Wikipedia' => 38872,
						'World of Warcraft' => 37447,
						'Xbox Live' => 36315,
						'Yahoo' => 36268,
						'Yahoo Mail' => 38890,
						'Youtube' => 36267,
						'Z1 Battle Royale' => 37262,
					),
					'México' => array(
						'Amazon' => 33292,
						'Amazon Prime Video' => 38752,
						'Anthem' => 38192,
						'Apex Legends' => 38139,
						'App Store' => 37732,
						'Apple Store' => 34466,
						'AT&T' => 35861,
						'Axtel' => 34439,
						'Banamex' => 33322,
						'Banco Santander' => 36772,
						'Banorte' => 33326,
						'Battlefield' => 38445,
						'BBVA Bancomer' => 33321,
						'Binance' => 37019,
						'Blizzard Battle.net' => 36106,
						'Cablecom' => 34035,
						'Cablemás' => 34438,
						'Call of Duty' => 35540,
						'Clash of Clans' => 37099,
						'Crunchyroll' => 37139,
						'Dead By Daylight' => 37432,
						'Deezer' => 33397,
						'Destiny' => 38966,
						'Discord' => 38606,
						'Dropbox' => 33294,
						'EA' => 36609,
						'eBay' => 33295,
						'Facebook' => 33296,
						'Facebook Messenger' => 33297,
						'Facetime' => 34594,
						'Fifa' => 38307,
						'Fortnite' => 36842,
						'Gears of War' => 38893,
						'Gmail' => 33298,
						'Go Daddy' => 36620,
						'Google' => 33299,
						'Google Drive' => 38260,
						'Google Hangouts' => 33300,
						'Google Play' => 33301,
						'Gran Turismo' => 36951,
						'Grindr' => 38740,
						'GTA 5' => 38275,
						'HBO' => 36351,
						'iCloud' => 33302,
						'iMessage' => 33303,
						'Instagram' => 33304,
						'iTunes' => 33305,
						'Izzi' => 37685,
						'League of Legends' => 39019,
						'Line' => 33395,
						'LinkedIn' => 33306,
						'Megacable' => 34437,
						'Mercado Libre' => 33320,
						'Microsoft Azure' => 37466,
						'Minecraft' => 38737,
						'Movistar' => 33307,
						'Netflix' => 33325,
						'Origin' => 38103,
						'Outlook' => 33308,
						'Overwatch' => 36483,
						'Paypal' => 33309,
						'Player Unknown\'s Battlegrounds' => 36562,
						'Playstation Network' => 33310,
						'Pokémon Go' => 36360,
						'Rainbow Six' => 36146,
						'Reddit' => 37482,
						'Roblox' => 38917,
						'Salesforce' => 38496,
						'Scotiabank' => 37686,
						'Segunda Mano' => 33327,
						'SKY México' => 33328,
						'Skype' => 33311,
						'Snapchat' => 34288,
						'SPEI' => 37689,
						'Spotify' => 33398,
						'Steam' => 34281,
						'Tango' => 33745,
						'Teamviewer' => 35689,
						'Telcel' => 33319,
						'Telegram' => 35852,
						'Telmex' => 33324,
						'Telnor' => 34440,
						'Tinder' => 37165,
						'Totalplay' => 37687,
						'Tweakbox' => 38903,
						'Twitch' => 36546,
						'Twitter' => 33312,
						'Unefon' => 37688,
						'WeChat' => 33399,
						'Whatsapp' => 33313,
						'Wikipedia' => 33314,
						'World of Warcraft' => 38880,
						'Xbox Live' => 33315,
						'Yahoo' => 33316,
						'Yahoo Mail' => 33317,
						'Yahoo Messenger' => 33318,
						'Youtube' => 33361,
						'Zello' => 33388,
					),
					'日本' => array(
						'Amazon' => 33464,
						'Amazon Web Services' => 34094,
						'Amazon インスタント・ビデオ' => 34496,
						'Apex Legends' => 38177,
						'App Store' => 35581,
						'Apple Store' => 34467,
						'ASAHI ネット' => 33859,
						'Au' => 33465,
						'Biglobe' => 33479,
						'Blizzard Battle.net' => 36672,
						'bmobile' => 33466,
						'Call of Duty' => 39053,
						'Dazn' => 36511,
						'Discord' => 38613,
						'Disney Mobile' => 33467,
						'DMM' => 35818,
						'Dropbox' => 33441,
						'EA' => 37080,
						'eBay' => 33442,
						'EO Net' => 33863,
						'Facebook' => 33443,
						'Facebook Messenger' => 33444,
						'Facetime' => 34593,
						'FC2' => 34510,
						'Fortnite' => 37162,
						'Freetel' => 35620,
						'Ghost Recon' => 38993,
						'Github' => 37375,
						'Gmail' => 33445,
						'Google' => 33446,
						'Google Hangouts' => 33447,
						'Google Play' => 33448,
						'Hulu' => 33480,
						'iCloud' => 33449,
						'IIJ' => 34511,
						'iMessage' => 33450,
						'Instagram' => 33451,
						'iTunes' => 33452,
						'Jcom' => 33478,
						'League of Legends' => 38899,
						'Line' => 33453,
						'LinkedIn' => 33454,
						'Livedoor' => 33472,
						'Microsoft Azure' => 36110,
						'Netflix' => 36728,
						'Nifty' => 33473,
						'Nintendo Network' => 35521,
						'NTT Docomo' => 33474,
						'NTT東日本' => 33475,
						'NTT西日本' => 33476,
						'OCN' => 33564,
						'Office 365' => 35928,
						'OneDrive' => 36496,
						'Outlook' => 33455,
						'Paypal' => 33456,
						'Player Unknown\'s Battlegrounds' => 36616,
						'Playstation Network' => 33457,
						'Rakuten' => 34513,
						'Reddit' => 37478,
						'Skype' => 33458,
						'Slack' => 37358,
						'Snapchat' => 38511,
						'So-net' => 33862,
						'Steam' => 38649,
						'Telegram' => 37227,
						'Tinder' => 37916,
						'Twitter' => 33459,
						'UQ Wimax' => 33482,
						'Whatsapp' => 38255,
						'Xbox Live' => 33471,
						'Yahoo' => 33460,
						'Yahoo BB' => 33860,
						'Yahoo Mail' => 33461,
						'Yammer' => 35560,
						'Youtube' => 33462,
						'じぶん銀行' => 33500,
						'ぷらら' => 33861,
						'みずほ銀行' => 33493,
						'りそな銀行' => 33496,
						'アメーバブログ' => 34514,
						'カカオトーク' => 33469,
						'ジャパンネット銀行' => 33497,
						'スカパー' => 33477,
						'スポナビLive' => 36516,
						'ソニー銀行' => 33498,
						'ソフトバンク' => 33470,
						'ポケモン go' => 35746,
						'ワイモバイル' => 36503,
						'三井住友銀行' => 33495,
						'三菱東京UFJ銀行' => 33494,
						'埼玉りそな銀行' => 36532,
						'楽天銀行' => 33499,
						'近畿大阪銀行' => 36531,
					),
					'Pilipinas' => array(
						'Anthem' => 38193,
						'Apex Legends' => 38158,
						'Battlefield' => 37925,
						'Blizzard Battle.net' => 37834,
						'Converge' => 38714,
						'Counter-strike' => 38241,
						'Destiny' => 38987,
						'Discord' => 38453,
						'Dota 2' => 37835,
						'EA' => 37931,
						'Facebook' => 37836,
						'Facebook Messenger' => 37837,
						'Fortnite' => 37930,
						'Globe' => 37941,
						'Gmail' => 38080,
						'Google' => 37838,
						'Google Drive' => 38259,
						'Google Hangouts' => 38365,
						'Google Play' => 38521,
						'GTA 5' => 38718,
						'iCloud' => 38853,
						'Instagram' => 37839,
						'League of Legends' => 38911,
						'Mobile legends' => 38175,
						'Netflix' => 37840,
						'Office 365' => 37936,
						'Origin' => 38397,
						'Outlook' => 37935,
						'Overwatch' => 37932,
						'Paypal' => 38463,
						'Player Unknown\'s Battlegrounds' => 37841,
						'Playstation Network' => 38736,
						'PLDT' => 37938,
						'Rainbow Six' => 37933,
						'Reddit' => 38089,
						'Roblox' => 37927,
						'Sky Cable' => 37942,
						'Skype' => 37929,
						'Smart' => 37940,
						'Spotify' => 38644,
						'Steam' => 37924,
						'Telegram' => 38019,
						'Tinder' => 37912,
						'TNT' => 37943,
						'Twitter' => 37928,
						'Warframe' => 37934,
						'Wattpad' => 38962,
						'Waze' => 38267,
						'Whatsapp' => 38254,
						'Yahoo' => 37926,
						'Yahoo Mail' => 38456,
						'Youtube' => 37842,
					),
					'Indonesia' => array(
						'Anthem' => 38194,
						'Apex Legends' => 38181,
						'Biznet' => 38975,
						'Blizzard Battle.net' => 37825,
						'Clash of Clans' => 37961,
						'Counter-strike' => 38410,
						'Discord' => 38084,
						'Dota 2' => 37826,
						'EA' => 38419,
						'Facebook' => 37827,
						'Fifa' => 38427,
						'First Media' => 38974,
						'Fortnite' => 38532,
						'Gmail' => 38250,
						'Google' => 37828,
						'Google Drive' => 38262,
						'Google Play' => 38518,
						'GTA 5' => 38700,
						'iCloud' => 38851,
						'Indosat Ooredoo' => 38978,
						'Instagram' => 37829,
						'Myrepublic' => 38972,
						'Netflix' => 37830,
						'Origin' => 38376,
						'Pinterest' => 37950,
						'Player Unknown\'s Battlegrounds' => 37831,
						'Playstation Network' => 38735,
						'Reddit' => 38498,
						'Roblox' => 38914,
						'Steam' => 38098,
						'Telegram' => 38020,
						'Telkom' => 38973,
						'Telkomsel' => 38976,
						'Tinder' => 37915,
						'Twitter' => 38160,
						'Uplay PC' => 37962,
						'Whatsapp' => 37832,
						'XL' => 38977,
						'Yahoo Mail' => 38889,
						'Youtube' => 37833,
					),
					'Pakistan' => array(
						'Apex Legends' => 38414,
						'App Store' => 38960,
						'Battlefield' => 38002,
						'Blizzard Battle.net' => 37992,
						'Call of Duty' => 38939,
						'Discord' => 37993,
						'Dota 2' => 38476,
						'EA' => 38418,
						'Facebook' => 37994,
						'Facebook Messenger' => 37995,
						'Fiberlink' => 38006,
						'Fifa' => 38425,
						'Fortnite' => 38252,
						'Google' => 37996,
						'iCloud' => 38715,
						'Instagram' => 37997,
						'Kik' => 38539,
						'Netflix' => 37998,
						'Pinterest' => 38679,
						'Player Unknown\'s Battlegrounds' => 37999,
						'Playstation Network' => 38571,
						'PTLC' => 38004,
						'Quora' => 38908,
						'Snapchat' => 38508,
						'Steam' => 38341,
						'Tinder' => 38000,
						'Tumblr' => 38546,
						'Twitter' => 38678,
						'Wateen' => 38007,
						'Wattpad' => 38544,
						'Whatsapp' => 38003,
						'Yahoo Mail' => 38882,
						'Youtube' => 38001,
						'Zong' => 38005,
					),
					'UAE' => array(
						'Apex Legends' => 38159,
						'beIN' => 39073,
						'Binance' => 37022,
						'Blizzard Battle.net' => 36214,
						'Botim' => 38393,
						'Call of Duty' => 38935,
						'Cloudflare' => 38642,
						'Counter-strike' => 38269,
						'Dead By Daylight' => 37437,
						'Discord' => 37773,
						'Dota 2' => 36423,
						'Du' => 36235,
						'EA' => 36883,
						'Etisalat' => 36234,
						'Facebook' => 36215,
						'Facebook Messenger' => 36233,
						'Fifa' => 38433,
						'For Honor' => 36216,
						'Fortnite' => 36996,
						'Gmail' => 36217,
						'Google' => 36218,
						'iCloud' => 38843,
						'Instagram' => 36420,
						'Netflix' => 36219,
						'Office 365' => 38041,
						'Origin' => 38422,
						'Outlook' => 36220,
						'Overwatch' => 36221,
						'Player Unknown\'s Battlegrounds' => 36618,
						'Playstation Network' => 36222,
						'Pokémon Go' => 36223,
						'Rainbow Six' => 36224,
						'Reddit' => 38499,
						'Roblox' => 37222,
						'Rocket League' => 36231,
						'Skype' => 36225,
						'Snapchat' => 36226,
						'Steam' => 38340,
						'Telegram' => 37185,
						'Tinder' => 36227,
						'Twitter' => 38677,
						'Uplay PC' => 36228,
						'Whatsapp' => 36229,
						'Wikipedia' => 38878,
						'Xbox Live' => 38404,
						'Yahoo' => 36232,
						'Yahoo Mail' => 38888,
						'Youtube' => 36230,
						'ZoHo' => 37553,
					),
					'Malaysia' => array(
						'Apex Legends' => 38179,
						'Blizzard Battle.net' => 37891,
						'Counter-strike' => 38409,
						'Destiny' => 38985,
						'Discord' => 37976,
						'Dota 2' => 38017,
						'EA' => 38420,
						'Facebook' => 37892,
						'Facebook Messenger' => 37893,
						'Fifa' => 38429,
						'Gmail' => 38251,
						'Google' => 37894,
						'Google Drive' => 38263,
						'Google Play' => 38529,
						'GTA 5' => 38488,
						'iCloud' => 38850,
						'Instagram' => 37895,
						'League of Legends' => 38910,
						'Line' => 38386,
						'LinkedIn' => 38150,
						'Maxis' => 37964,
						'Netflix' => 37896,
						'Origin' => 38395,
						'Overwatch' => 38895,
						'Paypal' => 38461,
						'Player Unknown\'s Battlegrounds' => 37897,
						'Playstation Network' => 38570,
						'Reddit' => 38363,
						'Roblox' => 38912,
						'Snapchat' => 38548,
						'Steam' => 38081,
						'TIME' => 37965,
						'Tinder' => 37917,
						'Twitter' => 38481,
						'Unifi' => 37963,
						'Uplay PC' => 38896,
						'Waze' => 38268,
						'Whatsapp' => 38028,
						'Yahoo Mail' => 38891,
						'Youtube' => 37898,
					),
					'Perú' => array(
						'Apex Legends' => 39015,
						'Bitel' => 37982,
						'Claro' => 37981,
						'Crunchyroll' => 38550,
						'Dota 2' => 38353,
						'EA' => 38415,
						'Econocable' => 37983,
						'Entel' => 37980,
						'Facebook' => 37791,
						'Facebook Messenger' => 38258,
						'Fortnite' => 37792,
						'Gmail' => 37944,
						'Google' => 37945,
						'HBO' => 38369,
						'iCloud' => 38855,
						'Instagram' => 37793,
						'Movistar' => 37794,
						'Netflix' => 38594,
						'Origin' => 38423,
						'Outlook' => 38581,
						'Playstation Network' => 38568,
						'Spotify' => 38580,
						'Steam' => 38099,
						'Telegram' => 38483,
						'Tinder' => 37909,
						'Twitter' => 38105,
						'Whatsapp' => 37795,
						'Youtube' => 37796,
					),
					'Argentina' => array(
						'Apex Legends' => 38129,
						'Arnet' => 37969,
						'Banco Galicia' => 36132,
						'Banco Nación' => 36131,
						'Banco Provincia' => 36133,
						'Banco Santander Río ' => 36130,
						'BBVA Francés' => 36134,
						'Binance' => 37020,
						'Blizzard Battle.net' => 36104,
						'Call of Duty' => 36743,
						'Claro' => 36100,
						'Clash of Clans' => 36128,
						'Correo Argentino' => 36999,
						'Counter-Strike' => 38247,
						'Crunchyroll' => 38091,
						'Dead By Daylight' => 37431,
						'Destiny' => 38965,
						'Discord' => 38614,
						'Dota 2' => 37187,
						'EA' => 36885,
						'Facebook' => 36072,
						'Facebook Messenger' => 36073,
						'Fibertel' => 36635,
						'Fifa' => 38435,
						'Flow' => 38309,
						'Fortnite' => 37017,
						'Free Fire' => 38806,
						'Gigared' => 38215,
						'Gmail' => 37716,
						'Google' => 36074,
						'Google Play' => 38520,
						'GTA 5' => 38276,
						'HBO' => 36352,
						'ICBC' => 38646,
						'iCloud' => 38858,
						'Instagram' => 36075,
						'Mercado Libre' => 36076,
						'Microsoft Azure' => 37467,
						'Movistar' => 36077,
						'Netflix' => 36078,
						'Nextel' => 36103,
						'OLX' => 37045,
						'Origin' => 36902,
						'Outlook' => 36079,
						'Overwatch' => 38774,
						'Path of Exile' => 37771,
						'Personal' => 37970,
						'Player Unknown\'s Battlegrounds' => 36563,
						'Playstation Network' => 36080,
						'Pokémon Go' => 36294,
						'Rainbow Six' => 36144,
						'Reddit' => 37483,
						'Roblox' => 38929,
						'Skype' => 36081,
						'Snapchat' => 36082,
						'Spotify' => 36107,
						'Steam' => 36129,
						'Teamviewer' => 36142,
						'Telecentro' => 36810,
						'Telecom' => 36097,
						'Telefónica' => 36099,
						'Telegram' => 38485,
						'Telered' => 37971,
						'Tinder' => 37169,
						'Tuenti' => 38628,
						'Twitch' => 36544,
						'Twitter' => 36109,
						'Uplay PC' => 36143,
						'Waze' => 37470,
						'Whatsapp' => 36083,
						'Wikipedia' => 37352,
						'World of Warcraft' => 38778,
						'Xbox Live' => 37443,
						'Yahoo Mail' => 36084,
						'Youtube' => 36085,
					),
					'Slovensko' => array(
						'Apex Legends' => 38131,
						'Blizzard Battle.net' => 37875,
						'Counter-strike' => 38243,
						'Discord' => 38612,
						'Dota 2' => 38480,
						'EA' => 38417,
						'Facebook' => 37876,
						'Facebook Messenger' => 37877,
						'Fifa' => 38426,
						'Fortnite' => 38807,
						'Google' => 37878,
						'GTA 5' => 38279,
						'HBO Go' => 38381,
						'iCloud' => 38848,
						'Instagram' => 37879,
						'Netflix' => 37880,
						'Origin' => 38374,
						'Player Unknown\'s Battlegrounds' => 37881,
						'Playstation Network' => 38572,
						'Reddit' => 38809,
						'Snapchat' => 38513,
						'Steam' => 38230,
						'Twitter' => 38669,
						'Whatsapp' => 38371,
						'Wikipedia' => 38877,
						'Xbox Live' => 38088,
						'Yahoo Mail' => 38881,
						'Youtube' => 37882,
					),
					'Ελλάς' => array(
						'Apex Legends' => 38132,
						'Bet365' => 38811,
						'Blizzard Battle.net' => 37843,
						'Clash Royale' => 38949,
						'Counter-strike' => 38235,
						'Destiny' => 38980,
						'Discord' => 38607,
						'Dota 2' => 38352,
						'EA' => 38416,
						'eBay' => 38578,
						'Facebook' => 37844,
						'Facebook Messenger' => 37845,
						'Fifa' => 38434,
						'Fortnite' => 38087,
						'Gmail' => 38079,
						'Google' => 37846,
						'Google Play' => 38527,
						'GTA 5' => 38701,
						'iCloud' => 38846,
						'Instagram' => 37847,
						'League of Legends' => 38618,
						'Netflix' => 37848,
						'Office 365' => 38076,
						'Origin' => 38375,
						'Paypal' => 38462,
						'Player Unknown\'s Battlegrounds' => 37849,
						'Playstation Network' => 38575,
						'Pokémon Go' => 38639,
						'Reddit' => 38516,
						'Snapchat' => 38505,
						'Steam' => 38231,
						'Twitch' => 38582,
						'Twitter' => 38676,
						'Viber' => 38588,
						'Whatsapp' => 38373,
						'Yahoo Mail' => 38892,
						'Youtube' => 37850,
						'Βικιπαίδεια' => 38873,
					),
					'Hrvatska' => array(
						'Apex Legends' => 38135,
						'Battlefield' => 38442,
						'Blizzard Battle.net' => 37859,
						'Clash Royale' => 38356,
						'Counter-strike' => 38244,
						'Destiny' => 39011,
						'Discord' => 38610,
						'Dota 2' => 38351,
						'EA' => 38036,
						'Facebook' => 37860,
						'Facebook Messenger' => 37861,
						'Fifa' => 38438,
						'Fortnite' => 38069,
						'Google' => 37862,
						'GTA 5' => 38278,
						'HBO Go' => 38384,
						'iCloud' => 38847,
						'Instagram' => 37863,
						'Netflix' => 37864,
						'Office 365' => 38075,
						'Origin' => 38149,
						'Player Unknown\'s Battlegrounds' => 37865,
						'Playstation Network' => 38574,
						'Reddit' => 38090,
						'Snapchat' => 38509,
						'Steam' => 38229,
						'Tinder' => 37920,
						'Twitter' => 38672,
						'Whatsapp' => 38026,
						'Wikipedia' => 38874,
						'Yahoo Mail' => 38884,
						'Youtube' => 37866,
					),
					'Česko' => array(
						'Apex Legends' => 38136,
						'Battlefield' => 38446,
						'Blizzard Battle.net' => 37851,
						'Counter-strike' => 38236,
						'Discord' => 38452,
						'Dota 2' => 38221,
						'EA' => 38037,
						'Facebook' => 37852,
						'Facebook Messenger' => 37853,
						'Fifa' => 38430,
						'Fortnite' => 38086,
						'Gmail' => 38515,
						'Google' => 37854,
						'Google Play' => 38523,
						'GTA 5' => 38304,
						'HBO Go' => 38380,
						'iCloud' => 38845,
						'Instagram' => 37855,
						'Netflix' => 37856,
						'Office 365' => 38042,
						'Origin' => 38043,
						'Player Unknown\'s Battlegrounds' => 37857,
						'Playstation Network' => 38573,
						'Reddit' => 38062,
						'Snapchat' => 38512,
						'Steam' => 38082,
						'Tinder' => 37914,
						'Twitch' => 38530,
						'Twitter' => 38675,
						'Uplay PC' => 38638,
						'Whatsapp' => 38025,
						'Xbox Live' => 38072,
						'Youtube' => 37858,
					),
					'Chile' => array(
						'Apex Legends' => 38137,
						'Banco Estado' => 37682,
						'Banco Santander' => 37351,
						'Blizzard Battle.net' => 38104,
						'Call of Duty' => 38938,
						'Claro' => 36290,
						'Clash of Clans' => 37304,
						'Correos' => 37025,
						'Counter-Strike' => 38246,
						'Crunchyroll' => 38093,
						'Dead By Daylight' => 37436,
						'Discord' => 37758,
						'Dota 2' => 38477,
						'EA' => 36884,
						'Entel' => 37680,
						'Facebook' => 36239,
						'Facebook Messenger' => 36285,
						'Falabella' => 37681,
						'Fifa' => 38432,
						'Fortnite' => 36997,
						'Gmail' => 36499,
						'Google' => 36284,
						'Google Drive' => 38560,
						'GTA 5' => 38305,
						'Gtd Manquehue' => 37683,
						'HBO' => 36353,
						'iCloud' => 38854,
						'Instagram' => 36283,
						'Itaú' => 38473,
						'LinkedIn' => 38625,
						'Movistar' => 36289,
						'Mundo Pacifico' => 37684,
						'Netflix' => 36282,
						'Office 365' => 38077,
						'Origin' => 38102,
						'Outlook' => 36281,
						'Player Unknown\'s Battlegrounds' => 36564,
						'Playstation Network' => 36280,
						'Pokémon Go' => 36293,
						'Rainbow Six' => 36270,
						'Reddit' => 37484,
						'Roblox' => 38930,
						'SII' => 37679,
						'Skype' => 36279,
						'Snapchat' => 36278,
						'Spotify' => 36274,
						'Steam' => 36272,
						'Teamviewer' => 37068,
						'Telegram' => 38170,
						'Telsur' => 36292,
						'Tinder' => 37907,
						'Twitch' => 36541,
						'Twitter' => 36273,
						'Uplay PC' => 36271,
						'VTR' => 36291,
						'Warframe' => 37123,
						'Whatsapp' => 36277,
						'Wom' => 38308,
						'Xbox Live' => 37024,
						'Yahoo Mail' => 36276,
						'Youtube' => 36275,
					),
					'Colombia' => array(
						'Apex Legends' => 38140,
						'BBVA' => 37781,
						'Blizzard Battle.net' => 38148,
						'Call of Duty' => 38937,
						'Claro' => 37788,
						'Directv' => 37968,
						'Discord' => 38552,
						'EA' => 38282,
						'ETB' => 37967,
						'Facebook' => 37782,
						'Facebook Messenger' => 38257,
						'Fifa' => 38431,
						'Fortnite' => 37783,
						'Free Fire' => 38805,
						'Gmail' => 37779,
						'Google' => 37780,
						'Google Drive' => 39067,
						'GTA 5' => 38277,
						'HBO' => 38370,
						'iCloud' => 38857,
						'Instagram' => 37784,
						'Movistar' => 37789,
						'Netflix' => 37820,
						'Origin' => 38424,
						'Outlook' => 38464,
						'Player Unknown\'s Battlegrounds' => 37785,
						'Playstation Network' => 38391,
						'Snapchat' => 38506,
						'Spotify' => 38168,
						'Steam' => 38933,
						'Teamviewer' => 38460,
						'Telegram' => 38484,
						'Tigo' => 37966,
						'Tinder' => 37908,
						'Twitter' => 38169,
						'Waze' => 39070,
						'Whatsapp' => 37786,
						'Xbox Live' => 38071,
						'Yahoo Mail' => 38924,
						'Youtube' => 37787,
					),
					'România' => array(
						'Apex Legends' => 38142,
						'Battlefield' => 38441,
						'Blizzard Battle.net' => 37867,
						'Brawl Stars' => 38817,
						'Call of Duty' => 38934,
						'Counter-strike' => 38237,
						'Destiny' => 38988,
						'Digi' => 38971,
						'Discord' => 37953,
						'Dota 2' => 38222,
						'EA' => 38039,
						'Facebook' => 37868,
						'Facebook Messenger' => 37869,
						'Fifa' => 38046,
						'Fortnite' => 38070,
						'Gmail' => 38549,
						'Google' => 37870,
						'Google Play' => 38524,
						'GTA 5' => 38281,
						'HBO Go' => 38383,
						'iCloud' => 38849,
						'Instagram' => 37871,
						'Netflix' => 37872,
						'Orange' => 38970,
						'Origin' => 38045,
						'Player Unknown\'s Battlegrounds' => 37873,
						'Playstation Network' => 38407,
						'Reddit' => 38063,
						'Roblox' => 38918,
						'Snapchat' => 38510,
						'Steam' => 38083,
						'Telekom' => 38931,
						'Tinder' => 37913,
						'Twitter' => 38674,
						'UPC' => 38968,
						'Uplay PC' => 38637,
						'Vodafone' => 38967,
						'Whatsapp' => 38027,
						'Wikipedia' => 38875,
						'Xbox Live' => 38073,
						'Yahoo Mail' => 38455,
						'Youtube' => 37874,
					),
					'Magyarország' => array(
						'Apex Legends' => 38143,
						'Battlefield' => 38450,
						'Blizzard Battle.net' => 37883,
						'Call of Duty' => 39004,
						'Counter-strike' => 38242,
						'Destiny' => 38979,
						'Discord' => 38454,
						'Dota 2' => 38475,
						'EA' => 38038,
						'Escape from Tarkov' => 39055,
						'Facebook' => 37884,
						'Facebook Messenger' => 37885,
						'Fifa' => 38437,
						'Fortnite' => 38808,
						'Ghost Recon' => 38991,
						'Gmail' => 38514,
						'Google' => 37886,
						'GTA 5' => 38280,
						'HBO Go' => 38382,
						'iCloud' => 38852,
						'Instagram' => 37887,
						'Mastercard' => 38592,
						'Netflix' => 37888,
						'Office 365' => 38040,
						'Origin' => 38044,
						'Outlook' => 38078,
						'Pinterest' => 37954,
						'Player Unknown\'s Battlegrounds' => 37889,
						'Playstation Network' => 38408,
						'Rainbow Six' => 38486,
						'Reddit' => 38065,
						'Snapchat' => 38507,
						'Steam' => 38232,
						'Tinder' => 37910,
						'Twitch' => 39016,
						'Twitter' => 38673,
						'Uplay PC' => 38354,
						'Whatsapp' => 38372,
						'Wikipedia' => 38876,
						'Xbox Live' => 38074,
						'Yahoo Mail' => 38886,
						'Youtube' => 37890,
					),
					'Ecuador' => array(
						'Call of Duty' => 38936,
						'Claro' => 37985,
						'CNT' => 37990,
						'EA' => 38421,
						'Facebook' => 37797,
						'Facebook Messenger' => 38256,
						'Fortnite' => 37798,
						'HBO' => 38368,
						'iCloud' => 38856,
						'Instagram' => 37799,
						'iPlanet' => 37986,
						'Movistar' => 37984,
						'Nedetel' => 37987,
						'Netflix' => 37819,
						'Netlife' => 37991,
						'Playstation Network' => 38577,
						'Puntonet' => 37988,
						'Steam' => 38932,
						'Telegram' => 38482,
						'TVCable' => 37989,
						'Twitter' => 38670,
						'Whatsapp' => 37800,
						'Youtube' => 37801,
					),
				)
			)
		),
	);

	const API_TOKEN = 'YW5kcm9pZF9hcGlfdXNlcl92MTpxTkRyenZSczY1bW1ESlk0ZVNIWmtobFY=';

	public function collectData(){

		if($this->queriedContext == 'All Websites') {
			$html = getSimpleHTMLDOM($this->getURI() . '/archive/')
				or returnClientError('Impossible to query website !.');

			$table = $html->find('table.table-striped', 0);

			$maxCount = 10;
			foreach ($table->find('tr') as $event) {
				$td = $event->find('td', 0);

				if (is_null($td)) {
					continue;
				}

				$link = $event->find('td', 0)->find('a', 0);

				$item = $this->collectArticleData($link->getAttribute('href'));
				$this->items[] = $item;
				if($maxCount == 0) break;
				$maxCount -= 1;
			}
		} else {
			$this->items = $this->collectCompanyEvents($this->getInput('website'));
		}
	}

	protected function collectArticleData($link) {

		preg_match('/\/([0-9]{3,})/', $link, $matches);
		$eventId = $matches[1];

		$header = array(
			'Authorization: Basic ' . self::API_TOKEN
		);

		$article = getContents('https://downdetectorapi.com/v1/events/' . $eventId, $header)
			or returnServerError('Could not request DownDetector API.');
		$article_json = json_decode($article);

		$item = array();
		$item['uri'] = $this->getURI() . $link;
		$item['id'] = $article_json->id;
		$item['title'] = $article_json->title;
		$item['content'] = $article_json->body;
		$item['timestamp'] = (new DateTime($article_json->started_at))->getTimestamp();
		return $item;

	}

	protected function collectCompanyEvents($companyId) {

		$header = array(
			'Authorization: Basic ' . self::API_TOKEN
		);

		$events = getContents('https://downdetectorapi.com/v1/companies/' . $companyId . '/events/', $header)
			or returnServerError('Could not request DownDetector API.');
		$events_json = json_decode($events);

		$items = array();

		foreach($events_json as $event) {
			$item = array();
			$item['id'] = $event->id;
			$item['title'] = $event->title;
			$item['content'] = $event->body;
			$item['timestamp'] = (new DateTime($event->started_at))->getTimestamp();
			$items[] = $item;
		}

		return $items;

	}

	public function getURI() {
		if($this->getInput('country') !== null) {
			return $this->getInput('country');
		} else {
			return self::URI;
		}
	}
}
