#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ------------------------------------------------------------------------------
# automatically generates the section_example.dox
srcdir=$1; shift
L=$*
L=`echo "$L" | awk '{for(i=1;i<=NF;++i)print $i}' | sort -u`
#echo "srcdir=$srcdir" 1>&2
#echo "L=$L" 1>&2

cat << EOF1
// do not edit: this file was automatically generated by `basename $0`
namespace rheolef {
/**
@page example_page Examples

The following examples are fully documented in the @ref usersguide_page :

<table>
EOF1
for x in $L; do
  comment=`grep -e "@examplefile" "$srcdir/$x" | awk '{for (i=4; i <= NF; ++i) printf("%s ",$i)}'`
  if test x"$comment" = x""; then
    echo "`basename $0`: error: $srcdir/$x without @examplefile" 1>&2
    exit 0
  fi
  #comment=`echo $comment`; # dot it flat
  #echo "x=$x" 1>&2
  #echo "comment=$comment" 1>&2
  cat << EOF2
<tr valign="top">
  <td>
    @ref $x
  </td>
  <td>
    $comment
  </td>
</tr>
EOF2
done

cat << EOF3
</table>
*/
} // namespace rheolef
EOF3
