/* Generated by re2c */
#line 1 "real_world/parse_date_1_78.re"
// re2c $INPUT -o $OUTPUT -db
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.re,v 1.78 2008/05/02 12:48:19 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == TIMELIB_UNSET) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 960 "real_world/parse_date_1_78.re"



#line 846 "real_world/parse_date_1_78.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,  16,  64,  48,  96,   0, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 192, 128, 128, 128, 
		192, 128, 128, 128, 128, 128, 192, 128, 
		128, 128, 192, 192, 192, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 30) YYFILL(30);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy2;
	case '\t':
	case ' ':	goto yy6;
	case '(':	goto yy8;
	case '+':
	case '-':	goto yy9;
	case ',':
	case '.':	goto yy10;
	case '0':	goto yy11;
	case '1':	goto yy12;
	case '2':	goto yy13;
	case '3':	goto yy14;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy15;
	case '@':	goto yy16;
	case 'A':	goto yy17;
	case 'B':
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy19;
	case 'D':	goto yy20;
	case 'E':	goto yy21;
	case 'F':	goto yy22;
	case 'G':	goto yy23;
	case 'I':	goto yy24;
	case 'J':	goto yy25;
	case 'L':	goto yy26;
	case 'M':	goto yy27;
	case 'N':	goto yy28;
	case 'O':	goto yy29;
	case 'P':	goto yy30;
	case 'S':	goto yy31;
	case 'T':	goto yy32;
	case 'V':	goto yy33;
	case 'W':	goto yy34;
	case 'X':	goto yy35;
	case 'Y':	goto yy36;
	case 'a':	goto yy37;
	case 'b':
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy38;
	case 'd':	goto yy39;
	case 'e':	goto yy40;
	case 'f':	goto yy41;
	case 'j':	goto yy42;
	case 'l':	goto yy43;
	case 'm':	goto yy44;
	case 'n':	goto yy45;
	case 'o':	goto yy46;
	case 'p':	goto yy47;
	case 's':	goto yy48;
	case 't':	goto yy49;
	case 'w':	goto yy50;
	case 'y':	goto yy51;
	default:	goto yy4;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(3, *YYCURSOR);
#line 1670 "real_world/parse_date_1_78.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 971 "real_world/parse_date_1_78.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	++YYCURSOR;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1676 "real_world/parse_date_1_78.re"
	{
		add_error(s, "Unexpected character");
		goto std;
	}
#line 982 "real_world/parse_date_1_78.c"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy52;
	}
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy55;
yy7:
	YYDEBUG(7, *YYCURSOR);
#line 1665 "real_world/parse_date_1_78.re"
	{
		goto std;
	}
#line 998 "real_world/parse_date_1_78.c"
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy5;
	if (yych <= 'Z') goto yy38;
	if (yych <= '`') goto yy5;
	if (yych <= 'z') goto yy38;
	goto yy5;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy52;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy57;
	case '0':
	case '1':	goto yy59;
	case '2':	goto yy60;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy61;
	default:	goto yy5;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	++YYCURSOR;
	goto yy7;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy62;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy64;
	case '-':	goto yy65;
	case '.':	goto yy66;
	case '/':	goto yy67;
	case '0':	goto yy68;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy69;
	case ':':	goto yy70;
	case 'n':	goto yy87;
	case 'r':	goto yy88;
	case 's':	goto yy89;
	case 't':	goto yy90;
	default:	goto yy5;
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy91;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy93;
	case '-':	goto yy65;
	case '.':	goto yy94;
	case '/':	goto yy67;
	case '0':
	case '1':
	case '2':	goto yy69;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy95;
	case ':':	goto yy96;
	case 'n':	goto yy87;
	case 'r':	goto yy88;
	case 's':	goto yy89;
	case 't':	goto yy90;
	default:	goto yy5;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy91;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy93;
	case '-':	goto yy65;
	case '.':	goto yy94;
	case '/':	goto yy67;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy95;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy99;
	case ':':	goto yy96;
	case 'n':	goto yy87;
	case 'r':	goto yy88;
	case 's':	goto yy89;
	case 't':	goto yy90;
	default:	goto yy5;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy91;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy93;
	case '-':	goto yy65;
	case '.':	goto yy94;
	case '/':	goto yy67;
	case '0':
	case '1':	goto yy99;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy100;
	case ':':	goto yy96;
	case 'n':	goto yy87;
	case 'r':	goto yy88;
	case 's':	goto yy89;
	case 't':	goto yy90;
	default:	goto yy5;
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy91;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy93;
	case '-':	goto yy65;
	case '.':	goto yy94;
	case '/':	goto yy67;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy100;
	case ':':	goto yy96;
	case 'n':	goto yy87;
	case 'r':	goto yy88;
	case 's':	goto yy89;
	case 't':	goto yy90;
	default:	goto yy5;
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy101;
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy102;
	goto yy5;
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy105;
			if (yych >= 'A') goto yy106;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy107;
				goto yy106;
			} else {
				if (yych <= 'P') goto yy108;
				if (yych <= 'T') goto yy106;
				goto yy109;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy106;
			} else {
				if (yych == 'g') goto yy111;
				goto yy110;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy112;
				goto yy110;
			} else {
				if (yych <= 'u') goto yy113;
				if (yych <= 'z') goto yy110;
			}
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
#line 1581 "real_world/parse_date_1_78.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1354 "real_world/parse_date_1_78.c"
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy106;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy110;
		goto yy18;
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy106;
			goto yy114;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'e') goto yy115;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'I') goto yy116;
			if (yych <= 'K') goto yy106;
			goto yy117;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy110;
			goto yy118;
		} else {
			if (yych == 'l') goto yy119;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy105;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy106;
				goto yy120;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy121;
				goto yy106;
			} else {
				if (yych <= 'O') goto yy122;
				if (yych <= 'Q') goto yy106;
				goto yy123;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy106;
				if (yych <= '`') goto yy18;
				goto yy110;
			} else {
				if (yych <= 'e') goto yy124;
				if (yych <= 'h') goto yy110;
				goto yy125;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy126;
				goto yy110;
			} else {
				if (yych <= 'r') goto yy127;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy106;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy128;
			goto yy106;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy18;
			} else {
				if (yych == '/') goto yy18;
				goto yy130;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy106;
			} else {
				if (yych <= 'I') goto yy135;
				if (yych <= 'U') goto yy106;
				goto yy136;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy136;
				goto yy106;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy137;
			if (yych <= 'T') goto yy106;
			goto yy138;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy139;
		} else {
			if (yych == 'u') goto yy140;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy141;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy106;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy142;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy143;
		} else {
			if (yych == 'I') goto yy144;
			if (yych <= 'N') goto yy106;
			goto yy145;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy146;
			goto yy110;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy147;
				goto yy110;
			} else {
				if (yych <= 'o') goto yy148;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy149;
				goto yy106;
			} else {
				if (yych <= 'I') goto yy150;
				if (yych <= 'N') goto yy106;
				goto yy151;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy106;
				goto yy18;
			} else {
				if (yych == 'e') goto yy152;
				goto yy110;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy153;
				goto yy110;
			} else {
				if (yych <= 'o') goto yy154;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy106;
			goto yy155;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'c') goto yy156;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy106;
			goto yy157;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'r') goto yy158;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy105;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy159;
				goto yy106;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy160;
				goto yy106;
			} else {
				if (yych <= 'I') goto yy161;
				if (yych <= 'T') goto yy106;
				goto yy145;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy106;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy162;
				if (yych <= 'd') goto yy110;
				goto yy163;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy164;
				goto yy110;
			} else {
				if (yych <= 'u') goto yy148;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy105;
	case '0':
	case '1':	goto yy165;
	case '2':	goto yy166;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy167;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy106;
	case 'E':	goto yy150;
	case 'H':	goto yy168;
	case 'O':	goto yy169;
	case 'U':	goto yy170;
	case 'W':	goto yy171;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy110;
	case 'e':	goto yy153;
	case 'h':	goto yy172;
	case 'o':	goto yy173;
	case 'u':	goto yy174;
	case 'w':	goto yy175;
	default:	goto yy18;
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy18;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy18;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy176;
				goto yy106;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy106;
			goto yy177;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'e') goto yy178;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy18;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy18;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy135;
				goto yy106;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy110;
				goto yy18;
			}
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy106;
			goto yy179;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy110;
		} else {
			if (yych <= 'e') goto yy180;
			if (yych <= 'z') goto yy110;
			goto yy18;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy107;
				goto yy106;
			} else {
				if (yych <= 'P') goto yy108;
				if (yych <= 'T') goto yy106;
				goto yy109;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy106;
				goto yy18;
			} else {
				if (yych == 'g') goto yy107;
				goto yy106;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy108;
				goto yy106;
			} else {
				if (yych <= 'u') goto yy109;
				if (yych <= 'z') goto yy106;
				goto yy18;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy106;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy106;
		goto yy18;
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy106;
			goto yy114;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'e') goto yy114;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'I') goto yy116;
			if (yych <= 'K') goto yy106;
			goto yy117;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy106;
			goto yy116;
		} else {
			if (yych == 'l') goto yy117;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy105;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy106;
				goto yy120;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy121;
				goto yy106;
			} else {
				if (yych <= 'O') goto yy122;
				if (yych <= 'Q') goto yy106;
				goto yy123;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy106;
				if (yych <= '`') goto yy18;
				goto yy106;
			} else {
				if (yych <= 'e') goto yy120;
				if (yych <= 'h') goto yy106;
				goto yy121;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy122;
				goto yy106;
			} else {
				if (yych <= 'r') goto yy123;
				if (yych <= 'z') goto yy106;
				goto yy18;
			}
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy137;
			if (yych <= 'T') goto yy106;
			goto yy138;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy137;
		} else {
			if (yych == 'u') goto yy138;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy141;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy106;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy141;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy143;
		} else {
			if (yych == 'I') goto yy144;
			if (yych <= 'N') goto yy106;
			goto yy145;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy143;
			goto yy106;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy144;
				goto yy106;
			} else {
				if (yych <= 'o') goto yy145;
				if (yych <= 'z') goto yy106;
				goto yy18;
			}
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy149;
				goto yy106;
			} else {
				if (yych <= 'I') goto yy150;
				if (yych <= 'N') goto yy106;
				goto yy151;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy106;
				goto yy18;
			} else {
				if (yych == 'e') goto yy149;
				goto yy106;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy150;
				goto yy106;
			} else {
				if (yych <= 'o') goto yy151;
				if (yych <= 'z') goto yy106;
				goto yy18;
			}
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy106;
			goto yy155;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'c') goto yy155;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy106;
			goto yy157;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'r') goto yy157;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy105;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy159;
				goto yy106;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy160;
				goto yy106;
			} else {
				if (yych <= 'I') goto yy161;
				if (yych <= 'T') goto yy106;
				goto yy145;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy106;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy159;
				if (yych <= 'd') goto yy106;
				goto yy160;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy161;
				goto yy106;
			} else {
				if (yych <= 'u') goto yy145;
				if (yych <= 'z') goto yy106;
				goto yy18;
			}
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy105;
	case '0':
	case '1':	goto yy165;
	case '2':	goto yy166;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy167;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy106;
	case 'E':
	case 'e':	goto yy150;
	case 'H':
	case 'h':	goto yy168;
	case 'O':
	case 'o':	goto yy169;
	case 'U':
	case 'u':	goto yy170;
	case 'W':
	case 'w':	goto yy171;
	default:	goto yy18;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy106;
			goto yy177;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'e') goto yy177;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy106;
			goto yy179;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '`') goto yy18;
			goto yy106;
		} else {
			if (yych <= 'e') goto yy179;
			if (yych <= 'z') goto yy106;
			goto yy18;
		}
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(53, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy52;
	}
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy55;
yy54:
	YYDEBUG(54, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy7;
						} else {
							goto yy5;
						}
					} else {
						goto yy18;
					}
				} else {
					if (yyaccept == 3) {
						goto yy76;
					} else {
						goto yy132;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy204;
					} else {
						goto yy209;
					}
				} else {
					if (yyaccept == 7) {
						goto yy270;
					} else {
						goto yy268;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy288;
					} else {
						goto yy323;
					}
				} else {
					if (yyaccept == 11) {
						goto yy387;
					} else {
						goto yy389;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy393;
					} else {
						goto yy489;
					}
				} else {
					if (yyaccept == 15) {
						goto yy528;
					} else {
						goto yy647;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy651;
						} else {
							goto yy682;
						}
					} else {
						goto yy696;
					}
				} else {
					if (yyaccept == 20) {
						goto yy709;
					} else {
						goto yy732;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy877;
					} else {
						goto yy560;
					}
				} else {
					if (yyaccept == 24) {
						goto yy892;
					} else {
						goto yy968;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy986;
					} else {
						goto yy991;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1020;
					} else {
						goto yy1033;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1039;
					} else {
						goto yy1097;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1100;
					} else {
						goto yy1190;
					}
				}
			}
		}
	}
yy55:
	YYDEBUG(55, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	YYDEBUG(56, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy54;
				goto yy181;
			} else {
				if (yych == 'D') goto yy183;
				if (yych <= 'E') goto yy54;
				goto yy184;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy74;
				if (yych <= 'L') goto yy54;
				goto yy185;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy54;
					goto yy186;
				} else {
					if (yych <= 'T') goto yy82;
					if (yych <= 'V') goto yy54;
					goto yy84;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy86;
				if (yych <= 'c') goto yy54;
				goto yy183;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy54;
					goto yy184;
				} else {
					if (yych == 'h') goto yy74;
					goto yy54;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy185;
				if (yych <= 'r') goto yy54;
				if (yych <= 's') goto yy186;
				goto yy82;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy54;
					goto yy84;
				} else {
					if (yych == 'y') goto yy86;
					goto yy54;
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(58, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy52;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy57;
		goto yy54;
	} else {
		if (yych <= '-') goto yy57;
		if (yych <= '/') goto yy54;
		if (yych <= '9') goto yy55;
		goto yy54;
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy187;
				} else {
					if (yych <= ':') goto yy188;
					if (yych <= 'C') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy182;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '4') {
					if (yych <= '/') goto yy18;
					goto yy187;
				} else {
					if (yych <= '5') goto yy189;
					if (yych <= '9') goto yy190;
					goto yy188;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy18;
					goto yy182;
				} else {
					if (yych == 'F') goto yy182;
					goto yy18;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy182;
					goto yy18;
				} else {
					if (yych <= 'M') goto yy182;
					if (yych <= 'R') goto yy18;
					goto yy182;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy182;
				if (yych <= 'X') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy18;
					goto yy182;
				} else {
					if (yych == 'f') goto yy182;
					goto yy18;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy182;
					goto yy18;
				} else {
					if (yych <= 'm') goto yy182;
					if (yych <= 'r') goto yy18;
					goto yy182;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy189;
				} else {
					if (yych <= '9') goto yy190;
					if (yych <= ':') goto yy188;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy18;
				if (yych <= 'F') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy182;
					goto yy18;
				} else {
					if (yych <= 'M') goto yy182;
					if (yych <= 'R') goto yy18;
					goto yy182;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy182;
				if (yych <= 'X') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy18;
					goto yy182;
				} else {
					if (yych == 'f') goto yy182;
					goto yy18;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy182;
					goto yy18;
				} else {
					if (yych <= 'm') goto yy182;
					if (yych <= 'r') goto yy18;
					goto yy182;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy64;
	if (yych <= '0') goto yy193;
	if (yych <= '1') goto yy194;
	if (yych <= '9') goto yy195;
	goto yy64;
yy63:
	YYDEBUG(63, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy64:
	YYDEBUG(64, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy63;
	case '-':
	case '.':	goto yy191;
	case 'A':
	case 'a':	goto yy71;
	case 'D':
	case 'd':	goto yy72;
	case 'F':
	case 'f':	goto yy73;
	case 'H':
	case 'h':	goto yy74;
	case 'I':	goto yy75;
	case 'J':
	case 'j':	goto yy77;
	case 'M':
	case 'm':	goto yy78;
	case 'N':
	case 'n':	goto yy79;
	case 'O':
	case 'o':	goto yy80;
	case 'S':
	case 's':	goto yy81;
	case 'T':
	case 't':	goto yy82;
	case 'V':	goto yy83;
	case 'W':
	case 'w':	goto yy84;
	case 'X':	goto yy85;
	case 'Y':
	case 'y':	goto yy86;
	default:	goto yy54;
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '0') goto yy196;
	if (yych <= '1') goto yy197;
	if (yych <= '9') goto yy198;
	goto yy192;
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy192;
		if (yych <= '0') goto yy203;
		goto yy205;
	} else {
		if (yych <= '5') goto yy206;
		if (yych <= '9') goto yy207;
		goto yy192;
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy208;
	case '3':	goto yy210;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy211;
	case 'A':
	case 'a':	goto yy212;
	case 'D':
	case 'd':	goto yy213;
	case 'F':
	case 'f':	goto yy214;
	case 'J':
	case 'j':	goto yy215;
	case 'M':
	case 'm':	goto yy216;
	case 'N':
	case 'n':	goto yy217;
	case 'O':
	case 'o':	goto yy218;
	case 'S':
	case 's':	goto yy219;
	default:	goto yy54;
	}
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy62;
			if (yych <= ',') goto yy64;
			goto yy220;
		} else {
			if (yych <= '.') goto yy66;
			if (yych <= '/') goto yy67;
			if (yych <= '5') goto yy221;
			goto yy222;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy70;
			if (yych == 'n') goto yy87;
			goto yy64;
		} else {
			if (yych <= 'r') goto yy88;
			if (yych <= 's') goto yy89;
			if (yych <= 't') goto yy90;
			goto yy64;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy91;
			if (yych <= ',') goto yy93;
			goto yy220;
		} else {
			if (yych <= '.') goto yy94;
			if (yych <= '/') goto yy67;
			if (yych <= '5') goto yy221;
			goto yy222;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy96;
			if (yych == 'n') goto yy87;
			goto yy93;
		} else {
			if (yych <= 'r') goto yy88;
			if (yych <= 's') goto yy89;
			if (yych <= 't') goto yy90;
			goto yy93;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy223;
	if (yych <= '9') goto yy224;
	goto yy54;
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy225;
		if (yych <= 'T') goto yy54;
		goto yy226;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy54;
			goto yy225;
		} else {
			if (yych == 'u') goto yy226;
			goto yy54;
		}
	}
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy227;
		if (yych <= 'D') goto yy54;
		goto yy228;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy227;
		} else {
			if (yych == 'e') goto yy228;
			goto yy54;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy229;
			goto yy54;
		} else {
			if (yych <= 'O') goto yy230;
			if (yych <= 'Q') goto yy54;
			goto yy231;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy229;
			goto yy54;
		} else {
			if (yych <= 'o') goto yy230;
			if (yych == 'r') goto yy231;
			goto yy54;
		}
	}
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy232;
	if (yych == 'o') goto yy232;
	goto yy54;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			if (yych <= '.') goto yy233;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy235;
			if (yych == 'I') goto yy237;
		} else {
			if (yych == 'W') goto yy76;
			if (yych <= 'X') goto yy238;
		}
	}
yy76:
	YYDEBUG(76, *YYCURSOR);
#line 1334 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3053 "real_world/parse_date_1_78.c"
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy239;
		if (yych <= 'T') goto yy54;
		goto yy240;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy239;
		} else {
			if (yych == 'u') goto yy240;
			goto yy54;
		}
	}
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy241;
			goto yy54;
		} else {
			if (yych <= 'I') goto yy242;
			if (yych <= 'N') goto yy54;
			goto yy243;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy241;
			goto yy54;
		} else {
			if (yych <= 'i') goto yy242;
			if (yych == 'o') goto yy243;
			goto yy54;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy244;
	if (yych == 'o') goto yy244;
	goto yy54;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy245;
	if (yych == 'c') goto yy245;
	goto yy54;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'E') goto yy247;
			if (yych <= 'T') goto yy54;
			goto yy248;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'e') goto yy247;
			if (yych == 'u') goto yy248;
			goto yy54;
		}
	}
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy249;
		if (yych <= 'T') goto yy54;
		goto yy250;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy54;
			goto yy249;
		} else {
			if (yych == 'u') goto yy250;
			goto yy54;
		}
	}
yy83:
	YYDEBUG(83, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy76;
			goto yy233;
		} else {
			if (yych == ' ') goto yy233;
			goto yy76;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy233;
			if (yych <= '/') goto yy76;
			goto yy235;
		} else {
			if (yych == 'I') goto yy85;
			goto yy76;
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy251;
	if (yych == 'e') goto yy251;
	goto yy54;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy76;
			goto yy233;
		} else {
			if (yych == ' ') goto yy233;
			goto yy76;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy233;
			if (yych <= '/') goto yy76;
			goto yy235;
		} else {
			if (yych == 'I') goto yy237;
			goto yy76;
		}
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy252;
	if (yych == 'e') goto yy252;
	goto yy54;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy244;
		goto yy54;
	} else {
		if (yych <= 'd') goto yy253;
		if (yych == 'o') goto yy244;
		goto yy54;
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy253;
	goto yy54;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'E') goto yy247;
			if (yych == 'U') goto yy248;
			goto yy54;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy246;
			if (yych <= 'd') goto yy54;
			goto yy247;
		} else {
			if (yych <= 's') goto yy54;
			if (yych <= 't') goto yy253;
			if (yych <= 'u') goto yy248;
			goto yy54;
		}
	}
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy249;
		if (yych <= 'T') goto yy54;
		goto yy250;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy54;
			goto yy254;
		} else {
			if (yych == 'u') goto yy250;
			goto yy54;
		}
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy93;
	if (yych <= '0') goto yy193;
	if (yych <= '1') goto yy194;
	if (yych <= '9') goto yy195;
	goto yy93;
yy92:
	YYDEBUG(92, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy93:
	YYDEBUG(93, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy92;
	case '-':
	case '.':	goto yy191;
	case 'A':
	case 'a':	goto yy97;
	case 'D':
	case 'd':	goto yy72;
	case 'F':
	case 'f':	goto yy73;
	case 'H':
	case 'h':	goto yy74;
	case 'I':	goto yy75;
	case 'J':
	case 'j':	goto yy77;
	case 'M':
	case 'm':	goto yy78;
	case 'N':
	case 'n':	goto yy79;
	case 'O':
	case 'o':	goto yy80;
	case 'P':
	case 'p':	goto yy98;
	case 'S':
	case 's':	goto yy81;
	case 'T':
	case 't':	goto yy82;
	case 'V':	goto yy83;
	case 'W':
	case 'w':	goto yy84;
	case 'X':	goto yy85;
	case 'Y':
	case 'y':	goto yy86;
	default:	goto yy54;
	}
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy192;
		if (yych <= '0') goto yy255;
		goto yy256;
	} else {
		if (yych <= '5') goto yy257;
		if (yych <= '9') goto yy258;
		goto yy192;
	}
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy62;
			if (yych <= ',') goto yy64;
			goto yy220;
		} else {
			if (yych <= '.') goto yy66;
			if (yych <= '/') goto yy259;
			if (yych <= '5') goto yy221;
			goto yy222;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy70;
			if (yych == 'n') goto yy87;
			goto yy64;
		} else {
			if (yych <= 'r') goto yy88;
			if (yych <= 's') goto yy89;
			if (yych <= 't') goto yy90;
			goto yy64;
		}
	}
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy260;
	if (yych <= '9') goto yy261;
	goto yy54;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy262;
			goto yy54;
		} else {
			if (yych <= 'M') goto yy263;
			if (yych == 'P') goto yy225;
			goto yy54;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy226;
			if (yych == 'm') goto yy263;
			goto yy54;
		} else {
			if (yych <= 'p') goto yy225;
			if (yych == 'u') goto yy226;
			goto yy54;
		}
	}
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy262;
		goto yy54;
	} else {
		if (yych <= 'M') goto yy263;
		if (yych == 'm') goto yy263;
		goto yy54;
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy62;
			goto yy64;
		} else {
			if (yych <= '-') goto yy220;
			if (yych <= '.') goto yy264;
			if (yych <= '/') goto yy259;
			goto yy222;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy87;
			goto yy64;
		} else {
			if (yych <= 'r') goto yy88;
			if (yych <= 's') goto yy89;
			if (yych <= 't') goto yy90;
			goto yy64;
		}
	}
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy265;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy222;
	goto yy182;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych >= ':') goto yy54;
yy102:
	YYDEBUG(102, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(103, *YYCURSOR);
	if (yych <= '/') goto yy104;
	if (yych <= '9') goto yy102;
yy104:
	YYDEBUG(104, *YYCURSOR);
#line 1020 "real_world/parse_date_1_78.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3454 "real_world/parse_date_1_78.c"
yy105:
	YYDEBUG(105, *YYCURSOR);
	++YYCURSOR;
	goto yy18;
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy266;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy266;
		goto yy18;
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy266;
			goto yy267;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'o') goto yy267;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy266;
			goto yy269;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'r') goto yy269;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy266;
			goto yy271;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'g') goto yy271;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy266;
			goto yy267;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'o') goto yy274;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy266;
			goto yy269;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy275;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy266;
			goto yy271;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'g') goto yy276;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy266;
			goto yy277;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'c') goto yy277;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy266;
			goto yy277;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'c') goto yy278;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy266;
			goto yy279;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'g') goto yy279;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy280;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'e') goto yy280;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy266;
			goto yy279;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'g') goto yy281;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy280;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy282;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy266;
			goto yy283;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'b') goto yy283;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'F') goto yy284;
			if (yych <= 'Q') goto yy266;
			goto yy285;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'e') goto yy266;
			goto yy284;
		} else {
			if (yych == 'r') goto yy285;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy266;
			goto yy286;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'u') goto yy286;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy266;
			goto yy287;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'i') goto yy287;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy266;
			goto yy283;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'b') goto yy289;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy18;
				goto yy266;
			} else {
				if (yych <= 'F') goto yy284;
				if (yych <= 'Q') goto yy266;
				goto yy285;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy18;
				goto yy273;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy290;
				goto yy273;
			} else {
				if (yych <= 'r') goto yy291;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy266;
			goto yy286;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'u') goto yy292;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy266;
			goto yy287;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'i') goto yy293;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy266;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy294;
			goto yy266;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy130:
	YYDEBUG(130, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy129;
	}
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy131;
	if (yych <= '3') goto yy133;
	if (yych <= '9') goto yy134;
	goto yy54;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy296;
	if (yych <= '0') goto yy297;
	if (yych <= '1') goto yy298;
	if (yych <= '9') goto yy299;
	goto yy296;
yy132:
	YYDEBUG(132, *YYCURSOR);
#line 1321 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4045 "real_world/parse_date_1_78.c"
yy133:
	YYDEBUG(133, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy296;
		if (yych <= '0') goto yy297;
		goto yy298;
	} else {
		if (yych <= '2') goto yy301;
		if (yych <= '9') goto yy302;
		goto yy296;
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy296;
		if (yych <= '0') goto yy303;
		goto yy304;
	} else {
		if (yych <= '2') goto yy301;
		if (yych <= '9') goto yy302;
		goto yy296;
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy18;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy18;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy305;
				goto yy266;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy130;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy266;
			goto yy306;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'n') goto yy306;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'L') goto yy307;
			if (yych <= 'M') goto yy266;
			goto yy308;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'k') goto yy266;
			goto yy307;
		} else {
			if (yych == 'n') goto yy308;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy266;
			goto yy306;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy309;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy18;
				goto yy266;
			} else {
				if (yych <= 'L') goto yy307;
				if (yych <= 'M') goto yy266;
				goto yy308;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy18;
				goto yy273;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy310;
				goto yy273;
			} else {
				if (yych <= 'n') goto yy311;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy266;
			goto yy312;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 's') goto yy312;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy266;
			goto yy312;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 's') goto yy313;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'R') goto yy314;
			if (yych <= 'X') goto yy266;
			goto yy315;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'q') goto yy266;
			goto yy314;
		} else {
			if (yych == 'y') goto yy315;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy266;
			goto yy316;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'd') goto yy316;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy266;
			goto yy287;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'n') goto yy287;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy18;
				goto yy266;
			} else {
				if (yych <= 'R') goto yy314;
				if (yych <= 'X') goto yy266;
				goto yy315;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy18;
				goto yy273;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy317;
				goto yy273;
			} else {
				if (yych <= 'y') goto yy318;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy266;
			goto yy316;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy319;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy266;
			goto yy287;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy293;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy266;
			goto yy320;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'x') goto yy320;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy266;
			goto yy284;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'n') goto yy284;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'O') goto yy321;
			if (yych <= 'U') goto yy266;
			if (yych <= 'V') goto yy277;
			goto yy322;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'n') goto yy266;
			goto yy321;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy266;
				goto yy277;
			} else {
				if (yych <= 'w') goto yy322;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy266;
			goto yy320;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'x') goto yy324;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy266;
			goto yy284;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy290;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy105;
			} else {
				if (yych == '/') goto yy272;
				goto yy18;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy266;
				goto yy321;
			} else {
				if (yych <= 'U') goto yy266;
				if (yych <= 'V') goto yy277;
				goto yy322;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy18;
				goto yy273;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy325;
				if (yych <= 'u') goto yy273;
				goto yy278;
			} else {
				if (yych <= 'w') goto yy326;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy266;
			goto yy327;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 't') goto yy327;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy266;
			goto yy327;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy328;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy329;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'e') goto yy329;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy329;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy330;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy266;
			goto yy331;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 't') goto yy331;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy332;
				goto yy266;
			} else {
				if (yych <= 'P') goto yy333;
				if (yych <= 'U') goto yy266;
				goto yy334;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych == 'c') goto yy332;
				goto yy266;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy333;
				goto yy266;
			} else {
				if (yych <= 'v') goto yy334;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy266;
			goto yy284;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'x') goto yy284;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy266;
			goto yy331;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy335;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy105;
			} else {
				if (yych == '/') goto yy272;
				goto yy18;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy332;
				goto yy266;
			} else {
				if (yych <= 'P') goto yy333;
				if (yych <= 'U') goto yy266;
				goto yy334;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy266;
				if (yych <= '^') goto yy18;
				goto yy272;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'b') goto yy273;
				goto yy336;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy337;
				goto yy273;
			} else {
				if (yych <= 'v') goto yy338;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy266;
			goto yy284;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'x') goto yy290;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy70;
		goto yy54;
	} else {
		if (yych <= '9') goto yy339;
		if (yych <= ':') goto yy70;
		goto yy54;
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy70;
		goto yy54;
	} else {
		if (yych <= '4') goto yy339;
		if (yych == ':') goto yy70;
		goto yy54;
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy70;
	if (yych == ':') goto yy70;
	goto yy54;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'I') goto yy340;
			if (yych <= 'T') goto yy266;
			goto yy341;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy266;
			goto yy340;
		} else {
			if (yych == 'u') goto yy341;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych == 'D') goto yy342;
			if (yych <= 'L') goto yy266;
			goto yy343;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			if (yych <= 'c') goto yy266;
			goto yy342;
		} else {
			if (yych == 'm') goto yy343;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy344;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'e') goto yy344;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy345;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'e') goto yy345;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy266;
			} else {
				if (yych <= 'I') goto yy340;
				if (yych <= 'T') goto yy266;
				goto yy341;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy18;
				goto yy273;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy346;
				goto yy273;
			} else {
				if (yych <= 'u') goto yy347;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy18;
				goto yy266;
			} else {
				if (yych <= 'D') goto yy342;
				if (yych <= 'L') goto yy266;
				goto yy343;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy266;
				goto yy18;
			} else {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy18;
				goto yy273;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy348;
				goto yy273;
			} else {
				if (yych <= 'm') goto yy349;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy344;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy350;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy266;
			goto yy345;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy351;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy18;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy18;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy352;
				goto yy266;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy266;
				goto yy18;
			}
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= 'C') goto yy266;
			if (yych <= 'D') goto yy353;
			goto yy354;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 'd') goto yy353;
			if (yych <= 'e') goto yy354;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy266;
			if (yych <= 'D') goto yy353;
			goto yy354;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy273;
				goto yy355;
			} else {
				if (yych <= 'e') goto yy356;
				if (yych <= 'z') goto yy273;
				goto yy18;
			}
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy266;
			goto yy357;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy266;
			if (yych <= '`') goto yy18;
			goto yy266;
		} else {
			if (yych <= 's') goto yy357;
			if (yych <= 'z') goto yy266;
			goto yy18;
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy266;
			goto yy357;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy266;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 's') goto yy358;
			if (yych <= 'z') goto yy273;
			goto yy18;
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy182:
	YYDEBUG(182, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy54;
				goto yy181;
			} else {
				if (yych == 'D') goto yy183;
				if (yych <= 'E') goto yy54;
				goto yy184;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy74;
				if (yych <= 'L') goto yy54;
				goto yy185;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy54;
					goto yy186;
				} else {
					if (yych <= 'T') goto yy82;
					if (yych <= 'V') goto yy54;
					goto yy84;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy86;
				if (yych <= 'c') goto yy54;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy54;
					goto yy184;
				} else {
					if (yych == 'h') goto yy74;
					goto yy54;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy185;
				if (yych <= 'r') goto yy54;
				if (yych <= 's') goto yy186;
				goto yy82;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy54;
					goto yy84;
				} else {
					if (yych == 'y') goto yy86;
					goto yy54;
				}
			}
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy227;
	if (yych == 'a') goto yy227;
	goto yy54;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy230;
		if (yych <= 'Q') goto yy54;
		goto yy231;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy54;
			goto yy230;
		} else {
			if (yych == 'r') goto yy231;
			goto yy54;
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy242;
		if (yych <= 'N') goto yy54;
		goto yy243;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy54;
			goto yy242;
		} else {
			if (yych == 'o') goto yy243;
			goto yy54;
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'E') goto yy359;
			if (yych <= 'T') goto yy54;
			goto yy248;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'e') goto yy359;
			if (yych == 'u') goto yy248;
			goto yy54;
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy360;
				} else {
					if (yych <= '9') goto yy361;
					if (yych >= ';') goto yy18;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy18;
				if (yych <= 'F') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy182;
					goto yy18;
				} else {
					if (yych <= 'M') goto yy182;
					if (yych <= 'R') goto yy18;
					goto yy182;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy182;
				if (yych <= 'X') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy18;
					goto yy182;
				} else {
					if (yych == 'f') goto yy182;
					goto yy18;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy182;
					goto yy18;
				} else {
					if (yych <= 'm') goto yy182;
					if (yych <= 'r') goto yy18;
					goto yy182;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy362;
	if (yych <= '9') goto yy105;
	goto yy18;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '/') goto yy18;
				if (yych <= '9') goto yy361;
				if (yych <= 'C') goto yy18;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy182;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '/') goto yy18;
				if (yych <= '9') goto yy363;
				if (yych <= 'C') goto yy18;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy182;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy191:
	YYDEBUG(191, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy192:
	YYDEBUG(192, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy191;
	case 'A':
	case 'a':	goto yy71;
	case 'D':
	case 'd':	goto yy199;
	case 'F':
	case 'f':	goto yy200;
	case 'I':	goto yy75;
	case 'J':
	case 'j':	goto yy77;
	case 'M':
	case 'm':	goto yy201;
	case 'N':
	case 'n':	goto yy79;
	case 'O':
	case 'o':	goto yy80;
	case 'S':
	case 's':	goto yy202;
	case 'V':	goto yy83;
	case 'X':	goto yy85;
	default:	goto yy54;
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy54;
	if (yych <= '.') goto yy364;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy195;
	goto yy54;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy54;
	if (yych <= '.') goto yy364;
	if (yych <= '/') goto yy54;
	if (yych >= '3') goto yy54;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy54;
	if (yych <= '.') goto yy364;
	goto yy54;
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy54;
		if (yych <= '-') goto yy365;
		goto yy364;
	} else {
		if (yych <= '/') goto yy54;
		if (yych <= '9') goto yy198;
		goto yy54;
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy54;
		if (yych <= '-') goto yy365;
		goto yy364;
	} else {
		if (yych <= '/') goto yy54;
		if (yych >= '3') goto yy54;
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy54;
	if (yych <= '-') goto yy365;
	if (yych <= '.') goto yy364;
	goto yy54;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy228;
	if (yych == 'e') goto yy228;
	goto yy54;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy229;
	if (yych == 'e') goto yy229;
	goto yy54;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy241;
	if (yych == 'a') goto yy241;
	goto yy54;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy366;
	if (yych == 'e') goto yy366;
	goto yy54;
yy203:
	YYDEBUG(203, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		goto yy367;
	} else {
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy207;
		if (yych <= ':') goto yy368;
	}
yy204:
	YYDEBUG(204, *YYCURSOR);
#line 1099 "real_world/parse_date_1_78.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 5758 "real_world/parse_date_1_78.c"
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		if (yych <= '.') goto yy367;
		goto yy204;
	} else {
		if (yych <= '2') goto yy207;
		if (yych <= '9') goto yy224;
		if (yych <= ':') goto yy368;
		goto yy204;
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		goto yy367;
	} else {
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy224;
		if (yych <= ':') goto yy368;
		goto yy204;
	}
yy207:
	YYDEBUG(207, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		goto yy367;
	} else {
		if (yych == ':') goto yy368;
		goto yy204;
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy369;
		} else {
			if (yych <= '9') goto yy211;
			if (yych >= 'n') goto yy370;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy370;
		} else {
			if (yych <= 's') goto yy371;
			if (yych <= 't') goto yy372;
		}
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
#line 1191 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 5835 "real_world/parse_date_1_78.c"
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy209;
			goto yy369;
		} else {
			if (yych <= '1') goto yy211;
			if (yych <= 'm') goto yy209;
			goto yy370;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy209;
			goto yy370;
		} else {
			if (yych <= 's') goto yy371;
			if (yych <= 't') goto yy372;
			goto yy209;
		}
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy369;
		if (yych <= 'm') goto yy209;
		goto yy370;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy209;
			goto yy370;
		} else {
			if (yych <= 's') goto yy371;
			if (yych <= 't') goto yy372;
			goto yy209;
		}
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy373;
		if (yych <= 'T') goto yy54;
		goto yy374;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy54;
			goto yy373;
		} else {
			if (yych == 'u') goto yy374;
			goto yy54;
		}
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy375;
	if (yych == 'e') goto yy375;
	goto yy54;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy376;
	if (yych == 'e') goto yy376;
	goto yy54;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy377;
		if (yych <= 'T') goto yy54;
		goto yy378;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy377;
		} else {
			if (yych == 'u') goto yy378;
			goto yy54;
		}
	}
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy379;
	if (yych == 'a') goto yy379;
	goto yy54;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy380;
	if (yych == 'o') goto yy380;
	goto yy54;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy381;
	if (yych == 'c') goto yy381;
	goto yy54;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy382;
	if (yych == 'e') goto yy382;
	goto yy54;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '0') goto yy383;
	if (yych <= '1') goto yy384;
	if (yych <= '9') goto yy198;
	goto yy192;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy385;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy386;
	goto yy182;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy385;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy388;
	goto yy182;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy368;
		goto yy204;
	} else {
		if (yych <= '9') goto yy224;
		if (yych <= ':') goto yy368;
		goto yy204;
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy368;
	if (yych == ':') goto yy368;
	goto yy204;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy390;
	if (yych == 'r') goto yy390;
	goto yy54;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy391;
	if (yych == 'g') goto yy391;
	goto yy54;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy392;
	if (yych == 'y') goto yy392;
	goto yy54;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy394;
	if (yych == 'c') goto yy394;
	goto yy54;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy395;
	if (yych == 'b') goto yy395;
	goto yy54;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy396;
	if (yych == 'r') goto yy396;
	goto yy54;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy397;
	if (yych == 'i') goto yy397;
	goto yy54;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy398;
	if (yych == 'u') goto yy398;
	goto yy54;
yy233:
	YYDEBUG(233, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	YYDEBUG(234, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy233;
		if (yych <= 0x1F) goto yy54;
		goto yy233;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy54;
			goto yy233;
		} else {
			if (yych <= '/') goto yy54;
			if (yych >= ':') goto yy54;
		}
	}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy236;
	if (yych <= '9') goto yy399;
yy236:
	YYDEBUG(236, *YYCURSOR);
#line 1256 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 6073 "real_world/parse_date_1_78.c"
yy237:
	YYDEBUG(237, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy76;
			goto yy233;
		} else {
			if (yych == ' ') goto yy233;
			goto yy76;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy233;
			if (yych <= '/') goto yy76;
			goto yy235;
		} else {
			if (yych != 'I') goto yy76;
		}
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy233;
		if (yych <= 0x1F) goto yy76;
		goto yy233;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy76;
			goto yy233;
		} else {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		}
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy400;
	if (yych == 'n') goto yy400;
	goto yy54;
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy401;
		if (yych <= 'M') goto yy54;
		goto yy402;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy54;
			goto yy401;
		} else {
			if (yych == 'n') goto yy402;
			goto yy54;
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy403;
		if (yych <= 'X') goto yy54;
		goto yy238;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy54;
			goto yy403;
		} else {
			if (yych == 'y') goto yy238;
			goto yy54;
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy404;
	if (yych == 'n') goto yy404;
	goto yy54;
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy405;
	if (yych == 'n') goto yy405;
	goto yy54;
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy394;
	if (yych == 'v') goto yy394;
	goto yy54;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy406;
	if (yych == 't') goto yy406;
	goto yy54;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy407;
	if (yych == 't') goto yy407;
	goto yy54;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy408;
		if (yych <= 'O') goto yy54;
		goto yy409;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy54;
			goto yy408;
		} else {
			if (yych == 'p') goto yy409;
			goto yy54;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy397;
	if (yych == 'n') goto yy397;
	goto yy54;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy410;
	if (yych == 'u') goto yy410;
	goto yy54;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy411;
	if (yych == 'e') goto yy411;
	goto yy54;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy54;
		if (yych <= 'D') goto yy412;
		goto yy413;
	} else {
		if (yych <= 'c') goto yy54;
		if (yych <= 'd') goto yy412;
		if (yych <= 'e') goto yy413;
		goto yy54;
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy398;
	if (yych == 'a') goto yy398;
	goto yy54;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy264;
		goto yy192;
	} else {
		if (yych <= '.') goto yy264;
		if (yych <= '/') goto yy259;
		goto yy192;
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy192;
			goto yy264;
		} else {
			if (yych <= ',') goto yy192;
			if (yych <= '.') goto yy264;
			goto yy259;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy192;
			goto yy410;
		} else {
			if (yych == 'u') goto yy410;
			goto yy192;
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		goto yy414;
	} else {
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy415;
		if (yych <= ':') goto yy416;
		goto yy204;
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		if (yych <= '.') goto yy414;
		goto yy204;
	} else {
		if (yych <= '2') goto yy415;
		if (yych <= '9') goto yy417;
		if (yych <= ':') goto yy416;
		goto yy204;
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		goto yy414;
	} else {
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy417;
		if (yych <= ':') goto yy416;
		goto yy204;
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy204;
		if (yych <= '-') goto yy364;
		goto yy414;
	} else {
		if (yych == ':') goto yy416;
		goto yy204;
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy212;
	case 'D':
	case 'd':	goto yy213;
	case 'F':
	case 'f':	goto yy214;
	case 'J':
	case 'j':	goto yy215;
	case 'M':
	case 'm':	goto yy216;
	case 'N':
	case 'n':	goto yy217;
	case 'O':
	case 'o':	goto yy218;
	case 'S':
	case 's':	goto yy219;
	default:	goto yy54;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy416;
		goto yy204;
	} else {
		if (yych <= '9') goto yy418;
		if (yych <= ':') goto yy416;
		goto yy204;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy416;
	if (yych == ':') goto yy416;
	goto yy204;
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy263;
	if (yych != 'm') goto yy54;
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy419;
		if (yych == '\t') goto yy419;
		goto yy54;
	} else {
		if (yych <= ' ') goto yy419;
		if (yych == '.') goto yy421;
		goto yy54;
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy192;
	if (yych <= '0') goto yy193;
	if (yych <= '1') goto yy194;
	if (yych <= '9') goto yy195;
	goto yy192;
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy422;
	case '1':	goto yy423;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy424;
	case 'A':
	case 'a':	goto yy425;
	case 'D':
	case 'd':	goto yy426;
	case 'F':
	case 'f':	goto yy427;
	case 'J':
	case 'j':	goto yy428;
	case 'M':
	case 'm':	goto yy429;
	case 'N':
	case 'n':	goto yy430;
	case 'O':
	case 'o':	goto yy431;
	case 'S':
	case 's':	goto yy432;
	default:	goto yy54;
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy433;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy433;
		goto yy18;
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
	} else {
		if (yych <= 'Z') goto yy433;
		if (yych <= '`') goto yy268;
		if (yych <= 'z') goto yy433;
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
#line 1491 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 6463 "real_world/parse_date_1_78.c"
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy130;
			} else {
				if (yych == ' ') goto yy130;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
			} else {
				if (yych == 'I') goto yy435;
				goto yy433;
			}
		} else {
			if (yych <= 'h') {
				if (yych >= 'a') goto yy433;
			} else {
				if (yych <= 'i') goto yy435;
				if (yych <= 'z') goto yy433;
			}
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
#line 1571 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 6511 "real_world/parse_date_1_78.c"
yy271:
	YYDEBUG(271, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'U') goto yy436;
				goto yy433;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'u') goto yy436;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy54;
	if (yych <= 'Z') goto yy437;
	goto yy54;
yy273:
	YYDEBUG(273, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy268;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy268;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '^') goto yy268;
			goto yy272;
		} else {
			if (yych <= '`') goto yy268;
			if (yych <= 'z') goto yy438;
			goto yy268;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'I') goto yy435;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'i') goto yy439;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'U') goto yy436;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'u') goto yy440;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'E') goto yy441;
				goto yy433;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'e') goto yy441;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'E') goto yy441;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'e') goto yy442;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy433;
			goto yy443;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'h') goto yy443;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy433;
			goto yy444;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'v') goto yy444;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy433;
			goto yy443;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'h') goto yy445;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy433;
			goto yy444;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'v') goto yy446;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'R') goto yy447;
				goto yy433;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'r') goto yy447;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy448;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 't') goto yy448;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy433;
			goto yy449;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 's') goto yy449;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy433;
			goto yy450;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'r') goto yy450;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy105;
		} else {
			if (yych <= '@') goto yy288;
			if (yych <= 'C') goto yy433;
			goto yy451;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy433;
			if (yych >= 'a') goto yy433;
		} else {
			if (yych <= 'd') goto yy451;
			if (yych <= 'z') goto yy433;
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
#line 1512 "real_world/parse_date_1_78.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 7034 "real_world/parse_date_1_78.c"
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'R') goto yy447;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'r') goto yy452;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy448;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy453;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy433;
			goto yy449;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 's') goto yy454;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy433;
			goto yy450;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy455;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy288;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy288;
			if (yych <= 'C') goto yy433;
			goto yy451;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy288;
		} else {
			if (yych == 'd') goto yy456;
			if (yych <= 'z') goto yy438;
			goto yy288;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych == '+') goto yy457;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy457;
			if (yych <= '@') goto yy18;
			goto yy433;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy296:
	YYDEBUG(296, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy295;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy132;
		if (yych <= '0') goto yy458;
		if (yych <= '1') goto yy459;
		goto yy460;
	} else {
		if (yych <= '9') goto yy461;
		if (yych == 'T') goto yy300;
		goto yy132;
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy462;
	case '0':	goto yy463;
	case '1':	goto yy464;
	case '2':	goto yy465;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy466;
	case ':':	goto yy467;
	default:	goto yy296;
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy468;
	case '0':	goto yy469;
	case '1':	goto yy464;
	case '2':	goto yy465;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy466;
	case ':':	goto yy470;
	default:	goto yy296;
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '.':	goto yy468;
	case '0':	goto yy463;
	case '1':	goto yy464;
	case '2':	goto yy465;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy466;
	case ':':	goto yy470;
	default:	goto yy296;
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy471;
	if (yych <= '2') goto yy472;
	if (yych <= '9') goto yy473;
	goto yy54;
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '4') goto yy474;
		if (yych <= '9') goto yy475;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '9') goto yy475;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy132;
	} else {
		if (yych <= '0') goto yy474;
		if (yych <= '9') goto yy476;
		if (yych <= ':') goto yy467;
		goto yy132;
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '2') goto yy476;
		if (yych <= '9') goto yy474;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy130;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'U') goto yy477;
				goto yy433;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'u') goto yy477;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'Y') goto yy478;
				goto yy433;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'y') goto yy478;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'E') goto yy478;
				goto yy433;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'e') goto yy478;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'U') goto yy477;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'u') goto yy479;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'Y') goto yy478;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'y') goto yy480;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'E') goto yy478;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'e') goto yy480;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy481;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 't') goto yy481;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy481;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy482;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'C') goto yy483;
				goto yy433;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'c') goto yy483;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy270;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy270;
			goto yy434;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy270;
			if (yych <= '9') goto yy130;
			goto yy270;
		} else {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy270;
			if (yych <= 'z') goto yy433;
			goto yy270;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy433;
			goto yy484;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'n') goto yy484;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'C') goto yy483;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'c') goto yy485;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy270;
			goto yy130;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy270;
				goto yy105;
			} else {
				if (yych <= ',') goto yy270;
				if (yych <= '-') goto yy434;
				goto yy130;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy272;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy270;
			goto yy433;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy270;
				goto yy272;
			} else {
				if (yych <= '`') goto yy270;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy433;
			goto yy484;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy486;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy487;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 't') goto yy487;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy433;
			goto yy488;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'n') goto yy488;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
	} else {
		if (yych <= 'Z') goto yy433;
		if (yych <= '`') goto yy323;
		if (yych <= 'z') goto yy433;
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
#line 977 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7941 "real_world/parse_date_1_78.c"
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy487;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy490;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy433;
			goto yy488;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy491;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy323;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy323;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '^') goto yy323;
			goto yy272;
		} else {
			if (yych <= '`') goto yy323;
			if (yych <= 'z') goto yy438;
			goto yy323;
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'O') goto yy492;
				goto yy433;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'o') goto yy492;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'O') goto yy492;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 'o') goto yy493;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy433;
			goto yy494;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'v') goto yy494;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy433;
			goto yy494;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'v') goto yy495;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy288;
			goto yy105;
		} else {
			if (yych <= '@') goto yy288;
			if (yych <= 'T') goto yy433;
			goto yy496;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy288;
			goto yy433;
		} else {
			if (yych <= 'u') goto yy496;
			if (yych <= 'z') goto yy433;
			goto yy288;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy433;
			goto yy497;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'o') goto yy497;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'T') goto yy498;
				goto yy433;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy270;
				goto yy433;
			} else {
				if (yych <= 't') goto yy498;
				if (yych <= 'z') goto yy433;
				goto yy270;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy433;
			goto yy499;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'e') goto yy499;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy288;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy288;
			if (yych <= 'T') goto yy433;
			goto yy496;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy288;
		} else {
			if (yych == 'u') goto yy500;
			if (yych <= 'z') goto yy438;
			goto yy288;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy433;
			goto yy497;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'o') goto yy501;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy270;
				goto yy433;
			} else {
				if (yych <= 'T') goto yy498;
				if (yych <= 'Z') goto yy433;
				goto yy270;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy438;
			} else {
				if (yych <= 't') goto yy502;
				if (yych <= 'z') goto yy438;
				goto yy270;
			}
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy433;
			goto yy499;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy503;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy70;
		goto yy54;
	} else {
		if (yych <= '5') goto yy504;
		if (yych == ':') goto yy70;
		goto yy54;
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= 'Q') goto yy433;
			if (yych <= 'R') goto yy505;
			goto yy487;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'r') goto yy505;
			if (yych <= 's') goto yy487;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy288;
			goto yy105;
		} else {
			if (yych <= '@') goto yy288;
			if (yych <= 'Q') goto yy433;
			goto yy506;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy288;
			goto yy433;
		} else {
			if (yych <= 'r') goto yy506;
			if (yych <= 'z') goto yy433;
			goto yy288;
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy507;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy507;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy433;
			goto yy508;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'o') goto yy508;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy288;
			goto yy105;
		} else {
			if (yych <= '@') goto yy288;
			if (yych <= 'R') goto yy433;
			goto yy509;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy288;
			goto yy433;
		} else {
			if (yych <= 's') goto yy509;
			if (yych <= 'z') goto yy433;
			goto yy288;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy433;
			goto yy510;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'l') goto yy510;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy105;
			if (yych <= '.') goto yy18;
			goto yy272;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy433;
			if (yych <= 'R') goto yy505;
			goto yy487;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy438;
				goto yy511;
			} else {
				if (yych <= 's') goto yy490;
				if (yych <= 'z') goto yy438;
				goto yy18;
			}
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy288;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy288;
			if (yych <= 'Q') goto yy433;
			goto yy506;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy288;
		} else {
			if (yych == 'r') goto yy512;
			if (yych <= 'z') goto yy438;
			goto yy288;
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy507;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy513;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy433;
			goto yy508;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'o') goto yy514;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy288;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy288;
			if (yych <= 'R') goto yy433;
			goto yy509;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy288;
		} else {
			if (yych == 's') goto yy515;
			if (yych <= 'z') goto yy438;
			goto yy288;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy433;
			goto yy510;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'l') goto yy516;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy18;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy18;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy517;
				goto yy433;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy433;
				goto yy18;
			}
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy288;
			goto yy105;
		} else {
			if (yych <= '@') goto yy288;
			if (yych <= 'M') goto yy433;
			goto yy518;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy288;
			goto yy433;
		} else {
			if (yych <= 'n') goto yy518;
			if (yych <= 'z') goto yy433;
			goto yy288;
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'J') goto yy433;
			goto yy519;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 'k') goto yy519;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy288;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy288;
			if (yych <= 'M') goto yy433;
			goto yy518;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy288;
		} else {
			if (yych == 'n') goto yy520;
			if (yych <= 'z') goto yy438;
			goto yy288;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'J') goto yy433;
			goto yy519;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'k') goto yy521;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy522;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy433;
			if (yych <= '`') goto yy18;
			goto yy433;
		} else {
			if (yych <= 't') goto yy522;
			if (yych <= 'z') goto yy433;
			goto yy18;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy433;
			goto yy522;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy433;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy523;
			if (yych <= 'z') goto yy438;
			goto yy18;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy408;
	if (yych == 'c') goto yy408;
	goto yy54;
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '/') goto yy18;
				if (yych <= '9') goto yy524;
				if (yych <= 'C') goto yy18;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy182;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych <= '/') goto yy18;
				if (yych <= '9') goto yy525;
				if (yych <= 'C') goto yy18;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy182;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy105;
	goto yy18;
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy525;
	goto yy182;
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy526;
	goto yy54;
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy527;
	if (yych <= '3') goto yy529;
	if (yych <= '9') goto yy530;
	goto yy54;
yy366:
	YYDEBUG(366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy409;
	if (yych == 'p') goto yy409;
	goto yy54;
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy531;
	if (yych <= '6') goto yy532;
	if (yych <= '9') goto yy533;
	goto yy54;
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy534;
	if (yych <= '6') goto yy535;
	if (yych <= '9') goto yy536;
	goto yy54;
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy537;
	goto yy54;
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy538;
	goto yy54;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy538;
	goto yy54;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy538;
	goto yy54;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy54;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy539;
	if (yych == 'g') goto yy539;
	goto yy54;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy539;
	if (yych == 'c') goto yy539;
	goto yy54;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy539;
	if (yych == 'b') goto yy539;
	goto yy54;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy539;
	if (yych == 'n') goto yy539;
	goto yy54;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy539;
		if (yych <= 'M') goto yy54;
		goto yy539;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy54;
			goto yy539;
		} else {
			if (yych == 'n') goto yy539;
			goto yy54;
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy539;
		if (yych <= 'X') goto yy54;
		goto yy539;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy54;
			goto yy539;
		} else {
			if (yych == 'y') goto yy539;
			goto yy54;
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy539;
	if (yych == 'v') goto yy539;
	goto yy54;
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy539;
	if (yych == 't') goto yy539;
	goto yy54;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy540;
	if (yych == 'p') goto yy540;
	goto yy54;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy54;
		if (yych <= '-') goto yy365;
		goto yy364;
	} else {
		if (yych <= '/') goto yy54;
		if (yych <= '9') goto yy541;
		goto yy54;
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy54;
		if (yych <= '-') goto yy365;
		goto yy364;
	} else {
		if (yych <= '/') goto yy54;
		if (yych <= '2') goto yy541;
		goto yy54;
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy542;
	case '1':	goto yy543;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy424;
	case 'A':
	case 'a':	goto yy425;
	case 'D':
	case 'd':	goto yy426;
	case 'F':
	case 'f':	goto yy427;
	case 'J':
	case 'j':	goto yy428;
	case 'M':
	case 'm':	goto yy429;
	case 'N':
	case 'n':	goto yy430;
	case 'O':
	case 'o':	goto yy431;
	case 'S':
	case 's':	goto yy432;
	default:	goto yy54;
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy545;
	case '-':	goto yy546;
	case '.':	goto yy547;
	case '/':	goto yy548;
	case '0':	goto yy549;
	case '1':	goto yy550;
	case '2':	goto yy551;
	case '3':	goto yy552;
	case '4':
	case '5':	goto yy553;
	case '6':	goto yy554;
	case '7':
	case '8':
	case '9':	goto yy55;
	case ':':	goto yy555;
	case 'W':	goto yy567;
	default:	goto yy387;
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
#line 1125 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 9269 "real_world/parse_date_1_78.c"
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy545;
	case '-':	goto yy546;
	case '.':	goto yy547;
	case '/':	goto yy548;
	case '0':	goto yy569;
	case '1':	goto yy570;
	case '2':	goto yy571;
	case '3':	goto yy572;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy55;
	case ':':	goto yy555;
	case 'W':	goto yy567;
	default:	goto yy389;
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
#line 1482 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 9330 "real_world/parse_date_1_78.c"
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'I') goto yy573;
			if (yych == 'i') goto yy573;
			goto yy76;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'U') goto yy574;
			if (yych == 'u') goto yy574;
			goto yy76;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy575;
	if (yych == 's') goto yy575;
yy393:
	YYDEBUG(393, *YYCURSOR);
#line 1649 "real_world/parse_date_1_78.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 9401 "real_world/parse_date_1_78.c"
yy394:
	YYDEBUG(394, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'E') goto yy576;
			if (yych == 'e') goto yy576;
			goto yy76;
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'R') goto yy577;
			if (yych == 'r') goto yy577;
			goto yy76;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy578;
	if (yych == 't') goto yy578;
	goto yy54;
yy397:
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy579;
	if (yych == 'd') goto yy579;
	goto yy393;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy392;
	if (yych == 'r') goto yy392;
	goto yy54;
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy236;
	if (yych <= '9') goto yy580;
	goto yy236;
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'U') goto yy581;
			if (yych == 'u') goto yy581;
			goto yy76;
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'Y') goto yy238;
			if (yych == 'y') goto yy238;
			goto yy76;
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'E') goto yy238;
			if (yych == 'e') goto yy238;
			goto yy76;
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'C') goto yy582;
			if (yych == 'c') goto yy582;
			goto yy76;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy575;
		if (yych <= 'T') goto yy393;
		goto yy583;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy393;
			goto yy575;
		} else {
			if (yych == 'u') goto yy583;
			goto yy393;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy579;
		if (yych <= 'S') goto yy393;
		goto yy584;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy393;
			goto yy579;
		} else {
			if (yych == 't') goto yy584;
			goto yy393;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'O') goto yy585;
			if (yych == 'o') goto yy585;
			goto yy76;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy586;
	if (yych == 'u') goto yy586;
	goto yy393;
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy587;
		if (yych <= 'R') goto yy393;
		goto yy575;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy393;
			goto yy587;
		} else {
			if (yych == 's') goto yy575;
			goto yy393;
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy233;
			goto yy76;
		} else {
			if (yych <= ' ') goto yy233;
			if (yych <= ',') goto yy76;
			goto yy233;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy76;
			if (yych <= '9') goto yy235;
			goto yy76;
		} else {
			if (yych <= 'T') goto yy394;
			if (yych == 't') goto yy394;
			goto yy76;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy588;
	if (yych == 'r') goto yy588;
	goto yy393;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy589;
	if (yych == 's') goto yy589;
	goto yy393;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy590;
	if (yych == 'n') goto yy590;
	goto yy393;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy591;
	if (yych == 'k') goto yy591;
	goto yy54;
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy592;
	if (yych <= '6') goto yy593;
	if (yych <= '9') goto yy533;
	goto yy54;
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy594;
			if (yych <= 0x1F) goto yy204;
			goto yy594;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy204;
				goto yy364;
			} else {
				if (yych <= '.') goto yy414;
				if (yych <= '9') goto yy204;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy98;
			if (yych <= 'O') goto yy204;
			goto yy98;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy204;
				goto yy98;
			} else {
				if (yych == 'p') goto yy98;
				goto yy204;
			}
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy596;
	if (yych <= '6') goto yy597;
	if (yych <= '9') goto yy536;
	goto yy54;
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy594;
			if (yych <= 0x1F) goto yy204;
			goto yy594;
		} else {
			if (yych == '.') goto yy416;
			if (yych <= '9') goto yy204;
			goto yy416;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy98;
			if (yych <= 'O') goto yy204;
			goto yy98;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy204;
				goto yy98;
			} else {
				if (yych == 'p') goto yy98;
				goto yy204;
			}
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy594;
			if (yych <= 0x1F) goto yy204;
			goto yy594;
		} else {
			if (yych == '.') goto yy416;
			if (yych <= '9') goto yy204;
			goto yy598;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy98;
			if (yych <= 'O') goto yy204;
			goto yy98;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy204;
				goto yy98;
			} else {
				if (yych == 'p') goto yy98;
				goto yy204;
			}
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(420, *YYCURSOR);
#line 1062 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9831 "real_world/parse_date_1_78.c"
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy419;
		if (yych <= 0x08) goto yy54;
		goto yy419;
	} else {
		if (yych == ' ') goto yy419;
		goto yy54;
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy599;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy600;
	goto yy54;
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy599;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy600;
	goto yy54;
yy424:
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy599;
	goto yy54;
yy425:
	YYDEBUG(425, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy601;
		if (yych <= 'T') goto yy54;
		goto yy602;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy54;
			goto yy601;
		} else {
			if (yych == 'u') goto yy602;
			goto yy54;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy603;
	if (yych == 'e') goto yy603;
	goto yy54;
yy427:
	YYDEBUG(427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy604;
	if (yych == 'e') goto yy604;
	goto yy54;
yy428:
	YYDEBUG(428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy605;
		if (yych <= 'T') goto yy54;
		goto yy606;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy605;
		} else {
			if (yych == 'u') goto yy606;
			goto yy54;
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy607;
	if (yych == 'a') goto yy607;
	goto yy54;
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy608;
	if (yych == 'o') goto yy608;
	goto yy54;
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy609;
	if (yych == 'c') goto yy609;
	goto yy54;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy610;
	if (yych == 'e') goto yy610;
	goto yy54;
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy611;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy611;
		goto yy18;
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy130;
	if (yych <= '2') goto yy612;
	if (yych <= '3') goto yy613;
	goto yy130;
yy435:
	YYDEBUG(435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy611;
			goto yy614;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'l') goto yy614;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy611;
			goto yy615;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 's') goto yy615;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy616;
	}
	goto yy54;
yy438:
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy611;
			goto yy614;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'l') goto yy619;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy611;
			goto yy615;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 's') goto yy620;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy611;
			goto yy621;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'm') goto yy621;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy611;
			goto yy621;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'm') goto yy622;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy611;
			goto yy623;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 't') goto yy623;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy611;
			goto yy624;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'e') goto yy624;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy611;
			goto yy623;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy625;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy611;
			goto yy624;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy626;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy611;
			goto yy627;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'u') goto yy627;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy611;
			goto yy623;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'h') goto yy623;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy611;
			goto yy628;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 't') goto yy628;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy611;
			goto yy629;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 't') goto yy629;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy630;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy630;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy611;
			goto yy627;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'u') goto yy631;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy611;
			goto yy623;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'h') goto yy625;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy611;
			goto yy628;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy632;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy611;
			goto yy629;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy633;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy630;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy634;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy635;
	if (yych <= '2') goto yy636;
	if (yych <= '9') goto yy637;
	goto yy54;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy132;
	} else {
		if (yych <= '0') goto yy638;
		if (yych <= '9') goto yy639;
		if (yych <= ':') goto yy467;
		goto yy132;
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '2') goto yy639;
		if (yych <= '9') goto yy638;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '4') goto yy638;
		if (yych <= '9') goto yy640;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '9') goto yy640;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy296;
		if (yych <= '0') goto yy641;
		goto yy642;
	} else {
		if (yych <= '2') goto yy643;
		if (yych <= '5') goto yy644;
		if (yych <= '9') goto yy645;
		goto yy296;
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy132;
	} else {
		if (yych <= '0') goto yy646;
		if (yych <= '9') goto yy648;
		if (yych <= ':') goto yy467;
		goto yy132;
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '2') goto yy648;
		if (yych <= '9') goto yy646;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '4') goto yy646;
		if (yych <= '9') goto yy649;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '9') goto yy649;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy650;
	if (yych <= '9') goto yy652;
	goto yy54;
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy296;
		if (yych <= '0') goto yy653;
		goto yy654;
	} else {
		if (yych <= '2') goto yy655;
		if (yych <= '5') goto yy656;
		if (yych <= '9') goto yy657;
		goto yy296;
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy132;
	} else {
		if (yych <= '0') goto yy646;
		if (yych <= '9') goto yy648;
		if (yych >= ';') goto yy132;
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy658;
	if (yych <= '9') goto yy659;
	goto yy54;
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy54;
	} else {
		if (yych <= '9') goto yy473;
		if (yych <= ':') goto yy467;
		goto yy54;
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy54;
	} else {
		if (yych <= '4') goto yy473;
		if (yych == ':') goto yy467;
		goto yy54;
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy467;
	if (yych == ':') goto yy467;
	goto yy54;
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy132;
	} else {
		if (yych <= '9') goto yy660;
		if (yych <= ':') goto yy467;
		goto yy132;
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy132;
	if (yych <= '9') goto yy660;
	goto yy132;
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '9') goto yy660;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy661;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy661;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy270;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy105;
			goto yy270;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy270;
			if (yych <= '9') goto yy130;
			goto yy270;
		} else {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy270;
			if (yych <= 'z') goto yy611;
			goto yy270;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy661;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy662;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy270;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy270;
			goto yy130;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy272;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy270;
			goto yy611;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy270;
				goto yy272;
			} else {
				if (yych <= '`') goto yy270;
				if (yych <= 'z') goto yy618;
				goto yy270;
			}
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy663;
		} else {
			if (yych == ' ') goto yy665;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy611;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy663;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy665;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy611;
			goto yy18;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy611;
			goto yy614;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'h') goto yy614;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy611;
			goto yy666;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'i') goto yy666;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy611;
			goto yy614;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'h') goto yy619;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy611;
			goto yy666;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'i') goto yy667;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy663;
		} else {
			if (yych == ' ') goto yy663;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy611;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
	} else {
		if (yych <= 'Z') goto yy611;
		if (yych <= '`') goto yy489;
		if (yych <= 'z') goto yy611;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
#line 986 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 10965 "real_world/parse_date_1_78.c"
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy663;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy663;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy611;
			goto yy18;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy489;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy489;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '^') goto yy489;
			goto yy272;
		} else {
			if (yych <= '`') goto yy489;
			if (yych <= 'z') goto yy618;
			goto yy489;
		}
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy611;
			goto yy668;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'b') goto yy668;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy611;
			goto yy668;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'b') goto yy669;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy611;
			goto yy670;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'i') goto yy670;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy611;
			goto yy670;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'i') goto yy671;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy611;
			goto yy672;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'r') goto yy672;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy611;
			goto yy673;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'n') goto yy673;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy105;
				goto yy270;
			} else {
				if (yych <= '-') goto yy434;
				if (yych <= '.') goto yy130;
				goto yy270;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy270;
			} else {
				if (yych == 'E') goto yy674;
				goto yy611;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy270;
				goto yy611;
			} else {
				if (yych <= 'e') goto yy674;
				if (yych <= 'z') goto yy611;
				goto yy270;
			}
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy611;
			goto yy675;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'n') goto yy675;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy611;
			goto yy672;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy676;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy611;
			goto yy673;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy677;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy270;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy270;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy105;
				if (yych <= ',') goto yy270;
				goto yy434;
			} else {
				if (yych == '/') goto yy272;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy270;
				goto yy611;
			} else {
				if (yych <= 'E') goto yy674;
				if (yych <= 'Z') goto yy611;
				goto yy270;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy272;
				if (yych <= '`') goto yy270;
				goto yy618;
			} else {
				if (yych <= 'e') goto yy678;
				if (yych <= 'z') goto yy618;
				goto yy270;
			}
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy611;
			goto yy675;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy679;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy680;
	goto yy54;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy611;
			goto yy623;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'd') goto yy623;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy611;
			goto yy672;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 's') goto yy672;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy611;
			goto yy681;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'y') goto yy681;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy611;
			goto yy683;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'r') goto yy683;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy611;
			goto yy684;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'd') goto yy684;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'E') goto yy611;
			goto yy675;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'f') goto yy675;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy611;
			goto yy623;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy625;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy611;
			goto yy672;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 's') goto yy676;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy611;
			goto yy681;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'y') goto yy685;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy611;
			goto yy683;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy686;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy611;
			goto yy684;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy687;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'E') goto yy611;
			goto yy675;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'f') goto yy679;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy130;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy611;
			goto yy688;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'e') goto yy688;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy611;
			goto yy689;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'd') goto yy689;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy611;
			goto yy688;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy690;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy611;
			goto yy689;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy691;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy611;
			goto yy692;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy611;
			if (yych <= '`') goto yy18;
			goto yy611;
		} else {
			if (yych <= 'e') goto yy692;
			if (yych <= 'z') goto yy611;
			goto yy18;
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy611;
			goto yy692;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy611;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy693;
			if (yych <= 'z') goto yy618;
			goto yy18;
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy55;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy18;
				goto yy182;
			} else {
				if (yych == '-') goto yy694;
				if (yych <= 'C') goto yy18;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'T') goto yy182;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy18;
				if (yych <= 'Y') goto yy182;
				goto yy18;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy18;
				} else {
					if (yych == 'g') goto yy18;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy18;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy18;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy18;
				}
			}
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy55;
	}
	if (yych == '-') goto yy694;
	goto yy182;
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy695;
	goto yy54;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '9') goto yy697;
		if (yych >= 'n') goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
#line 1243 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 11915 "real_world/parse_date_1_78.c"
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy528;
			goto yy697;
		} else {
			if (yych <= '9') goto yy695;
			if (yych <= 'm') goto yy528;
			goto yy698;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '9') goto yy695;
		if (yych <= 'm') goto yy528;
		goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy702;
	goto yy204;
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy701;
		goto yy204;
	} else {
		if (yych <= '0') goto yy702;
		if (yych <= '9') goto yy695;
		goto yy204;
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy695;
	goto yy204;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy536;
	goto yy204;
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych != '0') goto yy204;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	goto yy204;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy703;
	goto yy209;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy369;
	goto yy209;
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy704;
	goto yy54;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy704;
		goto yy54;
	} else {
		if (yych <= 'T') goto yy539;
		if (yych == 't') goto yy539;
		goto yy54;
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy54;
	if (yych <= '-') goto yy705;
	if (yych <= '.') goto yy364;
	goto yy54;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy599;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy424;
	goto yy54;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy599;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy424;
	goto yy54;
yy544:
	YYDEBUG(544, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy545:
	YYDEBUG(545, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':	goto yy544;
	case '-':
	case '.':	goto yy706;
	case 'A':
	case 'a':	goto yy556;
	case 'D':
	case 'd':	goto yy557;
	case 'F':
	case 'f':	goto yy558;
	case 'H':
	case 'h':	goto yy74;
	case 'I':	goto yy559;
	case 'J':
	case 'j':	goto yy561;
	case 'M':
	case 'm':	goto yy562;
	case 'N':
	case 'n':	goto yy563;
	case 'O':
	case 'o':	goto yy564;
	case 'S':
	case 's':	goto yy565;
	case 'T':
	case 't':	goto yy82;
	case 'V':	goto yy566;
	case 'W':
	case 'w':	goto yy84;
	case 'X':	goto yy568;
	case 'Y':
	case 'y':	goto yy86;
	default:	goto yy54;
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy708;
	case '1':	goto yy710;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy711;
	case 'A':
	case 'a':	goto yy712;
	case 'D':
	case 'd':	goto yy713;
	case 'F':
	case 'f':	goto yy714;
	case 'J':
	case 'j':	goto yy715;
	case 'M':
	case 'm':	goto yy716;
	case 'N':
	case 'n':	goto yy717;
	case 'O':
	case 'o':	goto yy718;
	case 'S':
	case 's':	goto yy719;
	case 'W':	goto yy720;
	default:	goto yy707;
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy707;
	if (yych <= '0') goto yy721;
	if (yych <= '2') goto yy722;
	if (yych <= '3') goto yy723;
	goto yy707;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '0') goto yy728;
	if (yych <= '1') goto yy729;
	if (yych <= '9') goto yy730;
	goto yy54;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '0') goto yy731;
	if (yych <= '9') goto yy733;
	goto yy182;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '2') goto yy733;
	if (yych <= '9') goto yy734;
	goto yy182;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy734;
	goto yy182;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '5') goto yy734;
	if (yych <= '6') goto yy735;
	if (yych <= '9') goto yy736;
	goto yy182;
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy736;
	goto yy182;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '0') goto yy736;
	if (yych <= '9') goto yy55;
	goto yy182;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '0') goto yy737;
	if (yych <= '1') goto yy738;
	goto yy54;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy739;
		if (yych <= 'T') goto yy54;
		goto yy740;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy54;
			goto yy739;
		} else {
			if (yych == 'u') goto yy740;
			goto yy54;
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy227;
		if (yych <= 'D') goto yy54;
		goto yy741;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy227;
		} else {
			if (yych == 'e') goto yy741;
			goto yy54;
		}
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy742;
			goto yy54;
		} else {
			if (yych <= 'O') goto yy230;
			if (yych <= 'Q') goto yy54;
			goto yy231;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy742;
			goto yy54;
		} else {
			if (yych <= 'o') goto yy230;
			if (yych == 'r') goto yy231;
			goto yy54;
		}
	}
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy743;
	} else {
		if (yych == 'W') goto yy560;
		if (yych <= 'X') goto yy744;
	}
yy560:
	YYDEBUG(560, *YYCURSOR);
#line 1308 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 12270 "real_world/parse_date_1_78.c"
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy745;
		if (yych <= 'T') goto yy54;
		goto yy746;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy745;
		} else {
			if (yych == 'u') goto yy746;
			goto yy54;
		}
	}
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy747;
			goto yy54;
		} else {
			if (yych <= 'I') goto yy242;
			if (yych <= 'N') goto yy54;
			goto yy243;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy747;
			goto yy54;
		} else {
			if (yych <= 'i') goto yy242;
			if (yych == 'o') goto yy243;
			goto yy54;
		}
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy748;
	if (yych == 'o') goto yy748;
	goto yy54;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy749;
	if (yych == 'c') goto yy749;
	goto yy54;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'E') goto yy750;
			if (yych <= 'T') goto yy54;
			goto yy248;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy246;
			goto yy54;
		} else {
			if (yych <= 'e') goto yy750;
			if (yych == 'u') goto yy248;
			goto yy54;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy568;
	goto yy560;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy54;
		if (yych <= '0') goto yy751;
		if (yych <= '4') goto yy752;
		goto yy753;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy54;
			goto yy251;
		} else {
			if (yych == 'e') goto yy251;
			goto yy54;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy743;
	goto yy560;
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '0') goto yy754;
	if (yych <= '9') goto yy755;
	goto yy182;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '2') goto yy755;
	if (yych <= '9') goto yy756;
	goto yy182;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy756;
	goto yy182;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '5') goto yy756;
	if (yych <= '6') goto yy757;
	if (yych <= '9') goto yy55;
	goto yy182;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy238;
	if (yych == 'l') goto yy238;
	goto yy54;
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy758;
	if (yych == 's') goto yy758;
	goto yy54;
yy575:
	YYDEBUG(575, *YYCURSOR);
	++YYCURSOR;
	goto yy393;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy585;
	if (yych == 'm') goto yy585;
	goto yy54;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy581;
	if (yych == 'u') goto yy581;
	goto yy54;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy759;
		if (yych <= 'M') goto yy54;
		goto yy760;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy54;
			goto yy759;
		} else {
			if (yych == 'n') goto yy760;
			goto yy54;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy761;
	if (yych == 'a') goto yy761;
	goto yy54;
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy236;
	if (yych <= '9') goto yy762;
	goto yy236;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy763;
	if (yych == 'a') goto yy763;
	goto yy54;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy238;
	if (yych == 'h') goto yy238;
	goto yy54;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy764;
	if (yych == 't') goto yy764;
	goto yy54;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy392;
	if (yych == 'h') goto yy392;
	goto yy54;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy765;
	if (yych == 'b') goto yy765;
	goto yy54;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy589;
	if (yych == 'r') goto yy589;
	goto yy54;
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy766;
	if (yych == 'n') goto yy766;
	goto yy54;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy589;
	if (yych != 's') goto yy54;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy579;
	if (yych == 'd') goto yy579;
	goto yy54;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy588;
	if (yych == 'e') goto yy588;
	goto yy54;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy183;
		if (yych <= 'R') goto yy393;
		goto yy575;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy393;
			goto yy183;
		} else {
			if (yych == 's') goto yy575;
			goto yy393;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy767;
	goto yy204;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy701;
		goto yy204;
	} else {
		if (yych <= '0') goto yy767;
		if (yych <= '9') goto yy695;
		goto yy204;
	}
yy594:
	YYDEBUG(594, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(595, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy594;
			goto yy54;
		} else {
			if (yych <= ' ') goto yy594;
			if (yych <= '@') goto yy54;
			goto yy98;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy98;
			goto yy54;
		} else {
			if (yych <= 'a') goto yy98;
			if (yych == 'p') goto yy98;
			goto yy54;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy768;
	goto yy204;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych == '0') goto yy768;
	goto yy204;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy769;
	if (yych <= '6') goto yy770;
	if (yych <= '9') goto yy536;
	goto yy54;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy771;
	if (yych <= '3') goto yy772;
	if (yych <= '9') goto yy773;
	goto yy54;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy774;
	goto yy54;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy775;
	if (yych == 'r') goto yy775;
	goto yy54;
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy775;
	if (yych == 'g') goto yy775;
	goto yy54;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy775;
	if (yych == 'c') goto yy775;
	goto yy54;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy775;
	if (yych == 'b') goto yy775;
	goto yy54;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy775;
	if (yych == 'n') goto yy775;
	goto yy54;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy775;
		if (yych <= 'M') goto yy54;
		goto yy775;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy54;
			goto yy775;
		} else {
			if (yych == 'n') goto yy775;
			goto yy54;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy775;
		if (yych <= 'X') goto yy54;
		goto yy775;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy54;
			goto yy775;
		} else {
			if (yych == 'y') goto yy775;
			goto yy54;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy775;
	if (yych == 'v') goto yy775;
	goto yy54;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy775;
	if (yych == 't') goto yy775;
	goto yy54;
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy776;
	if (yych == 'p') goto yy776;
	goto yy54;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy777;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy777;
		goto yy18;
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy296;
	if (yych <= '0') goto yy778;
	if (yych <= '1') goto yy779;
	if (yych <= '9') goto yy780;
	goto yy296;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy296;
		if (yych <= '0') goto yy778;
		goto yy779;
	} else {
		if (yych <= '2') goto yy301;
		if (yych <= '9') goto yy302;
		goto yy296;
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy270;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy105;
			goto yy270;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy270;
			if (yych <= '9') goto yy130;
			goto yy270;
		} else {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy270;
			if (yych <= 'z') goto yy777;
			goto yy270;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy777;
			goto yy781;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 't') goto yy781;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(617, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy616;
	}
	if (yych == '/') goto yy272;
	if (yych == '_') goto yy272;
	goto yy18;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy270;
			goto yy130;
		} else {
			if (yych == ')') goto yy105;
			if (yych <= ',') goto yy270;
			goto yy130;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy272;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy270;
			goto yy777;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy270;
				goto yy272;
			} else {
				if (yych <= '`') goto yy270;
				if (yych <= 'z') goto yy782;
				goto yy270;
			}
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy777;
			goto yy781;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy783;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy777;
			goto yy784;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'b') goto yy784;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy777;
			goto yy784;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'b') goto yy785;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy786;
		} else {
			if (yych == ' ') goto yy786;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy777;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy777;
			goto yy788;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'n') goto yy788;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy786;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy786;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy777;
			goto yy18;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy777;
			goto yy788;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'n') goto yy789;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy790;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy790;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy786;
		} else {
			if (yych == ' ') goto yy791;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy105;
			if (yych <= '@') goto yy18;
			goto yy777;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy777;
			goto yy792;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'h') goto yy792;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy777;
			goto yy793;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'y') goto yy793;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy790;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy794;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy786;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy791;
			if (yych == ')') goto yy105;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy777;
			goto yy18;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy777;
			goto yy792;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'h') goto yy795;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy777;
			goto yy793;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'y') goto yy796;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy637;
	if (yych <= ':') goto yy188;
	goto yy18;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy18;
		if (yych >= '5') goto yy362;
	} else {
		if (yych <= '9') goto yy105;
		if (yych <= ':') goto yy188;
		goto yy18;
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy362;
	if (yych <= '9') goto yy105;
	if (yych <= ':') goto yy188;
	goto yy18;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
		goto yy132;
	} else {
		if (yych <= '9') goto yy797;
		if (yych <= ':') goto yy467;
		goto yy132;
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy132;
	} else {
		if (yych <= '9') goto yy797;
		if (yych <= ':') goto yy470;
		goto yy132;
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy132;
	if (yych <= '9') goto yy797;
	goto yy132;
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy798;
		goto yy132;
	} else {
		if (yych <= '0') goto yy799;
		if (yych <= '9') goto yy800;
		if (yych <= ':') goto yy798;
		goto yy132;
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy801;
		goto yy132;
	} else {
		if (yych <= '2') goto yy800;
		if (yych <= '9') goto yy799;
		if (yych <= ':') goto yy801;
		goto yy132;
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy801;
		goto yy132;
	} else {
		if (yych <= '4') goto yy799;
		if (yych <= '9') goto yy802;
		if (yych <= ':') goto yy801;
		goto yy132;
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy801;
		goto yy132;
	} else {
		if (yych <= '9') goto yy802;
		if (yych <= ':') goto yy801;
		goto yy132;
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy801;
		goto yy132;
	} else {
		if (yych <= '9') goto yy640;
		if (yych <= ':') goto yy801;
		goto yy132;
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy467;
	} else {
		if (yych <= '9') goto yy797;
		if (yych <= ':') goto yy467;
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
#line 1295 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 13340 "real_world/parse_date_1_78.c"
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy470;
		goto yy647;
	} else {
		if (yych <= '9') goto yy797;
		if (yych <= ':') goto yy470;
		goto yy647;
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy647;
	if (yych <= '9') goto yy797;
	goto yy647;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy803;
	} else {
		if (yych <= '9') goto yy652;
		if (yych <= ':') goto yy803;
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
#line 1619 "real_world/parse_date_1_78.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 13400 "real_world/parse_date_1_78.c"
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy803;
	if (yych == ':') goto yy803;
	goto yy651;
yy653:
	YYDEBUG(653, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy804;
		goto yy132;
	} else {
		if (yych <= '0') goto yy805;
		if (yych <= '9') goto yy806;
		if (yych <= ':') goto yy804;
		goto yy132;
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy807;
		goto yy132;
	} else {
		if (yych <= '2') goto yy806;
		if (yych <= '9') goto yy805;
		if (yych <= ':') goto yy807;
		goto yy132;
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy807;
		goto yy132;
	} else {
		if (yych <= '4') goto yy805;
		if (yych <= '9') goto yy808;
		if (yych <= ':') goto yy807;
		goto yy132;
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy807;
		goto yy132;
	} else {
		if (yych <= '9') goto yy808;
		if (yych <= ':') goto yy807;
		goto yy132;
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy807;
		goto yy132;
	} else {
		if (yych <= '9') goto yy640;
		if (yych <= ':') goto yy807;
		goto yy132;
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy809;
		goto yy651;
	} else {
		if (yych <= '9') goto yy810;
		if (yych <= ':') goto yy809;
		goto yy651;
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy809;
	if (yych == ':') goto yy809;
	goto yy651;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy647;
	if (yych <= '9') goto yy811;
	goto yy647;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy777;
			goto yy812;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'r') goto yy812;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy777;
			goto yy812;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy813;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy664:
	YYDEBUG(664, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy663;
				if (yych <= 0x1F) goto yy54;
				goto yy663;
			} else {
				if (yych == 'D') goto yy814;
				if (yych <= 'E') goto yy54;
				goto yy815;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy816;
				if (yych <= 'L') goto yy54;
				goto yy817;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy54;
					goto yy818;
				} else {
					if (yych <= 'T') goto yy819;
					if (yych <= 'V') goto yy54;
					goto yy820;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy821;
				if (yych <= 'c') goto yy54;
				goto yy814;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy54;
					goto yy815;
				} else {
					if (yych == 'h') goto yy816;
					goto yy54;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy817;
				if (yych <= 'r') goto yy54;
				if (yych <= 's') goto yy818;
				goto yy819;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy54;
					goto yy820;
				} else {
					if (yych == 'y') goto yy821;
					goto yy54;
				}
			}
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy822;
	if (yych == 'd') goto yy822;
	goto yy664;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy777;
			goto yy823;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'g') goto yy823;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy777;
			goto yy823;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'g') goto yy824;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy777;
			goto yy825;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'e') goto yy825;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy777;
			goto yy825;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy826;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy777;
			goto yy827;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'o') goto yy827;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy777;
			goto yy827;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'o') goto yy828;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy777;
			goto yy829;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'd') goto yy829;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy777;
			goto yy792;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'd') goto yy792;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy777;
			goto yy830;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'm') goto yy830;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy777;
			goto yy831;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 't') goto yy831;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy777;
			goto yy829;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy832;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy777;
			goto yy792;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy795;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy777;
			goto yy830;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'm') goto yy833;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy777;
			goto yy831;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy834;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy387;
	if (yych <= '5') goto yy835;
	if (yych <= '6') goto yy836;
	goto yy387;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy105;
	} else {
		if (yych <= 'Z') goto yy777;
		if (yych <= '`') goto yy682;
		if (yych <= 'z') goto yy777;
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
#line 998 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13981 "real_world/parse_date_1_78.c"
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy777;
			goto yy837;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'r') goto yy837;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy838;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy838;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy682;
			goto yy105;
		} else {
			if (yych == '/') goto yy272;
			goto yy682;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '^') goto yy682;
			goto yy272;
		} else {
			if (yych <= '`') goto yy682;
			if (yych <= 'z') goto yy782;
			goto yy682;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy777;
			goto yy837;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy839;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy838;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy840;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy777;
			goto yy841;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 's') goto yy841;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		if (yych <= '@') goto yy18;
		goto yy842;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy842;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy777;
			goto yy841;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 's') goto yy843;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy842;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy844;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy105;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy777;
			goto yy845;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy777;
			if (yych <= '`') goto yy18;
			goto yy777;
		} else {
			if (yych <= 'r') goto yy845;
			if (yych <= 'z') goto yy777;
			goto yy18;
		}
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy777;
			goto yy845;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy777;
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy846;
			if (yych <= 'z') goto yy782;
			goto yy18;
		}
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '0') goto yy847;
	if (yych <= '1') goto yy848;
	goto yy54;
yy695:
	YYDEBUG(695, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy696;
	if (yych <= '9') goto yy849;
yy696:
	YYDEBUG(696, *YYCURSOR);
#line 1282 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 14260 "real_world/parse_date_1_78.c"
yy697:
	YYDEBUG(697, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '9') goto yy849;
		if (yych <= 'm') goto yy528;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy850;
	goto yy54;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy850;
	goto yy54;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy850;
	goto yy54;
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy851;
	goto yy54;
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy849;
	goto yy204;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy853;
	goto yy209;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy854;
	goto yy54;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy855;
	if (yych <= '3') goto yy856;
	if (yych <= '9') goto yy530;
	goto yy54;
yy706:
	YYDEBUG(706, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy707:
	YYDEBUG(707, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy706;
	case 'A':
	case 'a':	goto yy556;
	case 'D':
	case 'd':	goto yy724;
	case 'F':
	case 'f':	goto yy725;
	case 'I':	goto yy559;
	case 'J':
	case 'j':	goto yy561;
	case 'M':
	case 'm':	goto yy726;
	case 'N':
	case 'n':	goto yy563;
	case 'O':
	case 'o':	goto yy564;
	case 'S':
	case 's':	goto yy727;
	case 'V':	goto yy566;
	case 'X':	goto yy568;
	default:	goto yy54;
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy857;
	if (yych <= '/') goto yy709;
	if (yych <= '9') goto yy858;
yy709:
	YYDEBUG(709, *YYCURSOR);
#line 1231 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14380 "real_world/parse_date_1_78.c"
yy710:
	YYDEBUG(710, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy857;
	if (yych <= '/') goto yy709;
	if (yych <= '2') goto yy858;
	goto yy709;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy857;
	goto yy709;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy859;
		if (yych <= 'T') goto yy54;
		goto yy860;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy54;
			goto yy859;
		} else {
			if (yych == 'u') goto yy860;
			goto yy54;
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy861;
	if (yych == 'e') goto yy861;
	goto yy54;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy862;
	if (yych == 'e') goto yy862;
	goto yy54;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy863;
		if (yych <= 'T') goto yy54;
		goto yy864;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy54;
			goto yy863;
		} else {
			if (yych == 'u') goto yy864;
			goto yy54;
		}
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy865;
	if (yych == 'a') goto yy865;
	goto yy54;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy866;
	if (yych == 'o') goto yy866;
	goto yy54;
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy867;
	if (yych == 'c') goto yy867;
	goto yy54;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy868;
	if (yych == 'e') goto yy868;
	goto yy54;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '0') goto yy751;
	if (yych <= '4') goto yy752;
	if (yych <= '5') goto yy753;
	goto yy54;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '0') goto yy869;
	if (yych <= '9') goto yy870;
	goto yy54;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy870;
	goto yy54;
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy870;
	if (yych <= '6') goto yy871;
	goto yy54;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy741;
	if (yych == 'e') goto yy741;
	goto yy54;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy742;
	if (yych == 'e') goto yy742;
	goto yy54;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy747;
	if (yych == 'a') goto yy747;
	goto yy54;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy872;
	if (yych == 'e') goto yy872;
	goto yy54;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy54;
	if (yych <= '/') goto yy873;
	if (yych <= '9') goto yy874;
	goto yy54;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy54;
	if (yych <= '/') goto yy873;
	if (yych <= '2') goto yy874;
	goto yy54;
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy873;
	goto yy54;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych >= ' ') goto yy182;
			} else {
				if (yych <= '0') {
					if (yych >= '0') goto yy875;
				} else {
					if (yych <= '2') goto yy876;
					if (yych <= '3') goto yy878;
					goto yy879;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy182;
				} else {
					if (yych == 'F') goto yy182;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy182;
				} else {
					if (yych <= 'M') goto yy182;
					if (yych >= 'S') goto yy182;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy182;
				if (yych >= 'Y') goto yy182;
			} else {
				if (yych <= 'd') {
					if (yych >= 'd') goto yy182;
				} else {
					if (yych == 'f') goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy182;
				} else {
					if (yych <= 'm') goto yy182;
					if (yych >= 's') goto yy182;
				}
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy182;
				} else {
					if (yych == 'y') goto yy182;
				}
			}
		}
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
#line 1171 "real_world/parse_date_1_78.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 14618 "real_world/parse_date_1_78.c"
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy732;
				goto yy182;
			} else {
				if (yych <= '2') {
					if (yych <= '/') goto yy732;
					goto yy876;
				} else {
					if (yych <= '3') goto yy878;
					if (yych <= '9') goto yy879;
					goto yy732;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy732;
				if (yych <= 'F') goto yy182;
				goto yy732;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy182;
					goto yy732;
				} else {
					if (yych <= 'M') goto yy182;
					if (yych <= 'R') goto yy732;
					goto yy182;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy182;
				if (yych <= 'X') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy732;
					goto yy182;
				} else {
					if (yych == 'f') goto yy182;
					goto yy732;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy182;
					goto yy732;
				} else {
					if (yych <= 'm') goto yy182;
					if (yych <= 'r') goto yy732;
					goto yy182;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy732;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy732;
				}
			}
		}
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy732;
				goto yy182;
			} else {
				if (yych <= '/') goto yy732;
				if (yych <= '9') goto yy879;
				if (yych <= 'C') goto yy732;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy732;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy732;
					if (yych <= 'T') goto yy182;
					goto yy732;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy732;
				if (yych <= 'Y') goto yy182;
				goto yy732;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy732;
				} else {
					if (yych == 'g') goto yy732;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy732;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy732;
				}
			}
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy732;
				goto yy182;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy732;
					goto yy879;
				} else {
					if (yych <= '9') goto yy55;
					if (yych <= 'C') goto yy732;
					goto yy182;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy732;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy732;
					if (yych <= 'T') goto yy182;
					goto yy732;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy732;
				if (yych <= 'Y') goto yy182;
				goto yy732;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy732;
				} else {
					if (yych == 'g') goto yy732;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy732;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy732;
				}
			}
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy732;
				goto yy182;
			} else {
				if (yych == 'D') goto yy182;
				if (yych <= 'E') goto yy732;
				goto yy182;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy182;
				if (yych <= 'L') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'R') goto yy732;
				if (yych <= 'T') goto yy182;
				if (yych <= 'V') goto yy732;
				goto yy182;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy182;
				if (yych <= 'c') goto yy732;
				goto yy182;
			} else {
				if (yych == 'f') goto yy182;
				if (yych <= 'g') goto yy732;
				goto yy182;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy732;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy732;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy732;
				}
			}
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy880;
	goto yy54;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy880;
	goto yy54;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy881;
	if (yych == 'r') goto yy881;
	goto yy54;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy882;
	if (yych == 'g') goto yy882;
	goto yy54;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy883;
	if (yych == 'c') goto yy883;
	goto yy54;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy884;
	if (yych == 'b') goto yy884;
	goto yy54;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy560;
yy744:
	YYDEBUG(744, *YYCURSOR);
	++YYCURSOR;
	goto yy560;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy885;
	if (yych == 'n') goto yy885;
	goto yy54;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy886;
		if (yych <= 'M') goto yy54;
		goto yy887;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy54;
			goto yy886;
		} else {
			if (yych == 'n') goto yy887;
			goto yy54;
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy888;
		if (yych <= 'X') goto yy54;
		goto yy744;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy54;
			goto yy888;
		} else {
			if (yych == 'y') goto yy744;
			goto yy54;
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy883;
	if (yych == 'v') goto yy883;
	goto yy54;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy889;
	if (yych == 't') goto yy889;
	goto yy54;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy408;
		if (yych <= 'O') goto yy54;
		goto yy890;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy54;
			goto yy408;
		} else {
			if (yych == 'p') goto yy890;
			goto yy54;
		}
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy54;
	if (yych <= '9') goto yy891;
	goto yy54;
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy891;
	goto yy54;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '3') goto yy891;
	goto yy54;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy182;
		if (yych <= '0') goto yy875;
		goto yy876;
	} else {
		if (yych <= '3') goto yy878;
		if (yych <= '9') goto yy879;
		goto yy182;
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '2') goto yy876;
	if (yych <= '3') goto yy878;
	if (yych <= '9') goto yy879;
	goto yy182;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy879;
	goto yy182;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '6') goto yy879;
	if (yych <= '9') goto yy55;
	goto yy182;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy238;
	if (yych == 't') goto yy238;
	goto yy54;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy760;
	if (yych != 'n') goto yy54;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy893;
	if (yych == 'i') goto yy893;
	goto yy54;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy575;
	if (yych == 'y') goto yy575;
	goto yy54;
yy762:
	YYDEBUG(762, *YYCURSOR);
	++YYCURSOR;
	goto yy236;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy894;
	if (yych == 'r') goto yy894;
	goto yy54;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy392;
	if (yych == 'e') goto yy392;
	goto yy54;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy895;
	if (yych == 'e') goto yy895;
	goto yy54;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy392;
	if (yych == 'd') goto yy392;
	goto yy54;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy594;
			if (yych <= 0x1F) goto yy204;
			goto yy594;
		} else {
			if (yych == '.') goto yy701;
			if (yych <= '/') goto yy204;
			goto yy849;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy98;
			if (yych <= 'O') goto yy204;
			goto yy98;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy204;
				goto yy98;
			} else {
				if (yych == 'p') goto yy98;
				goto yy204;
			}
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy594;
			goto yy204;
		} else {
			if (yych <= ' ') goto yy594;
			if (yych == '.') goto yy701;
			goto yy204;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy98;
			if (yych == 'P') goto yy98;
			goto yy204;
		} else {
			if (yych <= 'a') goto yy98;
			if (yych == 'p') goto yy98;
			goto yy204;
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy896;
	goto yy204;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy701;
	if (yych == '0') goto yy896;
	goto yy204;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '9') goto yy773;
		if (yych <= 'm') goto yy528;
		goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy772:
	YYDEBUG(772, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '1') goto yy773;
		if (yych <= 'm') goto yy528;
		goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy698;
		goto yy528;
	} else {
		if (yych <= 'r') goto yy698;
		if (yych <= 's') goto yy699;
		if (yych <= 't') goto yy700;
		goto yy528;
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy897;
	if (yych <= '3') goto yy898;
	if (yych <= '9') goto yy773;
	goto yy54;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy899;
	goto yy54;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy899;
		goto yy54;
	} else {
		if (yych <= 'T') goto yy775;
		if (yych == 't') goto yy775;
		goto yy54;
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy105;
	goto yy18;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy900;
	case '.':	goto yy462;
	case '0':	goto yy463;
	case '1':	goto yy464;
	case '2':	goto yy465;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy466;
	case ':':	goto yy467;
	default:	goto yy296;
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy900;
	case '.':	goto yy468;
	case '0':	goto yy469;
	case '1':	goto yy464;
	case '2':	goto yy465;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy466;
	case ':':	goto yy470;
	default:	goto yy296;
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '-':	goto yy900;
	case '.':	goto yy468;
	case '0':	goto yy463;
	case '1':	goto yy464;
	case '2':	goto yy465;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy466;
	case ':':	goto yy470;
	default:	goto yy296;
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy270;
			goto yy130;
		} else {
			if (yych == ' ') goto yy130;
			goto yy270;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy105;
			if (yych <= ',') goto yy270;
			goto yy130;
		} else {
			if (yych <= '/') goto yy270;
			if (yych <= '9') goto yy130;
			goto yy270;
		}
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy105;
		if (yych <= '.') goto yy18;
		goto yy272;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy18;
			goto yy272;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy270;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy105;
			goto yy270;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy272;
			if (yych <= '9') goto yy130;
			goto yy270;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy270;
			if (yych <= 'z') goto yy901;
			goto yy270;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy903;
		if (yych == 'e') goto yy903;
		goto yy18;
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'D') goto yy18;
			goto yy903;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'e') goto yy904;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy787:
	YYDEBUG(787, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy786;
				if (yych <= 0x1F) goto yy54;
				goto yy786;
			} else {
				if (yych == 'D') goto yy814;
				if (yych <= 'E') goto yy54;
				goto yy815;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy816;
				if (yych <= 'L') goto yy54;
				goto yy817;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy54;
					goto yy818;
				} else {
					if (yych <= 'T') goto yy819;
					if (yych <= 'V') goto yy54;
					goto yy905;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy821;
				if (yych <= 'c') goto yy54;
				goto yy814;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy54;
					goto yy815;
				} else {
					if (yych == 'h') goto yy816;
					goto yy54;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy817;
				if (yych <= 'r') goto yy54;
				if (yych <= 's') goto yy818;
				goto yy819;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy54;
					goto yy905;
				} else {
					if (yych == 'y') goto yy821;
					goto yy54;
				}
			}
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy906;
		if (yych == 't') goto yy906;
		goto yy18;
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'S') goto yy18;
			goto yy906;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 't') goto yy907;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy908;
		if (yych == 'r') goto yy908;
		goto yy18;
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy822;
	if (yych == 'd') goto yy822;
	goto yy787;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy786;
		goto yy18;
	} else {
		if (yych <= ' ') goto yy786;
		if (yych == ')') goto yy105;
		goto yy18;
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy105;
	goto yy288;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'Q') goto yy18;
			goto yy908;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy909;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy786;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy786;
			if (yych <= '(') goto yy18;
			goto yy105;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy272;
			goto yy18;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy105;
		if (yych <= '.') goto yy288;
		goto yy272;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy288;
			goto yy272;
		} else {
			if (yych <= '`') goto yy288;
			if (yych <= 'z') goto yy901;
			goto yy288;
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy132;
	if (yych <= '9') goto yy811;
	goto yy132;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy910;
	if (yych <= '6') goto yy911;
	if (yych <= '9') goto yy652;
	goto yy54;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy798;
		goto yy132;
	} else {
		if (yych <= '9') goto yy797;
		if (yych <= ':') goto yy798;
		goto yy132;
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy132;
	} else {
		if (yych <= '9') goto yy797;
		if (yych >= ';') goto yy132;
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy912;
	if (yych <= '6') goto yy913;
	if (yych <= '9') goto yy659;
	goto yy54;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy132;
	} else {
		if (yych <= '9') goto yy797;
		if (yych >= ';') goto yy132;
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy914;
	if (yych <= '6') goto yy915;
	if (yych <= '9') goto yy916;
	goto yy54;
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy917;
	if (yych <= '6') goto yy918;
	if (yych <= '9') goto yy652;
	goto yy54;
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy919;
			if (yych <= 0x1F) goto yy132;
			goto yy919;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy132;
				goto yy804;
			} else {
				if (yych <= '/') goto yy132;
				if (yych <= '9') goto yy797;
				goto yy804;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy921;
			if (yych <= 'O') goto yy132;
			goto yy921;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy132;
				goto yy921;
			} else {
				if (yych == 'p') goto yy921;
				goto yy132;
			}
		}
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy919;
			if (yych <= 0x1F) goto yy132;
			goto yy919;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy132;
			} else {
				if (yych <= '/') goto yy132;
				if (yych <= '9') goto yy797;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy921;
			if (yych <= 'O') goto yy132;
			goto yy921;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy132;
				goto yy921;
			} else {
				if (yych == 'p') goto yy921;
				goto yy132;
			}
		}
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy912;
	if (yych <= '6') goto yy922;
	if (yych <= '9') goto yy659;
	goto yy54;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy919;
			if (yych <= 0x1F) goto yy132;
			goto yy919;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy132;
			} else {
				if (yych <= '/') goto yy132;
				if (yych <= '9') goto yy797;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy921;
			if (yych <= 'O') goto yy132;
			goto yy921;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy132;
				goto yy921;
			} else {
				if (yych == 'p') goto yy921;
				goto yy132;
			}
		}
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy923;
	if (yych <= '6') goto yy924;
	if (yych <= '9') goto yy916;
	goto yy54;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy919;
			if (yych <= 0x1F) goto yy651;
			goto yy919;
		} else {
			if (yych == '.') goto yy809;
			if (yych <= '9') goto yy651;
			goto yy809;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy921;
			if (yych <= 'O') goto yy651;
			goto yy921;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy651;
				goto yy921;
			} else {
				if (yych == 'p') goto yy921;
				goto yy651;
			}
		}
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	++YYCURSOR;
	goto yy132;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy925;
		if (yych == 'y') goto yy925;
		goto yy18;
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'X') goto yy18;
			goto yy925;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'y') goto yy926;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy927;
	if (yych == 'a') goto yy927;
	goto yy54;
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy928;
		if (yych <= 'Q') goto yy54;
		goto yy929;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy54;
			goto yy928;
		} else {
			if (yych == 'r') goto yy929;
			goto yy54;
		}
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy930;
	if (yych == 'o') goto yy930;
	goto yy54;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy931;
		if (yych <= 'N') goto yy54;
		goto yy932;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy54;
			goto yy931;
		} else {
			if (yych == 'o') goto yy932;
			goto yy54;
		}
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy933;
			goto yy54;
		} else {
			if (yych <= 'E') goto yy934;
			if (yych <= 'T') goto yy54;
			goto yy935;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy933;
			goto yy54;
		} else {
			if (yych <= 'e') goto yy934;
			if (yych == 'u') goto yy935;
			goto yy54;
		}
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy936;
		if (yych <= 'T') goto yy54;
		goto yy937;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy54;
			goto yy936;
		} else {
			if (yych == 'u') goto yy937;
			goto yy54;
		}
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy938;
	if (yych == 'e') goto yy938;
	goto yy54;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy939;
	if (yych == 'e') goto yy939;
	goto yy54;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy940;
	if (yych == 'a') goto yy940;
	goto yy54;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy941;
		if (yych == 'h') goto yy941;
		goto yy18;
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'G') goto yy18;
			goto yy941;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'h') goto yy942;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy925;
		if (yych == 'r') goto yy925;
		goto yy18;
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'Q') goto yy18;
			goto yy925;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'r') goto yy926;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy943;
		if (yych == 'u') goto yy943;
		goto yy18;
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'T') goto yy18;
			goto yy943;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'u') goto yy944;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy829:
	YYDEBUG(829, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy945;
		if (yych == 'a') goto yy945;
		goto yy18;
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'B') goto yy946;
		if (yych == 'b') goto yy946;
		goto yy18;
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy947;
		if (yych == 'h') goto yy947;
		goto yy18;
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= '@') goto yy18;
			goto yy945;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy948;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'A') goto yy18;
			goto yy946;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'b') goto yy949;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'G') goto yy18;
			goto yy947;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'h') goto yy950;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy951;
	goto yy54;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy951;
	goto yy54;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'O') goto yy952;
		if (yych == 'o') goto yy952;
		goto yy18;
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy953;
		if (yych == 'y') goto yy953;
		goto yy18;
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'N') goto yy18;
			goto yy952;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'o') goto yy954;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'X') goto yy18;
			goto yy953;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'y') goto yy955;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy956;
		if (yych == 'd') goto yy956;
		goto yy18;
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy957;
		if (yych == 'y') goto yy957;
		goto yy18;
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'C') goto yy18;
			goto yy956;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy958;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'X') goto yy18;
			goto yy957;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'y') goto yy959;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy105;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy960;
		if (yych == 'd') goto yy960;
		goto yy18;
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy105;
			goto yy18;
		} else {
			if (yych <= '/') goto yy272;
			if (yych <= 'C') goto yy18;
			goto yy960;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy272;
			goto yy18;
		} else {
			if (yych == 'd') goto yy961;
			if (yych <= 'z') goto yy901;
			goto yy18;
		}
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy962;
	goto yy54;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy962;
	goto yy54;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy963;
	goto yy54;
yy850:
	YYDEBUG(850, *YYCURSOR);
	++YYCURSOR;
	goto yy528;
yy851:
	YYDEBUG(851, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(852, *YYCURSOR);
	if (yych <= '/') goto yy204;
	if (yych <= '9') goto yy851;
	goto yy204;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy965;
	goto yy209;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy966;
	goto yy54;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '9') goto yy967;
		if (yych <= 'm') goto yy528;
		goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy528;
			goto yy967;
		} else {
			if (yych <= '9') goto yy695;
			if (yych <= 'm') goto yy528;
			goto yy698;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy969;
	if (yych <= '3') goto yy970;
	if (yych <= '9') goto yy971;
	goto yy54;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy972;
	goto yy709;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy973;
	if (yych == 'r') goto yy973;
	goto yy54;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy974;
	if (yych == 'g') goto yy974;
	goto yy54;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy975;
	if (yych == 'c') goto yy975;
	goto yy54;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy976;
	if (yych == 'b') goto yy976;
	goto yy54;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy977;
	if (yych == 'n') goto yy977;
	goto yy54;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy978;
		if (yych <= 'M') goto yy54;
		goto yy979;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy54;
			goto yy978;
		} else {
			if (yych == 'n') goto yy979;
			goto yy54;
		}
	}
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy980;
		if (yych <= 'X') goto yy54;
		goto yy981;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy54;
			goto yy980;
		} else {
			if (yych == 'y') goto yy981;
			goto yy54;
		}
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy975;
	if (yych == 'v') goto yy975;
	goto yy54;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy982;
	if (yych == 't') goto yy982;
	goto yy54;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy983;
	if (yych == 'p') goto yy983;
	goto yy54;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy54;
	if (yych <= '9') goto yy984;
	goto yy54;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy984;
	goto yy54;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '6') goto yy984;
	goto yy54;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy890;
	if (yych == 'p') goto yy890;
	goto yy54;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy985;
	if (yych <= '3') goto yy987;
	if (yych <= '9') goto yy988;
	goto yy54;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy989;
	goto yy54;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '9') goto yy990;
	goto yy182;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych >= ' ') goto yy182;
			} else {
				if (yych <= '/') goto yy877;
				if (yych <= '9') goto yy990;
				if (yych >= 'D') goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych >= 'H') goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych >= 'M') goto yy182;
				} else {
					if (yych <= 'R') goto yy877;
					if (yych <= 'T') goto yy182;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy877;
				if (yych <= 'Y') goto yy182;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
				} else {
					if (yych != 'g') goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych >= 's') goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy182;
				} else {
					if (yych == 'y') goto yy182;
				}
			}
		}
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
#line 1384 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 16632 "real_world/parse_date_1_78.c"
yy878:
	YYDEBUG(878, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy877;
				goto yy182;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy877;
					goto yy990;
				} else {
					if (yych <= '9') goto yy55;
					if (yych <= 'C') goto yy877;
					goto yy182;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy182;
				if (yych <= 'G') goto yy877;
				goto yy182;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy877;
					goto yy182;
				} else {
					if (yych <= 'R') goto yy877;
					if (yych <= 'T') goto yy182;
					goto yy877;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy877;
				if (yych <= 'Y') goto yy182;
				goto yy877;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy182;
					goto yy877;
				} else {
					if (yych == 'g') goto yy877;
					goto yy182;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy877;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy877;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy877;
				}
			}
		}
	}
yy879:
	YYDEBUG(879, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy182;
				if (yych <= 0x1F) goto yy877;
				goto yy182;
			} else {
				if (yych == 'D') goto yy182;
				if (yych <= 'E') goto yy877;
				goto yy182;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy182;
				if (yych <= 'L') goto yy877;
				goto yy182;
			} else {
				if (yych <= 'R') goto yy877;
				if (yych <= 'T') goto yy182;
				if (yych <= 'V') goto yy877;
				goto yy182;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy182;
				if (yych <= 'c') goto yy877;
				goto yy182;
			} else {
				if (yych == 'f') goto yy182;
				if (yych <= 'g') goto yy877;
				goto yy182;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy182;
				if (yych <= 'r') goto yy877;
				goto yy182;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy877;
					goto yy182;
				} else {
					if (yych == 'y') goto yy182;
					goto yy877;
				}
			}
		}
	}
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy992;
	goto yy54;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy993;
	if (yych == 'i') goto yy993;
	goto yy560;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy994;
	if (yych == 'u') goto yy994;
	goto yy560;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy995;
	if (yych == 'e') goto yy995;
	goto yy560;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy996;
	if (yych == 'r') goto yy996;
	goto yy560;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy997;
	if (yych == 'u') goto yy997;
	goto yy560;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy744;
	if (yych == 'y') goto yy744;
	goto yy560;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy744;
	if (yych == 'e') goto yy744;
	goto yy560;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy998;
	if (yych == 'c') goto yy998;
	goto yy560;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy999;
	if (yych == 'o') goto yy999;
	goto yy560;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy883;
	if (yych == 't') goto yy883;
	goto yy560;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1000;
	if (yych <= '/') goto yy892;
	if (yych <= '7') goto yy1001;
yy892:
	YYDEBUG(892, *YYCURSOR);
#line 1416 "real_world/parse_date_1_78.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 16856 "real_world/parse_date_1_78.c"
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1003;
	if (yych == 'g') goto yy1003;
	goto yy54;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy238;
	if (yych == 'y') goto yy238;
	goto yy54;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy238;
	if (yych == 'r') goto yy238;
	goto yy54;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy594;
			if (yych <= 0x1F) goto yy204;
			goto yy594;
		} else {
			if (yych == '.') goto yy1004;
			if (yych <= '9') goto yy204;
			goto yy1005;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy98;
			if (yych <= 'O') goto yy204;
			goto yy98;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy204;
				goto yy98;
			} else {
				if (yych == 'p') goto yy98;
				goto yy204;
			}
		}
	}
yy897:
	YYDEBUG(897, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '9') goto yy1006;
		if (yych <= 'm') goto yy528;
		goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy898:
	YYDEBUG(898, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy528;
		if (yych <= '1') goto yy1006;
		if (yych <= 'm') goto yy528;
		goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
			goto yy528;
		}
	}
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy1007;
	if (yych <= '3') goto yy1008;
	goto yy54;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1009;
	goto yy54;
yy901:
	YYDEBUG(901, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy902:
	YYDEBUG(902, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy272;
		goto yy54;
	} else {
		if (yych <= '_') goto yy272;
		if (yych <= '`') goto yy54;
		if (yych <= 'z') goto yy901;
		goto yy54;
	}
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy925;
	if (yych == 'r') goto yy925;
	goto yy54;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy925;
	if (yych == 'r') goto yy926;
	goto yy902;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1011;
	if (yych == 'e') goto yy1011;
	goto yy54;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy947;
	if (yych == 'h') goto yy947;
	goto yy54;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy947;
	if (yych == 'h') goto yy950;
	goto yy902;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy925;
	if (yych == 'y') goto yy925;
	goto yy54;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy925;
	if (yych == 'y') goto yy926;
	goto yy902;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy803;
		goto yy651;
	} else {
		if (yych <= '9') goto yy1012;
		if (yych <= ':') goto yy803;
		goto yy651;
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy803;
		goto yy651;
	} else {
		if (yych <= '0') goto yy1013;
		if (yych == ':') goto yy803;
		goto yy651;
	}
yy912:
	YYDEBUG(912, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy809;
		goto yy651;
	} else {
		if (yych <= '9') goto yy1014;
		if (yych <= ':') goto yy809;
		goto yy651;
	}
yy913:
	YYDEBUG(913, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy809;
		goto yy651;
	} else {
		if (yych <= '0') goto yy1013;
		if (yych == ':') goto yy809;
		goto yy651;
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '9') goto yy1013;
	goto yy651;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1013;
	goto yy651;
yy916:
	YYDEBUG(916, *YYCURSOR);
	++YYCURSOR;
	goto yy651;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy803;
		goto yy651;
	} else {
		if (yych <= '9') goto yy1015;
		if (yych <= ':') goto yy803;
		goto yy651;
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy803;
		goto yy651;
	} else {
		if (yych <= '0') goto yy1016;
		if (yych == ':') goto yy803;
		goto yy651;
	}
yy919:
	YYDEBUG(919, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(920, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy919;
			goto yy54;
		} else {
			if (yych <= ' ') goto yy919;
			if (yych <= '@') goto yy54;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy54;
		} else {
			if (yych <= 'a') goto yy921;
			if (yych != 'p') goto yy54;
		}
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1017;
		goto yy54;
	} else {
		if (yych <= 'M') goto yy1018;
		if (yych == 'm') goto yy1018;
		goto yy54;
	}
yy922:
	YYDEBUG(922, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy809;
		goto yy651;
	} else {
		if (yych <= '0') goto yy1016;
		if (yych == ':') goto yy809;
		goto yy651;
	}
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '9') goto yy1016;
	goto yy651;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1016;
	goto yy651;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy130;
		if (yych <= 0x1F) goto yy270;
		goto yy130;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy270;
			goto yy130;
		} else {
			if (yych <= '/') goto yy270;
			if (yych <= '9') goto yy130;
			goto yy270;
		}
	}
yy926:
	YYDEBUG(926, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy270;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych <= ',') goto yy270;
			goto yy130;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy272;
			if (yych <= '9') goto yy130;
			goto yy270;
		} else {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy270;
			if (yych <= 'z') goto yy901;
			goto yy270;
		}
	}
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1019;
	if (yych == 'y') goto yy1019;
	goto yy54;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1021;
	if (yych == 'r') goto yy1021;
	goto yy54;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1022;
	if (yych == 'i') goto yy1022;
	goto yy54;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1023;
	if (yych == 'u') goto yy1023;
	goto yy54;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1024;
	if (yych == 'n') goto yy1024;
	goto yy54;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1025;
	if (yych == 'n') goto yy1025;
	goto yy54;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1026;
	if (yych == 't') goto yy1026;
	goto yy54;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1027;
	if (yych == 'c') goto yy1027;
	goto yy54;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1022;
	if (yych == 'n') goto yy1022;
	goto yy54;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1028;
	if (yych == 'u') goto yy1028;
	goto yy54;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1029;
	if (yych == 'e') goto yy1029;
	goto yy54;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy54;
		if (yych <= 'D') goto yy1030;
		goto yy1031;
	} else {
		if (yych <= 'c') goto yy54;
		if (yych <= 'd') goto yy1030;
		if (yych <= 'e') goto yy1031;
		goto yy54;
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1023;
	if (yych == 'a') goto yy1023;
	goto yy54;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1032;
	if (yych == 'y') goto yy1032;
	goto yy54;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1034;
	if (yych == 't') goto yy1034;
	goto yy54;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1034;
	if (yych == 't') goto yy1035;
	goto yy902;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1036;
	if (yych == 's') goto yy1036;
	goto yy54;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1036;
	if (yych == 's') goto yy1037;
	goto yy902;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy953;
	if (yych == 'y') goto yy953;
	goto yy54;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy903;
	if (yych == 'e') goto yy903;
	goto yy54;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy786;
	if (yych == ' ') goto yy786;
	goto yy54;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy953;
	if (yych == 'y') goto yy955;
	goto yy902;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy903;
	if (yych == 'e') goto yy904;
	goto yy902;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy786;
	if (yych == ' ') goto yy786;
	goto yy902;
yy951:
	YYDEBUG(951, *YYCURSOR);
	++YYCURSOR;
	goto yy732;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1038;
	if (yych == 'w') goto yy1038;
	goto yy54;
yy953:
	YYDEBUG(953, *YYCURSOR);
	++YYCURSOR;
	goto yy288;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1038;
	if (yych == 'w') goto yy1040;
	goto yy902;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy272;
		goto yy288;
	} else {
		if (yych <= '_') goto yy272;
		if (yych <= '`') goto yy288;
		if (yych <= 'z') goto yy901;
		goto yy288;
	}
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy945;
	if (yych == 'a') goto yy945;
	goto yy54;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy953;
	if (yych == 's') goto yy953;
	goto yy288;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy945;
	if (yych == 'a') goto yy948;
	goto yy902;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy288;
			goto yy272;
		} else {
			if (yych == 'S') goto yy953;
			goto yy288;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy272;
			if (yych <= '`') goto yy288;
			goto yy901;
		} else {
			if (yych <= 's') goto yy955;
			if (yych <= 'z') goto yy901;
			goto yy288;
		}
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1041;
	if (yych == 'a') goto yy1041;
	goto yy54;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1041;
	if (yych == 'a') goto yy1042;
	goto yy902;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1043;
	goto yy54;
yy963:
	YYDEBUG(963, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(964, *YYCURSOR);
#line 1270 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 17456 "real_world/parse_date_1_78.c"
yy965:
	YYDEBUG(965, *YYCURSOR);
	++YYCURSOR;
	goto yy209;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1044;
	goto yy54;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy968;
		if (yych <= '9') goto yy849;
		if (yych >= 'n') goto yy698;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy698;
		} else {
			if (yych <= 's') goto yy699;
			if (yych <= 't') goto yy700;
		}
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
#line 1218 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 17497 "real_world/parse_date_1_78.c"
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy528;
			goto yy971;
		} else {
			if (yych == 'T') goto yy1045;
			goto yy528;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1046;
			if (yych <= 'q') goto yy528;
			goto yy1046;
		} else {
			if (yych <= 's') goto yy1047;
			if (yych <= 't') goto yy1048;
			goto yy528;
		}
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy528;
		} else {
			if (yych == 'T') goto yy1045;
			goto yy528;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1046;
			if (yych <= 'q') goto yy528;
			goto yy1046;
		} else {
			if (yych <= 's') goto yy1047;
			if (yych <= 't') goto yy1048;
			goto yy528;
		}
	}
yy971:
	YYDEBUG(971, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1045;
		if (yych <= 'm') goto yy528;
		goto yy1046;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy528;
			goto yy1046;
		} else {
			if (yych <= 's') goto yy1047;
			if (yych <= 't') goto yy1048;
			goto yy528;
		}
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy1049;
	if (yych <= '3') goto yy1050;
	if (yych <= '9') goto yy971;
	goto yy54;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'I') goto yy993;
		if (yych == 'i') goto yy993;
		goto yy560;
	}
yy974:
	YYDEBUG(974, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'U') goto yy994;
		if (yych == 'u') goto yy994;
		goto yy560;
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'E') goto yy995;
		if (yych == 'e') goto yy995;
		goto yy560;
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'R') goto yy996;
		if (yych == 'r') goto yy996;
		goto yy560;
	}
yy977:
	YYDEBUG(977, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'U') goto yy997;
		if (yych == 'u') goto yy997;
		goto yy560;
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'Y') goto yy744;
		if (yych == 'y') goto yy744;
		goto yy560;
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'E') goto yy744;
		if (yych == 'e') goto yy744;
		goto yy560;
	}
yy980:
	YYDEBUG(980, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'C') goto yy998;
		if (yych == 'c') goto yy998;
		goto yy560;
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy899;
	goto yy560;
yy982:
	YYDEBUG(982, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'O') goto yy999;
		if (yych == 'o') goto yy999;
		goto yy560;
	}
yy983:
	YYDEBUG(983, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy899;
		goto yy560;
	} else {
		if (yych <= 'T') goto yy975;
		if (yych == 't') goto yy975;
		goto yy560;
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	++YYCURSOR;
	goto yy877;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy986;
		if (yych <= '9') goto yy988;
		if (yych >= 'n') goto yy1051;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1051;
		} else {
			if (yych <= 's') goto yy1052;
			if (yych <= 't') goto yy1053;
		}
	}
yy986:
	YYDEBUG(986, *YYCURSOR);
#line 1206 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 17728 "real_world/parse_date_1_78.c"
yy987:
	YYDEBUG(987, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy986;
		if (yych <= '1') goto yy988;
		if (yych <= 'm') goto yy986;
		goto yy1051;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy986;
			goto yy1051;
		} else {
			if (yych <= 's') goto yy1052;
			if (yych <= 't') goto yy1053;
			goto yy986;
		}
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1051;
		goto yy986;
	} else {
		if (yych <= 'r') goto yy1051;
		if (yych <= 's') goto yy1052;
		if (yych <= 't') goto yy1053;
		goto yy986;
	}
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy1054;
	if (yych <= '3') goto yy1055;
	if (yych <= '9') goto yy988;
	goto yy54;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy55;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych >= ' ') goto yy181;
			} else {
				if (yych == 'D') goto yy183;
				if (yych >= 'F') goto yy184;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy74;
				if (yych >= 'M') goto yy185;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy186;
				} else {
					if (yych <= 'T') goto yy1056;
					if (yych >= 'W') goto yy84;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy86;
				if (yych >= 'd') goto yy183;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy184;
				} else {
					if (yych == 'h') goto yy74;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy185;
				if (yych <= 'r') goto yy991;
				if (yych <= 's') goto yy186;
				goto yy1057;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy84;
				} else {
					if (yych == 'y') goto yy86;
				}
			}
		}
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
#line 1346 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 17838 "real_world/parse_date_1_78.c"
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy1058;
	if (yych <= '3') goto yy1059;
	goto yy54;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy744;
	if (yych == 'l') goto yy744;
	goto yy54;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1060;
	if (yych == 's') goto yy1060;
	goto yy54;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy999;
	if (yych == 'm') goto yy999;
	goto yy54;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy997;
	if (yych != 'u') goto yy54;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1061;
	if (yych == 'a') goto yy1061;
	goto yy54;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy744;
	if (yych == 'h') goto yy744;
	goto yy54;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1062;
	if (yych == 'b') goto yy1062;
	goto yy54;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych >= '8') goto yy54;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1002, *YYCURSOR);
#line 1397 "real_world/parse_date_1_78.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 17914 "real_world/parse_date_1_78.c"
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1063;
	if (yych == 'h') goto yy1063;
	goto yy54;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1064;
	goto yy54;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1066;
	goto yy54;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy698;
		goto yy968;
	} else {
		if (yych <= 'r') goto yy698;
		if (yych <= 's') goto yy699;
		if (yych <= 't') goto yy700;
		goto yy968;
	}
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1068;
	goto yy54;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1068;
	goto yy54;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1010;
	if (yych <= '9') goto yy1070;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
#line 1435 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 17977 "real_world/parse_date_1_78.c"
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy54;
		if (yych <= 'D') goto yy1030;
		goto yy1071;
	} else {
		if (yych <= 'c') goto yy54;
		if (yych <= 'd') goto yy1030;
		if (yych <= 'e') goto yy1071;
		goto yy54;
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1073;
			if (yych <= 0x1F) goto yy651;
			goto yy1073;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy651;
				goto yy1073;
			} else {
				if (yych == '+') goto yy1073;
				goto yy651;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy1073;
			if (yych <= '.') goto yy803;
			if (yych <= '9') goto yy651;
			goto yy803;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy651;
				goto yy1073;
			} else {
				if (yych <= '`') goto yy651;
				if (yych <= 'z') goto yy1073;
				goto yy651;
			}
		}
	}
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1073;
			goto yy651;
		} else {
			if (yych <= ' ') goto yy1073;
			if (yych == '(') goto yy1073;
			goto yy651;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy651;
			if (yych <= '-') goto yy1073;
			goto yy651;
		} else {
			if (yych <= 'Z') goto yy1073;
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1073;
			goto yy651;
		}
	}
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1080;
			if (yych <= 0x1F) goto yy651;
			goto yy1080;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy651;
				goto yy1080;
			} else {
				if (yych == '+') goto yy1080;
				goto yy651;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy1080;
			if (yych <= '.') goto yy809;
			if (yych <= '9') goto yy651;
			goto yy809;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy651;
				goto yy1080;
			} else {
				if (yych <= '`') goto yy651;
				if (yych <= 'z') goto yy1080;
				goto yy651;
			}
		}
	}
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1080;
			if (yych <= 0x1F) goto yy651;
			goto yy1080;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy651;
				goto yy1080;
			} else {
				if (yych == '+') goto yy1080;
				goto yy651;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy1080;
			if (yych <= '.') goto yy803;
			if (yych <= '9') goto yy651;
			goto yy803;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy651;
				goto yy1080;
			} else {
				if (yych <= '`') goto yy651;
				if (yych <= 'z') goto yy1080;
				goto yy651;
			}
		}
	}
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1080;
			goto yy651;
		} else {
			if (yych <= ' ') goto yy1080;
			if (yych == '(') goto yy1080;
			goto yy651;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy651;
			if (yych <= '-') goto yy1080;
			goto yy651;
		} else {
			if (yych <= 'Z') goto yy1080;
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1080;
			goto yy651;
		}
	}
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1018;
	if (yych != 'm') goto yy54;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1083;
		if (yych == '\t') goto yy1083;
		goto yy54;
	} else {
		if (yych <= ' ') goto yy1083;
		if (yych == '.') goto yy1085;
		goto yy54;
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1086;
	if (yych == 's') goto yy1086;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
#line 1554 "real_world/parse_date_1_78.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18186 "real_world/parse_date_1_78.c"
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1087;
	if (yych == 't') goto yy1087;
	goto yy54;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy1088;
	if (yych == 'd') goto yy1088;
	goto yy1020;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1019;
	if (yych == 'r') goto yy1019;
	goto yy54;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1086;
		if (yych <= 'T') goto yy1020;
		goto yy1089;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1020;
			goto yy1086;
		} else {
			if (yych == 'u') goto yy1089;
			goto yy1020;
		}
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy1088;
		if (yych <= 'S') goto yy1020;
		goto yy1090;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy1020;
			goto yy1088;
		} else {
			if (yych == 't') goto yy1090;
			goto yy1020;
		}
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1091;
	if (yych == 'u') goto yy1091;
	goto yy1020;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1092;
		if (yych <= 'R') goto yy1020;
		goto yy1086;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1020;
			goto yy1092;
		} else {
			if (yych == 's') goto yy1086;
			goto yy1020;
		}
	}
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1093;
	if (yych == 'r') goto yy1093;
	goto yy1020;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy1094;
	if (yych == 's') goto yy1094;
	goto yy1020;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy1095;
	if (yych == 'n') goto yy1095;
	goto yy1020;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1096;
	if (yych == 'k') goto yy1096;
	goto yy54;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ' ') goto yy1098;
	} else {
		if (yych <= 'S') goto yy1086;
		if (yych == 's') goto yy1086;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
#line 1045 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		// skip "last day of" or "first day of"
		if (*ptr == 'l') {
			s->time->relative.first_last_day_of = 2;
		} else {
			s->time->relative.first_last_day_of = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 18319 "real_world/parse_date_1_78.c"
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	++YYCURSOR;
	goto yy682;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy272;
		goto yy682;
	} else {
		if (yych <= '_') goto yy272;
		if (yych <= '`') goto yy682;
		if (yych <= 'z') goto yy901;
		goto yy682;
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy663;
	if (yych == ' ') goto yy663;
	goto yy54;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy663;
	if (yych == ' ') goto yy663;
	goto yy902;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	++YYCURSOR;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
#line 1008 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18365 "real_world/parse_date_1_78.c"
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy272;
		goto yy1039;
	} else {
		if (yych <= '_') goto yy272;
		if (yych <= '`') goto yy1039;
		if (yych <= 'z') goto yy901;
		goto yy1039;
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1099;
	if (yych == 'y') goto yy1099;
	goto yy54;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1099;
	if (yych == 'y') goto yy1101;
	goto yy902;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '2') goto yy1102;
	if (yych <= '3') goto yy1103;
	goto yy54;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1104;
	goto yy54;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1105;
	if (yych <= '2') goto yy1106;
	if (yych <= '9') goto yy1107;
	goto yy54;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1108;
	goto yy54;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1108;
	goto yy54;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1108;
	goto yy54;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy528;
			goto yy1109;
		} else {
			if (yych == 'T') goto yy1045;
			goto yy528;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1046;
			if (yych <= 'q') goto yy528;
			goto yy1046;
		} else {
			if (yych <= 's') goto yy1047;
			if (yych <= 't') goto yy1048;
			goto yy528;
		}
	}
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy528;
			goto yy1109;
		} else {
			if (yych == 'T') goto yy1045;
			goto yy528;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1046;
			if (yych <= 'q') goto yy528;
			goto yy1046;
		} else {
			if (yych <= 's') goto yy1047;
			if (yych <= 't') goto yy1048;
			goto yy528;
		}
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1110;
	goto yy54;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1110;
	goto yy54;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1110;
	goto yy54;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy986;
		if (yych <= '9') goto yy1111;
		if (yych <= 'm') goto yy986;
		goto yy1051;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy986;
			goto yy1051;
		} else {
			if (yych <= 's') goto yy1052;
			if (yych <= 't') goto yy1053;
			goto yy986;
		}
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy986;
		if (yych <= '1') goto yy1111;
		if (yych <= 'm') goto yy986;
		goto yy1051;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy986;
			goto yy1051;
		} else {
			if (yych <= 's') goto yy1052;
			if (yych <= 't') goto yy1053;
			goto yy986;
		}
	}
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy54;
			if (yych <= '1') goto yy1112;
			goto yy1113;
		} else {
			if (yych <= '9') goto yy1114;
			if (yych <= 'G') goto yy54;
			goto yy249;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy250;
			goto yy54;
		} else {
			if (yych <= 'h') goto yy249;
			if (yych == 'u') goto yy250;
			goto yy54;
		}
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy54;
			if (yych <= '1') goto yy1115;
			goto yy1116;
		} else {
			if (yych <= '9') goto yy1117;
			if (yych <= 'G') goto yy54;
			goto yy249;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy250;
			goto yy54;
		} else {
			if (yych <= 'h') goto yy249;
			if (yych == 'u') goto yy250;
			goto yy54;
		}
	}
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1118;
	goto yy54;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1118;
	goto yy54;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy744;
	if (yych == 't') goto yy744;
	goto yy54;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1119;
	if (yych == 'r') goto yy1119;
	goto yy54;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1120;
	if (yych == 'e') goto yy1120;
	goto yy54;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy392;
	if (yych == 't') goto yy392;
	goto yy54;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1065, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy204;
			goto yy1064;
		} else {
			if (yych == 'A') goto yy1121;
			goto yy204;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1121;
			if (yych <= '`') goto yy204;
			goto yy1121;
		} else {
			if (yych == 'p') goto yy1121;
			goto yy204;
		}
	}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1067, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy54;
			goto yy1066;
		} else {
			if (yych == 'A') goto yy1121;
			goto yy54;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1121;
			if (yych <= '`') goto yy54;
			goto yy1121;
		} else {
			if (yych == 'p') goto yy1121;
			goto yy54;
		}
	}
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1069, *YYCURSOR);
#line 1448 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 18673 "real_world/parse_date_1_78.c"
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1010;
	if (yych <= '9') goto yy1122;
	goto yy1010;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1123;
	if (yych == 'k') goto yy1123;
	goto yy54;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1072;
			if (yych <= 0x1F) goto yy54;
			goto yy1072;
		} else {
			if (yych == '(') goto yy1074;
			if (yych <= '*') goto yy54;
			goto yy1075;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy1075;
			if (yych <= '@') goto yy54;
			goto yy1076;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy1077;
				goto yy1076;
			} else {
				if (yych <= '`') goto yy54;
				if (yych <= 'z') goto yy1078;
				goto yy54;
			}
		}
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy54;
	if (yych <= 'Z') goto yy1078;
	if (yych <= '`') goto yy54;
	if (yych <= 'z') goto yy1078;
	goto yy54;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1124;
	if (yych <= '2') goto yy1125;
	if (yych <= '9') goto yy1126;
	goto yy54;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy916;
		goto yy651;
	} else {
		if (yych <= 'Z') goto yy1127;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1128;
		goto yy651;
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy916;
		if (yych <= '@') goto yy651;
		goto yy1127;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy1129;
			goto yy1127;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1128;
			goto yy651;
		}
	}
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy916;
		goto yy651;
	} else {
		if (yych <= 'Z') goto yy1127;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1127;
		goto yy651;
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy54;
				goto yy1079;
			} else {
				if (yych == ' ') goto yy1079;
				goto yy54;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy1074;
				if (yych <= '*') goto yy54;
				goto yy1075;
			} else {
				if (yych == '-') goto yy1075;
				goto yy54;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy1081;
				if (yych <= 'F') goto yy1076;
				goto yy1077;
			} else {
				if (yych != 'P') goto yy1076;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy54;
				if (yych <= 'a') goto yy1082;
				goto yy1078;
			} else {
				if (yych <= 'p') goto yy1082;
				if (yych <= 'z') goto yy1078;
				goto yy54;
			}
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy916;
			goto yy651;
		} else {
			if (yych <= '.') goto yy1017;
			if (yych <= '@') goto yy651;
			goto yy1127;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1130;
			if (yych <= 'Z') goto yy1127;
			goto yy651;
		} else {
			if (yych == 'm') goto yy1131;
			if (yych <= 'z') goto yy1128;
			goto yy651;
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy916;
			goto yy651;
		} else {
			if (yych <= '.') goto yy1017;
			if (yych <= '@') goto yy651;
			goto yy1127;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1130;
			if (yych <= 'Z') goto yy1127;
			goto yy651;
		} else {
			if (yych == 'm') goto yy1130;
			if (yych <= 'z') goto yy1127;
			goto yy651;
		}
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1084, *YYCURSOR);
#line 1595 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 18898 "real_world/parse_date_1_78.c"
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1083;
		if (yych <= 0x08) goto yy54;
		goto yy1083;
	} else {
		if (yych == ' ') goto yy1083;
		goto yy54;
	}
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	++YYCURSOR;
	goto yy1020;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1132;
		if (yych <= 'M') goto yy54;
		goto yy1133;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy54;
			goto yy1132;
		} else {
			if (yych == 'n') goto yy1133;
			goto yy54;
		}
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1134;
	if (yych == 'a') goto yy1134;
	goto yy54;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1135;
	if (yych == 't') goto yy1135;
	goto yy54;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1019;
	if (yych == 'h') goto yy1019;
	goto yy54;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1094;
	if (yych == 'r') goto yy1094;
	goto yy54;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1136;
	if (yych == 'n') goto yy1136;
	goto yy54;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1094;
	if (yych != 's') goto yy54;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1088;
	if (yych == 'd') goto yy1088;
	goto yy54;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1093;
	if (yych == 'e') goto yy1093;
	goto yy54;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy814;
		if (yych >= 'S') goto yy1086;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy814;
		} else {
			if (yych == 's') goto yy1086;
		}
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
#line 1530 "real_world/parse_date_1_78.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19016 "real_world/parse_date_1_78.c"
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1137;
	if (yych == 'o') goto yy1137;
	goto yy54;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	++YYCURSOR;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
#line 965 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19039 "real_world/parse_date_1_78.c"
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy272;
		goto yy1100;
	} else {
		if (yych <= '_') goto yy272;
		if (yych <= '`') goto yy1100;
		if (yych <= 'z') goto yy901;
		goto yy1100;
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1110;
	goto yy54;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1110;
	goto yy54;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1138;
	goto yy54;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1107;
	if (yych <= ':') goto yy1139;
	goto yy54;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '4') goto yy1107;
	if (yych == ':') goto yy1139;
	goto yy54;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1139;
	goto yy54;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1045;
	goto yy528;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1140;
		if (yych <= 'm') goto yy986;
		goto yy1046;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy986;
			goto yy1046;
		} else {
			if (yych <= 's') goto yy1047;
			if (yych <= 't') goto yy1048;
			goto yy986;
		}
	}
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	++YYCURSOR;
	goto yy986;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1110;
		if (yych <= 'm') goto yy986;
		goto yy1051;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy986;
			goto yy1051;
		} else {
			if (yych <= 's') goto yy1052;
			if (yych <= 't') goto yy1053;
			goto yy986;
		}
	}
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1141;
	if (yych <= '9') goto yy1114;
	if (yych <= ':') goto yy1142;
	goto yy54;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy54;
		if (yych <= '4') goto yy1141;
		goto yy1143;
	} else {
		if (yych == ':') goto yy1142;
		goto yy54;
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1143;
	if (yych == ':') goto yy1142;
	goto yy54;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1144;
	if (yych <= '9') goto yy1117;
	goto yy54;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '4') goto yy1144;
	if (yych <= '5') goto yy1143;
	goto yy54;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1143;
	goto yy54;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1145;
	goto yy54;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy744;
	if (yych == 'y') goto yy744;
	goto yy54;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy744;
	if (yych == 'r') goto yy744;
	goto yy54;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1146;
		goto yy54;
	} else {
		if (yych <= 'M') goto yy1147;
		if (yych == 'm') goto yy1147;
		goto yy54;
	}
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1010;
	if (yych <= '9') goto yy1148;
	goto yy1010;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy814;
		if (yych <= 'R') goto yy54;
		goto yy1086;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy54;
			goto yy814;
		} else {
			if (yych == 's') goto yy1086;
			goto yy54;
		}
	}
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '9') goto yy1126;
	if (yych <= ':') goto yy1149;
	goto yy651;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy651;
		if (yych >= '5') goto yy1150;
	} else {
		if (yych <= '9') goto yy916;
		if (yych <= ':') goto yy1149;
		goto yy651;
	}
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '5') goto yy1150;
	if (yych <= '9') goto yy916;
	if (yych <= ':') goto yy1149;
	goto yy651;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy916;
		goto yy651;
	} else {
		if (yych <= 'Z') goto yy1151;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1151;
		goto yy651;
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy651;
			goto yy916;
		} else {
			if (yych == '/') goto yy1152;
			goto yy651;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1151;
			if (yych <= '^') goto yy651;
			goto yy1152;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1153;
			goto yy651;
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy916;
		if (yych <= '@') goto yy651;
		goto yy1151;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy1154;
			goto yy1151;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1151;
			goto yy651;
		}
	}
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy1083;
			if (yych <= 0x08) goto yy651;
			goto yy1083;
		} else {
			if (yych == ' ') goto yy1083;
			if (yych <= '(') goto yy651;
			goto yy916;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy1085;
			goto yy651;
		} else {
			if (yych <= 'Z') goto yy1151;
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1151;
			goto yy651;
		}
	}
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy1083;
			if (yych == '\t') goto yy1083;
			goto yy651;
		} else {
			if (yych <= ' ') goto yy1083;
			if (yych == ')') goto yy916;
			goto yy651;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy1085;
			if (yych <= '/') goto yy1152;
			if (yych <= '@') goto yy651;
			goto yy1151;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy651;
				goto yy1152;
			} else {
				if (yych <= '`') goto yy651;
				if (yych <= 'z') goto yy1153;
				goto yy651;
			}
		}
	}
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1133;
	if (yych != 'n') goto yy54;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1155;
	if (yych == 'i') goto yy1155;
	goto yy54;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1086;
	if (yych == 'y') goto yy1086;
	goto yy54;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1019;
	if (yych == 'e') goto yy1019;
	goto yy54;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1019;
	if (yych == 'd') goto yy1019;
	goto yy54;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1156;
	if (yych == 'f') goto yy1156;
	goto yy54;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1157;
	if (yych <= '2') goto yy1158;
	goto yy54;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1159;
	if (yych <= '9') goto yy1160;
	goto yy54;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1161;
	if (yych <= '2') goto yy1162;
	if (yych <= '9') goto yy1107;
	goto yy54;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1163;
	if (yych <= '9') goto yy1164;
	if (yych >= ';') goto yy54;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1165;
	goto yy54;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1164;
	goto yy54;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1163;
	if (yych <= '9') goto yy1164;
	goto yy54;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1166;
	if (yych <= '2') goto yy1167;
	goto yy54;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1147;
	if (yych != 'm') goto yy54;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1168;
		if (yych == '\t') goto yy1168;
		goto yy54;
	} else {
		if (yych <= ' ') goto yy1168;
		if (yych == '.') goto yy1170;
		goto yy54;
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	++YYCURSOR;
	goto yy1010;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '5') goto yy1150;
	if (yych <= '9') goto yy916;
	goto yy651;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '9') goto yy916;
	goto yy651;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy916;
		goto yy651;
	} else {
		if (yych <= 'Z') goto yy1171;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1171;
		goto yy651;
	}
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy54;
	if (yych <= 'Z') goto yy1172;
	goto yy54;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy651;
			goto yy916;
		} else {
			if (yych == '/') goto yy1152;
			goto yy651;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1171;
			if (yych <= '^') goto yy651;
			goto yy1152;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1173;
			goto yy651;
		}
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy651;
			goto yy916;
		} else {
			if (yych == '+') goto yy1075;
			goto yy651;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy1075;
			if (yych <= '@') goto yy651;
			goto yy1171;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1171;
			goto yy651;
		}
	}
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1174;
	if (yych == 'g') goto yy1174;
	goto yy54;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	++YYCURSOR;
	goto yy1033;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1175;
	goto yy54;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '4') goto yy1175;
	goto yy54;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1160;
	if (yych <= ':') goto yy1176;
	goto yy54;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1176;
	goto yy54;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1177;
	if (yych <= ':') goto yy1139;
	goto yy54;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '4') goto yy1177;
	if (yych == ':') goto yy1139;
	goto yy54;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1176;
	if (yych <= '6') goto yy1178;
	if (yych >= ':') goto yy54;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1179;
	if (yych <= '6') goto yy1180;
	goto yy54;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1181;
	goto yy54;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1182;
	goto yy54;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '4') goto yy1182;
	goto yy54;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1169, *YYCURSOR);
#line 1079 "real_world/parse_date_1_78.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 19658 "real_world/parse_date_1_78.c"
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1168;
		if (yych <= 0x08) goto yy54;
		goto yy1168;
	} else {
		if (yych == ' ') goto yy1168;
		goto yy54;
	}
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy916;
		goto yy651;
	} else {
		if (yych <= 'Z') goto yy1183;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1183;
		goto yy651;
	}
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy54;
	if (yych <= 'z') goto yy1184;
	goto yy54;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy651;
			goto yy916;
		} else {
			if (yych == '/') goto yy1152;
			goto yy651;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1183;
			if (yych <= '^') goto yy651;
			goto yy1152;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1186;
			goto yy651;
		}
	}
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1187;
	if (yych == 'h') goto yy1187;
	goto yy54;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1188;
	goto yy54;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1189;
	if (yych <= '6') goto yy1191;
	if (yych <= '9') goto yy1192;
	goto yy54;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1193;
	goto yy54;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '0') goto yy1189;
	if (yych <= '5') goto yy1179;
	if (yych <= '6') goto yy1180;
	goto yy54;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1192;
	goto yy54;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1192;
	goto yy54;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1164;
	goto yy54;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1142;
	goto yy54;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy916;
		goto yy651;
	} else {
		if (yych <= 'Z') goto yy1194;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1194;
		goto yy651;
	}
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yyaccept = 17;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1185, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy1152;
		goto yy651;
	} else {
		if (yych <= '_') goto yy1152;
		if (yych <= '`') goto yy651;
		if (yych <= 'z') goto yy1184;
		goto yy651;
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy651;
			goto yy916;
		} else {
			if (yych == '/') goto yy1152;
			goto yy651;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1194;
			if (yych <= '^') goto yy651;
			goto yy1152;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1195;
			goto yy651;
		}
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1019;
	if (yych == 't') goto yy1019;
	goto yy54;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1196;
	goto yy54;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1190;
	if (yych <= '9') goto yy1192;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
#line 1358 "real_world/parse_date_1_78.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 19861 "real_world/parse_date_1_78.c"
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1190;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	++YYCURSOR;
	goto yy1190;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1197;
	if (yych <= '9') goto yy1160;
	goto yy54;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy916;
	goto yy651;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy916;
		if (yych <= '.') goto yy651;
		goto yy1152;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy651;
			goto yy1152;
		} else {
			if (yych <= '`') goto yy651;
			if (yych <= 'z') goto yy1198;
			goto yy651;
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1200;
	goto yy54;
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1201;
	if (yych <= ':') goto yy1176;
	goto yy54;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1199, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy1152;
		goto yy54;
	} else {
		if (yych <= '_') goto yy1152;
		if (yych <= '`') goto yy54;
		if (yych <= 'z') goto yy1198;
		goto yy54;
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1202;
	goto yy54;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1203;
	goto yy54;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1204;
	if (yych <= '6') goto yy1205;
	goto yy54;
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '5') goto yy1206;
	if (yych <= '6') goto yy1207;
	if (yych <= '9') goto yy1192;
	goto yy54;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1208;
	goto yy54;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1208;
	goto yy54;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1190;
	if (yych <= '9') goto yy1209;
	goto yy1190;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1209;
	goto yy1190;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1210;
	if (yych == ' ') goto yy1210;
	goto yy54;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1212;
	goto yy1190;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1211, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy54;
			goto yy1210;
		} else {
			if (yych == ' ') goto yy1210;
			goto yy54;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy54;
			goto yy1213;
		} else {
			if (yych == 'G') goto yy1214;
			goto yy54;
		}
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '9') goto yy1215;
	goto yy54;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1217;
	if (yych <= '2') goto yy1219;
	if (yych <= '9') goto yy1220;
	goto yy54;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1221;
	goto yy54;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yyaccept = 33;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1216, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1222;
		if (yych <= ',') goto yy1190;
		goto yy1222;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy1190;
			goto yy1215;
		} else {
			if (yych == 'G') goto yy1223;
			goto yy1190;
		}
	}
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1218;
	if (yych <= '9') goto yy1220;
	if (yych <= ':') goto yy1224;
yy1218:
	YYDEBUG(1218, *YYCURSOR);
#line 1461 "real_world/parse_date_1_78.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 20077 "real_world/parse_date_1_78.c"
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1218;
		if (yych >= '5') goto yy1225;
	} else {
		if (yych <= '9') goto yy1226;
		if (yych <= ':') goto yy1224;
		goto yy1218;
	}
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1218;
	if (yych <= '5') goto yy1225;
	if (yych <= '9') goto yy1226;
	if (yych <= ':') goto yy1224;
	goto yy1218;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1227;
	goto yy54;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy54;
	if (yych <= '1') goto yy1228;
	if (yych <= '2') goto yy1229;
	if (yych <= '9') goto yy1230;
	goto yy54;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1231;
	goto yy54;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1218;
	if (yych <= '5') goto yy1225;
	if (yych <= '9') goto yy1226;
	goto yy1218;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1218;
	if (yych >= ':') goto yy1218;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	++YYCURSOR;
	goto yy1218;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1213;
	if (yych == '-') goto yy1213;
	goto yy54;
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1190;
	if (yych <= '9') goto yy1230;
	if (yych <= ':') goto yy1232;
	goto yy1190;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1190;
		if (yych >= '5') goto yy1189;
	} else {
		if (yych <= '9') goto yy1192;
		if (yych <= ':') goto yy1232;
		goto yy1190;
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1190;
	if (yych <= '5') goto yy1189;
	if (yych <= '9') goto yy1192;
	if (yych <= ':') goto yy1232;
	goto yy1190;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1233;
	goto yy54;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1190;
	if (yych <= '5') goto yy1189;
	if (yych <= '9') goto yy1192;
	goto yy1190;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1222;
	if (yych == '-') goto yy1222;
	goto yy54;
}
#line 1680 "real_world/parse_date_1_78.re"

}

#define YYMAXFILL 30


timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}


timelib_time *timelib_parse_from_format(char *format, char *string, int len, timelib_error_container **errors, const timelib_tzdb *tzdb)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'd': // two digit day, with leading zero
			case 'j': // two digit day, without leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': // day suffix, ignored, nor checked
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': // day of year - resets month (0 based)
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
				}
				break;

			case 'm': // two digit month, with leading zero
			case 'n': // two digit month, without leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': // three letter month
			case 'F': // full month
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': // two digit year
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit year could not be found", string, begin);
				}
				TIMELIB_PROCESS_YEAR(s->time->y);
				break;
			case 'Y': // four digit year
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': // two digit hour, with leading zero
			case 'h': // two digit hour, without leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': // two digit hour, with leading zero
			case 'H': // two digit hour, without leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': // am/pm/a.m./p.m.
			case 'A': // AM/PM/A.M./P.M.
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': // two digit minute, with leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->i = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit minute could not be found", string, begin);
				}
				break;
			case 's': // two digit second, with leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->s = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit second could not be found", string, begin);
				}
				break;
			case 'u': // five digit millisecond, with leading zero
				TIMELIB_CHECK_NUMBER;
				if ((s->time->f = timelib_get_nr((char **) &ptr, 5)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A five digit millisecond could not be found", string, begin);
				}
				break;
			case ' ': // any sort of whitespace (' ' and \t)
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': // epoch seconds
				TIMELIB_CHECK_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				break;

			case 'e': // timezone
				{
					int tz_not_found;
					s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': // separation symbol
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': // reset all fields to default
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->tz_info = NULL;
				break; // break intentionally not missing

			case '|': // reset all fields to default when not set
				if (s->time->y == TIMELIB_UNSET ) s->time->y = 1970;
				if (s->time->m == TIMELIB_UNSET ) s->time->m = 1;
				if (s->time->d == TIMELIB_UNSET ) s->time->d = 1;
				if (s->time->h == TIMELIB_UNSET ) s->time->h = 0;
				if (s->time->i == TIMELIB_UNSET ) s->time->i = 0;
				if (s->time->s == TIMELIB_UNSET ) s->time->s = 0;
				if (s->time->f == TIMELIB_UNSET ) s->time->f = 0.0;
				
				break; // break intentionally not missing

			case '?': // random char
				++ptr;
				break;

			case '*': // random chars until a separator or number ([ \t.,:;/-0123456789])
				timelib_eat_until_separator((char **) &ptr);
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		add_pbf_error(s, "Trailing data", string, ptr);
	}
	if (*fptr) {
		add_pbf_error(s, "Data missing", string, ptr);
	}

	// clean up a bit
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}


	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
