% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jupyter.R
\name{convert_ipynb}
\alias{convert_ipynb}
\title{Convert a Jupyter/IPython notebook to an R Markdown document}
\usage{
convert_ipynb(input, output = xfun::with_ext(input, "Rmd"))
}
\arguments{
\item{input}{Path to the input \file{.ipynb} file.}

\item{output}{The output file path.}
}
\value{
The output file path (invisibly).
}
\description{
Read a Jupyter/IPython notebook file (\file{.ipynb}) via
\code{jsonlite::fromJSON()}, convert its code cells to R Markdown code
chunks, preserve Markdown cells, and write out the results to an Rmd file.
}
\details{
This simple converter may have some rough edges, depending on how many
IPython-specific features are used in a notebook. For example, line magics
are not automatically converted (warnings will be issued if line magics are
detected), but you may consider using or writing R functions to replace them
in R Markdown (e.g., the \command{\%load} magic may be replaced by
\code{reticulate::source_python()}). Cell magics will be converted to code
chunks with the (\pkg{knitr}) language engine names being the magic names.
For example, the cell magic \command{\%\%js} is converted to \verb{```{js}}
in R Markdown. This does not always work because not all IPython cell magics
have their counterparts in \pkg{knitr}'s language engines, but common cell
magics like \command{\%\%bash}, \command{\%\%sh}, \command{\%\%js},
\command{\%\%perl}, \command{\%\%python}, and \command{\%\%ruby} should work.
}
\examples{
# this is not a real ipynb file, but illustrates what convert_ipynb() does
nb_data <- list(
  cells = list(
    list(cell_type = 'markdown', source = 'Hi **Markdown**!'),
    list(cell_type = 'code', source = 'print("Hi R Markdown!")')
  ),
  metadata = list(
    kernelspec = list(language = 'python')
  )
)
nb_file = tempfile(fileext = '.ipynb')
jsonlite::write_json(nb_data, nb_file, auto_unbox = TRUE, pretty = TRUE)
xfun::file_string(nb_file)  # show file content

# convert to R Markdown
nb_rmd = rmarkdown:::convert_ipynb(nb_file)
xfun::file_string(nb_rmd)
}
