% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_CI.R
\name{add_ci}
\alias{add_ci}
\alias{add_boxplot}
\title{Draw Confidences Intervals on Phylogenies}
\usage{
add_ci(tree, trees, col95 = "#FF00004D", col50 = "#0000FF4D",
  height = 0.7, legend = TRUE, ...)

add_boxplot(tree, trees, ...)
}
\arguments{
\item{tree}{a phylogenetic tree to which the confidences should be added.}

\item{trees}{phylogenetic trees, i.e. an object of class `multiPhylo`}

\item{col95}{colour used for the 95% intervals; by default: transparent
red.}

\item{col50}{colour used for the 50% intervals; by default: transparent
blue.}

\item{height}{the height of the boxes.}

\item{legend}{a logical value.}

\item{\dots}{arguments passed to other functions, \code{\link{legend}} or
\code{\link{bxp}}.}
}
\description{
These are low-level plotting commands to draw the confidence
intervals on the node of a tree as rectangles with coloured backgrounds or
add boxplots to ultrametric or tipdated trees.
}
\details{
All trees should to be rooted, either ultrametric or tip dated.
}
\examples{
data("Laurasiatherian")
dm <- dist.hamming(Laurasiatherian)
tree <- upgma(dm)
set.seed(123)
trees <- bootstrap.phyDat(Laurasiatherian,
                          FUN=function(x)upgma(dist.hamming(x)), bs=100)
                          tree <- plotBS(tree, trees, "phylogram")
tree <- plotBS(tree, trees, "phylogram")
add_ci(tree, trees)
plot(tree, direction="downwards")
add_boxplot(tree, trees, boxwex=.7)
}
\seealso{
\code{\link{plot.phylo}}, \code{\link{plotBS}}
}
\author{
Emmanuel Paradis, Santiago Claramunt, Joseph Brown, Klaus Schliep
}
\keyword{aplot}
