% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{degCheckFactors}
\alias{degCheckFactors}
\title{Distribution of gene ratios used to calculate Size Factors.}
\usage{
degCheckFactors(counts, each = FALSE)
}
\arguments{
\item{counts}{Matrix with counts for each samples and each gene.
row number should be the same length than pvalues vector.}

\item{each}{Plot each sample separately.}
}
\value{
ggplot2 object
}
\description{
This function check the median ratio normalization used by
DESeq2 and similarly by edgeR to visualy check whether
the median is the best size factor to represent depth.
}
\details{
This function will plot the gene ratios for each sample. To calculate
the ratios, it follows the simliar logic than DESeq2/edgeR uses, where the expression
of each gene is divided by the mean expression of that gene. The distribution
of the ratios should approximate to a normal shape and the factors should be similar
to the median of distributions. If some samples show different distribution,
the factor may be bias due to some biological or technical factor.
}
\examples{
data(humanGender)
library(SummarizedExperiment)
degCheckFactors(assays(humanGender)[[1]][, 1:10])
}
\references{
\itemize{
\item Code to calculate size factors comes from
\code{\link[DESeq2:estimateSizeFactorsForMatrix]{DESeq2::estimateSizeFactorsForMatrix()}}.
}
}
