# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameAvailabilityParameters(_serialization.Model):
    """Parameters body to pass for resource name availability check.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Resource name. Required.
    :vartype name: str
    :ivar type: Resource type. The only legal value of this property for checking redis cache name
     availability is 'Microsoft.Cache/redis'. Required.
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: str, **kwargs):
        """
        :keyword name: Resource name. Required.
        :paramtype name: str
        :keyword type: Resource type. The only legal value of this property for checking redis cache
         name availability is 'Microsoft.Cache/redis'. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.redis.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.redis.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorDetailAutoGenerated(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.redis.models.ErrorDetailAutoGenerated]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.redis.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.redis.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.redis.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExportRDBParameters(_serialization.Model):
    """Parameters for Redis export operation.

    All required parameters must be populated in order to send to Azure.

    :ivar format: File format.
    :vartype format: str
    :ivar prefix: Prefix to use for exported files. Required.
    :vartype prefix: str
    :ivar container: Container name to export to. Required.
    :vartype container: str
    :ivar preferred_data_archive_auth_method: Preferred auth method to communicate to storage
     account used for data archive, specify SAS or ManagedIdentity, default value is SAS.
    :vartype preferred_data_archive_auth_method: str
    """

    _validation = {
        "prefix": {"required": True},
        "container": {"required": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "prefix": {"key": "prefix", "type": "str"},
        "container": {"key": "container", "type": "str"},
        "preferred_data_archive_auth_method": {"key": "preferred-data-archive-auth-method", "type": "str"},
    }

    def __init__(
        self,
        *,
        prefix: str,
        container: str,
        format: Optional[str] = None,
        preferred_data_archive_auth_method: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword format: File format.
        :paramtype format: str
        :keyword prefix: Prefix to use for exported files. Required.
        :paramtype prefix: str
        :keyword container: Container name to export to. Required.
        :paramtype container: str
        :keyword preferred_data_archive_auth_method: Preferred auth method to communicate to storage
         account used for data archive, specify SAS or ManagedIdentity, default value is SAS.
        :paramtype preferred_data_archive_auth_method: str
        """
        super().__init__(**kwargs)
        self.format = format
        self.prefix = prefix
        self.container = container
        self.preferred_data_archive_auth_method = preferred_data_archive_auth_method


class ImportRDBParameters(_serialization.Model):
    """Parameters for Redis import operation.

    All required parameters must be populated in order to send to Azure.

    :ivar format: File format.
    :vartype format: str
    :ivar files: files to import. Required.
    :vartype files: list[str]
    :ivar preferred_data_archive_auth_method: Preferred auth method to communicate to storage
     account used for data archive, specify SAS or ManagedIdentity, default value is SAS.
    :vartype preferred_data_archive_auth_method: str
    """

    _validation = {
        "files": {"required": True},
    }

    _attribute_map = {
        "format": {"key": "format", "type": "str"},
        "files": {"key": "files", "type": "[str]"},
        "preferred_data_archive_auth_method": {"key": "preferred-data-archive-auth-method", "type": "str"},
    }

    def __init__(
        self,
        *,
        files: List[str],
        format: Optional[str] = None,
        preferred_data_archive_auth_method: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword format: File format.
        :paramtype format: str
        :keyword files: files to import. Required.
        :paramtype files: list[str]
        :keyword preferred_data_archive_auth_method: Preferred auth method to communicate to storage
         account used for data archive, specify SAS or ManagedIdentity, default value is SAS.
        :paramtype preferred_data_archive_auth_method: str
        """
        super().__init__(**kwargs)
        self.format = format
        self.files = files
        self.preferred_data_archive_auth_method = preferred_data_archive_auth_method


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.redis.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.redis.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.redis.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.redis.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NotificationListResponse(_serialization.Model):
    """The response of listUpgradeNotifications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of all notifications.
    :vartype value: list[~azure.mgmt.redis.models.UpgradeNotification]
    :ivar next_link: Link for next set of notifications.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[UpgradeNotification]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.UpgradeNotification"]] = None, **kwargs):
        """
        :keyword value: List of all notifications.
        :paramtype value: list[~azure.mgmt.redis.models.UpgradeNotification]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Operation(_serialization.Model):
    """REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that describes the operation.
    :vartype display: ~azure.mgmt.redis.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that describes the operation.
        :paramtype display: ~azure.mgmt.redis.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that describes the operation.

    :ivar provider: Friendly name of the resource provider.
    :vartype provider: str
    :ivar operation: Operation type: read, write, delete, listKeys/action, etc.
    :vartype operation: str
    :ivar resource: Resource type on which the operation is performed.
    :vartype resource: str
    :ivar description: Friendly name of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        resource: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Friendly name of the resource provider.
        :paramtype provider: str
        :keyword operation: Operation type: read, write, delete, listKeys/action, etc.
        :paramtype operation: str
        :keyword resource: Resource type on which the operation is performed.
        :paramtype resource: str
        :keyword description: Friendly name of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.redis.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: List of operations supported by the resource provider.
        :paramtype value: list[~azure.mgmt.redis.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.redis.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.redis.models.ErrorDetailAutoGenerated
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetailAutoGenerated"] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.redis.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.redis.models.ErrorDetailAutoGenerated
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class OperationStatus(OperationStatusResult):
    """Asynchronous operation status.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.redis.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.redis.models.ErrorDetailAutoGenerated
    :ivar properties: Additional properties from RP, only when operation is successful.
    :vartype properties: dict[str, any]
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetailAutoGenerated"] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.redis.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.redis.models.ErrorDetailAutoGenerated
        :keyword properties: Additional properties from RP, only when operation is successful.
        :paramtype properties: dict[str, any]
        """
        super().__init__(
            id=id,
            name=name,
            status=status,
            percent_complete=percent_complete,
            start_time=start_time,
            end_time=end_time,
            operations=operations,
            error=error,
            **kwargs
        )
        self.properties = properties


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.redis.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.redis.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.redis.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.redis.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.redis.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.redis.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.redis.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs):
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.redis.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.redis.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.redis.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.redis.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class RedisAccessKeys(_serialization.Model):
    """Redis cache access keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_key: The current primary key that clients can use to authenticate with Redis
     cache.
    :vartype primary_key: str
    :ivar secondary_key: The current secondary key that clients can use to authenticate with Redis
     cache.
    :vartype secondary_key: str
    """

    _validation = {
        "primary_key": {"readonly": True},
        "secondary_key": {"readonly": True},
    }

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.primary_key = None
        self.secondary_key = None


class RedisCommonProperties(_serialization.Model):
    """Create/Update/Get common properties of the redis cache.

    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    """

    _attribute_map = {
        "redis_configuration": {"key": "redisConfiguration", "type": "RedisCommonPropertiesRedisConfiguration"},
        "redis_version": {"key": "redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "tenantSettings", "type": "{str}"},
        "shard_count": {"key": "shardCount", "type": "int"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(
        self,
        *,
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        **kwargs
    ):
        """
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access


class RedisCommonPropertiesRedisConfiguration(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar rdb_backup_enabled: Specifies whether the rdb backup is enabled.
    :vartype rdb_backup_enabled: str
    :ivar rdb_backup_frequency: Specifies the frequency for creating rdb backup in minutes. Valid
     values: (15, 30, 60, 360, 720, 1440).
    :vartype rdb_backup_frequency: str
    :ivar rdb_backup_max_snapshot_count: Specifies the maximum number of snapshots for rdb backup.
    :vartype rdb_backup_max_snapshot_count: str
    :ivar rdb_storage_connection_string: The storage account connection string for storing rdb
     file.
    :vartype rdb_storage_connection_string: str
    :ivar aof_backup_enabled: Specifies whether the aof backup is enabled.
    :vartype aof_backup_enabled: str
    :ivar aof_storage_connection_string0: First storage account connection string.
    :vartype aof_storage_connection_string0: str
    :ivar aof_storage_connection_string1: Second storage account connection string.
    :vartype aof_storage_connection_string1: str
    :ivar maxfragmentationmemory_reserved: Value in megabytes reserved for fragmentation per shard.
    :vartype maxfragmentationmemory_reserved: str
    :ivar maxmemory_policy: The eviction strategy used when your data won't fit within its memory
     limit.
    :vartype maxmemory_policy: str
    :ivar maxmemory_reserved: Value in megabytes reserved for non-cache usage per shard e.g.
     failover.
    :vartype maxmemory_reserved: str
    :ivar maxmemory_delta: Value in megabytes reserved for non-cache usage per shard e.g. failover.
    :vartype maxmemory_delta: str
    :ivar maxclients: The max clients config.
    :vartype maxclients: str
    :ivar preferred_data_archive_auth_method: Preferred auth method to communicate to storage
     account used for data archive, specify SAS or ManagedIdentity, default value is SAS.
    :vartype preferred_data_archive_auth_method: str
    :ivar preferred_data_persistence_auth_method: Preferred auth method to communicate to storage
     account used for data persistence, specify SAS or ManagedIdentity, default value is SAS.
    :vartype preferred_data_persistence_auth_method: str
    :ivar zonal_configuration: Zonal Configuration.
    :vartype zonal_configuration: str
    :ivar authnotrequired: Specifies whether the authentication is disabled. Setting this property
     is highly discouraged from security point of view.
    :vartype authnotrequired: str
    """

    _validation = {
        "maxclients": {"readonly": True},
        "preferred_data_archive_auth_method": {"readonly": True},
        "zonal_configuration": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "rdb_backup_enabled": {"key": "rdb-backup-enabled", "type": "str"},
        "rdb_backup_frequency": {"key": "rdb-backup-frequency", "type": "str"},
        "rdb_backup_max_snapshot_count": {"key": "rdb-backup-max-snapshot-count", "type": "str"},
        "rdb_storage_connection_string": {"key": "rdb-storage-connection-string", "type": "str"},
        "aof_backup_enabled": {"key": "aof-backup-enabled", "type": "str"},
        "aof_storage_connection_string0": {"key": "aof-storage-connection-string-0", "type": "str"},
        "aof_storage_connection_string1": {"key": "aof-storage-connection-string-1", "type": "str"},
        "maxfragmentationmemory_reserved": {"key": "maxfragmentationmemory-reserved", "type": "str"},
        "maxmemory_policy": {"key": "maxmemory-policy", "type": "str"},
        "maxmemory_reserved": {"key": "maxmemory-reserved", "type": "str"},
        "maxmemory_delta": {"key": "maxmemory-delta", "type": "str"},
        "maxclients": {"key": "maxclients", "type": "str"},
        "preferred_data_archive_auth_method": {"key": "preferred-data-archive-auth-method", "type": "str"},
        "preferred_data_persistence_auth_method": {"key": "preferred-data-persistence-auth-method", "type": "str"},
        "zonal_configuration": {"key": "zonal-configuration", "type": "str"},
        "authnotrequired": {"key": "authnotrequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        rdb_backup_enabled: Optional[str] = None,
        rdb_backup_frequency: Optional[str] = None,
        rdb_backup_max_snapshot_count: Optional[str] = None,
        rdb_storage_connection_string: Optional[str] = None,
        aof_backup_enabled: Optional[str] = None,
        aof_storage_connection_string0: Optional[str] = None,
        aof_storage_connection_string1: Optional[str] = None,
        maxfragmentationmemory_reserved: Optional[str] = None,
        maxmemory_policy: Optional[str] = None,
        maxmemory_reserved: Optional[str] = None,
        maxmemory_delta: Optional[str] = None,
        preferred_data_persistence_auth_method: Optional[str] = None,
        authnotrequired: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword rdb_backup_enabled: Specifies whether the rdb backup is enabled.
        :paramtype rdb_backup_enabled: str
        :keyword rdb_backup_frequency: Specifies the frequency for creating rdb backup in minutes.
         Valid values: (15, 30, 60, 360, 720, 1440).
        :paramtype rdb_backup_frequency: str
        :keyword rdb_backup_max_snapshot_count: Specifies the maximum number of snapshots for rdb
         backup.
        :paramtype rdb_backup_max_snapshot_count: str
        :keyword rdb_storage_connection_string: The storage account connection string for storing rdb
         file.
        :paramtype rdb_storage_connection_string: str
        :keyword aof_backup_enabled: Specifies whether the aof backup is enabled.
        :paramtype aof_backup_enabled: str
        :keyword aof_storage_connection_string0: First storage account connection string.
        :paramtype aof_storage_connection_string0: str
        :keyword aof_storage_connection_string1: Second storage account connection string.
        :paramtype aof_storage_connection_string1: str
        :keyword maxfragmentationmemory_reserved: Value in megabytes reserved for fragmentation per
         shard.
        :paramtype maxfragmentationmemory_reserved: str
        :keyword maxmemory_policy: The eviction strategy used when your data won't fit within its
         memory limit.
        :paramtype maxmemory_policy: str
        :keyword maxmemory_reserved: Value in megabytes reserved for non-cache usage per shard e.g.
         failover.
        :paramtype maxmemory_reserved: str
        :keyword maxmemory_delta: Value in megabytes reserved for non-cache usage per shard e.g.
         failover.
        :paramtype maxmemory_delta: str
        :keyword preferred_data_persistence_auth_method: Preferred auth method to communicate to
         storage account used for data persistence, specify SAS or ManagedIdentity, default value is
         SAS.
        :paramtype preferred_data_persistence_auth_method: str
        :keyword authnotrequired: Specifies whether the authentication is disabled. Setting this
         property is highly discouraged from security point of view.
        :paramtype authnotrequired: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.rdb_backup_enabled = rdb_backup_enabled
        self.rdb_backup_frequency = rdb_backup_frequency
        self.rdb_backup_max_snapshot_count = rdb_backup_max_snapshot_count
        self.rdb_storage_connection_string = rdb_storage_connection_string
        self.aof_backup_enabled = aof_backup_enabled
        self.aof_storage_connection_string0 = aof_storage_connection_string0
        self.aof_storage_connection_string1 = aof_storage_connection_string1
        self.maxfragmentationmemory_reserved = maxfragmentationmemory_reserved
        self.maxmemory_policy = maxmemory_policy
        self.maxmemory_reserved = maxmemory_reserved
        self.maxmemory_delta = maxmemory_delta
        self.maxclients = None
        self.preferred_data_archive_auth_method = None
        self.preferred_data_persistence_auth_method = preferred_data_persistence_auth_method
        self.zonal_configuration = None
        self.authnotrequired = authnotrequired


class RedisCreateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Parameters supplied to the Create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.redis.models.ManagedServiceIdentity
    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    :ivar sku: The SKU of the Redis cache to deploy. Required.
    :vartype sku: ~azure.mgmt.redis.models.Sku
    :ivar subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :vartype subnet_id: str
    :ivar static_ip: Static IP address. Optionally, may be specified when deploying a Redis cache
     inside an existing Azure Virtual Network; auto assigned by default.
    :vartype static_ip: str
    """

    _validation = {
        "location": {"required": True},
        "sku": {"required": True},
        "subnet_id": {
            "pattern": r"^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$"
        },
        "static_ip": {"pattern": r"^\d+\.\d+\.\d+\.\d+$"},
    }

    _attribute_map = {
        "zones": {"key": "zones", "type": "[str]"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "redis_configuration": {
            "key": "properties.redisConfiguration",
            "type": "RedisCommonPropertiesRedisConfiguration",
        },
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "properties.enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "properties.replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "properties.replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "properties.tenantSettings", "type": "{str}"},
        "shard_count": {"key": "properties.shardCount", "type": "int"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "sku": {"key": "properties.sku", "type": "Sku"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "static_ip": {"key": "properties.staticIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        zones: Optional[List[str]] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        subnet_id: Optional[str] = None,
        static_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.redis.models.ManagedServiceIdentity
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        :keyword sku: The SKU of the Redis cache to deploy. Required.
        :paramtype sku: ~azure.mgmt.redis.models.Sku
        :keyword subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
         cache in. Example format:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
        :paramtype subnet_id: str
        :keyword static_ip: Static IP address. Optionally, may be specified when deploying a Redis
         cache inside an existing Azure Virtual Network; auto assigned by default.
        :paramtype static_ip: str
        """
        super().__init__(**kwargs)
        self.zones = zones
        self.location = location
        self.tags = tags
        self.identity = identity
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access
        self.sku = sku
        self.subnet_id = subnet_id
        self.static_ip = static_ip


class RedisCreateProperties(RedisCommonProperties):  # pylint: disable=too-many-instance-attributes
    """Properties supplied to Create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    :ivar sku: The SKU of the Redis cache to deploy. Required.
    :vartype sku: ~azure.mgmt.redis.models.Sku
    :ivar subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :vartype subnet_id: str
    :ivar static_ip: Static IP address. Optionally, may be specified when deploying a Redis cache
     inside an existing Azure Virtual Network; auto assigned by default.
    :vartype static_ip: str
    """

    _validation = {
        "sku": {"required": True},
        "subnet_id": {
            "pattern": r"^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$"
        },
        "static_ip": {"pattern": r"^\d+\.\d+\.\d+\.\d+$"},
    }

    _attribute_map = {
        "redis_configuration": {"key": "redisConfiguration", "type": "RedisCommonPropertiesRedisConfiguration"},
        "redis_version": {"key": "redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "tenantSettings", "type": "{str}"},
        "shard_count": {"key": "shardCount", "type": "int"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "static_ip": {"key": "staticIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        subnet_id: Optional[str] = None,
        static_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        :keyword sku: The SKU of the Redis cache to deploy. Required.
        :paramtype sku: ~azure.mgmt.redis.models.Sku
        :keyword subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
         cache in. Example format:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
        :paramtype subnet_id: str
        :keyword static_ip: Static IP address. Optionally, may be specified when deploying a Redis
         cache inside an existing Azure Virtual Network; auto assigned by default.
        :paramtype static_ip: str
        """
        super().__init__(
            redis_configuration=redis_configuration,
            redis_version=redis_version,
            enable_non_ssl_port=enable_non_ssl_port,
            replicas_per_master=replicas_per_master,
            replicas_per_primary=replicas_per_primary,
            tenant_settings=tenant_settings,
            shard_count=shard_count,
            minimum_tls_version=minimum_tls_version,
            public_network_access=public_network_access,
            **kwargs
        )
        self.sku = sku
        self.subnet_id = subnet_id
        self.static_ip = static_ip


class RedisFirewallRule(ProxyResource):
    """A firewall rule on a redis cache has a name, and describes a contiguous range of IP addresses permitted to connect.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar start_ip: lowest IP address included in the range. Required.
    :vartype start_ip: str
    :ivar end_ip: highest IP address included in the range. Required.
    :vartype end_ip: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "start_ip": {"required": True},
        "end_ip": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_ip": {"key": "properties.startIP", "type": "str"},
        "end_ip": {"key": "properties.endIP", "type": "str"},
    }

    def __init__(self, *, start_ip: str, end_ip: str, **kwargs):
        """
        :keyword start_ip: lowest IP address included in the range. Required.
        :paramtype start_ip: str
        :keyword end_ip: highest IP address included in the range. Required.
        :paramtype end_ip: str
        """
        super().__init__(**kwargs)
        self.start_ip = start_ip
        self.end_ip = end_ip


class RedisFirewallRuleCreateParameters(RedisFirewallRule):
    """Parameters required for creating a firewall rule on redis cache. (Note, you can just use the FirewallRule type instead now.).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar start_ip: lowest IP address included in the range. Required.
    :vartype start_ip: str
    :ivar end_ip: highest IP address included in the range. Required.
    :vartype end_ip: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "start_ip": {"required": True},
        "end_ip": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_ip": {"key": "properties.startIP", "type": "str"},
        "end_ip": {"key": "properties.endIP", "type": "str"},
    }

    def __init__(self, *, start_ip: str, end_ip: str, **kwargs):
        """
        :keyword start_ip: lowest IP address included in the range. Required.
        :paramtype start_ip: str
        :keyword end_ip: highest IP address included in the range. Required.
        :paramtype end_ip: str
        """
        super().__init__(start_ip=start_ip, end_ip=end_ip, **kwargs)


class RedisFirewallRuleListResult(_serialization.Model):
    """The response of list firewall rules Redis operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Results of the list firewall rules operation.
    :vartype value: list[~azure.mgmt.redis.models.RedisFirewallRule]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RedisFirewallRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RedisFirewallRule"]] = None, **kwargs):
        """
        :keyword value: Results of the list firewall rules operation.
        :paramtype value: list[~azure.mgmt.redis.models.RedisFirewallRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RedisForceRebootResponse(_serialization.Model):
    """Response to force reboot for Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Status message.
    :vartype message: str
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.message = None


class RedisInstanceDetails(_serialization.Model):
    """Details of single instance of redis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ssl_port: Redis instance SSL port.
    :vartype ssl_port: int
    :ivar non_ssl_port: If enableNonSslPort is true, provides Redis instance Non-SSL port.
    :vartype non_ssl_port: int
    :ivar zone: If the Cache uses availability zones, specifies availability zone where this
     instance is located.
    :vartype zone: str
    :ivar shard_id: If clustering is enabled, the Shard ID of Redis Instance.
    :vartype shard_id: int
    :ivar is_master: Specifies whether the instance is a primary node.
    :vartype is_master: bool
    :ivar is_primary: Specifies whether the instance is a primary node.
    :vartype is_primary: bool
    """

    _validation = {
        "ssl_port": {"readonly": True},
        "non_ssl_port": {"readonly": True},
        "zone": {"readonly": True},
        "shard_id": {"readonly": True},
        "is_master": {"readonly": True},
        "is_primary": {"readonly": True},
    }

    _attribute_map = {
        "ssl_port": {"key": "sslPort", "type": "int"},
        "non_ssl_port": {"key": "nonSslPort", "type": "int"},
        "zone": {"key": "zone", "type": "str"},
        "shard_id": {"key": "shardId", "type": "int"},
        "is_master": {"key": "isMaster", "type": "bool"},
        "is_primary": {"key": "isPrimary", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.ssl_port = None
        self.non_ssl_port = None
        self.zone = None
        self.shard_id = None
        self.is_master = None
        self.is_primary = None


class RedisLinkedServer(_serialization.Model):
    """Linked server Id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Linked server Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class RedisLinkedServerCreateParameters(_serialization.Model):
    """Parameter required for creating a linked server to redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar linked_redis_cache_id: Fully qualified resourceId of the linked redis cache. Required.
    :vartype linked_redis_cache_id: str
    :ivar linked_redis_cache_location: Location of the linked redis cache. Required.
    :vartype linked_redis_cache_location: str
    :ivar server_role: Role of the linked server. Required. Known values are: "Primary" and
     "Secondary".
    :vartype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar geo_replicated_primary_host_name: The unchanging DNS name which will always point to
     current geo-primary cache among the linked redis caches for seamless Geo Failover experience.
    :vartype geo_replicated_primary_host_name: str
    :ivar primary_host_name: The changing DNS name that resolves to the current geo-primary cache
     among the linked redis caches before or after the Geo Failover.
    :vartype primary_host_name: str
    """

    _validation = {
        "linked_redis_cache_id": {"required": True},
        "linked_redis_cache_location": {"required": True},
        "server_role": {"required": True},
        "geo_replicated_primary_host_name": {"readonly": True},
        "primary_host_name": {"readonly": True},
    }

    _attribute_map = {
        "linked_redis_cache_id": {"key": "properties.linkedRedisCacheId", "type": "str"},
        "linked_redis_cache_location": {"key": "properties.linkedRedisCacheLocation", "type": "str"},
        "server_role": {"key": "properties.serverRole", "type": "str"},
        "geo_replicated_primary_host_name": {"key": "properties.geoReplicatedPrimaryHostName", "type": "str"},
        "primary_host_name": {"key": "properties.primaryHostName", "type": "str"},
    }

    def __init__(
        self,
        *,
        linked_redis_cache_id: str,
        linked_redis_cache_location: str,
        server_role: Union[str, "_models.ReplicationRole"],
        **kwargs
    ):
        """
        :keyword linked_redis_cache_id: Fully qualified resourceId of the linked redis cache. Required.
        :paramtype linked_redis_cache_id: str
        :keyword linked_redis_cache_location: Location of the linked redis cache. Required.
        :paramtype linked_redis_cache_location: str
        :keyword server_role: Role of the linked server. Required. Known values are: "Primary" and
         "Secondary".
        :paramtype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
        """
        super().__init__(**kwargs)
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role
        self.geo_replicated_primary_host_name = None
        self.primary_host_name = None


class RedisLinkedServerCreateProperties(_serialization.Model):
    """Create properties for a linked server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar linked_redis_cache_id: Fully qualified resourceId of the linked redis cache. Required.
    :vartype linked_redis_cache_id: str
    :ivar linked_redis_cache_location: Location of the linked redis cache. Required.
    :vartype linked_redis_cache_location: str
    :ivar server_role: Role of the linked server. Required. Known values are: "Primary" and
     "Secondary".
    :vartype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar geo_replicated_primary_host_name: The unchanging DNS name which will always point to
     current geo-primary cache among the linked redis caches for seamless Geo Failover experience.
    :vartype geo_replicated_primary_host_name: str
    :ivar primary_host_name: The changing DNS name that resolves to the current geo-primary cache
     among the linked redis caches before or after the Geo Failover.
    :vartype primary_host_name: str
    """

    _validation = {
        "linked_redis_cache_id": {"required": True},
        "linked_redis_cache_location": {"required": True},
        "server_role": {"required": True},
        "geo_replicated_primary_host_name": {"readonly": True},
        "primary_host_name": {"readonly": True},
    }

    _attribute_map = {
        "linked_redis_cache_id": {"key": "linkedRedisCacheId", "type": "str"},
        "linked_redis_cache_location": {"key": "linkedRedisCacheLocation", "type": "str"},
        "server_role": {"key": "serverRole", "type": "str"},
        "geo_replicated_primary_host_name": {"key": "geoReplicatedPrimaryHostName", "type": "str"},
        "primary_host_name": {"key": "primaryHostName", "type": "str"},
    }

    def __init__(
        self,
        *,
        linked_redis_cache_id: str,
        linked_redis_cache_location: str,
        server_role: Union[str, "_models.ReplicationRole"],
        **kwargs
    ):
        """
        :keyword linked_redis_cache_id: Fully qualified resourceId of the linked redis cache. Required.
        :paramtype linked_redis_cache_id: str
        :keyword linked_redis_cache_location: Location of the linked redis cache. Required.
        :paramtype linked_redis_cache_location: str
        :keyword server_role: Role of the linked server. Required. Known values are: "Primary" and
         "Secondary".
        :paramtype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
        """
        super().__init__(**kwargs)
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role
        self.geo_replicated_primary_host_name = None
        self.primary_host_name = None


class RedisLinkedServerProperties(RedisLinkedServerCreateProperties):
    """Properties of a linked server to be returned in get/put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar linked_redis_cache_id: Fully qualified resourceId of the linked redis cache. Required.
    :vartype linked_redis_cache_id: str
    :ivar linked_redis_cache_location: Location of the linked redis cache. Required.
    :vartype linked_redis_cache_location: str
    :ivar server_role: Role of the linked server. Required. Known values are: "Primary" and
     "Secondary".
    :vartype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar geo_replicated_primary_host_name: The unchanging DNS name which will always point to
     current geo-primary cache among the linked redis caches for seamless Geo Failover experience.
    :vartype geo_replicated_primary_host_name: str
    :ivar primary_host_name: The changing DNS name that resolves to the current geo-primary cache
     among the linked redis caches before or after the Geo Failover.
    :vartype primary_host_name: str
    :ivar provisioning_state: Terminal state of the link between primary and secondary redis cache.
    :vartype provisioning_state: str
    """

    _validation = {
        "linked_redis_cache_id": {"required": True},
        "linked_redis_cache_location": {"required": True},
        "server_role": {"required": True},
        "geo_replicated_primary_host_name": {"readonly": True},
        "primary_host_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "linked_redis_cache_id": {"key": "linkedRedisCacheId", "type": "str"},
        "linked_redis_cache_location": {"key": "linkedRedisCacheLocation", "type": "str"},
        "server_role": {"key": "serverRole", "type": "str"},
        "geo_replicated_primary_host_name": {"key": "geoReplicatedPrimaryHostName", "type": "str"},
        "primary_host_name": {"key": "primaryHostName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        linked_redis_cache_id: str,
        linked_redis_cache_location: str,
        server_role: Union[str, "_models.ReplicationRole"],
        **kwargs
    ):
        """
        :keyword linked_redis_cache_id: Fully qualified resourceId of the linked redis cache. Required.
        :paramtype linked_redis_cache_id: str
        :keyword linked_redis_cache_location: Location of the linked redis cache. Required.
        :paramtype linked_redis_cache_location: str
        :keyword server_role: Role of the linked server. Required. Known values are: "Primary" and
         "Secondary".
        :paramtype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
        """
        super().__init__(
            linked_redis_cache_id=linked_redis_cache_id,
            linked_redis_cache_location=linked_redis_cache_location,
            server_role=server_role,
            **kwargs
        )
        self.provisioning_state = None


class RedisLinkedServerWithProperties(ProxyResource):
    """Response to put/get linked server (with properties) for Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar linked_redis_cache_id: Fully qualified resourceId of the linked redis cache.
    :vartype linked_redis_cache_id: str
    :ivar linked_redis_cache_location: Location of the linked redis cache.
    :vartype linked_redis_cache_location: str
    :ivar server_role: Role of the linked server. Known values are: "Primary" and "Secondary".
    :vartype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar geo_replicated_primary_host_name: The unchanging DNS name which will always point to
     current geo-primary cache among the linked redis caches for seamless Geo Failover experience.
    :vartype geo_replicated_primary_host_name: str
    :ivar primary_host_name: The changing DNS name that resolves to the current geo-primary cache
     among the linked redis caches before or after the Geo Failover.
    :vartype primary_host_name: str
    :ivar provisioning_state: Terminal state of the link between primary and secondary redis cache.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "geo_replicated_primary_host_name": {"readonly": True},
        "primary_host_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "linked_redis_cache_id": {"key": "properties.linkedRedisCacheId", "type": "str"},
        "linked_redis_cache_location": {"key": "properties.linkedRedisCacheLocation", "type": "str"},
        "server_role": {"key": "properties.serverRole", "type": "str"},
        "geo_replicated_primary_host_name": {"key": "properties.geoReplicatedPrimaryHostName", "type": "str"},
        "primary_host_name": {"key": "properties.primaryHostName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        linked_redis_cache_id: Optional[str] = None,
        linked_redis_cache_location: Optional[str] = None,
        server_role: Optional[Union[str, "_models.ReplicationRole"]] = None,
        **kwargs
    ):
        """
        :keyword linked_redis_cache_id: Fully qualified resourceId of the linked redis cache.
        :paramtype linked_redis_cache_id: str
        :keyword linked_redis_cache_location: Location of the linked redis cache.
        :paramtype linked_redis_cache_location: str
        :keyword server_role: Role of the linked server. Known values are: "Primary" and "Secondary".
        :paramtype server_role: str or ~azure.mgmt.redis.models.ReplicationRole
        """
        super().__init__(**kwargs)
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role
        self.geo_replicated_primary_host_name = None
        self.primary_host_name = None
        self.provisioning_state = None


class RedisLinkedServerWithPropertiesList(_serialization.Model):
    """List of linked servers (with properties) of a Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of linked servers (with properties) of a Redis cache.
    :vartype value: list[~azure.mgmt.redis.models.RedisLinkedServerWithProperties]
    :ivar next_link: Link for next set.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RedisLinkedServerWithProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RedisLinkedServerWithProperties"]] = None, **kwargs):
        """
        :keyword value: List of linked servers (with properties) of a Redis cache.
        :paramtype value: list[~azure.mgmt.redis.models.RedisLinkedServerWithProperties]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RedisListResult(_serialization.Model):
    """The response of list Redis operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Redis cache instances.
    :vartype value: list[~azure.mgmt.redis.models.RedisResource]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RedisResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RedisResource"]] = None, **kwargs):
        """
        :keyword value: List of Redis cache instances.
        :paramtype value: list[~azure.mgmt.redis.models.RedisResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RedisPatchSchedule(ProxyResource):
    """Response to put/get patch schedules for Redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar schedule_entries: List of patch schedules for a Redis cache. Required.
    :vartype schedule_entries: list[~azure.mgmt.redis.models.ScheduleEntry]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "schedule_entries": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "schedule_entries": {"key": "properties.scheduleEntries", "type": "[ScheduleEntry]"},
    }

    def __init__(self, *, schedule_entries: List["_models.ScheduleEntry"], **kwargs):
        """
        :keyword schedule_entries: List of patch schedules for a Redis cache. Required.
        :paramtype schedule_entries: list[~azure.mgmt.redis.models.ScheduleEntry]
        """
        super().__init__(**kwargs)
        self.location = None
        self.schedule_entries = schedule_entries


class RedisPatchScheduleListResult(_serialization.Model):
    """The response of list patch schedules Redis operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Results of the list patch schedules operation.
    :vartype value: list[~azure.mgmt.redis.models.RedisPatchSchedule]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RedisPatchSchedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.RedisPatchSchedule"]] = None, **kwargs):
        """
        :keyword value: Results of the list patch schedules operation.
        :paramtype value: list[~azure.mgmt.redis.models.RedisPatchSchedule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class RedisProperties(RedisCreateProperties):  # pylint: disable=too-many-instance-attributes
    """Properties of the redis cache.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    :ivar sku: The SKU of the Redis cache to deploy. Required.
    :vartype sku: ~azure.mgmt.redis.models.Sku
    :ivar subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :vartype subnet_id: str
    :ivar static_ip: Static IP address. Optionally, may be specified when deploying a Redis cache
     inside an existing Azure Virtual Network; auto assigned by default.
    :vartype static_ip: str
    :ivar provisioning_state: Redis instance provisioning status. Known values are: "Creating",
     "Deleting", "Disabled", "Failed", "Linking", "Provisioning", "RecoveringScaleFailure",
     "Scaling", "Succeeded", "Unlinking", "Unprovisioning", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.redis.models.ProvisioningState
    :ivar host_name: Redis host name.
    :vartype host_name: str
    :ivar port: Redis non-SSL port.
    :vartype port: int
    :ivar ssl_port: Redis SSL port.
    :vartype ssl_port: int
    :ivar access_keys: The keys of the Redis cache - not set if this object is not the response to
     Create or Update redis cache.
    :vartype access_keys: ~azure.mgmt.redis.models.RedisAccessKeys
    :ivar linked_servers: List of the linked servers associated with the cache.
    :vartype linked_servers: list[~azure.mgmt.redis.models.RedisLinkedServer]
    :ivar instances: List of the Redis instances associated with the cache.
    :vartype instances: list[~azure.mgmt.redis.models.RedisInstanceDetails]
    :ivar private_endpoint_connections: List of private endpoint connection associated with the
     specified redis cache.
    :vartype private_endpoint_connections: list[~azure.mgmt.redis.models.PrivateEndpointConnection]
    """

    _validation = {
        "sku": {"required": True},
        "subnet_id": {
            "pattern": r"^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$"
        },
        "static_ip": {"pattern": r"^\d+\.\d+\.\d+\.\d+$"},
        "provisioning_state": {"readonly": True},
        "host_name": {"readonly": True},
        "port": {"readonly": True},
        "ssl_port": {"readonly": True},
        "access_keys": {"readonly": True},
        "linked_servers": {"readonly": True},
        "instances": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "redis_configuration": {"key": "redisConfiguration", "type": "RedisCommonPropertiesRedisConfiguration"},
        "redis_version": {"key": "redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "tenantSettings", "type": "{str}"},
        "shard_count": {"key": "shardCount", "type": "int"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "static_ip": {"key": "staticIP", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "ssl_port": {"key": "sslPort", "type": "int"},
        "access_keys": {"key": "accessKeys", "type": "RedisAccessKeys"},
        "linked_servers": {"key": "linkedServers", "type": "[RedisLinkedServer]"},
        "instances": {"key": "instances", "type": "[RedisInstanceDetails]"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(
        self,
        *,
        sku: "_models.Sku",
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        subnet_id: Optional[str] = None,
        static_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        :keyword sku: The SKU of the Redis cache to deploy. Required.
        :paramtype sku: ~azure.mgmt.redis.models.Sku
        :keyword subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
         cache in. Example format:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
        :paramtype subnet_id: str
        :keyword static_ip: Static IP address. Optionally, may be specified when deploying a Redis
         cache inside an existing Azure Virtual Network; auto assigned by default.
        :paramtype static_ip: str
        """
        super().__init__(
            redis_configuration=redis_configuration,
            redis_version=redis_version,
            enable_non_ssl_port=enable_non_ssl_port,
            replicas_per_master=replicas_per_master,
            replicas_per_primary=replicas_per_primary,
            tenant_settings=tenant_settings,
            shard_count=shard_count,
            minimum_tls_version=minimum_tls_version,
            public_network_access=public_network_access,
            sku=sku,
            subnet_id=subnet_id,
            static_ip=static_ip,
            **kwargs
        )
        self.provisioning_state = None
        self.host_name = None
        self.port = None
        self.ssl_port = None
        self.access_keys = None
        self.linked_servers = None
        self.instances = None
        self.private_endpoint_connections = None


class RedisRebootParameters(_serialization.Model):
    """Specifies which Redis node(s) to reboot.

    :ivar reboot_type: Which Redis node(s) to reboot. Depending on this value data loss is
     possible. Known values are: "PrimaryNode", "SecondaryNode", and "AllNodes".
    :vartype reboot_type: str or ~azure.mgmt.redis.models.RebootType
    :ivar shard_id: If clustering is enabled, the ID of the shard to be rebooted.
    :vartype shard_id: int
    :ivar ports: A list of redis instances to reboot, specified by per-instance SSL ports or
     non-SSL ports.
    :vartype ports: list[int]
    """

    _attribute_map = {
        "reboot_type": {"key": "rebootType", "type": "str"},
        "shard_id": {"key": "shardId", "type": "int"},
        "ports": {"key": "ports", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        reboot_type: Optional[Union[str, "_models.RebootType"]] = None,
        shard_id: Optional[int] = None,
        ports: Optional[List[int]] = None,
        **kwargs
    ):
        """
        :keyword reboot_type: Which Redis node(s) to reboot. Depending on this value data loss is
         possible. Known values are: "PrimaryNode", "SecondaryNode", and "AllNodes".
        :paramtype reboot_type: str or ~azure.mgmt.redis.models.RebootType
        :keyword shard_id: If clustering is enabled, the ID of the shard to be rebooted.
        :paramtype shard_id: int
        :keyword ports: A list of redis instances to reboot, specified by per-instance SSL ports or
         non-SSL ports.
        :paramtype ports: list[int]
        """
        super().__init__(**kwargs)
        self.reboot_type = reboot_type
        self.shard_id = shard_id
        self.ports = ports


class RedisRegenerateKeyParameters(_serialization.Model):
    """Specifies which Redis access keys to reset.

    All required parameters must be populated in order to send to Azure.

    :ivar key_type: The Redis access key to regenerate. Required. Known values are: "Primary" and
     "Secondary".
    :vartype key_type: str or ~azure.mgmt.redis.models.RedisKeyType
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.RedisKeyType"], **kwargs):
        """
        :keyword key_type: The Redis access key to regenerate. Required. Known values are: "Primary"
         and "Secondary".
        :paramtype key_type: str or ~azure.mgmt.redis.models.RedisKeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class RedisResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A single Redis item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar zones: A list of availability zones denoting where the resource needs to come from.
    :vartype zones: list[str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.redis.models.ManagedServiceIdentity
    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    :ivar sku: The SKU of the Redis cache to deploy. Required.
    :vartype sku: ~azure.mgmt.redis.models.Sku
    :ivar subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
     cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
    :vartype subnet_id: str
    :ivar static_ip: Static IP address. Optionally, may be specified when deploying a Redis cache
     inside an existing Azure Virtual Network; auto assigned by default.
    :vartype static_ip: str
    :ivar provisioning_state: Redis instance provisioning status. Known values are: "Creating",
     "Deleting", "Disabled", "Failed", "Linking", "Provisioning", "RecoveringScaleFailure",
     "Scaling", "Succeeded", "Unlinking", "Unprovisioning", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.redis.models.ProvisioningState
    :ivar host_name: Redis host name.
    :vartype host_name: str
    :ivar port: Redis non-SSL port.
    :vartype port: int
    :ivar ssl_port: Redis SSL port.
    :vartype ssl_port: int
    :ivar access_keys: The keys of the Redis cache - not set if this object is not the response to
     Create or Update redis cache.
    :vartype access_keys: ~azure.mgmt.redis.models.RedisAccessKeys
    :ivar linked_servers: List of the linked servers associated with the cache.
    :vartype linked_servers: list[~azure.mgmt.redis.models.RedisLinkedServer]
    :ivar instances: List of the Redis instances associated with the cache.
    :vartype instances: list[~azure.mgmt.redis.models.RedisInstanceDetails]
    :ivar private_endpoint_connections: List of private endpoint connection associated with the
     specified redis cache.
    :vartype private_endpoint_connections: list[~azure.mgmt.redis.models.PrivateEndpointConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "subnet_id": {
            "pattern": r"^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$"
        },
        "static_ip": {"pattern": r"^\d+\.\d+\.\d+\.\d+$"},
        "provisioning_state": {"readonly": True},
        "host_name": {"readonly": True},
        "port": {"readonly": True},
        "ssl_port": {"readonly": True},
        "access_keys": {"readonly": True},
        "linked_servers": {"readonly": True},
        "instances": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "redis_configuration": {
            "key": "properties.redisConfiguration",
            "type": "RedisCommonPropertiesRedisConfiguration",
        },
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "properties.enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "properties.replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "properties.replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "properties.tenantSettings", "type": "{str}"},
        "shard_count": {"key": "properties.shardCount", "type": "int"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "sku": {"key": "properties.sku", "type": "Sku"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "static_ip": {"key": "properties.staticIP", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "ssl_port": {"key": "properties.sslPort", "type": "int"},
        "access_keys": {"key": "properties.accessKeys", "type": "RedisAccessKeys"},
        "linked_servers": {"key": "properties.linkedServers", "type": "[RedisLinkedServer]"},
        "instances": {"key": "properties.instances", "type": "[RedisInstanceDetails]"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        subnet_id: Optional[str] = None,
        static_ip: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword zones: A list of availability zones denoting where the resource needs to come from.
        :paramtype zones: list[str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.redis.models.ManagedServiceIdentity
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        :keyword sku: The SKU of the Redis cache to deploy. Required.
        :paramtype sku: ~azure.mgmt.redis.models.Sku
        :keyword subnet_id: The full resource ID of a subnet in a virtual network to deploy the Redis
         cache in. Example format:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1.
        :paramtype subnet_id: str
        :keyword static_ip: Static IP address. Optionally, may be specified when deploying a Redis
         cache inside an existing Azure Virtual Network; auto assigned by default.
        :paramtype static_ip: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.zones = zones
        self.identity = identity
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access
        self.sku = sku
        self.subnet_id = subnet_id
        self.static_ip = static_ip
        self.provisioning_state = None
        self.host_name = None
        self.port = None
        self.ssl_port = None
        self.access_keys = None
        self.linked_servers = None
        self.instances = None
        self.private_endpoint_connections = None


class RedisUpdateParameters(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Parameters supplied to the Update Redis operation.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.redis.models.ManagedServiceIdentity
    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    :ivar sku: The SKU of the Redis cache to deploy.
    :vartype sku: ~azure.mgmt.redis.models.Sku
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "redis_configuration": {
            "key": "properties.redisConfiguration",
            "type": "RedisCommonPropertiesRedisConfiguration",
        },
        "redis_version": {"key": "properties.redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "properties.enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "properties.replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "properties.replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "properties.tenantSettings", "type": "{str}"},
        "shard_count": {"key": "properties.shardCount", "type": "int"},
        "minimum_tls_version": {"key": "properties.minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "sku": {"key": "properties.sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        sku: Optional["_models.Sku"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.redis.models.ManagedServiceIdentity
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        :keyword sku: The SKU of the Redis cache to deploy.
        :paramtype sku: ~azure.mgmt.redis.models.Sku
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access
        self.sku = sku


class RedisUpdateProperties(RedisCommonProperties):
    """Patchable properties of the redis cache.

    :ivar redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :vartype redis_configuration: ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
    :ivar redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major' is
     required) or the value 'latest' which refers to the latest stable Redis version that is
     available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
    :vartype redis_version: str
    :ivar enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is enabled.
    :vartype enable_non_ssl_port: bool
    :ivar replicas_per_master: The number of replicas to be created per primary.
    :vartype replicas_per_master: int
    :ivar replicas_per_primary: The number of replicas to be created per primary.
    :vartype replicas_per_primary: int
    :ivar tenant_settings: A dictionary of tenant settings.
    :vartype tenant_settings: dict[str, str]
    :ivar shard_count: The number of shards to be created on a Premium Cluster Cache.
    :vartype shard_count: int
    :ivar minimum_tls_version: Optional: requires clients to use a specified TLS version (or
     higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
    :vartype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this cache.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private
     endpoints are the exclusive access method. Default value is 'Enabled'. Known values are:
     "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
    :ivar sku: The SKU of the Redis cache to deploy.
    :vartype sku: ~azure.mgmt.redis.models.Sku
    """

    _attribute_map = {
        "redis_configuration": {"key": "redisConfiguration", "type": "RedisCommonPropertiesRedisConfiguration"},
        "redis_version": {"key": "redisVersion", "type": "str"},
        "enable_non_ssl_port": {"key": "enableNonSslPort", "type": "bool"},
        "replicas_per_master": {"key": "replicasPerMaster", "type": "int"},
        "replicas_per_primary": {"key": "replicasPerPrimary", "type": "int"},
        "tenant_settings": {"key": "tenantSettings", "type": "{str}"},
        "shard_count": {"key": "shardCount", "type": "int"},
        "minimum_tls_version": {"key": "minimumTlsVersion", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        redis_configuration: Optional["_models.RedisCommonPropertiesRedisConfiguration"] = None,
        redis_version: Optional[str] = None,
        enable_non_ssl_port: bool = False,
        replicas_per_master: Optional[int] = None,
        replicas_per_primary: Optional[int] = None,
        tenant_settings: Optional[Dict[str, str]] = None,
        shard_count: Optional[int] = None,
        minimum_tls_version: Optional[Union[str, "_models.TlsVersion"]] = None,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        sku: Optional["_models.Sku"] = None,
        **kwargs
    ):
        """
        :keyword redis_configuration: All Redis Settings. Few possible keys:
         rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
         etc.
        :paramtype redis_configuration:
         ~azure.mgmt.redis.models.RedisCommonPropertiesRedisConfiguration
        :keyword redis_version: Redis version. This should be in the form 'major[.minor]' (only 'major'
         is required) or the value 'latest' which refers to the latest stable Redis version that is
         available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
        :paramtype redis_version: str
        :keyword enable_non_ssl_port: Specifies whether the non-ssl Redis server port (6379) is
         enabled.
        :paramtype enable_non_ssl_port: bool
        :keyword replicas_per_master: The number of replicas to be created per primary.
        :paramtype replicas_per_master: int
        :keyword replicas_per_primary: The number of replicas to be created per primary.
        :paramtype replicas_per_primary: int
        :keyword tenant_settings: A dictionary of tenant settings.
        :paramtype tenant_settings: dict[str, str]
        :keyword shard_count: The number of shards to be created on a Premium Cluster Cache.
        :paramtype shard_count: int
        :keyword minimum_tls_version: Optional: requires clients to use a specified TLS version (or
         higher) to connect (e,g, '1.0', '1.1', '1.2'). Known values are: "1.0", "1.1", and "1.2".
        :paramtype minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         cache.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled',
         private endpoints are the exclusive access method. Default value is 'Enabled'. Known values
         are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.redis.models.PublicNetworkAccess
        :keyword sku: The SKU of the Redis cache to deploy.
        :paramtype sku: ~azure.mgmt.redis.models.Sku
        """
        super().__init__(
            redis_configuration=redis_configuration,
            redis_version=redis_version,
            enable_non_ssl_port=enable_non_ssl_port,
            replicas_per_master=replicas_per_master,
            replicas_per_primary=replicas_per_primary,
            tenant_settings=tenant_settings,
            shard_count=shard_count,
            minimum_tls_version=minimum_tls_version,
            public_network_access=public_network_access,
            **kwargs
        )
        self.sku = sku


class ScheduleEntry(_serialization.Model):
    """Patch schedule entry for a Premium Redis Cache.

    All required parameters must be populated in order to send to Azure.

    :ivar day_of_week: Day of the week when a cache can be patched. Required. Known values are:
     "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Everyday", and
     "Weekend".
    :vartype day_of_week: str or ~azure.mgmt.redis.models.DayOfWeek
    :ivar start_hour_utc: Start hour after which cache patching can start. Required.
    :vartype start_hour_utc: int
    :ivar maintenance_window: ISO8601 timespan specifying how much time cache patching can take.
    :vartype maintenance_window: ~datetime.timedelta
    """

    _validation = {
        "day_of_week": {"required": True},
        "start_hour_utc": {"required": True},
    }

    _attribute_map = {
        "day_of_week": {"key": "dayOfWeek", "type": "str"},
        "start_hour_utc": {"key": "startHourUtc", "type": "int"},
        "maintenance_window": {"key": "maintenanceWindow", "type": "duration"},
    }

    def __init__(
        self,
        *,
        day_of_week: Union[str, "_models.DayOfWeek"],
        start_hour_utc: int,
        maintenance_window: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword day_of_week: Day of the week when a cache can be patched. Required. Known values are:
         "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday", "Everyday", and
         "Weekend".
        :paramtype day_of_week: str or ~azure.mgmt.redis.models.DayOfWeek
        :keyword start_hour_utc: Start hour after which cache patching can start. Required.
        :paramtype start_hour_utc: int
        :keyword maintenance_window: ISO8601 timespan specifying how much time cache patching can take.
        :paramtype maintenance_window: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.day_of_week = day_of_week
        self.start_hour_utc = start_hour_utc
        self.maintenance_window = maintenance_window


class Sku(_serialization.Model):
    """SKU parameters supplied to the create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium).
     Required. Known values are: "Basic", "Standard", and "Premium".
    :vartype name: str or ~azure.mgmt.redis.models.SkuName
    :ivar family: The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
     Required. Known values are: "C" and "P".
    :vartype family: str or ~azure.mgmt.redis.models.SkuFamily
    :ivar capacity: The size of the Redis cache to deploy. Valid values: for C (Basic/Standard)
     family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4). Required.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
        "family": {"required": True},
        "capacity": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: Union[str, "_models.SkuName"], family: Union[str, "_models.SkuFamily"], capacity: int, **kwargs
    ):
        """
        :keyword name: The type of Redis cache to deploy. Valid values: (Basic, Standard, Premium).
         Required. Known values are: "Basic", "Standard", and "Premium".
        :paramtype name: str or ~azure.mgmt.redis.models.SkuName
        :keyword family: The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P =
         Premium). Required. Known values are: "C" and "P".
        :paramtype family: str or ~azure.mgmt.redis.models.SkuFamily
        :keyword capacity: The size of the Redis cache to deploy. Valid values: for C (Basic/Standard)
         family (0, 1, 2, 3, 4, 5, 6), for P (Premium) family (1, 2, 3, 4). Required.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.family = family
        self.capacity = capacity


class UpgradeNotification(_serialization.Model):
    """Properties of upgrade notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of upgrade notification.
    :vartype name: str
    :ivar timestamp: Timestamp when upgrade notification occurred.
    :vartype timestamp: ~datetime.datetime
    :ivar upsell_notification: Details about this upgrade notification.
    :vartype upsell_notification: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "timestamp": {"readonly": True},
        "upsell_notification": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "upsell_notification": {"key": "upsellNotification", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.timestamp = None
        self.upsell_notification = None


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
