# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import HDInsightManagementClientConfiguration
from .operations import ClustersOperations
from .operations import ApplicationsOperations
from .operations import LocationsOperations
from .operations import ConfigurationsOperations
from .operations import ExtensionsOperations
from .operations import ScriptActionsOperations
from .operations import ScriptExecutionHistoryOperations
from .operations import Operations
from .operations import VirtualMachinesOperations
from .. import models


class HDInsightManagementClient(object):
    """HDInsight Management Client.

    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.hdinsight.aio.operations.ClustersOperations
    :ivar applications: ApplicationsOperations operations
    :vartype applications: azure.mgmt.hdinsight.aio.operations.ApplicationsOperations
    :ivar locations: LocationsOperations operations
    :vartype locations: azure.mgmt.hdinsight.aio.operations.LocationsOperations
    :ivar configurations: ConfigurationsOperations operations
    :vartype configurations: azure.mgmt.hdinsight.aio.operations.ConfigurationsOperations
    :ivar extensions: ExtensionsOperations operations
    :vartype extensions: azure.mgmt.hdinsight.aio.operations.ExtensionsOperations
    :ivar script_actions: ScriptActionsOperations operations
    :vartype script_actions: azure.mgmt.hdinsight.aio.operations.ScriptActionsOperations
    :ivar script_execution_history: ScriptExecutionHistoryOperations operations
    :vartype script_execution_history: azure.mgmt.hdinsight.aio.operations.ScriptExecutionHistoryOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.hdinsight.aio.operations.Operations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.hdinsight.aio.operations.VirtualMachinesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = HDInsightManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.clusters = ClustersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.applications = ApplicationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.configurations = ConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.extensions = ExtensionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.script_actions = ScriptActionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.script_execution_history = ScriptExecutionHistoryOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "HDInsightManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
