/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class SingleClustererEnhancer
extends AbstractClusterer
implements OptionHandler {
    private static final long serialVersionUID = 4893928362926428671L;
    protected Clusterer m_Clusterer = new SimpleKMeans();

    protected String defaultClustererString() {
        return SimpleKMeans.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull name of base clusterer.\n\t(default: " + this.defaultClustererString() + ")", "W", 1, "-W"));
        if (this.m_Clusterer instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_Clusterer.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
            while (enu.hasMoreElements()) {
                result.addElement((Option)enu.nextElement());
            }
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            this.setClusterer(AbstractClusterer.forName(tmpStr, null));
            this.setClusterer(AbstractClusterer.forName(tmpStr, Utils.partitionOptions(options)));
        } else {
            this.setClusterer(AbstractClusterer.forName(this.defaultClustererString(), null));
            this.setClusterer(AbstractClusterer.forName(this.defaultClustererString(), Utils.partitionOptions(options)));
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-W");
        result.add(this.getClusterer().getClass().getName());
        if (this.getClusterer() instanceof OptionHandler) {
            result.add("--");
            String[] options = ((OptionHandler)((Object)this.getClusterer())).getOptions();
            for (int i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String clustererTipText() {
        return "The base clusterer to be used.";
    }

    public void setClusterer(Clusterer value) {
        this.m_Clusterer = value;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected String getClustererSpec() {
        Clusterer clusterer = this.getClusterer();
        String result = clusterer.getClass().getName();
        if (clusterer instanceof OptionHandler) {
            result = result + " " + Utils.joinOptions(((OptionHandler)((Object)clusterer)).getOptions());
        }
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getClusterer() == null ? super.getCapabilities() : this.getClusterer().getCapabilities();
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    public int numberOfClusters() throws Exception {
        return this.m_Clusterer.numberOfClusters();
    }
}

