--[[
-- @brief Generates pilot names
--]]
function pirate_name ()
   -- For translation, just transliterate if necessary. (Note the space
   -- appended to each entry; this can be omitted for transliterations
   -- to languages that don't use spaces, like Japanese.)
   local articles = {
      _("Das "),
      _("Der "),
      _("Kono "),
      _("La "),
      _("Le "),
      _("The "),
      _("Ye "),
   }
   local descriptors = {
      _("Aerobic "),
      _("Aku No "),
      _("Amai "),
      _("Ancient "),
      _("Astro "),
      _("Baggy "),
      _("Bakana "),
      _("Bald "),
      _("Beautiful "),
      _("Benevolent "),
      _("Bedrohliche "),
      _("Big "),
      _("Big Bad "),
      _("Bloody "),
      _("Bright "),
      _("Brooding "),
      _("BT "),
      _("Bureina "),
      _("Caped "),
      _("Citrus "),
      _("Clustered "),
      _("Cocky "),
      _("Creamy "),
      _("Crisis "),
      _("Crusty "),
      _("Dark "),
      _("Deadly "),
      _("Deathly "),
      _("Defiant "),
      _("Delicious "),
      _("Despicable "),
      _("Destructive "),
      _("Diligent "),
      _("Drunk "),
      _("Egotistical "),
      _("Escaped "),
      _("Eternal "),
      _("Evil "),
      _("Fallen "),
      _("Fearless "),
      _("Fearsome "),
      _("Filthy "),
      _("Flightless "),
      _("Flying "),
      _("Foreboding "),
      _("Fuketeru "),
      _("Full-Motion "),
      _("Furchtlose "),
      _("General "),
      _("Gigantic "),
      _("Glittery "),
      _("Glorious "),
      _("Great "),
      _("Groß "),
      _("Grumpy "),
      _("Hairy "),
      _("Hammy "),
      _("Handsome "),
      _("Happy "),
      _("Hashitteru "),
      _("Hellen "),
      _("Hen'na "),
      _("Hidoi "),
      _("Hilarious "),
      _("Hitori No "),
      _("Horrible "),
      _("IDS "),
      _("Imperial "),
      _("Impressive "),
      _("Insatiable "),
      _("Iron "),
      _("Justice "),
      _("Kakkowarui "),
      _("Koronderu "),
      _("Kowai "),
      _("Lesser "),
      _("Lightspeed "),
      _("Lone "),
      _("Lovely "),
      _("Lustful "),
      _("Mächtige "),
      _("Malodorous "),
      _("Messy "),
      _("Mighty "),
      _("Mijikai "),
      _("Morbid "),
      _("Mukashi No "),
      _("Murderous "),
      _("Nai "),
      _("Naïve "),
      _("Neutron-Accelerated "),
      _("New "),
      _("Night's "),
      _("Nimble "),
      _("Ninkyōna "),
      _("No Good "),
      _("Numb "),
      _("Oishī "),
      _("Ōkina "),
      _("Old "),
      _("Oshirisu No"),
      _("Oyoideru "),
      _("Perilous "),
      _("Pirate's "),
      _("Pocket "),
      _("Princeless "),
      _("Psychic "),
      _("Raging "),
      _("Reclusive "),
      _("Relentless "),
      _("Rostige "),
      _("Rough "),
      _("Ruthless "),
      _("Saccharin "),
      _("Salty "),
      _("Samui "),
      _("Satanic "),
      _("Secluded "),
      _("Seltsame "),
      _("Serial "),
      _("Sharing "),
      _("Silly "),
      _("Single "),
      _("Sleepy "),
      _("Slimy "),
      _("Smelly "),
      _("Solar "),
      _("Space "),
      _("Static "),
      _("Steel "),
      _("Strange "),
      _("Strawhat "),
      _("Sukina "),
      _("Super "),
      _("Sweaty "),
      _("Sweet "),
      _("Tall "),
      _("Takai "),
      _("Terrible "),
      _("Tired "),
      _("Toothless "),
      _("Tropical "),
      _("Tsukareteru "),
      _("Typical "),
      _("Ultimate "),
      _("Umai "),
      _("Undead "),
      _("Unersättliche "),
      _("Unhealthy "),
      _("Unreal "),
      _("Unsightly "),
      _("Utsukushī "),
      _("Vengeful "),
      _("Very Bad "),
      _("Violent "),
      _("Warui "),
      _("Weeping "),
      _("Winged "),
      _("Wretched "),
      _("Yaseteru "),
      _("Yasui "),
      _("Yasashī "),
      _("Yummy "),
   }
   local colours = {
      _("Akai "),
      _("Amarillo "),
      _("Aoi "),
      _("Azul "),
      _("Blau "),
      _("Bleu "),
      _("Blue "),
      _("Crimson "),
      _("Cyan "),
      _("Gelb "),
      _("Gray "),
      _("Green "),
      _("Grün "),
      _("Kiiroi "),
      _("Kuroi "),
      _("Mauve "),
      _("Purple "),
      _("Red "),
      _("Roho "),
      _("Schwarz "),
      _("Shiroi "),
      _("Silver "),
      _("Violet "),
      _("Yellow "),
   }
   local actors = {
      _("1024"),
      _("Aku"),
      _("Akuma"),
      _("Alphabet Soup"),
      _("Amigo"),
      _("Angel"),
      _("Angle Grinder"),
      _("Anvil"),
      _("Ari"),
      _("Arrow"),
      _("Atama"),
      _("Aunt"),
      _("Auster"),
      _("Avenger"),
      _("Axis"),
      _("Baka"),
      _("Bakemono"),
      _("Band Saw"),
      _("Bat"),
      _("Beard"),
      _("Belt Sander"),
      _("Bench Grinder"),
      _("Bengoshi"),
      _("Black Hole"),
      _("Blarg"),
      _("Blitzschneider"),
      _("Blizzard"),
      _("Blood"),
      _("Blunder"),
      _("Bobber"),
      _("Bolt Cutter"),
      _("Bōshi"),
      _("Brain"),
      _("Bride"),
      _("Brigand"),
      _("Bulk"),
      _("Burglar"),
      _("Cane"),
      _("Chainsaw"),
      _("Cheese"),
      _("Cheese Grater"),
      _("Chi"),
      _("Chicken"),
      _("Circle"),
      _("Claw"),
      _("Claw Hammer"),
      _("Club"),
      _("Coot"),
      _("Corsair"),
      _("Cougar"),
      _("Crisis"),
      _("Crow"),
      _("Crowbar"),
      _("Crusader"),
      _("Curse"),
      _("Cyborg"),
      _("Darkness"),
      _("Death"),
      _("Deity"),
      _("Demon"),
      _("Destruction"),
      _("Devil"),
      _("Dictator"),
      _("Disaster"),
      _("Donkey"),
      _("Doom"),
      _("Drache"),
      _("Dragon"),
      _("Dread"),
      _("Drifter"),
      _("Drill Press"),
      _("Duckling"),
      _("Eagle"),
      _("Eggplant"),
      _("Ego"),
      _("Electricity"),
      _("Emperor"),
      _("Energy-Volt"),
      _("Engine"),
      _("Fang"),
      _("Flare"),
      _("Flash"),
      _("Fox"),
      _("Friend"),
      _("Fugitive"),
      _("Gaki"),
      _("Geschützturmdrehbank"),
      _("Giant"),
      _("Gift"),
      _("Gohan"),
      _("Goose"),
      _("Gorilla"),
      _("Gun"),
      _("Hae"),
      _("Hamburger"),
      _("Hammer"),
      _("Headache"),
      _("Hex"),
      _("Hikari"),
      _("Horobi"),
      _("Horror"),
      _("Hunter"),
      _("Husband"),
      _("Ichigo"),
      _("Id"),
      _("Impact Wrench"),
      _("Inazuma"),
      _("Ishi"),
      _("Itoyōji"),
      _("Jalapeño"),
      _("Jigsaw"),
      _("Jishin"),
      _("Jinx"),
      _("Ka"),
      _("Kailan"),
      _("Kaji"),
      _("Kamakiri"),
      _("Kame"),
      _("Kami"),
      _("Kamikaze"),
      _("Kappa"),
      _("Karaoke"),
      _("Katana"),
      _("Kaze"),
      _("Keel"),
      _("Ketchup"),
      _("Killer"),
      _("Kirin"),
      _("Kitchen Knife"),
      _("Kitsune"),
      _("Kitten"),
      _("Knave"),
      _("Knife"),
      _("Knight"),
      _("Kōmori"),
      _("Kumo"),
      _("Lance"),
      _("Lanze"),
      _("Lantern"),
      _("Lawyer"),
      _("League"),
      _("Lust"),
      _("Madōshi"),
      _("Magician"),
      _("Mahō"),
      _("Maize"),
      _("Mangaka"),
      _("Mangekyō"),
      _("Mango"),
      _("Mech"),
      _("Melon"),
      _("Mind"),
      _("Model"),
      _("Monster"),
      _("Mosquito"),
      _("Moustache"),
      _("Mugi"),
      _("Nanika"),
      _("Neckbeard"),
      _("Necromancer"),
      _("Neko"),
      _("Nezumi"),
      _("Night"),
      _("Niku"),
      _("Ninja"),
      _("Niwatori"),
      _("Nova"),
      _("Ogre"),
      _("Oni"),
      _("Onion"),
      _("Osiris"),
      _("Outlaw"),
      _("Oyster"),
      _("Panther"),
      _("Paste"),
      _("Pea"),
      _("Peapod"),
      _("Peril"),
      _("Pickaxe"),
      _("Pipe Wrench"),
      _("Pitchfork"),
      _("Politician"),
      _("Potato"),
      _("Potter"),
      _("Pride"),
      _("Princess"),
      _("Puppy"),
      _("Raigeki"),
      _("Ramen"),
      _("Rat"),
      _("Ratte"),
      _("Ravager"),
      _("Raven"),
      _("Reaver"),
      _("Recluse"),
      _("Rice"),
      _("Ring"),
      _("River"),
      _("Rōjin"),
      _("Rubber Mallet"),
      _("Ryū"),
      _("Sakura"),
      _("Salad"),
      _("Samurai"),
      _("Sasori"),
      _("Scythe"),
      _("Sea"),
      _("Seaweed"),
      _("Seijika"),
      _("Sentinel"),
      _("Serpent"),
      _("Shepherd"),
      _("Shinigami"),
      _("Shinobi"),
      _("Shock"),
      _("Shovel"),
      _("Shujin"),
      _("Siren"),
      _("Slayer"),
      _("Space Dog"),
      _("Spade"),
      _("Spaghetti"),
      _("Spaghetti Monster"),
      _("Spider"),
      _("Squeegee"),
      _("Staple Gun"),
      _("Stern"),
      _("Stir-fry"),
      _("Storm"),
      _("Supernova"),
      _("Surströmming"),
      _("Table Saw"),
      _("Tallman"),
      _("Tanoshimi"),
      _("Tatsumaki"),
      _("Tegami"),
      _("Teineigo"),
      _("Tenkūryū"),
      _("Terror"),
      _("Thunder"),
      _("Tomodachi"),
      _("Tooth"),
      _("Tora"),
      _("Tori"),
      _("Treasure Hunter"),
      _("Tree"),
      _("Tsuchi"),
      _("Tumbler"),
      _("Turret Lathe"),
      _("Twilight"),
      _("Tyrant"),
      _("Umi"),
      _("Urchin"),
      _("Velocity"),
      _("Vengeance"),
      _("Void"),
      _("Vomit"),
      _("Wache"),
      _("Watcher"),
      _("Wedge"),
      _("Widget"),
      _("Widow"),
      _("Wight"),
      _("Willow"),
      _("Wind"),
      _("Wizard"),
      _("Wolf"),
      _("Yakuza"),
      _("Yama"),
      _("Yami"),
      _("Yarou"),
      _("Yasai"),
      _("Yatsu"),
      _("Youma"),
      _("Zombie"),
   }
   local article = articles[ rnd.rnd(1,#articles) ]
   local descriptor = descriptors[ rnd.rnd(1,#descriptors) ]
   local colour = colours[ rnd.rnd(1,#colours) ]
   local actor = actors[ rnd.rnd(1,#actors) ]

   local r = rnd.rnd()
   if r < 0.166 then
      return article .. actor
   elseif r < 0.333 then
      return colour .. actor
   elseif r < 0.50 then
      return descriptor .. actor
   elseif r < 0.666 then
      return article .. descriptor .. actor
   elseif r < 0.833 then
      return article .. colour .. actor
   else
      return article .. descriptor .. colour .. actor
   end
end
