# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class VortexCore(PolyDataAlgorithm):
    r"""
    VortexCore - Compute vortex core lines using the parallel vectors
    method
    
    Superclass: PolyDataAlgorithm
    
    VortexCore computes vortex core lines using the parallel vectors
    method, as described in
    
    Roth, Martin and Ronald Peikert. “A higher-order method for finding
    vortex core lines.” Proceedings Visualization '98 (Cat.
    No.98CB36276) (1998): 143-150.
    
    By default, the "Higher-Order" approach of computing the parallel
    vector lines between the flow field's velocity and jerk is disabled
    in favor of computing the parallel vector lines between the velocity
    and acceleration, as suggested in
    
    Haimes, Robert and David N. Kenwright. “On the velocity gradient
    tensor and fluid feature extraction.” (1999).
    
    To further discriminate against spurious vortex cores, at each
    potential point value the Q-criterion, delta-criterion, and
    lambda_2-criterion are checked as defined in
    
    Haller, G. (2005). An objective definition of a vortex. Journal of
    Fluid Mechanics, 525, 1-26.
    
    Additionally, the lambda_ci criterion is computed as defined in
    
    Chakraborty, P., Balachandar, S., & Adran, R. (2005). On the
    relationships between local vortex identification schemes. Journal of
    Fluid Mechanics, 535, 189-214.
    
    The Q-criterion and delta-criterion are used to prefilter cells prior
    to the execution of the parallel lines algorithm, and all criteria
    values are stored as point values on the output polylines.
    
    The faster_approximation option uses a faster approximate gradient
    calculation to accelerate the vortex core calculation.
    
    @sa
    ParallelVectors
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVortexCore, obj, update, **traits)
    
    faster_approximation = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _faster_approximation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFasterApproximation,
                        self.faster_approximation_)

    higher_order_method = tvtk_base.false_bool_trait(desc=\
        r"""
        When this flag is on, the flow field's jerk is used instead of
        acceleration as the second vector field during the parallel
        vector operation. The default is off.
        """
    )

    def _higher_order_method_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHigherOrderMethod,
                        self.higher_order_method_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('faster_approximation', 'GetFasterApproximation'),
    ('higher_order_method', 'GetHigherOrderMethod'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'faster_approximation',
    'global_warning_display', 'higher_order_method', 'release_data_flag',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VortexCore, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VortexCore properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['faster_approximation', 'higher_order_method'], [], []),
            title='Edit VortexCore properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VortexCore properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

