# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.algorithm import Algorithm


class ReaderAlgorithm(Algorithm):
    r"""
    ReaderAlgorithm - Superclass for readers that implement a
    simplified API.
    
    Superclass: Algorithm
    
    This class and associated subclasses were created to make it easier
    to develop readers. When directly subclassing from other algorithm
    classes one has to learn a general purpose API that somewhat
    obfuscates pipeline functionality behind information keys. One has to
    know how to find time and pieces requests using keys for example.
    Furthermore, these classes together with specialized executives can
    implement common reader functionality for things such as file series
    (for time and/or partitions), caching, mapping time requests to
    indices etc. This class implements the most basic API which is
    specialized as needed by subclasses (for file series for example).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkReaderAlgorithm, obj, update, **traits)
    
    def create_output(self, *args):
        """
        create_output(self, currentOutput:DataObject) -> DataObject
        C++: virtual DataObject *create_output(
            DataObject *currentOutput)
        This can be overridden by a subclass to create an output that is
        determined by the file being read. If the output is known at
        compile time, it is easier to override
        fill_output_port_information() to set
        DataObject::DATA_TYPE_NAME(). The subclass should compare the
        new output type with the type of the currentOutput argument and
        return currentOutput without changing its reference count if the
        types are same.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CreateOutput, *my_args)
        return wrap_vtk(ret)

    def read_arrays(self, *args):
        """
        read_arrays(self, piece:int, npieces:int, nghosts:int,
            timestep:int, output:DataObject) -> int
        C++: virtual int read_arrays(int piece, int npieces, int nghosts,
            int timestep, DataObject *output)
        Read all the arrays (point, cell, field etc.). This is called
        after read_points() so the data object should already contain the
        mesh and points.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadArrays, *my_args)
        return ret

    def read_mesh(self, *args):
        """
        read_mesh(self, piece:int, npieces:int, nghosts:int, timestep:int,
            output:DataObject) -> int
        C++: virtual int read_mesh(int piece, int npieces, int nghosts,
            int timestep, DataObject *output)
        Read the mesh (connectivity) for a given set of data
        partitioning, number of ghost levels and time step (index). The
        reader populates the data object passed in as the last argument.
        It is OK to read more than the mesh (points, arrays etc.).
        However, this may interfere with any caching implemented by the
        executive (i.e. cause more reads).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadMesh, *my_args)
        return ret

    def read_meta_data(self, *args):
        """
        read_meta_data(self, metadata:Information) -> int
        C++: virtual int read_meta_data(Information *metadata)
        Provide meta-data for the pipeline. This meta-data cannot vary
        over time as this method will not be called when only a request
        is changed. These include things like time steps. Subclasses may
        have specialized interfaces making this simpler.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadMetaData, *my_args)
        return ret

    def read_points(self, *args):
        """
        read_points(self, piece:int, npieces:int, nghosts:int,
            timestep:int, output:DataObject) -> int
        C++: virtual int read_points(int piece, int npieces, int nghosts,
            int timestep, DataObject *output)
        Read the points. The reader populates the input data object. This
        is called after read_mesh() so the data object should already
        contain the mesh.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadPoints, *my_args)
        return ret

    def read_time_dependent_meta_data(self, *args):
        """
        read_time_dependent_meta_data(self, __a:int, __b:Information)
            -> int
        C++: virtual int read_time_dependent_meta_data(int, Information *)
        Provide meta-data for the pipeline. This meta-data can vary over
        time as this method will be called after a request is changed
        (such as time) These include things like whole extent. Subclasses
        may have specialized interfaces making this simpler.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ReadTimeDependentMetaData, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ReaderAlgorithm, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ReaderAlgorithm properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ReaderAlgorithm properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ReaderAlgorithm properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

