#
# @file    TestFunctionDefinition.py
# @brief   SBML FunctionDefinition unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestFunctionDefinition.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestFunctionDefinition(unittest.TestCase):

  global FD
  FD = None

  def setUp(self):
    self.FD = libsbml.FunctionDefinition(2,4)
    if (self.FD == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.FD ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_FunctionDefinition_create(self):
    self.assertTrue( self.FD.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    self.assertTrue( self.FD.getMetaId() == "" )
    self.assertTrue( self.FD.getNotes() == None )
    self.assertTrue( self.FD.getAnnotation() == None )
    self.assertTrue( self.FD.getId() == "" )
    self.assertTrue( self.FD.getName() == "" )
    self.assertTrue( self.FD.getMath() == None )
    pass  

  def test_FunctionDefinition_createWith(self):
    math = libsbml.parseFormula("lambda(x, x^3)")
    fd = libsbml.FunctionDefinition(2,4)
    fd.setId( "pow3")
    fd.setMath(math)
    self.assertTrue( fd.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    self.assertTrue( fd.getMetaId() == "" )
    self.assertTrue( fd.getNotes() == None )
    self.assertTrue( fd.getAnnotation() == None )
    self.assertTrue( fd.getName() == "" )
    math1 = fd.getMath()
    self.assertTrue( math1 != None )
    formula = libsbml.formulaToString(math1)
    self.assertTrue( formula != None )
    self.assertTrue((  "lambda(x, x^3)" == formula ))
    self.assertTrue( fd.getMath() != math )
    self.assertEqual( True, fd.isSetMath() )
    self.assertTrue((  "pow3" == fd.getId() ))
    self.assertEqual( True, fd.isSetId() )
    _dummyList = [ math ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ fd ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_FunctionDefinition_createWithNS(self):
    xmlns = libsbml.XMLNamespaces()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = libsbml.SBMLNamespaces(2,1)
    sbmlns.addNamespaces(xmlns)
    object = libsbml.FunctionDefinition(sbmlns)
    self.assertTrue( object.getTypeCode() == libsbml.SBML_FUNCTION_DEFINITION )
    self.assertTrue( object.getMetaId() == "" )
    self.assertTrue( object.getNotes() == None )
    self.assertTrue( object.getAnnotation() == None )
    self.assertTrue( object.getLevel() == 2 )
    self.assertTrue( object.getVersion() == 1 )
    self.assertTrue( object.getNamespaces() != None )
    self.assertTrue( object.getNamespaces().getLength() == 2 )
    _dummyList = [ object ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_FunctionDefinition_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_FunctionDefinition_getArguments(self):
    self.FD.setMath(libsbml.parseFormula("lambda(x, y, x^y)"))
    self.assertTrue( self.FD.getNumArguments() == 2 )
    math = self.FD.getArgument(0)
    self.assertTrue( math != None )
    self.assertEqual( True, math.isName() )
    self.assertTrue((  "x" == math.getName() ))
    self.assertTrue( math.getNumChildren() == 0 )
    math = self.FD.getArgument(1)
    self.assertTrue( math != None )
    self.assertEqual( True, math.isName() )
    self.assertTrue((  "y" == math.getName() ))
    self.assertTrue( math.getNumChildren() == 0 )
    self.assertTrue( self.FD.getArgument(0) == self.FD.getArgument( "x") )
    self.assertTrue( self.FD.getArgument(1) == self.FD.getArgument( "y") )
    pass  

  def test_FunctionDefinition_getBody(self):
    math1 = libsbml.parseFormula("lambda(x, x)")
    self.FD.setMath(math1)
    math = self.FD.getBody()
    self.assertTrue( math != None )
    self.assertEqual( True, math.isName() )
    self.assertTrue((  "x" == math.getName() ))
    self.assertTrue( math.getNumChildren() == 0 )
    _dummyList = [ math1 ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_FunctionDefinition_setId(self):
    id =  "pow3";
    self.FD.setId(id)
    self.assertTrue(( id == self.FD.getId() ))
    self.assertEqual( True, self.FD.isSetId() )
    if (self.FD.getId() == id):
      pass    
    self.FD.setId(self.FD.getId())
    self.assertTrue(( id == self.FD.getId() ))
    self.FD.setId("")
    self.assertEqual( False, self.FD.isSetId() )
    if (self.FD.getId() != None):
      pass    
    pass  

  def test_FunctionDefinition_setMath(self):
    math = libsbml.parseFormula("lambda(x, x^3)")
    self.FD.setMath(math)
    math1 = self.FD.getMath()
    self.assertTrue( math1 != None )
    formula = libsbml.formulaToString(math1)
    self.assertTrue( formula != None )
    self.assertTrue((  "lambda(x, x^3)" == formula ))
    self.assertTrue( self.FD.getMath() != math )
    self.assertEqual( True, self.FD.isSetMath() )
    self.FD.setMath(self.FD.getMath())
    math1 = self.FD.getMath()
    self.assertTrue( math1 != None )
    formula = libsbml.formulaToString(math1)
    self.assertTrue( formula != None )
    self.assertTrue((  "lambda(x, x^3)" == formula ))
    self.assertTrue( self.FD.getMath() != math )
    self.FD.setMath(None)
    self.assertEqual( False, self.FD.isSetMath() )
    if (self.FD.getMath() != None):
      pass    
    pass  

  def test_FunctionDefinition_setName(self):
    name =  "Cube_Me";
    self.FD.setName(name)
    self.assertTrue(( name == self.FD.getName() ))
    self.assertEqual( True, self.FD.isSetName() )
    if (self.FD.getName() == name):
      pass    
    self.FD.setName(self.FD.getName())
    self.assertTrue(( name == self.FD.getName() ))
    self.FD.setName("")
    self.assertEqual( False, self.FD.isSetName() )
    if (self.FD.getName() != None):
      pass    
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestFunctionDefinition))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
