; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-unknown \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-unknown \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-aix \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-aix \
; RUN:   -mcpu=pwr9 < %s | FileCheck %s

define i32 @test_builtin_ppc_compare_exp_eq(double %d) {
; CHECK-LABEL: test_builtin_ppc_compare_exp_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscmpexpdp 0, 1, 1
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    li 4, 1
; CHECK-NEXT:    iseleq 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.compare.exp.eq(double %d, double %d)
  ret i32 %0
}

declare i32 @llvm.ppc.compare.exp.eq(double, double)

define i32 @test_builtin_ppc_compare_exp_lt(double %d) {
; CHECK-LABEL: test_builtin_ppc_compare_exp_lt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscmpexpdp 0, 1, 1
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    li 4, 1
; CHECK-NEXT:    isellt 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.compare.exp.lt(double %d, double %d)
  ret i32 %0
}

declare i32 @llvm.ppc.compare.exp.lt(double, double)

define i32 @test_builtin_ppc_compare_exp_gt(double %d) {
; CHECK-LABEL: test_builtin_ppc_compare_exp_gt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscmpexpdp 0, 1, 1
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    li 4, 1
; CHECK-NEXT:    iselgt 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.compare.exp.gt(double %d, double %d)
  ret i32 %0
}

declare i32 @llvm.ppc.compare.exp.gt(double, double)

define i32 @test_builtin_ppc_compare_exp_uo(double %d) {
; CHECK-LABEL: test_builtin_ppc_compare_exp_uo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xscmpexpdp 0, 1, 1
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    li 4, 1
; CHECK-NEXT:    isel 3, 4, 3, 3
; CHECK-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.compare.exp.uo(double %d, double %d)
  ret i32 %0
}

declare i32 @llvm.ppc.compare.exp.uo(double, double)

define i32 @test_builtin_ppc_test_data_class_d(double %d) {
; CHECK-LABEL: test_builtin_ppc_test_data_class_d:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xststdcdp 0, 1, 0
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    li 4, 1
; CHECK-NEXT:    iseleq 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %test_data_class = tail call i32 @llvm.ppc.test.data.class.f64(double %d, i32 0)
  ret i32 %test_data_class
}

declare i32 @llvm.ppc.test.data.class.f64(double, i32 immarg)

define i32 @test_builtin_ppc_test_data_class_f(float %f) {
; CHECK-LABEL: test_builtin_ppc_test_data_class_f:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xststdcsp 0, 1, 127
; CHECK-NEXT:    li 3, 0
; CHECK-NEXT:    li 4, 1
; CHECK-NEXT:    iseleq 3, 4, 3
; CHECK-NEXT:    blr
entry:
  %test_data_class = tail call i32 @llvm.ppc.test.data.class.f32(float %f, i32 127)
  ret i32 %test_data_class
}

declare i32 @llvm.ppc.test.data.class.f32(float, i32 immarg)
