/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "reverb_panel.h"
#ifndef __GTK_DIAL_H__
 #include "gtkdial.h"
#endif

static void time_callback(GtkAdjustment *adj, gpointer data)
{
  delay_set_time((delay *)data,adj->value);

}

static void ap_time_callback(GtkAdjustment *adj, gpointer data)
{
  all_pass_set_time((all_pass *)data,adj->value);

}

static void feedback_callback(GtkAdjustment *adj, gpointer data)
{
    delay_set_feedback((delay *) data,(int)adj->value);
}

static void ap_feedback_callback(GtkAdjustment *adj, gpointer data)
{
    all_pass_set_feedback((all_pass *) data,(int)adj->value);
}

GtkWidget *reverb_panel_new(reverb *target, GtkStyle *dial_style)
{
  GtkWidget *panel;
  GtkWidget *table;
  GtkObject *range;
  GtkWidget *dial;

  panel = gtk_hbox_new(TRUE,10);
  table = gtk_table_new(6,6,TRUE);
  /*comb 1*/
  range =  gtk_adjustment_new(C1_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (time_callback), 
		      (gpointer)(target->combs[0]));
  gtk_table_attach(GTK_TABLE(table),dial,0,1,0,1,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(C1_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (feedback_callback), 
		      (gpointer)(target->combs[0]));
  gtk_table_attach(GTK_TABLE(table),dial,0,1,1,2,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  /*comb 2*/
  range =  gtk_adjustment_new(C2_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (time_callback), 
		      (gpointer)(target->combs[1]));
  gtk_table_attach(GTK_TABLE(table),dial,1,2,0,1,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(C2_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (feedback_callback), 
		      (gpointer)(target->combs[1]));
  gtk_table_attach(GTK_TABLE(table),dial,1,2,1,2,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  /*comb 3*/
  range =  gtk_adjustment_new(C3_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (time_callback), 
		      (gpointer)(target->combs[2]));
  gtk_table_attach(GTK_TABLE(table),dial,2,3,0,1,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(C3_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (feedback_callback), 
		      (gpointer)(target->combs[2]));
  gtk_table_attach(GTK_TABLE(table),dial,2,3,1,2,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);


  /*comb 4*/
  range =  gtk_adjustment_new(C4_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (time_callback), 
		      (gpointer)(target->combs[3]));
  gtk_table_attach(GTK_TABLE(table),dial,3,4,0,1,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(C4_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (feedback_callback), 
		      (gpointer)(target->combs[3]));
  gtk_table_attach(GTK_TABLE(table),dial,3,4,1,2,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  /*comb 5*/
  range =  gtk_adjustment_new(C5_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (time_callback), 
		      (gpointer)(target->combs[4]));
  gtk_table_attach(GTK_TABLE(table),dial,4,5,0,1,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(C5_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (feedback_callback), 
		      (gpointer)(target->combs[4]));
  gtk_table_attach(GTK_TABLE(table),dial,4,5,1,2,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);


  /*comb 6*/
  range =  gtk_adjustment_new(C6_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (time_callback), 
		      (gpointer)(target->combs[5]));
  gtk_table_attach(GTK_TABLE(table),dial,5,6,0,1,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(C6_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (feedback_callback), 
		      (gpointer)(target->combs[5]));
  gtk_table_attach(GTK_TABLE(table),dial,5,6,1,2,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);


  /*all pass 1*/
  range =  gtk_adjustment_new(AP1_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (ap_time_callback), 
		      (gpointer)(target->ap_1));
  gtk_table_attach(GTK_TABLE(table),dial,2,3,3,4,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(AP2_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (ap_feedback_callback), 
		      (gpointer)(target->ap_1));
  gtk_table_attach(GTK_TABLE(table),dial,3,4,3,4,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  /*all pass 2*/
  range =  gtk_adjustment_new(AP2_INIT_D,0,MAX_REVERB_DLY,0.1,0.1,0.1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (ap_time_callback), 
		      (gpointer)(target->ap_2));
  gtk_table_attach(GTK_TABLE(table),dial,2,3,4,5,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);

  range =  gtk_adjustment_new(AP2_INIT_F,0,MAX_FEEDBACK,1,1,1);
  dial       = gtk_dial_new(GTK_ADJUSTMENT(range));
  gtk_signal_connect (GTK_OBJECT (range), "value_changed",
		      GTK_SIGNAL_FUNC (ap_feedback_callback), 
		      (gpointer)(target->ap_2));
  gtk_table_attach(GTK_TABLE(table),dial,3,4,4,5,0,0,3,0);
  gtk_widget_set_usize(dial,20,20);
  gtk_widget_set_style(dial,dial_style);
  gtk_widget_show(dial);


  gtk_widget_show(table);
  gtk_container_add(GTK_CONTAINER(panel),table);

  return panel;
}



/*
  Local Variables:
  mode: font-lock
  End:
*/
