/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.optimization;

import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTForInit;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTReturnStatement;
import net.sourceforge.pmd.ast.ASTThrowStatement;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.rules.optimization.AbstractOptimizationRule;

public class AvoidInstantiatingObjectsInLoops
extends AbstractOptimizationRule {
    public Object visit(ASTAllocationExpression node, Object data) {
        if (this.insideLoop(node) && this.fourthParentNotThrow(node) && this.fourthParentNotReturn(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean fourthParentNotThrow(ASTAllocationExpression node) {
        return !(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTThrowStatement);
    }

    private boolean fourthParentNotReturn(ASTAllocationExpression node) {
        return !(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTReturnStatement);
    }

    private boolean insideLoop(ASTAllocationExpression node) {
        for (Node n = node.jjtGetParent(); n != null; n = n.jjtGetParent()) {
            if (n instanceof ASTDoStatement || n instanceof ASTWhileStatement || n instanceof ASTForStatement) {
                return true;
            }
            if (!(n instanceof ASTForInit)) continue;
            n = n.jjtGetParent();
        }
        return false;
    }
}

