<?xml version="1.0" encoding="UTF-8"?>
<tagger name="polish">
  <tagset>
  <def-label name="CNJCOO" closed="true">
    <tags-item tags="cnjcoo"/>
  </def-label> 
  <def-label name="CNJADV" closed="true">
    <tags-item tags="cnjadv"/>
  </def-label> 
  <def-label name="CNJSUB" closed="true">
    <tags-item tags="cnjsub"/>
  </def-label> 
  <def-label name="IJ">
    <tags-item tags="ij"/>
  </def-label> 
  <def-label name="TAKNIEADV">
    <tags-item lemma="tak" tags="adv"/>
    <tags-item lemma="nie" tags="adv"/>
  </def-label> 
  <def-label name="TAKNIEIJ">
    <tags-item lemma="tak" tags="ij"/>
    <tags-item lemma="nie" tags="ij"/>
  </def-label> 
  <def-label name="ADV">
    <tags-item tags="adv"/>
    <tags-item tags="adv.comp"/>
    <tags-item tags="adv.sup"/>
  </def-label> 
  <def-label name="PR" closed="true">
    <tags-item tags="pr"/>
  </def-label> 
  <def-label name="PO" closed="true">
    <tags-item lemma="po" tags="pr"/>
  </def-label> 
  <def-label name="VBSER" closed="true">
    <tags-item lemma="być" tags="vbser"/>
  </def-label> 
  <def-label name="PRCASELESS" closed="true">
    <tags-item lemma="jako" tags="pr"/>
  </def-label> 
  <def-label name="GENPR" closed="true">
    <tags-item lemma="do" tags="pr"/>
    <tags-item lemma="od" tags="pr"/>
    <tags-item lemma="aż od" tags="pr"/>
    <tags-item lemma="mimo" tags="pr"/>
    <tags-item lemma="z" tags="pr.gen"/>
    <tags-item lemma="bez" tags="pr"/>
    <tags-item lemma="spod" tags="pr"/>
    <tags-item lemma="sponad" tags="pr"/>
    <tags-item lemma="spomiędzy" tags="pr"/>
    <tags-item lemma="u" tags="pr"/>
    <tags-item lemma="dla" tags="pr"/>
    <tags-item lemma="około" tags="pr"/>
    <tags-item lemma="podczas" tags="pr"/>
    <tags-item lemma="zamiast" tags="pr"/>
    <tags-item lemma="z wyjątkiem" tags="pr"/>
  </def-label> 
  <def-label name="DATPR" closed="true">
    <tags-item lemma="ku" tags="pr"/>
    <tags-item lemma="dzięki" tags="pr"/>
  </def-label> 
  <def-label name="ACCPR" closed="true">
    <tags-item lemma="po" tags="pr"/>
    <tags-item lemma="pod" tags="pr"/>
    <tags-item lemma="popod" tags="pr"/>
    <tags-item lemma="o" tags="pr"/>
    <tags-item lemma="w" tags="pr"/>
    <tags-item lemma="na" tags="pr"/>
    <tags-item lemma="nad" tags="pr"/>
    <tags-item lemma="przed" tags="pr"/>
    <tags-item lemma="za" tags="pr"/>
    <tags-item lemma="bez względu na" tags="pr"/>
  </def-label> 
  <def-label name="LOCPR" closed="true">
    <tags-item lemma="w" tags="pr"/>
    <tags-item lemma="na" tags="pr"/>
    <tags-item lemma="o" tags="pr"/>
  </def-label> 
  <def-label name="INSPR" closed="true">
    <tags-item lemma="z" tags="pr.ins"/>
    <tags-item lemma="międzi" tags="pr"/>
    <tags-item lemma="nad" tags="pr"/>
    <tags-item lemma="pod" tags="pr"/>
    <tags-item lemma="przed" tags="pr"/>
    <tags-item lemma="za" tags="pr"/>
  </def-label> 
  <def-label name="P3DETPOS" closed="true">
    <tags-item lemma="jej" tags="det.pos.adv"/>
    <tags-item lemma="jego" tags="det.pos.adv"/>
    <tags-item lemma="ich" tags="det.pos.adv"/>
  </def-label> 

  <def-label name="PRPERS" closed="true">
    <tags-item lemma="prpers" tags="prn.*"/>
  </def-label> 

  <def-label name="P3PRNNONPR" closed="true">
    <tags-item lemma="prpers" tags="prn.emph.p3.mp.sg.acc"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.mp.sg.gen"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.nt.sg.acc"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.nt.sg.gen"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.ma.sg.acc"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.ma.sg.gen"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.mi.sg.acc"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.mi.sg.gen"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.mf.sg.acc"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.mf.sg.gen"/>
    <tags-item lemma="prpers" tags="prn.emph.p3.f.sg.dat"/>
  </def-label> 

  <def-label name="ADJPO" closed="true">
    <tags-item tags="adj.po"/>
  </def-label> 

  <def-mult name="PRNIEGOEMPHNT" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.emph.p3.nt.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNIEGOEMPHM" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.emph.p3.mp.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNIEGONT" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.p3.nt.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNIEGOOM" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.p3.mp.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="ADJENCSER" closed="true">  
    <sequence>
      <tags-item tags="adj.*"/>
      <tags-item tags="vbser.pres.*"/>
    </sequence>
  </def-mult>
    <def-label name="JEVERB">
      <tags-item lemma="jeść" tags="vblex.*"/>
    </def-label> 
    <def-label name="VERB">
      <tags-item tags="vbhaver.*"/>
    </def-label> 
  </tagset>

  <forbid>
  <label-sequence>
    <label-item label="PR"/>
    <label-item label="P3PRNNONPR"/>
  </label-sequence>
  <label-sequence>
    <label-item label="VBSER"/>
    <label-item label="ADJENCSER"/>
  </label-sequence>
  <label-sequence>
    <label-item label="PR"/>
    <label-item label="ADJENCSER"/>
  </label-sequence>
    <label-sequence>
      <label-item label="VERB"/>
      <label-item label="JEVERB"/>
    </label-sequence>
</forbid>

<enforce-rules>
  <enforce-after label="PR">
    <label-set>
      <label-item label="P3DETPOS"/>
    </label-set>
  </enforce-after>
  <enforce-after label="PO">
    <label-set>
      <label-item label="ADJPO"/>
    </label-set>
  </enforce-after>
</enforce-rules>

<preferences>
  <prefer tags="prn.emph.p3.nt.sg.gen"/>
  <prefer tags="prn.emph.p3.nt.sg.dat"/>
  <prefer tags="prn.emph.p3.nt.sg.acc"/>
  <prefer tags="prn.emph.p3.nt.sg.ins"/>
  <prefer tags="prn.emph.p3.nt.sg.loc"/>
  <prefer tags="prn.emph.p3.mp.pl.gen"/>
  <prefer tags="prn.emph.p3.mp.pl.dat"/>
  <prefer tags="prn.emph.p3.mp.pl.acc"/>
  <prefer tags="prn.emph.p3.mp.pl.ins"/>
  <prefer tags="prn.emph.p3.mp.pl.loc"/>
  <prefer tags="vbhaver.impf.pres.p3.sg"/>
  <prefer tags="vbhaver.impf.pres.p3.pl"/>
</preferences>

<tagset>
  <def-label name="ADJFSGNOM">
    <tags-item tags="adj.comp.f.sg.nom"/>
    <tags-item tags="adj.f.sg.nom"/>
    <tags-item tags="adj.dim.f.sg.nom"/>
    <tags-item tags="adj.sint.comp.f.sg.nom"/>
    <tags-item tags="adj.sint.dim.f.sg.nom"/>
    <tags-item tags="adj.sint.f.sg.nom"/>
  </def-label> 
  <def-label name="ADJMASGNOM">
    <tags-item tags="adj.comp.ma.sg.nom"/>
    <tags-item tags="adj.ma.sg.nom"/>
    <tags-item tags="adj.dim.ma.sg.nom"/>
    <tags-item tags="adj.sint.comp.ma.sg.nom"/>
    <tags-item tags="adj.sint.dim.ma.sg.nom"/>
    <tags-item tags="adj.sint.ma.sg.nom"/>
  </def-label> 
  <def-label name="ADJMISGNOM">
    <tags-item tags="adj.comp.mi.sg.nom"/>
    <tags-item tags="adj.mi.sg.nom"/>
    <tags-item tags="adj.dim.mi.sg.nom"/>
    <tags-item tags="adj.sint.comp.mi.sg.nom"/>
    <tags-item tags="adj.sint.dim.mi.sg.nom"/>
    <tags-item tags="adj.sint.mi.sg.nom"/>
  </def-label> 
  <def-label name="ADJNTSGNOM">
    <tags-item tags="adj.comp.nt.sg.nom"/>
    <tags-item tags="adj.nt.sg.nom"/>
    <tags-item tags="adj.dim.nt.sg.nom"/>
    <tags-item tags="adj.sint.comp.nt.sg.nom"/>
    <tags-item tags="adj.sint.dim.nt.sg.nom"/>
    <tags-item tags="adj.sint.nt.sg.nom"/>
  </def-label> 
  <def-label name="ADJFSGGEN">
    <tags-item tags="adj.comp.f.sg.gen"/>
    <tags-item tags="adj.f.sg.gen"/>
    <tags-item tags="adj.dim.f.sg.gen"/>
    <tags-item tags="adj.sint.comp.f.sg.gen"/>
    <tags-item tags="adj.sint.dim.f.sg.gen"/>
    <tags-item tags="adj.sint.f.sg.gen"/>
  </def-label> 
  <def-label name="ADJMASGGEN">
    <tags-item tags="adj.comp.ma.sg.gen"/>
    <tags-item tags="adj.ma.sg.gen"/>
    <tags-item tags="adj.dim.ma.sg.gen"/>
    <tags-item tags="adj.sint.comp.ma.sg.gen"/>
    <tags-item tags="adj.sint.dim.ma.sg.gen"/>
    <tags-item tags="adj.sint.ma.sg.gen"/>
  </def-label> 
  <def-label name="ADJMISGGEN">
    <tags-item tags="adj.comp.mi.sg.gen"/>
    <tags-item tags="adj.mi.sg.gen"/>
    <tags-item tags="adj.dim.mi.sg.gen"/>
    <tags-item tags="adj.sint.comp.mi.sg.gen"/>
    <tags-item tags="adj.sint.dim.mi.sg.gen"/>
    <tags-item tags="adj.sint.mi.sg.gen"/>
  </def-label> 
  <def-label name="ADJNTSGGEN">
    <tags-item tags="adj.comp.nt.sg.gen"/>
    <tags-item tags="adj.nt.sg.gen"/>
    <tags-item tags="adj.dim.nt.sg.gen"/>
    <tags-item tags="adj.sint.comp.nt.sg.gen"/>
    <tags-item tags="adj.sint.dim.nt.sg.gen"/>
    <tags-item tags="adj.sint.nt.sg.gen"/>
  </def-label> 
  <def-label name="ADJFSGDAT">
    <tags-item tags="adj.comp.f.sg.dat"/>
    <tags-item tags="adj.f.sg.dat"/>
    <tags-item tags="adj.dim.f.sg.dat"/>
    <tags-item tags="adj.sint.comp.f.sg.dat"/>
    <tags-item tags="adj.sint.dim.f.sg.dat"/>
    <tags-item tags="adj.sint.f.sg.dat"/>
  </def-label> 
  <def-label name="ADJMASGDAT">
    <tags-item tags="adj.comp.ma.sg.dat"/>
    <tags-item tags="adj.ma.sg.dat"/>
    <tags-item tags="adj.dim.ma.sg.dat"/>
    <tags-item tags="adj.sint.comp.ma.sg.dat"/>
    <tags-item tags="adj.sint.dim.ma.sg.dat"/>
    <tags-item tags="adj.sint.ma.sg.dat"/>
  </def-label> 
  <def-label name="ADJMISGDAT">
    <tags-item tags="adj.comp.mi.sg.dat"/>
    <tags-item tags="adj.mi.sg.dat"/>
    <tags-item tags="adj.dim.mi.sg.dat"/>
    <tags-item tags="adj.sint.comp.mi.sg.dat"/>
    <tags-item tags="adj.sint.dim.mi.sg.dat"/>
    <tags-item tags="adj.sint.mi.sg.dat"/>
  </def-label> 
  <def-label name="ADJNTSGDAT">
    <tags-item tags="adj.comp.nt.sg.dat"/>
    <tags-item tags="adj.nt.sg.dat"/>
    <tags-item tags="adj.dim.nt.sg.dat"/>
    <tags-item tags="adj.sint.comp.nt.sg.dat"/>
    <tags-item tags="adj.sint.dim.nt.sg.dat"/>
    <tags-item tags="adj.sint.nt.sg.dat"/>
  </def-label> 
  <def-label name="ADJFSGACC">
    <tags-item tags="adj.comp.f.sg.acc"/>
    <tags-item tags="adj.f.sg.acc"/>
    <tags-item tags="adj.dim.f.sg.acc"/>
    <tags-item tags="adj.sint.comp.f.sg.acc"/>
    <tags-item tags="adj.sint.dim.f.sg.acc"/>
    <tags-item tags="adj.sint.f.sg.acc"/>
  </def-label> 
  <def-label name="ADJMASGACC">
    <tags-item tags="adj.comp.ma.sg.acc"/>
    <tags-item tags="adj.ma.sg.acc"/>
    <tags-item tags="adj.dim.ma.sg.acc"/>
    <tags-item tags="adj.sint.comp.ma.sg.acc"/>
    <tags-item tags="adj.sint.dim.ma.sg.acc"/>
    <tags-item tags="adj.sint.ma.sg.acc"/>
  </def-label> 
  <def-label name="ADJMISGACC">
    <tags-item tags="adj.comp.mi.sg.acc"/>
    <tags-item tags="adj.mi.sg.acc"/>
    <tags-item tags="adj.dim.mi.sg.acc"/>
    <tags-item tags="adj.sint.comp.mi.sg.acc"/>
    <tags-item tags="adj.sint.dim.mi.sg.acc"/>
    <tags-item tags="adj.sint.mi.sg.acc"/>
  </def-label> 
  <def-label name="ADJNTSGACC">
    <tags-item tags="adj.comp.nt.sg.acc"/>
    <tags-item tags="adj.nt.sg.acc"/>
    <tags-item tags="adj.dim.nt.sg.acc"/>
    <tags-item tags="adj.sint.comp.nt.sg.acc"/>
    <tags-item tags="adj.sint.dim.nt.sg.acc"/>
    <tags-item tags="adj.sint.nt.sg.acc"/>
  </def-label> 
  <def-label name="ADJFSGINS">
    <tags-item tags="adj.comp.f.sg.ins"/>
    <tags-item tags="adj.f.sg.ins"/>
    <tags-item tags="adj.dim.f.sg.ins"/>
    <tags-item tags="adj.sint.comp.f.sg.ins"/>
    <tags-item tags="adj.sint.dim.f.sg.ins"/>
    <tags-item tags="adj.sint.f.sg.ins"/>
  </def-label> 
  <def-label name="ADJMASGINS">
    <tags-item tags="adj.comp.ma.sg.ins"/>
    <tags-item tags="adj.ma.sg.ins"/>
    <tags-item tags="adj.dim.ma.sg.ins"/>
    <tags-item tags="adj.sint.comp.ma.sg.ins"/>
    <tags-item tags="adj.sint.dim.ma.sg.ins"/>
    <tags-item tags="adj.sint.ma.sg.ins"/>
  </def-label> 
  <def-label name="ADJMISGINS">
    <tags-item tags="adj.comp.mi.sg.ins"/>
    <tags-item tags="adj.mi.sg.ins"/>
    <tags-item tags="adj.dim.mi.sg.ins"/>
    <tags-item tags="adj.sint.comp.mi.sg.ins"/>
    <tags-item tags="adj.sint.dim.mi.sg.ins"/>
    <tags-item tags="adj.sint.mi.sg.ins"/>
  </def-label> 
  <def-label name="ADJNTSGINS">
    <tags-item tags="adj.comp.nt.sg.ins"/>
    <tags-item tags="adj.nt.sg.ins"/>
    <tags-item tags="adj.dim.nt.sg.ins"/>
    <tags-item tags="adj.sint.comp.nt.sg.ins"/>
    <tags-item tags="adj.sint.dim.nt.sg.ins"/>
    <tags-item tags="adj.sint.nt.sg.ins"/>
  </def-label> 
  <def-label name="ADJFSGLOC">
    <tags-item tags="adj.comp.f.sg.loc"/>
    <tags-item tags="adj.f.sg.loc"/>
    <tags-item tags="adj.dim.f.sg.loc"/>
    <tags-item tags="adj.sint.comp.f.sg.loc"/>
    <tags-item tags="adj.sint.dim.f.sg.loc"/>
    <tags-item tags="adj.sint.f.sg.loc"/>
  </def-label> 
  <def-label name="ADJMASGLOC">
    <tags-item tags="adj.comp.ma.sg.loc"/>
    <tags-item tags="adj.ma.sg.loc"/>
    <tags-item tags="adj.dim.ma.sg.loc"/>
    <tags-item tags="adj.sint.comp.ma.sg.loc"/>
    <tags-item tags="adj.sint.dim.ma.sg.loc"/>
    <tags-item tags="adj.sint.ma.sg.loc"/>
  </def-label> 
  <def-label name="ADJMISGLOC">
    <tags-item tags="adj.comp.mi.sg.loc"/>
    <tags-item tags="adj.mi.sg.loc"/>
    <tags-item tags="adj.dim.mi.sg.loc"/>
    <tags-item tags="adj.sint.comp.mi.sg.loc"/>
    <tags-item tags="adj.sint.dim.mi.sg.loc"/>
    <tags-item tags="adj.sint.mi.sg.loc"/>
  </def-label> 
  <def-label name="ADJNTSGLOC">
    <tags-item tags="adj.comp.nt.sg.loc"/>
    <tags-item tags="adj.nt.sg.loc"/>
    <tags-item tags="adj.dim.nt.sg.loc"/>
    <tags-item tags="adj.sint.comp.nt.sg.loc"/>
    <tags-item tags="adj.sint.dim.nt.sg.loc"/>
    <tags-item tags="adj.sint.nt.sg.loc"/>
  </def-label> 
  <def-label name="ADJFSGVOC">
    <tags-item tags="adj.comp.f.sg.voc"/>
    <tags-item tags="adj.f.sg.voc"/>
    <tags-item tags="adj.dim.f.sg.voc"/>
    <tags-item tags="adj.sint.comp.f.sg.voc"/>
    <tags-item tags="adj.sint.dim.f.sg.voc"/>
    <tags-item tags="adj.sint.f.sg.voc"/>
  </def-label> 
  <def-label name="ADJMASGVOC">
    <tags-item tags="adj.comp.ma.sg.voc"/>
    <tags-item tags="adj.ma.sg.voc"/>
    <tags-item tags="adj.dim.ma.sg.voc"/>
    <tags-item tags="adj.sint.comp.ma.sg.voc"/>
    <tags-item tags="adj.sint.dim.ma.sg.voc"/>
    <tags-item tags="adj.sint.ma.sg.voc"/>
  </def-label> 
  <def-label name="ADJMISGVOC">
    <tags-item tags="adj.comp.mi.sg.voc"/>
    <tags-item tags="adj.mi.sg.voc"/>
    <tags-item tags="adj.dim.mi.sg.voc"/>
    <tags-item tags="adj.sint.comp.mi.sg.voc"/>
    <tags-item tags="adj.sint.dim.mi.sg.voc"/>
    <tags-item tags="adj.sint.mi.sg.voc"/>
  </def-label> 
  <def-label name="ADJNTSGVOC">
    <tags-item tags="adj.comp.nt.sg.voc"/>
    <tags-item tags="adj.nt.sg.voc"/>
    <tags-item tags="adj.dim.nt.sg.voc"/>
    <tags-item tags="adj.sint.comp.nt.sg.voc"/>
    <tags-item tags="adj.sint.dim.nt.sg.voc"/>
    <tags-item tags="adj.sint.nt.sg.voc"/>
  </def-label> 
  <def-label name="ADJFPLNOM">
    <tags-item tags="adj.comp.f.pl.nom"/>
    <tags-item tags="adj.f.pl.nom"/>
    <tags-item tags="adj.dim.f.pl.nom"/>
    <tags-item tags="adj.sint.comp.f.pl.nom"/>
    <tags-item tags="adj.sint.dim.f.pl.nom"/>
    <tags-item tags="adj.sint.f.pl.nom"/>
  </def-label> 
  <def-label name="ADJMAPLNOM">
    <tags-item tags="adj.comp.ma.pl.nom"/>
    <tags-item tags="adj.ma.pl.nom"/>
    <tags-item tags="adj.dim.ma.pl.nom"/>
    <tags-item tags="adj.sint.comp.ma.pl.nom"/>
    <tags-item tags="adj.sint.dim.ma.pl.nom"/>
    <tags-item tags="adj.sint.ma.pl.nom"/>
  </def-label> 
  <def-label name="ADJMIPLNOM">
    <tags-item tags="adj.comp.mi.pl.nom"/>
    <tags-item tags="adj.mi.pl.nom"/>
    <tags-item tags="adj.dim.mi.pl.nom"/>
    <tags-item tags="adj.sint.comp.mi.pl.nom"/>
    <tags-item tags="adj.sint.dim.mi.pl.nom"/>
    <tags-item tags="adj.sint.mi.pl.nom"/>
  </def-label> 
  <def-label name="ADJNTPLNOM">
    <tags-item tags="adj.comp.nt.pl.nom"/>
    <tags-item tags="adj.nt.pl.nom"/>
    <tags-item tags="adj.dim.nt.pl.nom"/>
    <tags-item tags="adj.sint.comp.nt.pl.nom"/>
    <tags-item tags="adj.sint.dim.nt.pl.nom"/>
    <tags-item tags="adj.sint.nt.pl.nom"/>
  </def-label> 
  <def-label name="ADJFPLGEN">
    <tags-item tags="adj.comp.f.pl.gen"/>
    <tags-item tags="adj.f.pl.gen"/>
    <tags-item tags="adj.dim.f.pl.gen"/>
    <tags-item tags="adj.sint.comp.f.pl.gen"/>
    <tags-item tags="adj.sint.dim.f.pl.gen"/>
    <tags-item tags="adj.sint.f.pl.gen"/>
  </def-label> 
  <def-label name="ADJMAPLGEN">
    <tags-item tags="adj.comp.ma.pl.gen"/>
    <tags-item tags="adj.ma.pl.gen"/>
    <tags-item tags="adj.dim.ma.pl.gen"/>
    <tags-item tags="adj.sint.comp.ma.pl.gen"/>
    <tags-item tags="adj.sint.dim.ma.pl.gen"/>
    <tags-item tags="adj.sint.ma.pl.gen"/>
  </def-label> 
  <def-label name="ADJMIPLGEN">
    <tags-item tags="adj.comp.mi.pl.gen"/>
    <tags-item tags="adj.mi.pl.gen"/>
    <tags-item tags="adj.dim.mi.pl.gen"/>
    <tags-item tags="adj.sint.comp.mi.pl.gen"/>
    <tags-item tags="adj.sint.dim.mi.pl.gen"/>
    <tags-item tags="adj.sint.mi.pl.gen"/>
  </def-label> 
  <def-label name="ADJNTPLGEN">
    <tags-item tags="adj.comp.nt.pl.gen"/>
    <tags-item tags="adj.nt.pl.gen"/>
    <tags-item tags="adj.dim.nt.pl.gen"/>
    <tags-item tags="adj.sint.comp.nt.pl.gen"/>
    <tags-item tags="adj.sint.dim.nt.pl.gen"/>
    <tags-item tags="adj.sint.nt.pl.gen"/>
  </def-label> 
  <def-label name="ADJFPLDAT">
    <tags-item tags="adj.comp.f.pl.dat"/>
    <tags-item tags="adj.f.pl.dat"/>
    <tags-item tags="adj.dim.f.pl.dat"/>
    <tags-item tags="adj.sint.comp.f.pl.dat"/>
    <tags-item tags="adj.sint.dim.f.pl.dat"/>
    <tags-item tags="adj.sint.f.pl.dat"/>
  </def-label> 
  <def-label name="ADJMAPLDAT">
    <tags-item tags="adj.comp.ma.pl.dat"/>
    <tags-item tags="adj.ma.pl.dat"/>
    <tags-item tags="adj.dim.ma.pl.dat"/>
    <tags-item tags="adj.sint.comp.ma.pl.dat"/>
    <tags-item tags="adj.sint.dim.ma.pl.dat"/>
    <tags-item tags="adj.sint.ma.pl.dat"/>
  </def-label> 
  <def-label name="ADJMIPLDAT">
    <tags-item tags="adj.comp.mi.pl.dat"/>
    <tags-item tags="adj.mi.pl.dat"/>
    <tags-item tags="adj.dim.mi.pl.dat"/>
    <tags-item tags="adj.sint.comp.mi.pl.dat"/>
    <tags-item tags="adj.sint.dim.mi.pl.dat"/>
    <tags-item tags="adj.sint.mi.pl.dat"/>
  </def-label> 
  <def-label name="ADJNTPLDAT">
    <tags-item tags="adj.comp.nt.pl.dat"/>
    <tags-item tags="adj.nt.pl.dat"/>
    <tags-item tags="adj.dim.nt.pl.dat"/>
    <tags-item tags="adj.sint.comp.nt.pl.dat"/>
    <tags-item tags="adj.sint.dim.nt.pl.dat"/>
    <tags-item tags="adj.sint.nt.pl.dat"/>
  </def-label> 
  <def-label name="ADJFPLACC">
    <tags-item tags="adj.comp.f.pl.acc"/>
    <tags-item tags="adj.f.pl.acc"/>
    <tags-item tags="adj.dim.f.pl.acc"/>
    <tags-item tags="adj.sint.comp.f.pl.acc"/>
    <tags-item tags="adj.sint.dim.f.pl.acc"/>
    <tags-item tags="adj.sint.f.pl.acc"/>
  </def-label> 
  <def-label name="ADJMAPLACC">
    <tags-item tags="adj.comp.ma.pl.acc"/>
    <tags-item tags="adj.ma.pl.acc"/>
    <tags-item tags="adj.dim.ma.pl.acc"/>
    <tags-item tags="adj.sint.comp.ma.pl.acc"/>
    <tags-item tags="adj.sint.dim.ma.pl.acc"/>
    <tags-item tags="adj.sint.ma.pl.acc"/>
  </def-label> 
  <def-label name="ADJMIPLACC">
    <tags-item tags="adj.comp.mi.pl.acc"/>
    <tags-item tags="adj.mi.pl.acc"/>
    <tags-item tags="adj.dim.mi.pl.acc"/>
    <tags-item tags="adj.sint.comp.mi.pl.acc"/>
    <tags-item tags="adj.sint.dim.mi.pl.acc"/>
    <tags-item tags="adj.sint.mi.pl.acc"/>
  </def-label> 
  <def-label name="ADJNTPLACC">
    <tags-item tags="adj.comp.nt.pl.acc"/>
    <tags-item tags="adj.nt.pl.acc"/>
    <tags-item tags="adj.dim.nt.pl.acc"/>
    <tags-item tags="adj.sint.comp.nt.pl.acc"/>
    <tags-item tags="adj.sint.dim.nt.pl.acc"/>
    <tags-item tags="adj.sint.nt.pl.acc"/>
  </def-label> 
  <def-label name="ADJFPLINS">
    <tags-item tags="adj.comp.f.pl.ins"/>
    <tags-item tags="adj.f.pl.ins"/>
    <tags-item tags="adj.dim.f.pl.ins"/>
    <tags-item tags="adj.sint.comp.f.pl.ins"/>
    <tags-item tags="adj.sint.dim.f.pl.ins"/>
    <tags-item tags="adj.sint.f.pl.ins"/>
  </def-label> 
  <def-label name="ADJMAPLINS">
    <tags-item tags="adj.comp.ma.pl.ins"/>
    <tags-item tags="adj.ma.pl.ins"/>
    <tags-item tags="adj.dim.ma.pl.ins"/>
    <tags-item tags="adj.sint.comp.ma.pl.ins"/>
    <tags-item tags="adj.sint.dim.ma.pl.ins"/>
    <tags-item tags="adj.sint.ma.pl.ins"/>
  </def-label> 
  <def-label name="ADJMIPLINS">
    <tags-item tags="adj.comp.mi.pl.ins"/>
    <tags-item tags="adj.mi.pl.ins"/>
    <tags-item tags="adj.dim.mi.pl.ins"/>
    <tags-item tags="adj.sint.comp.mi.pl.ins"/>
    <tags-item tags="adj.sint.dim.mi.pl.ins"/>
    <tags-item tags="adj.sint.mi.pl.ins"/>
  </def-label> 
  <def-label name="ADJNTPLINS">
    <tags-item tags="adj.comp.nt.pl.ins"/>
    <tags-item tags="adj.nt.pl.ins"/>
    <tags-item tags="adj.dim.nt.pl.ins"/>
    <tags-item tags="adj.sint.comp.nt.pl.ins"/>
    <tags-item tags="adj.sint.dim.nt.pl.ins"/>
    <tags-item tags="adj.sint.nt.pl.ins"/>
  </def-label> 
  <def-label name="ADJFPLLOC">
    <tags-item tags="adj.comp.f.pl.loc"/>
    <tags-item tags="adj.f.pl.loc"/>
    <tags-item tags="adj.dim.f.pl.loc"/>
    <tags-item tags="adj.sint.comp.f.pl.loc"/>
    <tags-item tags="adj.sint.dim.f.pl.loc"/>
    <tags-item tags="adj.sint.f.pl.loc"/>
  </def-label> 
  <def-label name="ADJMAPLLOC">
    <tags-item tags="adj.comp.ma.pl.loc"/>
    <tags-item tags="adj.ma.pl.loc"/>
    <tags-item tags="adj.dim.ma.pl.loc"/>
    <tags-item tags="adj.sint.comp.ma.pl.loc"/>
    <tags-item tags="adj.sint.dim.ma.pl.loc"/>
    <tags-item tags="adj.sint.ma.pl.loc"/>
  </def-label> 
  <def-label name="ADJMIPLLOC">
    <tags-item tags="adj.comp.mi.pl.loc"/>
    <tags-item tags="adj.mi.pl.loc"/>
    <tags-item tags="adj.dim.mi.pl.loc"/>
    <tags-item tags="adj.sint.comp.mi.pl.loc"/>
    <tags-item tags="adj.sint.dim.mi.pl.loc"/>
    <tags-item tags="adj.sint.mi.pl.loc"/>
  </def-label> 
  <def-label name="ADJNTPLLOC">
    <tags-item tags="adj.comp.nt.pl.loc"/>
    <tags-item tags="adj.nt.pl.loc"/>
    <tags-item tags="adj.dim.nt.pl.loc"/>
    <tags-item tags="adj.sint.comp.nt.pl.loc"/>
    <tags-item tags="adj.sint.dim.nt.pl.loc"/>
    <tags-item tags="adj.sint.nt.pl.loc"/>
  </def-label> 
  <def-label name="ADJFPLVOC">
    <tags-item tags="adj.comp.f.pl.voc"/>
    <tags-item tags="adj.f.pl.voc"/>
    <tags-item tags="adj.dim.f.pl.voc"/>
    <tags-item tags="adj.sint.comp.f.pl.voc"/>
    <tags-item tags="adj.sint.dim.f.pl.voc"/>
    <tags-item tags="adj.sint.f.pl.voc"/>
  </def-label> 
  <def-label name="ADJMAPLVOC">
    <tags-item tags="adj.comp.ma.pl.voc"/>
    <tags-item tags="adj.ma.pl.voc"/>
    <tags-item tags="adj.dim.ma.pl.voc"/>
    <tags-item tags="adj.sint.comp.ma.pl.voc"/>
    <tags-item tags="adj.sint.dim.ma.pl.voc"/>
    <tags-item tags="adj.sint.ma.pl.voc"/>
  </def-label> 
  <def-label name="ADJMIPLVOC">
    <tags-item tags="adj.comp.mi.pl.voc"/>
    <tags-item tags="adj.mi.pl.voc"/>
    <tags-item tags="adj.dim.mi.pl.voc"/>
    <tags-item tags="adj.sint.comp.mi.pl.voc"/>
    <tags-item tags="adj.sint.dim.mi.pl.voc"/>
    <tags-item tags="adj.sint.mi.pl.voc"/>
  </def-label> 
  <def-label name="ADJNTPLVOC">
    <tags-item tags="adj.comp.nt.pl.voc"/>
    <tags-item tags="adj.nt.pl.voc"/>
    <tags-item tags="adj.dim.nt.pl.voc"/>
    <tags-item tags="adj.sint.comp.nt.pl.voc"/>
    <tags-item tags="adj.sint.dim.nt.pl.voc"/>
    <tags-item tags="adj.sint.nt.pl.voc"/>
  </def-label> 
  <def-label name="VPARTFSGNOM">
    <tags-item tags="vaux.impf.pp.adj.f.sg.nom"/>
    <tags-item tags="vaux.impf.pprs.adj.f.sg.nom"/>
    <tags-item tags="vbser.pprs.adj.f.sg.nom"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.nom"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.nom"/>
    <tags-item tags="vbhaver.impf.pprs.adj.f.sg.nom"/>
  </def-label> 
  <def-label name="VPARTMASGNOM">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.nom"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.nom"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.nom"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.nom"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.nom"/>
  </def-label> 
  <def-label name="VPARTMISGNOM">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.nom"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.nom"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.nom"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.nom"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.nom"/>
  </def-label> 
  <def-label name="VPARTNTSGNOM">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.nom"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.nom"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.nom"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.nom"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.nom"/>
  </def-label> 
  <def-label name="VPARTFSGGEN">
    <tags-item tags="vaux.impf.pp.adj.f.sg.gen"/>
    <tags-item tags="vbser.pprs.adj.f.sg.gen"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.gen"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.gen"/>
    <tags-item tags="vbhaver.impf.pprs.f.sg.gen"/>
  </def-label> 
  <def-label name="VPARTMASGGEN">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.gen"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.gen"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.gen"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.gen"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.gen"/>
  </def-label> 
  <def-label name="VPARTMISGGEN">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.gen"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.gen"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.gen"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.gen"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.gen"/>
  </def-label> 
  <def-label name="VPARTNTSGGEN">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.gen"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.gen"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.gen"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.gen"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.gen"/>
  </def-label> 
  <def-label name="VPARTFSGDAT">
    <tags-item tags="vaux.impf.pp.adj.f.sg.dat"/>
    <tags-item tags="vbser.pprs.adj.f.sg.dat"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.dat"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.dat"/>
    <tags-item tags="vbhaver.impf.pprs.f.sg.dat"/>
  </def-label> 
  <def-label name="VPARTMASGDAT">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.dat"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.dat"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.dat"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.dat"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.dat"/>
  </def-label> 
  <def-label name="VPARTMISGDAT">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.dat"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.dat"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.dat"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.dat"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.dat"/>
  </def-label> 
  <def-label name="VPARTNTSGDAT">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.dat"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.dat"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.dat"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.dat"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.dat"/>
  </def-label> 
  <def-label name="VPARTFSGACC">
    <tags-item tags="vaux.impf.pp.adj.f.sg.acc"/>
    <tags-item tags="vbser.pprs.adj.f.sg.acc"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.acc"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.acc"/>
    <tags-item tags="vbhaver.impf.pprs.f.sg.acc"/>
  </def-label> 
  <def-label name="VPARTMASGACC">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.acc"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.acc"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.acc"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.acc"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.acc"/>
  </def-label> 
  <def-label name="VPARTMISGACC">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.acc"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.acc"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.acc"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.acc"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.acc"/>
  </def-label> 
  <def-label name="VPARTNTSGACC">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.acc"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.acc"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.acc"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.acc"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.acc"/>
  </def-label> 
  <def-label name="VPARTFSGINS">
    <tags-item tags="vaux.impf.pp.adj.f.sg.ins"/>
    <tags-item tags="vbser.pprs.adj.f.sg.ins"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.ins"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.ins"/>
    <tags-item tags="vbhaver.impf.pprs.f.sg.ins"/>
  </def-label> 
  <def-label name="VPARTMASGINS">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.ins"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.ins"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.ins"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.ins"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.ins"/>
  </def-label> 
  <def-label name="VPARTMISGINS">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.ins"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.ins"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.ins"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.ins"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.ins"/>
  </def-label> 
  <def-label name="VPARTNTSGINS">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.ins"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.ins"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.ins"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.ins"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.ins"/>
  </def-label> 
  <def-label name="VPARTFSGLOC">
    <tags-item tags="vaux.impf.pp.adj.f.sg.loc"/>
    <tags-item tags="vbser.pprs.adj.f.sg.loc"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.loc"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.loc"/>
    <tags-item tags="vbhaver.impf.pprs.f.sg.loc"/>
  </def-label> 
  <def-label name="VPARTMASGLOC">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.loc"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.loc"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.loc"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.loc"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.loc"/>
  </def-label> 
  <def-label name="VPARTMISGLOC">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.loc"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.loc"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.loc"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.loc"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.loc"/>
  </def-label> 
  <def-label name="VPARTNTSGLOC">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.loc"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.loc"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.loc"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.loc"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.loc"/>
  </def-label> 
  <def-label name="VPARTFSGVOC">
    <tags-item tags="vaux.impf.pp.adj.f.sg.voc"/>
    <tags-item tags="vbser.pprs.adj.f.sg.voc"/>
    <tags-item tags="vblex.impf.pp.adj.f.sg.voc"/>
    <tags-item tags="vblex.perf.pp.adj.f.sg.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.f.sg.voc"/>
    <tags-item tags="vbhaver.impf.pprs.f.sg.voc"/>
  </def-label> 
  <def-label name="VPARTMASGVOC">
    <tags-item tags="vaux.impf.pp.adj.ma.sg.voc"/>
    <tags-item tags="vbser.pprs.adj.ma.sg.voc"/>
    <tags-item tags="vblex.impf.pp.adj.ma.sg.voc"/>
    <tags-item tags="vblex.perf.pp.adj.ma.sg.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.sg.voc"/>
    <tags-item tags="vbhaver.impf.pprs.ma.sg.voc"/>
  </def-label> 
  <def-label name="VPARTMISGVOC">
    <tags-item tags="vaux.impf.pp.adj.mi.sg.voc"/>
    <tags-item tags="vbser.pprs.adj.mi.sg.voc"/>
    <tags-item tags="vblex.impf.pp.adj.mi.sg.voc"/>
    <tags-item tags="vblex.perf.pp.adj.mi.sg.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.sg.voc"/>
    <tags-item tags="vbhaver.impf.pprs.mi.sg.voc"/>
  </def-label> 
  <def-label name="VPARTNTSGVOC">
    <tags-item tags="vaux.impf.pp.adj.nt.sg.voc"/>
    <tags-item tags="vbser.pprs.adj.nt.sg.voc"/>
    <tags-item tags="vblex.impf.pp.adj.nt.sg.voc"/>
    <tags-item tags="vblex.perf.pp.adj.nt.sg.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.sg.voc"/>
    <tags-item tags="vbhaver.impf.pprs.nt.sg.voc"/>
  </def-label> 
  <def-label name="VPARTFPLNOM">
    <tags-item tags="vaux.impf.pp.adj.f.pl.nom"/>
    <tags-item tags="vbser.pprs.adj.f.pl.nom"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.nom"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.nom"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.nom"/>
  </def-label> 
  <def-label name="VPARTMAPLNOM">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.nom"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.nom"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.nom"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.nom"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.nom"/>
  </def-label> 
  <def-label name="VPARTMIPLNOM">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.nom"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.nom"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.nom"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.nom"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.nom"/>
  </def-label> 
  <def-label name="VPARTNTPLNOM">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.nom"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.nom"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.nom"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.nom"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.nom"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.nom"/>
  </def-label> 
  <def-label name="VPARTFPLGEN">
    <tags-item tags="vaux.impf.pp.adj.f.pl.gen"/>
    <tags-item tags="vbser.pprs.adj.f.pl.gen"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.gen"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.gen"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.gen"/>
  </def-label> 
  <def-label name="VPARTMAPLGEN">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.gen"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.gen"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.gen"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.gen"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.gen"/>
  </def-label> 
  <def-label name="VPARTMIPLGEN">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.gen"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.gen"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.gen"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.gen"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.gen"/>
  </def-label> 
  <def-label name="VPARTNTPLGEN">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.gen"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.gen"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.gen"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.gen"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.gen"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.gen"/>
  </def-label> 
  <def-label name="VPARTFPLDAT">
    <tags-item tags="vaux.impf.pp.adj.f.pl.dat"/>
    <tags-item tags="vbser.pprs.adj.f.pl.dat"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.dat"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.dat"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.dat"/>
  </def-label> 
  <def-label name="VPARTMAPLDAT">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.dat"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.dat"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.dat"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.dat"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.dat"/>
  </def-label> 
  <def-label name="VPARTMIPLDAT">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.dat"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.dat"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.dat"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.dat"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.dat"/>
  </def-label> 
  <def-label name="VPARTNTPLDAT">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.dat"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.dat"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.dat"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.dat"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.dat"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.dat"/>
  </def-label> 
  <def-label name="VPARTFPLACC">
    <tags-item tags="vaux.impf.pp.adj.f.pl.acc"/>
    <tags-item tags="vbser.pprs.adj.f.pl.acc"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.acc"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.acc"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.acc"/>
  </def-label> 
  <def-label name="VPARTMAPLACC">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.acc"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.acc"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.acc"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.acc"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.acc"/>
  </def-label> 
  <def-label name="VPARTMIPLACC">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.acc"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.acc"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.acc"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.acc"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.acc"/>
  </def-label> 
  <def-label name="VPARTNTPLACC">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.acc"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.acc"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.acc"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.acc"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.acc"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.acc"/>
  </def-label> 
  <def-label name="VPARTFPLINS">
    <tags-item tags="vaux.impf.pp.adj.f.pl.ins"/>
    <tags-item tags="vbser.pprs.adj.f.pl.ins"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.ins"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.ins"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.ins"/>
  </def-label> 
  <def-label name="VPARTMAPLINS">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.ins"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.ins"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.ins"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.ins"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.ins"/>
  </def-label> 
  <def-label name="VPARTMIPLINS">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.ins"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.ins"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.ins"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.ins"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.ins"/>
  </def-label> 
  <def-label name="VPARTNTPLINS">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.ins"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.ins"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.ins"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.ins"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.ins"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.ins"/>
  </def-label> 
  <def-label name="VPARTFPLLOC">
    <tags-item tags="vaux.impf.pp.adj.f.pl.loc"/>
    <tags-item tags="vbser.pprs.adj.f.pl.loc"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.loc"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.loc"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.loc"/>
  </def-label> 
  <def-label name="VPARTMAPLLOC">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.loc"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.loc"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.loc"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.loc"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.loc"/>
  </def-label> 
  <def-label name="VPARTMIPLLOC">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.loc"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.loc"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.loc"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.loc"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.loc"/>
  </def-label> 
  <def-label name="VPARTNTPLLOC">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.loc"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.loc"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.loc"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.loc"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.loc"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.loc"/>
  </def-label> 
  <def-label name="VPARTFPLVOC">
    <tags-item tags="vaux.impf.pp.adj.f.pl.voc"/>
    <tags-item tags="vbser.pprs.adj.f.pl.voc"/>
    <tags-item tags="vblex.impf.pp.adj.f.pl.voc"/>
    <tags-item tags="vblex.perf.pp.adj.f.pl.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.f.pl.voc"/>
    <tags-item tags="vbhaver.impf.pprs.f.pl.voc"/>
  </def-label> 
  <def-label name="VPARTMAPLVOC">
    <tags-item tags="vaux.impf.pp.adj.ma.pl.voc"/>
    <tags-item tags="vbser.pprs.adj.ma.pl.voc"/>
    <tags-item tags="vblex.impf.pp.adj.ma.pl.voc"/>
    <tags-item tags="vblex.perf.pp.adj.ma.pl.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.ma.pl.voc"/>
    <tags-item tags="vbhaver.impf.pprs.ma.pl.voc"/>
  </def-label> 
  <def-label name="VPARTMIPLVOC">
    <tags-item tags="vaux.impf.pp.adj.mi.pl.voc"/>
    <tags-item tags="vbser.pprs.adj.mi.pl.voc"/>
    <tags-item tags="vblex.impf.pp.adj.mi.pl.voc"/>
    <tags-item tags="vblex.perf.pp.adj.mi.pl.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.mi.pl.voc"/>
    <tags-item tags="vbhaver.impf.pprs.mi.pl.voc"/>
  </def-label> 
  <def-label name="VPARTNTPLVOC">
    <tags-item tags="vaux.impf.pp.adj.nt.pl.voc"/>
    <tags-item tags="vbser.pprs.adj.nt.pl.voc"/>
    <tags-item tags="vblex.impf.pp.adj.nt.pl.voc"/>
    <tags-item tags="vblex.perf.pp.adj.nt.pl.voc"/>
    <tags-item tags="vblex.impf.pprs.adj.nt.pl.voc"/>
    <tags-item tags="vbhaver.impf.pprs.nt.pl.voc"/>
  </def-label> 

  <def-label name="DETFSGNOM">
    <tags-item tags="det.pos.f.sg.nom"/>
    <tags-item tags="det.pos.uns.f.sg.nom"/>
    <tags-item lemma="jeden" tags="num.f.sg.nom"/>
    <tags-item tags="det.qnt.f.sg.nom"/>
    <tags-item tags="det.ind.f.sg.nom"/>
    <tags-item tags="det.itg.f.sg.nom"/>
    <tags-item tags="det.ord.f.sg.nom"/>
    <tags-item tags="det.dem.f.sg.nom"/>
  </def-label> 
  <def-label name="DETMASGNOM">
    <tags-item tags="det.pos.ma.sg.nom"/>
    <tags-item tags="det.pos.uns.ma.sg.nom"/>
    <tags-item lemma="jeden" tags="num.ma.sg.nom"/>
    <tags-item tags="det.qnt.ma.sg.nom"/>
    <tags-item tags="det.ind.ma.sg.nom"/>
    <tags-item tags="det.itg.ma.sg.nom"/>
    <tags-item tags="det.ord.ma.sg.nom"/>
    <tags-item tags="det.dem.ma.sg.nom"/>
  </def-label> 
  <def-label name="DETMISGNOM">
    <tags-item tags="det.pos.mi.sg.nom"/>
    <tags-item tags="det.pos.uns.mi.sg.nom"/>
    <tags-item lemma="jeden" tags="num.mi.sg.nom"/>
    <tags-item tags="det.qnt.mi.sg.nom"/>
    <tags-item tags="det.ind.mi.sg.nom"/>
    <tags-item tags="det.itg.mi.sg.nom"/>
    <tags-item tags="det.ord.mi.sg.nom"/>
    <tags-item tags="det.dem.mi.sg.nom"/>
  </def-label> 
  <def-label name="DETNTSGNOM">
    <tags-item tags="det.pos.nt.sg.nom"/>
    <tags-item tags="det.pos.uns.nt.sg.nom"/>
    <tags-item lemma="jeden" tags="num.nt.sg.nom"/>
    <tags-item tags="det.qnt.nt.sg.nom"/>
    <tags-item tags="det.ind.nt.sg.nom"/>
    <tags-item tags="det.itg.nt.sg.nom"/>
    <tags-item tags="det.ord.nt.sg.nom"/>
    <tags-item tags="det.dem.nt.sg.nom"/>
  </def-label> 
  <def-label name="DETFSGGEN">
    <tags-item tags="det.pos.f.sg.gen"/>
    <tags-item tags="det.pos.uns.f.sg.gen"/>
    <tags-item lemma="jeden" tags="num.f.sg.gen"/>
    <tags-item tags="det.qnt.f.sg.gen"/>
    <tags-item tags="det.ind.f.sg.gen"/>
    <tags-item tags="det.itg.f.sg.gen"/>
    <tags-item tags="det.ord.f.sg.gen"/>
    <tags-item tags="det.dem.f.sg.gen"/>
  </def-label> 
  <def-label name="DETMASGGEN">
    <tags-item tags="det.pos.ma.sg.gen"/>
    <tags-item tags="det.pos.uns.ma.sg.gen"/>
    <tags-item lemma="jeden" tags="num.ma.sg.gen"/>
    <tags-item tags="det.qnt.ma.sg.gen"/>
    <tags-item tags="det.ind.ma.sg.gen"/>
    <tags-item tags="det.itg.ma.sg.gen"/>
    <tags-item tags="det.ord.ma.sg.gen"/>
    <tags-item tags="det.dem.ma.sg.gen"/>
  </def-label> 
  <def-label name="DETMISGGEN">
    <tags-item tags="det.pos.mi.sg.gen"/>
    <tags-item tags="det.pos.uns.mi.sg.gen"/>
    <tags-item lemma="jeden" tags="num.mi.sg.gen"/>
    <tags-item tags="det.qnt.mi.sg.gen"/>
    <tags-item tags="det.ind.mi.sg.gen"/>
    <tags-item tags="det.itg.mi.sg.gen"/>
    <tags-item tags="det.ord.mi.sg.gen"/>
    <tags-item tags="det.dem.mi.sg.gen"/>
  </def-label> 
  <def-label name="DETNTSGGEN">
    <tags-item tags="det.pos.nt.sg.gen"/>
    <tags-item tags="det.pos.uns.nt.sg.gen"/>
    <tags-item lemma="jeden" tags="num.nt.sg.gen"/>
    <tags-item tags="det.qnt.nt.sg.gen"/>
    <tags-item tags="det.ind.nt.sg.gen"/>
    <tags-item tags="det.itg.nt.sg.gen"/>
    <tags-item tags="det.ord.nt.sg.gen"/>
    <tags-item tags="det.dem.nt.sg.gen"/>
  </def-label> 
  <def-label name="DETFSGDAT">
    <tags-item tags="det.pos.f.sg.dat"/>
    <tags-item tags="det.pos.uns.f.sg.dat"/>
    <tags-item lemma="jeden" tags="num.f.sg.dat"/>
    <tags-item tags="det.qnt.f.sg.dat"/>
    <tags-item tags="det.ind.f.sg.dat"/>
    <tags-item tags="det.itg.f.sg.dat"/>
    <tags-item tags="det.ord.f.sg.dat"/>
    <tags-item tags="det.dem.f.sg.dat"/>
  </def-label> 
  <def-label name="DETMASGDAT">
    <tags-item tags="det.pos.ma.sg.dat"/>
    <tags-item lemma="jeden" tags="num.ma.sg.dat"/>
    <tags-item tags="det.qnt.ma.sg.dat"/>
    <tags-item tags="det.ind.ma.sg.dat"/>
    <tags-item tags="det.itg.ma.sg.dat"/>
    <tags-item tags="det.ord.ma.sg.dat"/>
    <tags-item tags="det.dem.ma.sg.dat"/>
  </def-label> 
  <def-label name="DETMISGDAT">
    <tags-item tags="det.pos.mi.sg.dat"/>
    <tags-item lemma="jeden" tags="num.mi.sg.dat"/>
    <tags-item tags="det.qnt.mi.sg.dat"/>
    <tags-item tags="det.ind.mi.sg.dat"/>
    <tags-item tags="det.itg.mi.sg.dat"/>
    <tags-item tags="det.ord.mi.sg.dat"/>
    <tags-item tags="det.dem.mi.sg.dat"/>
  </def-label> 
  <def-label name="DETNTSGDAT">
    <tags-item tags="det.pos.nt.sg.dat"/>
    <tags-item lemma="jeden" tags="num.nt.sg.dat"/>
    <tags-item tags="det.qnt.nt.sg.dat"/>
    <tags-item tags="det.ind.nt.sg.dat"/>
    <tags-item tags="det.itg.nt.sg.dat"/>
    <tags-item tags="det.ord.nt.sg.dat"/>
    <tags-item tags="det.dem.nt.sg.dat"/>
  </def-label> 
  <def-label name="DETFSGACC">
    <tags-item tags="det.pos.f.sg.acc"/>
    <tags-item tags="det.pos.uns.f.sg.acc"/>
    <tags-item lemma="jeden" tags="num.f.sg.acc"/>
    <tags-item tags="det.qnt.f.sg.acc"/>
    <tags-item tags="det.ind.f.sg.acc"/>
    <tags-item tags="det.itg.f.sg.acc"/>
    <tags-item tags="det.ord.f.sg.acc"/>
    <tags-item tags="det.dem.f.sg.acc"/>
  </def-label> 
  <def-label name="DETMASGACC">
    <tags-item tags="det.pos.ma.sg.acc"/>
    <tags-item tags="det.pos.uns.ma.sg.acc"/>
    <tags-item lemma="jeden" tags="num.ma.sg.acc"/>
    <tags-item tags="det.qnt.ma.sg.acc"/>
    <tags-item tags="det.ind.ma.sg.acc"/>
    <tags-item tags="det.itg.ma.sg.acc"/>
    <tags-item tags="det.ord.ma.sg.acc"/>
    <tags-item tags="det.dem.ma.sg.acc"/>
  </def-label> 
  <def-label name="DETMISGACC">
    <tags-item tags="det.pos.mi.sg.acc"/>
    <tags-item tags="det.pos.uns.mi.sg.acc"/>
    <tags-item lemma="jeden" tags="num.mi.sg.acc"/>
    <tags-item tags="det.qnt.mi.sg.acc"/>
    <tags-item tags="det.ind.mi.sg.acc"/>
    <tags-item tags="det.itg.mi.sg.acc"/>
    <tags-item tags="det.ord.mi.sg.acc"/>
    <tags-item tags="det.dem.mi.sg.acc"/>
  </def-label> 
  <def-label name="DETNTSGACC">
    <tags-item tags="det.pos.nt.sg.acc"/>
    <tags-item tags="det.pos.uns.nt.sg.acc"/>
    <tags-item lemma="jeden" tags="num.nt.sg.acc"/>
    <tags-item tags="det.qnt.nt.sg.acc"/>
    <tags-item tags="det.ind.nt.sg.acc"/>
    <tags-item tags="det.itg.nt.sg.acc"/>
    <tags-item tags="det.ord.nt.sg.acc"/>
    <tags-item tags="det.dem.nt.sg.acc"/>
  </def-label> 
  <def-label name="DETFSGINS">
    <tags-item tags="det.pos.f.sg.ins"/>
    <tags-item tags="det.pos.uns.f.sg.ins"/>
    <tags-item lemma="jeden" tags="num.f.sg.ins"/>
    <tags-item tags="det.qnt.f.sg.ins"/>
    <tags-item tags="det.ind.f.sg.ins"/>
    <tags-item tags="det.itg.f.sg.ins"/>
    <tags-item tags="det.ord.f.sg.ins"/>
    <tags-item tags="det.dem.f.sg.ins"/>
  </def-label> 
  <def-label name="DETMASGINS">
    <tags-item tags="det.pos.ma.sg.ins"/>
    <tags-item tags="det.pos.uns.ma.sg.ins"/>
    <tags-item lemma="jeden" tags="num.ma.sg.ins"/>
    <tags-item tags="det.qnt.ma.sg.ins"/>
    <tags-item tags="det.ind.ma.sg.ins"/>
    <tags-item tags="det.itg.ma.sg.ins"/>
    <tags-item tags="det.ord.ma.sg.ins"/>
    <tags-item tags="det.dem.ma.sg.ins"/>
  </def-label> 
  <def-label name="DETMISGINS">
    <tags-item tags="det.pos.mi.sg.ins"/>
    <tags-item tags="det.pos.uns.mi.sg.ins"/>
    <tags-item lemma="jeden" tags="num.mi.sg.ins"/>
    <tags-item tags="det.qnt.mi.sg.ins"/>
    <tags-item tags="det.ind.mi.sg.ins"/>
    <tags-item tags="det.itg.mi.sg.ins"/>
    <tags-item tags="det.ord.mi.sg.ins"/>
    <tags-item tags="det.dem.mi.sg.ins"/>
  </def-label> 
  <def-label name="DETNTSGINS">
    <tags-item tags="det.pos.nt.sg.ins"/>
    <tags-item tags="det.pos.uns.nt.sg.ins"/>
    <tags-item lemma="jeden" tags="num.nt.sg.ins"/>
    <tags-item tags="det.qnt.nt.sg.ins"/>
    <tags-item tags="det.ind.nt.sg.ins"/>
    <tags-item tags="det.itg.nt.sg.ins"/>
    <tags-item tags="det.ord.nt.sg.ins"/>
    <tags-item tags="det.dem.nt.sg.ins"/>
  </def-label> 
  <def-label name="DETFSGLOC">
    <tags-item tags="det.pos.f.sg.loc"/>
    <tags-item tags="det.pos.uns.f.sg.loc"/>
    <tags-item lemma="jeden" tags="num.f.sg.loc"/>
    <tags-item tags="det.qnt.f.sg.loc"/>
    <tags-item tags="det.ind.f.sg.loc"/>
    <tags-item tags="det.itg.f.sg.loc"/>
    <tags-item tags="det.ord.f.sg.loc"/>
    <tags-item tags="det.dem.f.sg.loc"/>
  </def-label> 
  <def-label name="DETMASGLOC">
    <tags-item tags="det.pos.ma.sg.loc"/>
    <tags-item lemma="jeden" tags="num.ma.sg.loc"/>
    <tags-item tags="det.qnt.ma.sg.loc"/>
    <tags-item tags="det.ind.ma.sg.loc"/>
    <tags-item tags="det.itg.ma.sg.loc"/>
    <tags-item tags="det.ord.ma.sg.loc"/>
    <tags-item tags="det.dem.ma.sg.loc"/>
  </def-label> 
  <def-label name="DETMISGLOC">
    <tags-item tags="det.pos.mi.sg.loc"/>
    <tags-item lemma="jeden" tags="num.mi.sg.loc"/>
    <tags-item tags="det.qnt.mi.sg.loc"/>
    <tags-item tags="det.ind.mi.sg.loc"/>
    <tags-item tags="det.itg.mi.sg.loc"/>
    <tags-item tags="det.ord.mi.sg.loc"/>
    <tags-item tags="det.dem.mi.sg.loc"/>
  </def-label> 
  <def-label name="DETNTSGLOC">
    <tags-item tags="det.pos.nt.sg.loc"/>
    <tags-item lemma="jeden" tags="num.nt.sg.loc"/>
    <tags-item tags="det.qnt.nt.sg.loc"/>
    <tags-item tags="det.ind.nt.sg.loc"/>
    <tags-item tags="det.itg.nt.sg.loc"/>
    <tags-item tags="det.ord.nt.sg.loc"/>
    <tags-item tags="det.dem.nt.sg.loc"/>
  </def-label> 
  <def-label name="DETFSGVOC">
    <tags-item tags="det.pos.f.sg.voc"/>
    <tags-item tags="det.pos.uns.f.sg.voc"/>
    <tags-item lemma="jeden" tags="num.f.sg.voc"/>
    <tags-item tags="det.qnt.f.sg.voc"/>
    <tags-item tags="det.ind.f.sg.voc"/>
    <tags-item tags="det.itg.f.sg.voc"/>
    <tags-item tags="det.ord.f.sg.voc"/>
    <tags-item tags="det.dem.f.sg.voc"/>
  </def-label> 
  <def-label name="DETMASGVOC">
    <tags-item tags="det.pos.ma.sg.voc"/>
    <tags-item tags="det.pos.uns.ma.sg.voc"/>
    <tags-item lemma="jeden" tags="num.ma.sg.voc"/>
    <tags-item tags="det.qnt.ma.sg.voc"/>
    <tags-item tags="det.ind.ma.sg.voc"/>
    <tags-item tags="det.itg.ma.sg.voc"/>
    <tags-item tags="det.ord.ma.sg.voc"/>
    <tags-item tags="det.dem.ma.sg.voc"/>
  </def-label> 
  <def-label name="DETMISGVOC">
    <tags-item tags="det.pos.mi.sg.voc"/>
    <tags-item tags="det.pos.uns.mi.sg.voc"/>
    <tags-item lemma="jeden" tags="num.mi.sg.voc"/>
    <tags-item tags="det.qnt.mi.sg.voc"/>
    <tags-item tags="det.ind.mi.sg.voc"/>
    <tags-item tags="det.itg.mi.sg.voc"/>
    <tags-item tags="det.ord.mi.sg.voc"/>
    <tags-item tags="det.dem.mi.sg.voc"/>
  </def-label> 
  <def-label name="DETNTSGVOC">
    <tags-item tags="det.pos.nt.sg.voc"/>
    <tags-item tags="det.pos.uns.nt.sg.voc"/>
    <tags-item lemma="jeden" tags="num.nt.sg.voc"/>
    <tags-item tags="det.qnt.nt.sg.voc"/>
    <tags-item tags="det.ind.nt.sg.voc"/>
    <tags-item tags="det.itg.nt.sg.voc"/>
    <tags-item tags="det.ord.nt.sg.voc"/>
    <tags-item tags="det.dem.nt.sg.voc"/>
  </def-label> 
  <def-label name="DETFPLNOM">
    <tags-item tags="det.pos.f.pl.nom"/>
    <tags-item tags="det.pos.uns.f.pl.nom"/>
    <tags-item lemma="jeden" tags="num.f.pl.nom"/>
    <tags-item lemma="dva" tags="num.f.pl.nom"/>
    <tags-item tags="det.qnt.f.pl.nom"/>
    <tags-item tags="det.ind.f.pl.nom"/>
    <tags-item tags="det.itg.f.pl.nom"/>
    <tags-item tags="det.ord.f.pl.nom"/>
    <tags-item tags="det.dem.f.pl.nom"/>
  </def-label> 
  <def-label name="DETMAPLNOM">
    <tags-item tags="det.pos.ma.pl.nom"/>
    <tags-item tags="det.pos.uns.ma.pl.nom"/>
    <tags-item lemma="jeden" tags="num.ma.pl.nom"/>
    <tags-item lemma="dva" tags="num.ma.pl.nom"/>
    <tags-item tags="det.qnt.ma.pl.nom"/>
    <tags-item tags="det.ind.ma.pl.nom"/>
    <tags-item tags="det.itg.ma.pl.nom"/>
    <tags-item tags="det.ord.ma.pl.nom"/>
    <tags-item tags="det.dem.ma.pl.nom"/>
  </def-label> 
  <def-label name="DETMIPLNOM">
    <tags-item tags="det.pos.mi.pl.nom"/>
    <tags-item tags="det.pos.uns.mi.pl.nom"/>
    <tags-item lemma="jeden" tags="num.mi.pl.nom"/>
    <tags-item lemma="dva" tags="num.mi.pl.nom"/>
    <tags-item tags="det.qnt.mi.pl.nom"/>
    <tags-item tags="det.ind.mi.pl.nom"/>
    <tags-item tags="det.itg.mi.pl.nom"/>
    <tags-item tags="det.ord.mi.pl.nom"/>
    <tags-item tags="det.dem.mi.pl.nom"/>
  </def-label> 
  <def-label name="DETNTPLNOM">
    <tags-item tags="det.pos.nt.pl.nom"/>
    <tags-item tags="det.pos.uns.nt.pl.nom"/>
    <tags-item lemma="jeden" tags="num.nt.pl.nom"/>
    <tags-item lemma="dva" tags="num.nt.pl.nom"/>
    <tags-item tags="det.qnt.nt.pl.nom"/>
    <tags-item tags="det.ind.nt.pl.nom"/>
    <tags-item tags="det.itg.nt.pl.nom"/>
    <tags-item tags="det.ord.nt.pl.nom"/>
    <tags-item tags="det.dem.nt.pl.nom"/>
  </def-label> 
  <def-label name="DETFPLGEN">
    <tags-item tags="det.pos.f.pl.gen"/>
    <tags-item lemma="jeden" tags="num.f.pl.gen"/>
    <tags-item lemma="dva" tags="num.f.pl.gen"/>
    <tags-item tags="det.qnt.f.pl.gen"/>
    <tags-item tags="det.ind.f.pl.gen"/>
    <tags-item tags="det.itg.f.pl.gen"/>
    <tags-item tags="det.ord.f.pl.gen"/>
    <tags-item tags="det.dem.f.pl.gen"/>
  </def-label> 
  <def-label name="DETMAPLGEN">
    <tags-item tags="det.pos.ma.pl.gen"/>
    <tags-item lemma="jeden" tags="num.ma.pl.gen"/>
    <tags-item lemma="dva" tags="num.ma.pl.gen"/>
    <tags-item tags="det.qnt.ma.pl.gen"/>
    <tags-item tags="det.ind.ma.pl.gen"/>
    <tags-item tags="det.itg.ma.pl.gen"/>
    <tags-item tags="det.ord.ma.pl.gen"/>
    <tags-item tags="det.dem.ma.pl.gen"/>
  </def-label> 
  <def-label name="DETMIPLGEN">
    <tags-item tags="det.pos.mi.pl.gen"/>
    <tags-item lemma="jeden" tags="num.mi.pl.gen"/>
    <tags-item lemma="dva" tags="num.mi.pl.gen"/>
    <tags-item tags="det.qnt.mi.pl.gen"/>
    <tags-item tags="det.ind.mi.pl.gen"/>
    <tags-item tags="det.itg.mi.pl.gen"/>
    <tags-item tags="det.ord.mi.pl.gen"/>
    <tags-item tags="det.dem.mi.pl.gen"/>
  </def-label> 
  <def-label name="DETNTPLGEN">
    <tags-item tags="det.pos.nt.pl.gen"/>
    <tags-item lemma="jeden" tags="num.nt.pl.gen"/>
    <tags-item lemma="dva" tags="num.nt.pl.gen"/>
    <tags-item tags="det.qnt.nt.pl.gen"/>
    <tags-item tags="det.ind.nt.pl.gen"/>
    <tags-item tags="det.itg.nt.pl.gen"/>
    <tags-item tags="det.ord.nt.pl.gen"/>
    <tags-item tags="det.dem.nt.pl.gen"/>
  </def-label> 
  <def-label name="DETFPLDAT">
    <tags-item tags="det.pos.f.pl.dat"/>
    <tags-item lemma="jeden" tags="num.f.pl.dat"/>
    <tags-item lemma="dva" tags="num.f.pl.dat"/>
    <tags-item tags="det.qnt.f.pl.dat"/>
    <tags-item tags="det.ind.f.pl.dat"/>
    <tags-item tags="det.itg.f.pl.dat"/>
    <tags-item tags="det.ord.f.pl.dat"/>
    <tags-item tags="det.dem.f.pl.dat"/>
  </def-label> 
  <def-label name="DETMAPLDAT">
    <tags-item tags="det.pos.ma.pl.dat"/>
    <tags-item lemma="jeden" tags="num.ma.pl.dat"/>
    <tags-item lemma="dva" tags="num.ma.pl.dat"/>
    <tags-item tags="det.qnt.ma.pl.dat"/>
    <tags-item tags="det.ind.ma.pl.dat"/>
    <tags-item tags="det.itg.ma.pl.dat"/>
    <tags-item tags="det.ord.ma.pl.dat"/>
    <tags-item tags="det.dem.ma.pl.dat"/>
  </def-label> 
  <def-label name="DETMIPLDAT">
    <tags-item tags="det.pos.mi.pl.dat"/>
    <tags-item lemma="jeden" tags="num.mi.pl.dat"/>
    <tags-item lemma="dva" tags="num.mi.pl.dat"/>
    <tags-item tags="det.qnt.mi.pl.dat"/>
    <tags-item tags="det.ind.mi.pl.dat"/>
    <tags-item tags="det.itg.mi.pl.dat"/>
    <tags-item tags="det.ord.mi.pl.dat"/>
    <tags-item tags="det.dem.mi.pl.dat"/>
  </def-label> 
  <def-label name="DETNTPLDAT">
    <tags-item tags="det.pos.nt.pl.dat"/>
    <tags-item lemma="jeden" tags="num.nt.pl.dat"/>
    <tags-item lemma="dva" tags="num.nt.pl.dat"/>
    <tags-item tags="det.qnt.nt.pl.dat"/>
    <tags-item tags="det.ind.nt.pl.dat"/>
    <tags-item tags="det.itg.nt.pl.dat"/>
    <tags-item tags="det.ord.nt.pl.dat"/>
    <tags-item tags="det.dem.nt.pl.dat"/>
  </def-label> 
  <def-label name="DETFPLACC">
    <tags-item tags="det.pos.f.pl.acc"/>
    <tags-item tags="det.pos.uns.f.pl.acc"/>
    <tags-item lemma="jeden" tags="num.f.pl.acc"/>
    <tags-item lemma="dva" tags="num.f.pl.acc"/>
    <tags-item tags="det.qnt.f.pl.acc"/>
    <tags-item tags="det.ind.f.pl.acc"/>
    <tags-item tags="det.itg.f.pl.acc"/>
    <tags-item tags="det.ord.f.pl.acc"/>
    <tags-item tags="det.dem.f.pl.acc"/>
  </def-label> 
  <def-label name="DETMAPLACC">
    <tags-item tags="det.pos.ma.pl.acc"/>
    <tags-item tags="det.pos.uns.ma.pl.acc"/>
    <tags-item lemma="jeden" tags="num.ma.pl.acc"/>
    <tags-item lemma="dva" tags="num.ma.pl.acc"/>
    <tags-item tags="det.qnt.ma.pl.acc"/>
    <tags-item tags="det.ind.ma.pl.acc"/>
    <tags-item tags="det.itg.ma.pl.acc"/>
    <tags-item tags="det.ord.ma.pl.acc"/>
    <tags-item tags="det.dem.ma.pl.acc"/>
  </def-label> 
  <def-label name="DETMIPLACC">
    <tags-item tags="det.pos.mi.pl.acc"/>
    <tags-item tags="det.pos.uns.mi.pl.acc"/>
    <tags-item lemma="jeden" tags="num.mi.pl.acc"/>
    <tags-item lemma="dva" tags="num.mi.pl.acc"/>
    <tags-item tags="det.qnt.mi.pl.acc"/>
    <tags-item tags="det.ind.mi.pl.acc"/>
    <tags-item tags="det.itg.mi.pl.acc"/>
    <tags-item tags="det.ord.mi.pl.acc"/>
    <tags-item tags="det.dem.mi.pl.acc"/>
  </def-label> 
  <def-label name="DETNTPLACC">
    <tags-item tags="det.pos.nt.pl.acc"/>
    <tags-item tags="det.pos.uns.nt.pl.acc"/>
    <tags-item lemma="jeden" tags="num.nt.pl.acc"/>
    <tags-item lemma="dva" tags="num.nt.pl.acc"/>
    <tags-item tags="det.qnt.nt.pl.acc"/>
    <tags-item tags="det.ind.nt.pl.acc"/>
    <tags-item tags="det.itg.nt.pl.acc"/>
    <tags-item tags="det.ord.nt.pl.acc"/>
    <tags-item tags="det.dem.nt.pl.acc"/>
  </def-label> 
  <def-label name="DETFPLINS">
    <tags-item tags="det.pos.f.pl.ins"/>
    <tags-item lemma="jeden" tags="num.f.pl.ins"/>
    <tags-item lemma="dva" tags="num.f.pl.ins"/>
    <tags-item tags="det.qnt.f.pl.ins"/>
    <tags-item tags="det.ind.f.pl.ins"/>
    <tags-item tags="det.itg.f.pl.ins"/>
    <tags-item tags="det.ord.f.pl.ins"/>
    <tags-item tags="det.dem.f.pl.ins"/>
  </def-label> 
  <def-label name="DETMAPLINS">
    <tags-item tags="det.pos.ma.pl.ins"/>
    <tags-item lemma="jeden" tags="num.ma.pl.ins"/>
    <tags-item lemma="dva" tags="num.ma.pl.ins"/>
    <tags-item tags="det.qnt.ma.pl.ins"/>
    <tags-item tags="det.ind.ma.pl.ins"/>
    <tags-item tags="det.itg.ma.pl.ins"/>
    <tags-item tags="det.ord.ma.pl.ins"/>
    <tags-item tags="det.dem.ma.pl.ins"/>
  </def-label> 
  <def-label name="DETMIPLINS">
    <tags-item tags="det.pos.mi.pl.ins"/>
    <tags-item lemma="jeden" tags="num.mi.pl.ins"/>
    <tags-item lemma="dva" tags="num.mi.pl.ins"/>
    <tags-item tags="det.qnt.mi.pl.ins"/>
    <tags-item tags="det.ind.mi.pl.ins"/>
    <tags-item tags="det.itg.mi.pl.ins"/>
    <tags-item tags="det.ord.mi.pl.ins"/>
    <tags-item tags="det.dem.mi.pl.ins"/>
  </def-label> 
  <def-label name="DETNTPLINS">
    <tags-item tags="det.pos.nt.pl.ins"/>
    <tags-item lemma="jeden" tags="num.nt.pl.ins"/>
    <tags-item lemma="dva" tags="num.nt.pl.ins"/>
    <tags-item tags="det.qnt.nt.pl.ins"/>
    <tags-item tags="det.ind.nt.pl.ins"/>
    <tags-item tags="det.itg.nt.pl.ins"/>
    <tags-item tags="det.ord.nt.pl.ins"/>
    <tags-item tags="det.dem.nt.pl.ins"/>
  </def-label> 
  <def-label name="DETFPLLOC">
    <tags-item tags="det.pos.f.pl.loc"/>
    <tags-item lemma="jeden" tags="num.f.pl.loc"/>
    <tags-item lemma="dva" tags="num.f.pl.loc"/>
    <tags-item tags="det.qnt.f.pl.loc"/>
    <tags-item tags="det.ind.f.pl.loc"/>
    <tags-item tags="det.itg.f.pl.loc"/>
    <tags-item tags="det.ord.f.pl.loc"/>
    <tags-item tags="det.dem.f.pl.loc"/>
  </def-label> 
  <def-label name="DETMAPLLOC">
    <tags-item tags="det.pos.ma.pl.loc"/>
    <tags-item lemma="jeden" tags="num.ma.pl.loc"/>
    <tags-item lemma="dva" tags="num.ma.pl.loc"/>
    <tags-item tags="det.qnt.ma.pl.loc"/>
    <tags-item tags="det.ind.ma.pl.loc"/>
    <tags-item tags="det.itg.ma.pl.loc"/>
    <tags-item tags="det.ord.ma.pl.loc"/>
    <tags-item tags="det.dem.ma.pl.loc"/>
  </def-label> 
  <def-label name="DETMIPLLOC">
    <tags-item tags="det.pos.mi.pl.loc"/>
    <tags-item lemma="jeden" tags="num.mi.pl.loc"/>
    <tags-item lemma="dva" tags="num.mi.pl.loc"/>
    <tags-item tags="det.qnt.mi.pl.loc"/>
    <tags-item tags="det.ind.mi.pl.loc"/>
    <tags-item tags="det.itg.mi.pl.loc"/>
    <tags-item tags="det.ord.mi.pl.loc"/>
    <tags-item tags="det.dem.mi.pl.loc"/>
  </def-label> 
  <def-label name="DETNTPLLOC">
    <tags-item tags="det.pos.nt.pl.loc"/>
    <tags-item lemma="jeden" tags="num.nt.pl.loc"/>
    <tags-item lemma="dva" tags="num.nt.pl.loc"/>
    <tags-item tags="det.qnt.nt.pl.loc"/>
    <tags-item tags="det.ind.nt.pl.loc"/>
    <tags-item tags="det.itg.nt.pl.loc"/>
    <tags-item tags="det.ord.nt.pl.loc"/>
    <tags-item tags="det.dem.nt.pl.loc"/>
  </def-label> 
  <def-label name="DETFPLVOC">
    <tags-item tags="det.pos.f.pl.voc"/>
    <tags-item tags="det.pos.uns.f.pl.voc"/>
    <tags-item lemma="jeden" tags="num.f.pl.voc"/>
    <tags-item lemma="dva" tags="num.f.pl.voc"/>
    <tags-item tags="det.qnt.f.pl.voc"/>
    <tags-item tags="det.ind.f.pl.voc"/>
    <tags-item tags="det.itg.f.pl.voc"/>
    <tags-item tags="det.ord.f.pl.voc"/>
    <tags-item tags="det.dem.f.pl.voc"/>
  </def-label> 
  <def-label name="DETMAPLVOC">
    <tags-item tags="det.pos.ma.pl.voc"/>
    <tags-item tags="det.pos.uns.ma.pl.voc"/>
    <tags-item lemma="jeden" tags="num.ma.pl.voc"/>
    <tags-item lemma="dva" tags="num.ma.pl.voc"/>
    <tags-item tags="det.qnt.ma.pl.voc"/>
    <tags-item tags="det.ind.ma.pl.voc"/>
    <tags-item tags="det.itg.ma.pl.voc"/>
    <tags-item tags="det.ord.ma.pl.voc"/>
    <tags-item tags="det.dem.ma.pl.voc"/>
  </def-label> 
  <def-label name="DETMIPLVOC">
    <tags-item tags="det.pos.mi.pl.voc"/>
    <tags-item tags="det.pos.uns.mi.pl.voc"/>
    <tags-item lemma="jeden" tags="num.mi.pl.voc"/>
    <tags-item lemma="dva" tags="num.mi.pl.voc"/>
    <tags-item tags="det.qnt.mi.pl.voc"/>
    <tags-item tags="det.ind.mi.pl.voc"/>
    <tags-item tags="det.itg.mi.pl.voc"/>
    <tags-item tags="det.ord.mi.pl.voc"/>
    <tags-item tags="det.dem.mi.pl.voc"/>
  </def-label> 
  <def-label name="DETNTPLVOC">
    <tags-item tags="det.pos.nt.pl.voc"/>
    <tags-item tags="det.pos.uns.nt.pl.voc"/>
    <tags-item lemma="jeden" tags="num.nt.pl.voc"/>
    <tags-item lemma="dva" tags="num.nt.pl.voc"/>
    <tags-item tags="det.qnt.nt.pl.voc"/>
    <tags-item tags="det.ind.nt.pl.voc"/>
    <tags-item tags="det.itg.nt.pl.voc"/>
    <tags-item tags="det.ord.nt.pl.voc"/>
    <tags-item tags="det.dem.nt.pl.voc"/>
  </def-label> 

  <def-label name="PRNFSGNOM">
    <tags-item tags="prn.pos.f.sg.nom"/>
    <tags-item tags="prn.pos.uns.f.sg.nom"/>
    <tags-item tags="prn.ind.f.sg.nom"/>
    <tags-item tags="prn.itg.f.sg.nom"/>
  </def-label> 
  <def-label name="PRNMASGNOM">
    <tags-item tags="prn.pos.ma.sg.nom"/>
    <tags-item tags="prn.pos.uns.ma.sg.nom"/>
    <tags-item tags="prn.ind.ma.sg.nom"/>
    <tags-item tags="prn.itg.ma.sg.nom"/>
  </def-label> 
  <def-label name="PRNMISGNOM">
    <tags-item tags="prn.pos.mi.sg.nom"/>
    <tags-item tags="prn.pos.uns.mi.sg.nom"/>
    <tags-item tags="prn.ind.mi.sg.nom"/>
    <tags-item tags="prn.itg.mi.sg.nom"/>
  </def-label> 
  <def-label name="PRNNTSGNOM">
    <tags-item tags="prn.pos.nt.sg.nom"/>
    <tags-item tags="prn.pos.uns.nt.sg.nom"/>
    <tags-item tags="prn.ind.nt.sg.nom"/>
    <tags-item tags="prn.itg.nt.sg.nom"/>
  </def-label> 
  <def-label name="PRNFSGGEN">
    <tags-item tags="prn.pos.f.sg.gen"/>
    <tags-item tags="prn.pos.uns.f.sg.gen"/>
    <tags-item tags="prn.ind.f.sg.gen"/>
    <tags-item tags="prn.itg.f.sg.gen"/>
  </def-label> 
  <def-label name="PRNMASGGEN">
    <tags-item tags="prn.pos.ma.sg.gen"/>
    <tags-item tags="prn.ind.ma.sg.gen"/>
    <tags-item tags="prn.itg.ma.sg.gen"/>
  </def-label> 
  <def-label name="PRNMISGGEN">
    <tags-item tags="prn.pos.mi.sg.gen"/>
    <tags-item tags="prn.ind.mi.sg.gen"/>
    <tags-item tags="prn.itg.mi.sg.gen"/>
  </def-label> 
  <def-label name="PRNNTSGGEN">
    <tags-item tags="prn.pos.nt.sg.gen"/>
    <tags-item tags="prn.ind.nt.sg.gen"/>
    <tags-item tags="prn.itg.nt.sg.gen"/>
  </def-label> 
  <def-label name="PRNFSGDAT">
    <tags-item tags="prn.pos.f.sg.dat"/>
    <tags-item tags="prn.pos.uns.f.sg.dat"/>
    <tags-item tags="prn.ind.f.sg.dat"/>
    <tags-item tags="prn.itg.f.sg.dat"/>
  </def-label> 
  <def-label name="PRNMASGDAT">
    <tags-item tags="prn.pos.ma.sg.dat"/>
    <tags-item tags="prn.ind.ma.sg.dat"/>
    <tags-item tags="prn.itg.ma.sg.dat"/>
  </def-label> 
  <def-label name="PRNMISGDAT">
    <tags-item tags="prn.pos.mi.sg.dat"/>
    <tags-item tags="prn.ind.mi.sg.dat"/>
    <tags-item tags="prn.itg.mi.sg.dat"/>
  </def-label> 
  <def-label name="PRNNTSGDAT">
    <tags-item tags="prn.pos.nt.sg.dat"/>
    <tags-item tags="prn.ind.nt.sg.dat"/>
    <tags-item tags="prn.itg.nt.sg.dat"/>
  </def-label> 
  <def-label name="PRNFSGACC">
    <tags-item tags="prn.pos.f.sg.acc"/>
    <tags-item tags="prn.pos.uns.f.sg.acc"/>
    <tags-item tags="prn.ind.f.sg.acc"/>
    <tags-item tags="prn.itg.f.sg.acc"/>
  </def-label> 
  <def-label name="PRNMASGACC">
    <tags-item tags="prn.pos.ma.sg.acc"/>
    <tags-item tags="prn.pos.uns.ma.sg.acc"/>
    <tags-item tags="prn.ind.ma.sg.acc"/>
    <tags-item tags="prn.itg.ma.sg.acc"/>
  </def-label> 
  <def-label name="PRNMISGACC">
    <tags-item tags="prn.pos.mi.sg.acc"/>
    <tags-item tags="prn.pos.uns.mi.sg.acc"/>
    <tags-item tags="prn.ind.mi.sg.acc"/>
    <tags-item tags="prn.itg.mi.sg.acc"/>
  </def-label> 
  <def-label name="PRNNTSGACC">
    <tags-item tags="prn.pos.nt.sg.acc"/>
    <tags-item tags="prn.pos.uns.nt.sg.acc"/>
    <tags-item tags="prn.ind.nt.sg.acc"/>
    <tags-item tags="prn.itg.nt.sg.acc"/>
  </def-label> 
  <def-label name="PRNFSGINS">
    <tags-item tags="prn.pos.f.sg.ins"/>
    <tags-item tags="prn.pos.uns.f.sg.ins"/>
    <tags-item tags="prn.ind.f.sg.ins"/>
    <tags-item tags="prn.itg.f.sg.ins"/>
  </def-label> 
  <def-label name="PRNMASGINS">
    <tags-item tags="prn.pos.ma.sg.ins"/>
    <tags-item tags="prn.ind.ma.sg.ins"/>
    <tags-item tags="prn.itg.ma.sg.ins"/>
  </def-label> 
  <def-label name="PRNMISGINS">
    <tags-item tags="prn.pos.mi.sg.ins"/>
    <tags-item tags="prn.ind.mi.sg.ins"/>
    <tags-item tags="prn.itg.mi.sg.ins"/>
  </def-label> 
  <def-label name="PRNNTSGINS">
    <tags-item tags="prn.pos.nt.sg.ins"/>
    <tags-item tags="prn.ind.nt.sg.ins"/>
    <tags-item tags="prn.itg.nt.sg.ins"/>
  </def-label> 
  <def-label name="PRNFSGLOC">
    <tags-item tags="prn.pos.f.sg.loc"/>
    <tags-item tags="prn.pos.uns.f.sg.loc"/>
    <tags-item tags="prn.ind.f.sg.loc"/>
    <tags-item tags="prn.itg.f.sg.loc"/>
  </def-label> 
  <def-label name="PRNMASGLOC">
    <tags-item tags="prn.pos.ma.sg.loc"/>
    <tags-item tags="prn.ind.ma.sg.loc"/>
    <tags-item tags="prn.itg.ma.sg.loc"/>
  </def-label> 
  <def-label name="PRNMISGLOC">
    <tags-item tags="prn.pos.mi.sg.loc"/>
    <tags-item tags="prn.ind.mi.sg.loc"/>
    <tags-item tags="prn.itg.mi.sg.loc"/>
  </def-label> 
  <def-label name="PRNNTSGLOC">
    <tags-item tags="prn.pos.nt.sg.loc"/>
    <tags-item tags="prn.ind.nt.sg.loc"/>
    <tags-item tags="prn.itg.nt.sg.loc"/>
  </def-label> 
  <def-label name="PRNFSGVOC">
    <tags-item tags="prn.pos.f.sg.voc"/>
    <tags-item tags="prn.pos.uns.f.sg.voc"/>
    <tags-item tags="prn.ind.f.sg.voc"/>
    <tags-item tags="prn.itg.f.sg.voc"/>
  </def-label> 
  <def-label name="PRNMASGVOC">
    <tags-item tags="prn.pos.ma.sg.voc"/>
    <tags-item tags="prn.pos.uns.ma.sg.voc"/>
    <tags-item tags="prn.ind.ma.sg.voc"/>
    <tags-item tags="prn.itg.ma.sg.voc"/>
  </def-label> 
  <def-label name="PRNMISGVOC">
    <tags-item tags="prn.pos.mi.sg.voc"/>
    <tags-item tags="prn.pos.uns.mi.sg.voc"/>
    <tags-item tags="prn.ind.mi.sg.voc"/>
    <tags-item tags="prn.itg.mi.sg.voc"/>
  </def-label> 
  <def-label name="PRNNTSGVOC">
    <tags-item tags="prn.pos.nt.sg.voc"/>
    <tags-item tags="prn.pos.uns.nt.sg.voc"/>
    <tags-item tags="prn.ind.nt.sg.voc"/>
    <tags-item tags="prn.itg.nt.sg.voc"/>
  </def-label> 
  <def-label name="PRNFPLNOM">
    <tags-item tags="prn.pos.f.pl.nom"/>
    <tags-item tags="prn.pos.uns.f.pl.nom"/>
    <tags-item tags="prn.ind.f.pl.nom"/>
    <tags-item tags="prn.itg.f.pl.nom"/>
  </def-label> 
  <def-label name="PRNMAPLNOM">
    <tags-item tags="prn.pos.ma.pl.nom"/>
    <tags-item tags="prn.pos.uns.ma.pl.nom"/>
    <tags-item tags="prn.ind.ma.pl.nom"/>
    <tags-item tags="prn.itg.ma.pl.nom"/>
  </def-label> 
  <def-label name="PRNMIPLNOM">
    <tags-item tags="prn.pos.mi.pl.nom"/>
    <tags-item tags="prn.pos.uns.mi.pl.nom"/>
    <tags-item tags="prn.ind.mi.pl.nom"/>
    <tags-item tags="prn.itg.mi.pl.nom"/>
  </def-label> 
  <def-label name="PRNNTPLNOM">
    <tags-item tags="prn.pos.nt.pl.nom"/>
    <tags-item tags="prn.pos.uns.nt.pl.nom"/>
    <tags-item tags="prn.ind.nt.pl.nom"/>
    <tags-item tags="prn.itg.nt.pl.nom"/>
  </def-label> 
  <def-label name="PRNFPLGEN">
    <tags-item tags="prn.pos.f.pl.gen"/>
    <tags-item tags="prn.ind.f.pl.gen"/>
    <tags-item tags="prn.itg.f.pl.gen"/>
  </def-label> 
  <def-label name="PRNMAPLGEN">
    <tags-item tags="prn.pos.ma.pl.gen"/>
    <tags-item tags="prn.ind.ma.pl.gen"/>
    <tags-item tags="prn.itg.ma.pl.gen"/>
  </def-label> 
  <def-label name="PRNMIPLGEN">
    <tags-item tags="prn.pos.mi.pl.gen"/>
    <tags-item tags="prn.ind.mi.pl.gen"/>
    <tags-item tags="prn.itg.mi.pl.gen"/>
  </def-label> 
  <def-label name="PRNNTPLGEN">
    <tags-item tags="prn.pos.nt.pl.gen"/>
    <tags-item tags="prn.ind.nt.pl.gen"/>
    <tags-item tags="prn.itg.nt.pl.gen"/>
  </def-label> 
  <def-label name="PRNFPLDAT">
    <tags-item tags="prn.pos.f.pl.dat"/>
    <tags-item tags="prn.ind.f.pl.dat"/>
    <tags-item tags="prn.itg.f.pl.dat"/>
  </def-label> 
  <def-label name="PRNMAPLDAT">
    <tags-item tags="prn.pos.ma.pl.dat"/>
    <tags-item tags="prn.ind.ma.pl.dat"/>
    <tags-item tags="prn.itg.ma.pl.dat"/>
  </def-label> 
  <def-label name="PRNMIPLDAT">
    <tags-item tags="prn.pos.mi.pl.dat"/>
    <tags-item tags="prn.ind.mi.pl.dat"/>
    <tags-item tags="prn.itg.mi.pl.dat"/>
  </def-label> 
  <def-label name="PRNNTPLDAT">
    <tags-item tags="prn.pos.nt.pl.dat"/>
    <tags-item tags="prn.ind.nt.pl.dat"/>
    <tags-item tags="prn.itg.nt.pl.dat"/>
  </def-label> 
  <def-label name="PRNFPLACC">
    <tags-item tags="prn.pos.f.pl.acc"/>
    <tags-item tags="prn.pos.uns.f.pl.acc"/>
    <tags-item tags="prn.ind.f.pl.acc"/>
    <tags-item tags="prn.itg.f.pl.acc"/>
  </def-label> 
  <def-label name="PRNMAPLACC">
    <tags-item tags="prn.pos.ma.pl.acc"/>
    <tags-item tags="prn.pos.uns.ma.pl.acc"/>
    <tags-item tags="prn.ind.ma.pl.acc"/>
    <tags-item tags="prn.itg.ma.pl.acc"/>
  </def-label> 
  <def-label name="PRNMIPLACC">
    <tags-item tags="prn.pos.mi.pl.acc"/>
    <tags-item tags="prn.pos.uns.mi.pl.acc"/>
    <tags-item tags="prn.ind.mi.pl.acc"/>
    <tags-item tags="prn.itg.mi.pl.acc"/>
  </def-label> 
  <def-label name="PRNNTPLACC">
    <tags-item tags="prn.pos.nt.pl.acc"/>
    <tags-item tags="prn.pos.uns.nt.pl.acc"/>
    <tags-item tags="prn.ind.nt.pl.acc"/>
    <tags-item tags="prn.itg.nt.pl.acc"/>
  </def-label> 
  <def-label name="PRNFPLINS">
    <tags-item tags="prn.pos.f.pl.ins"/>
    <tags-item tags="prn.ind.f.pl.ins"/>
    <tags-item tags="prn.itg.f.pl.ins"/>
  </def-label> 
  <def-label name="PRNMAPLINS">
    <tags-item tags="prn.pos.ma.pl.ins"/>
    <tags-item tags="prn.ind.ma.pl.ins"/>
    <tags-item tags="prn.itg.ma.pl.ins"/>
  </def-label> 
  <def-label name="PRNMIPLINS">
    <tags-item tags="prn.pos.mi.pl.ins"/>
    <tags-item tags="prn.ind.mi.pl.ins"/>
    <tags-item tags="prn.itg.mi.pl.ins"/>
  </def-label> 
  <def-label name="PRNNTPLINS">
    <tags-item tags="prn.pos.nt.pl.ins"/>
    <tags-item tags="prn.ind.nt.pl.ins"/>
    <tags-item tags="prn.itg.nt.pl.ins"/>
  </def-label> 
  <def-label name="PRNFPLLOC">
    <tags-item tags="prn.pos.f.pl.loc"/>
    <tags-item tags="prn.ind.f.pl.loc"/>
    <tags-item tags="prn.itg.f.pl.loc"/>
  </def-label> 
  <def-label name="PRNMAPLLOC">
    <tags-item tags="prn.pos.ma.pl.loc"/>
    <tags-item tags="prn.ind.ma.pl.loc"/>
    <tags-item tags="prn.itg.ma.pl.loc"/>
  </def-label> 
  <def-label name="PRNMIPLLOC">
    <tags-item tags="prn.pos.mi.pl.loc"/>
    <tags-item tags="prn.ind.mi.pl.loc"/>
    <tags-item tags="prn.itg.mi.pl.loc"/>
  </def-label> 
  <def-label name="PRNNTPLLOC">
    <tags-item tags="prn.pos.nt.pl.loc"/>
    <tags-item tags="prn.ind.nt.pl.loc"/>
    <tags-item tags="prn.itg.nt.pl.loc"/>
  </def-label> 
  <def-label name="PRNFPLVOC">
    <tags-item tags="prn.pos.f.pl.voc"/>
    <tags-item tags="prn.pos.uns.f.pl.voc"/>
    <tags-item tags="prn.ind.f.pl.voc"/>
    <tags-item tags="prn.itg.f.pl.voc"/>
  </def-label> 
  <def-label name="PRNMAPLVOC">
    <tags-item tags="prn.pos.ma.pl.voc"/>
    <tags-item tags="prn.pos.uns.ma.pl.voc"/>
    <tags-item tags="prn.ind.ma.pl.voc"/>
    <tags-item tags="prn.itg.ma.pl.voc"/>
  </def-label> 
  <def-label name="PRNMIPLVOC">
    <tags-item tags="prn.pos.mi.pl.voc"/>
    <tags-item tags="prn.pos.uns.mi.pl.voc"/>
    <tags-item tags="prn.ind.mi.pl.voc"/>
    <tags-item tags="prn.itg.mi.pl.voc"/>
  </def-label> 
  <def-label name="PRNNTPLVOC">
    <tags-item tags="prn.pos.nt.pl.voc"/>
    <tags-item tags="prn.pos.uns.nt.pl.voc"/>
    <tags-item tags="prn.ind.nt.pl.voc"/>
    <tags-item tags="prn.itg.nt.pl.voc"/>
  </def-label> 

  <def-label name="NOMNOM">
    <tags-item tags="n.*.*.nom"/>
    <tags-item tags="np.*.*.*.nom"/>
  </def-label> 
  <def-label name="NOMGEN">
    <tags-item tags="n.*.*.gen"/>
    <tags-item tags="np.*.*.*.gen"/>
  </def-label> 
  <def-label name="NOMDAT">
    <tags-item tags="n.*.*.dat"/>
    <tags-item tags="np.*.*.*.dat"/>
  </def-label> 
  <def-label name="NOMACC">
    <tags-item tags="n.*.*.acc"/>
    <tags-item tags="np.*.*.*.acc"/>
  </def-label> 
  <def-label name="NOMINS">
    <tags-item tags="n.*.*.ins"/>
    <tags-item tags="np.*.*.*.ins"/>
  </def-label> 
  <def-label name="NOMLOC">
    <tags-item tags="n.*.*.loc"/>
    <tags-item tags="np.*.*.*.loc"/>
  </def-label> 
  <def-label name="NOMVOC">
    <tags-item tags="n.*.*.voc"/>
    <tags-item tags="np.*.*.*.voc"/>
  </def-label> 
  <def-label name="NOM">
    <tags-item tags="n.*"/>
    <tags-item tags="np.*"/>
  </def-label> 

  <def-mult name="CNJSUBBYTENC" closed="true">
    <sequence>
      <label-item label="CNJSUB"/>
      <label-item label="BYTENC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEMOCI" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="MOCI"/>
    </sequence>
  </def-mult>
  <def-mult name="NEMUSET" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="MUSET"/>
    </sequence>
  </def-mult>
  <def-mult name="NEMIT" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="MIT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEPOVINEN" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="POVINEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEIMPERF" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="IMPERF"/>
    </sequence>
  </def-mult>
  <def-mult name="NEPERF" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="PERF"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNEHOEMPHNT" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.emph.p3.nt.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNEHOEMPHM" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.emph.p3.m.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNEHONT" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.p3.nt.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="PRNEHOM" closed="true">  
    <sequence>
      <label-item label="PR"/>
      <tags-item tags="prn.p3.m.sg.acc"/>
    </sequence>
  </def-mult>
  <def-mult name="NESERFUT" closed="true">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="SERFUT"/>
    </sequence>
  </def-mult>

  <def-mult name="NEJADJFSGNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFSGGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFSGDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFSGACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFSGINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFSGLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFSGVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFSGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGACC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMASGVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMASGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMISGVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMISGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTSGVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTSGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJFPLVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJFPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMAPLVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMAPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJMIPLVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJMIPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLNOM">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLGEN">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLDAT">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLACC">  
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLINS">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLLOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEJADJNTPLVOC">
    <sequence>
      <label-item label="NEJ"/>
      <label-item label="ADJNTPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFSGVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFSGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGACC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMASGVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMASGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMISGVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMISGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTSGVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTSGVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTFPLVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTFPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMAPLVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMAPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTMIPLVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTMIPLVOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLNOM">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLNOM"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLGEN">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLGEN"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLDAT">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLDAT"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLACC">  
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLACC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLINS">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLINS"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLLOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLLOC"/>
    </sequence>
  </def-mult>
  <def-mult name="NEVPARTNTPLVOC">
    <sequence>
      <label-item label="NE"/>
      <label-item label="VPARTNTPLVOC"/>
    </sequence>
  </def-mult>
</tagset>

<forbid>
  <label-sequence>
    <label-item label="PR"/>
    <label-item label="P3PRNNONPR"/>
  </label-sequence>
  <label-sequence>
    <label-item label="SERFUT"/>
    <label-item label="PERF"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NESERFUT"/>
    <label-item label="PERF"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="ADJMASGACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="NEJADJMASGACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="ADJMAPLACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="NEJADJMAPLACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="ADJMASGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="NEJADJMASGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="ADJMISGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="NEJADJMISGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="ADJNTPLDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="NEJADJNTPLDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="VPARTMASGACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="NEVPARTMASGACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="VPARTMAPLACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOMPR"/>
    <label-item label="NEVPARTMAPLACC"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="VPARTMASGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="NEVPARTMASGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="VPARTMISGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="NEVPARTMISGDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="VPARTNTPLDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="INSPR"/>
    <label-item label="NEVPARTNTPLDAT"/>
  </label-sequence>
  <label-sequence>
    <label-item label="NOM"/>
    <label-item label="PRPERSPPR"/>
  </label-sequence>
  <label-sequence>
    <label-item label="PREADV"/>
    <label-item label="PRPERSPPR"/>
  </label-sequence>
</forbid>

<enforce-rules>
  <enforce-after label="PR">
    <label-set>
      <label-item label="P3DETPOS"/>
    </label-set>
  </enforce-after>
  <enforce-after label="NOMPR">
    <label-set>
      <label-item label="ADJMASGNOM"/>
      <label-item label="ADJMISGNOM"/>
      <label-item label="ADJFSGNOM"/>
      <label-item label="ADJNTSGNOM"/>
      <label-item label="ADJMAPLNOM"/>
      <label-item label="ADJMIPLNOM"/>
      <label-item label="ADJFPLNOM"/>
      <label-item label="ADJNTPLNOM"/>
      <label-item label="NEJADJMASGNOM"/>
      <label-item label="NEJADJMISGNOM"/>
      <label-item label="NEJADJFSGNOM"/>
      <label-item label="NEJADJNTSGNOM"/>
      <label-item label="NEJADJMAPLNOM"/>
      <label-item label="NEJADJMIPLNOM"/>
      <label-item label="NEJADJFPLNOM"/>
      <label-item label="NEJADJNTPLNOM"/>
    </label-set>
  </enforce-after>
  <enforce-after label="GENPR">
    <label-set>
      <label-item label="ADJMASGGEN"/>
      <label-item label="ADJMISGGEN"/>
      <label-item label="ADJFSGGEN"/>
      <label-item label="ADJNTSGGEN"/>
      <label-item label="ADJMAPLGEN"/>
      <label-item label="ADJMIPLGEN"/>
      <label-item label="ADJFPLGEN"/>
      <label-item label="ADJNTPLGEN"/>
      <label-item label="NEJADJMASGGEN"/>
      <label-item label="NEJADJMISGGEN"/>
      <label-item label="NEJADJFSGGEN"/>
      <label-item label="NEJADJNTSGGEN"/>
      <label-item label="NEJADJMAPLGEN"/>
      <label-item label="NEJADJMIPLGEN"/>
      <label-item label="NEJADJFPLGEN"/>
      <label-item label="NEJADJNTPLGEN"/>
    </label-set>
  </enforce-after>
  <enforce-after label="DATPR">
    <label-set>
      <label-item label="ADJMASGDAT"/>
      <label-item label="ADJMISGDAT"/>
      <label-item label="ADJFSGDAT"/>
      <label-item label="ADJNTSGDAT"/>
      <label-item label="ADJMAPLDAT"/>
      <label-item label="ADJMIPLDAT"/>
      <label-item label="ADJFPLDAT"/>
      <label-item label="ADJNTPLDAT"/>
      <label-item label="NEJADJMASGDAT"/>
      <label-item label="NEJADJMISGDAT"/>
      <label-item label="NEJADJFSGDAT"/>
      <label-item label="NEJADJNTSGDAT"/>
      <label-item label="NEJADJMAPLDAT"/>
      <label-item label="NEJADJMIPLDAT"/>
      <label-item label="NEJADJFPLDAT"/>
      <label-item label="NEJADJNTPLDAT"/>
    </label-set>
  </enforce-after>
  <enforce-after label="INSPR">
    <label-set>
      <label-item label="ADJMASGINS"/>
      <label-item label="ADJMISGINS"/>
      <label-item label="ADJFSGINS"/>
      <label-item label="ADJNTSGINS"/>
      <label-item label="ADJMAPLINS"/>
      <label-item label="ADJMIPLINS"/>
      <label-item label="ADJFPLINS"/>
      <label-item label="ADJNTPLINS"/>
      <label-item label="NEJADJMASGINS"/>
      <label-item label="NEJADJMISGINS"/>
      <label-item label="NEJADJFSGINS"/>
      <label-item label="NEJADJNTSGINS"/>
      <label-item label="NEJADJMAPLINS"/>
      <label-item label="NEJADJMIPLINS"/>
      <label-item label="NEJADJFPLINS"/>
      <label-item label="NEJADJNTPLINS"/>
    </label-set>
  </enforce-after>
  <enforce-after label="LOCPR">
    <label-set>
      <label-item label="ADJMASGLOC"/>
      <label-item label="ADJMISGLOC"/>
      <label-item label="ADJFSGLOC"/>
      <label-item label="ADJNTSGLOC"/>
      <label-item label="ADJMAPLLOC"/>
      <label-item label="ADJMIPLLOC"/>
      <label-item label="ADJFPLLOC"/>
      <label-item label="ADJNTPLLOC"/>
      <label-item label="NEJADJMASGLOC"/>
      <label-item label="NEJADJMISGLOC"/>
      <label-item label="NEJADJFSGLOC"/>
      <label-item label="NEJADJNTSGLOC"/>
      <label-item label="NEJADJMAPLLOC"/>
      <label-item label="NEJADJMIPLLOC"/>
      <label-item label="NEJADJFPLLOC"/>
      <label-item label="NEJADJNTPLLOC"/>
    </label-set>
  </enforce-after>
</enforce-rules>

<preferences>
  <prefer tags="vbser.pres.p3.sg"/>
  <prefer tags="vbhaver.impf.pres.p3.sg"/>
  <prefer tags="prn.emph.p3.nt.sg.gen"/>
  <prefer tags="prn.emph.p3.nt.sg.dat"/>
  <prefer tags="prn.emph.p3.nt.sg.acc"/>
  <prefer tags="prn.emph.p3.nt.sg.ins"/>
  <prefer tags="prn.emph.p3.nt.sg.loc"/>
  <prefer tags="prn.emph.p3.ma.pl.gen"/>
  <prefer tags="prn.emph.p3.ma.pl.dat"/>
  <prefer tags="prn.emph.p3.ma.pl.acc"/>
  <prefer tags="prn.emph.p3.ma.pl.ins"/>
  <prefer tags="prn.emph.p3.ma.pl.loc"/>
  <prefer tags="prn.emph.p3.f.sg.nom"/>
</preferences>

 <discard-on-ambiguity>
   <discard tags="n.nt.sg.voc"/>
   <discard tags="n.nt.pl.voc"/>
   <discard tags="np.top.nt.sg.voc"/>
   <discard tags="np.top.nt.pl.voc"/>
   <discard tags="num.mf.pl.voc"/>
 </discard-on-ambiguity>

</tagger>
