#!/bin/bash

if [ -z $1 ]; then
echo "Usage: genspritelist.sh C_FILES"
echo "       generates sprites_autogen.h and sprites_autogen.c"
exit 1
fi

TYPES=`grep -h REGISTER_SPRITE_TYPE $*|cut -d '(' -f 2|cut -d ')' -f 1`

cat <<EOF > sprites_autogen.h 
#ifndef SPRITES_AUTOGEN_H
#define SPRITES_AUTOGEN_H
/* Warning! This file is automatically generated by 
   utils/genspritelist.sh. Do not edit! */

void sprite_types_register();
EOF
for t in $TYPES; do
echo "extern sprite_type_t $t;" >>  sprites_autogen.h;
done
echo  >>  sprites_autogen.h;
echo "#endif" >>  sprites_autogen.h;

cat <<EOF > sprites_autogen.inc
#include "sprite_types.h"
/* Warning! This file is automatically generated by 
   utils/genspritelist.sh. Do not edit! */

void sprite_types_register()
{
EOF

for t in $TYPES; do
echo "    sprite_types_list[nr_sprite_types++] = &$t;" >>  sprites_autogen.inc;
done
echo  "}" >>  sprites_autogen.inc;
