C  Copyright (c) 2003-2010 University of Florida
C
C  This program is free software; you can redistribute it and/or modify
C  it under the terms of the GNU General Public License as published by
C  the Free Software Foundation; either version 2 of the License, or
C  (at your option) any later version.

C  This program is distributed in the hope that it will be useful,
C  but WITHOUT ANY WARRANTY; without even the implied warranty of
C  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C  GNU General Public License for more details.

C  The GNU General Public License is included in this distribution
C  in the file COPYRIGHT.
      subroutine denom_eomip_pt(array_table, narray_table, 
     *                      index_table,
     *                      nindex_table, segment_table, nsegment_table,
     *                      block_map_table, nblock_map_table,
     *                      scalar_table, nscalar_table, 
     *                      address_table, op)
c--------------------------------------------------------------------------
c   Divides each sample of the block given by the array argument by the 
c   MP2 denominator
c       eps = epsilon(i)+epsilon(j)-epsilon(a)-epsilon(b)
c--------------------------------------------------------------------------

      implicit none
      include 'interpreter.h'
      include 'trace.h'
      include 'mpif.h'
      include 'epsilon.h'
#ifdef ALTIX
      include 'sheap.h'
#endif

      integer narray_table, nindex_table, nsegment_table, 
     *        nblock_map_table
      integer op(loptable_entry)
      integer array_table(larray_table_entry, narray_table)
      integer index_table(lindex_table_entry, nindex_table)
      integer segment_table(lsegment_table_entry, nsegment_table)
      integer block_map_table(lblock_map_entry, nblock_map_table)
      integer nscalar_table
      double precision scalar_table(nscalar_table)
      double precision sind, shift  
      integer*8 address_table(narray_table)

      integer i, j, k
      integer array, array_type, index, nindex, ierr
      integer block, blkndx, seg
      integer find_current_block
      integer*8 indblk, get_block_index
      integer stack
      
      integer comm

      integer val1(mx_array_index), val2(mx_array_index)
      integer type(mx_array_index)
      integer na1, na2, ni1, ni2
      integer*8 addr, get_index_from_base

      double precision x(1)
#ifdef ALTIX
      pointer (dptr, x)
#else
      common x
#endif

#ifdef ALTIX
      dptr = dshptr
#endif

c---------------------------------------------------------------------------
c   Find the indices of the array block.
c---------------------------------------------------------------------------
       
      array = op(c_result_array)
      nindex = array_table(c_nindex, array)
      do i = 1, nindex
         index = array_table(c_index_array1+i-1,array)
         type(i) = index_table(c_index_type, index)
         seg = index_table(c_current_seg,index)

c-------------------------------------------------------------------------
c   Get segment ranges.
c-------------------------------------------------------------------------

         call get_index_segment(index, seg, segment_table,
     *                             nsegment_table, index_table,
     *                             nindex_table, val1(i), val2(i))
      enddo

c---------------------------------------------------------------------------
c   Get array data address.
c---------------------------------------------------------------------------

      if (array_table(c_array_type,array) .eq. static_array) then
         addr = address_table(array)
         indblk = get_index_from_base(addr, x, 2)
      else
         block = find_current_block(array, array_table(1,array),
     *                             index_table, nindex_table,
     *                             segment_table, nsegment_table,
     *                             block_map_table, blkndx)

         stack = array_table(c_array_stack,array)
         indblk = get_block_index(array, block, stack,
     *                            blkndx, x, .true.)
      endif 

c---------------------------------------------------------------------------
c   Get the constant shift.
c---------------------------------------------------------------------------
       
      array = op(c_op1_array)
      array_type = array_table(c_array_type, array)

      if (array_type .ne. scalar_value) then 
         write(6,*) 'Error: second argument in TY denominator
     *               must be a scalar '
         call abort_job() 
      endif 

      sind = array_table(c_scalar_index, array)
      shift = scalar_table(sind) 

      if (nindex .eq. 6) then
         write(6,*) 'shift=',shift

         call eps_eomip_pt_divide6(x(indblk), val1(1),val2(1),type(1),
     *                   val1(2),val2(2),type(2),
     *                   val1(3),val2(3),type(3),
     *                   val1(4),val2(4),type(4),
     *                   val1(5),val2(5),type(5),
     *                   val1(6),val2(6),type(6),
     *                   epsilon,epsilonb,shift) 
      else
         print *,'Error in energy_denominator: Result array ',
     *      'must have either 6 indices.'
         print *,'array ',array,' has ',nindex,' indices.'
         call abort_job()
      endif
      
      return
      end

c----------------------------------------------------------------------|
c----------------------------------------------------------------------|

      subroutine eps_eomip_pt_divide6(x, i1,i2,itype,
     *                      j1,j2,jtype,k1,k2,ktype,
     *                      a1,a2, atype, b1, b2, btype, 
     *                      kk1, kk2, kktype, epsilon, epsilonb, 
     *                      shift)
      implicit none
      include 'interpreter.h'

      integer a1,a2,b1,b2,c1,c2,i1,i2,j1,j2,k1,k2
      integer atype, itype, btype, jtype, ctype, ktype,kktype
      double precision x(i1:i2,j1:j2,k1:k2,a1:a2,b1:b2,kk1:kk2)

      double precision epsilon(*), epsilonb(*)

      integer a,b,c,i,j,k,kk1,kk2,kk
      double precision eps, epsa, epsb, epsc, epsi, epsj, epsk
      double precision val, shift 
      double precision sum,sumeps

c--------------------------------------------------------------------
c Set index types if necessary and perform simple check. 
c--------------------------------------------------------------------


      write(6,*) ' SHIFT = ', shift

c---------Target root index--------------------------|
      do kk=kk1,kk2    


c---------Occupied indices---------------------------|

      do k = k1,k2
         if (ktype .eq. mobindex) then
            epsk = epsilonb(k)
         else
            epsk = epsilon(k)
         endif
      do j = j1,j2
         if (jtype .eq. mobindex) then
            epsj = epsilonb(j)
         else
            epsj = epsilon(j)
         endif
      do i = i1, i2
         if (itype .eq. mobindex) then
            epsi = epsilonb(i)
         else
            epsi = epsilon(i)
         endif

c----------Virtual indixes-----------------------------|

      do b = b1,b2
         if (btype .eq. mobindex) then
            epsb = epsilonb(b)
         else
            epsb = epsilon(b)
         endif
      do a = a1,a2
         if (atype .eq. mobindex) then
            epsa = epsilonb(a)
         else
            epsa = epsilon(a)
         endif
c-----------------------------------------------------|

         val =  x(i,j,k,a,b,kk)
         eps = epsi + epsj + epsk - epsa - epsb 
     *       + shift 
         x(i,j,k,a,b,kk) = val/eps
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo

      return
      end


c---------------------------------------------------------------------------|
c---------------------------------------------------------------------------|
